#ifndef BZ_ARRAYOPS_CC
#define BZ_ARRAYOPS_CC

#ifndef BZ_ARRAY_H
 #error <blitz/array/ops.cc> must be included via <blitz/array.h>
#endif

#ifndef BZ_UPDATE_H
 #include <blitz/update.h>
#endif

BZ_NAMESPACE(blitz)

/*
 * Constant operands
 */

template<class T_numtype, int N_rank>
inline Array<T_numtype, N_rank>& Array<T_numtype,N_rank>::initialize(
    T_numtype x)
{
    (*this) = _bz_ArrayExpr<_bz_ArrayExprConstant<T_numtype> >(x);
    return *this;
}

template<class T_numtype, int N_rank>
inline Array<T_numtype, N_rank>& 
Array<T_numtype,N_rank>::operator+=(T_numtype x)
{
    (*this) += _bz_ArrayExpr<_bz_ArrayExprConstant<T_numtype> >(x);
    return *this;
}

template<class T_numtype, int N_rank>
inline Array<T_numtype, N_rank>&
Array<T_numtype,N_rank>::operator-=(T_numtype x)
{
    (*this) -= _bz_ArrayExpr<_bz_ArrayExprConstant<T_numtype> >(x);
    return *this;
}

template<class T_numtype, int N_rank>
inline Array<T_numtype, N_rank>&
Array<T_numtype,N_rank>::operator*=(T_numtype x)
{
    (*this) *= _bz_ArrayExpr<_bz_ArrayExprConstant<T_numtype> >(x);
    return *this;
}

template<class T_numtype, int N_rank>
inline Array<T_numtype, N_rank>&
Array<T_numtype,N_rank>::operator/=(T_numtype x)
{
    (*this) /= _bz_ArrayExpr<_bz_ArrayExprConstant<T_numtype> >(x);
    return *this;
}

template<class T_numtype, int N_rank>
inline Array<T_numtype, N_rank>&
Array<T_numtype,N_rank>::operator%=(T_numtype x)
{
    (*this) %= _bz_ArrayExpr<_bz_ArrayExprConstant<T_numtype> >(x);
    return *this;
}

template<class T_numtype, int N_rank>
inline Array<T_numtype, N_rank>&
Array<T_numtype,N_rank>::operator^=(T_numtype x)
{
    (*this) ^= _bz_ArrayExpr<_bz_ArrayExprConstant<T_numtype> >(x);
    return *this;
}

template<class T_numtype, int N_rank>
inline Array<T_numtype, N_rank>&
Array<T_numtype,N_rank>::operator&=(T_numtype x)
{
    (*this) &= _bz_ArrayExpr<_bz_ArrayExprConstant<T_numtype> >(x);
    return *this;
}

template<class T_numtype, int N_rank>
inline Array<T_numtype, N_rank>&
Array<T_numtype,N_rank>::operator|=(T_numtype x)
{
    (*this) |= _bz_ArrayExpr<_bz_ArrayExprConstant<T_numtype> >(x);
    return *this;
}

template<class T_numtype, int N_rank>
inline Array<T_numtype, N_rank>&
Array<T_numtype,N_rank>::operator>>=(T_numtype x)
{
    (*this) <<= _bz_ArrayExpr<_bz_ArrayExprConstant<T_numtype> >(x);
    return *this;
}

template<class T_numtype, int N_rank>
inline Array<T_numtype, N_rank>&
Array<T_numtype,N_rank>::operator<<=(T_numtype x)
{
    (*this) <<= _bz_ArrayExpr<_bz_ArrayExprConstant<T_numtype> >(x);
    return *this;
}

/*
 * Array operands
 */

template<class T_numtype, int N_rank>
inline Array<T_numtype, N_rank>&
Array<T_numtype, N_rank>::operator=(const Array<T_numtype,N_rank>& x)
{
    (*this) = _bz_ArrayExpr<ArrayIterator<T_numtype, N_rank> >(x.begin());
    return *this;
}

template<class T_numtype, int N_rank> template<class T_numtype2>
inline Array<T_numtype, N_rank>&
Array<T_numtype, N_rank>::operator=(const Array<T_numtype2,N_rank>& x)
{
    (*this) = _bz_ArrayExpr<ArrayIterator<T_numtype2, N_rank> >(x.begin());
    return *this;
}

template<class T_numtype, int N_rank> template<class T_numtype2>
inline Array<T_numtype, N_rank>&
Array<T_numtype, N_rank>::operator+=(const Array<T_numtype2,N_rank>& x)
{
    (*this) += _bz_ArrayExpr<ArrayIterator<T_numtype2, N_rank> >(x.begin());
    return *this;
}

template<class T_numtype, int N_rank> template<class T_numtype2>
inline Array<T_numtype, N_rank>&
Array<T_numtype, N_rank>::operator-=(const Array<T_numtype2,N_rank>& x)
{
    (*this) -= _bz_ArrayExpr<ArrayIterator<T_numtype2, N_rank> >(x.begin());
    return *this;
}

template<class T_numtype, int N_rank> template<class T_numtype2>
inline Array<T_numtype, N_rank>&
Array<T_numtype, N_rank>::operator*=(const Array<T_numtype2,N_rank>& x)
{
    (*this) *= _bz_ArrayExpr<ArrayIterator<T_numtype2, N_rank> >(x.begin());
    return *this;
}

template<class T_numtype, int N_rank> template<class T_numtype2>
inline Array<T_numtype, N_rank>&
Array<T_numtype, N_rank>::operator/=(const Array<T_numtype2,N_rank>& x)
{
    (*this) /= _bz_ArrayExpr<ArrayIterator<T_numtype2, N_rank> >(x.begin());
    return *this;
}

template<class T_numtype, int N_rank> template<class T_numtype2>
inline Array<T_numtype, N_rank>&
Array<T_numtype, N_rank>::operator%=(const Array<T_numtype2,N_rank>& x)
{
    (*this) %= _bz_ArrayExpr<ArrayIterator<T_numtype2, N_rank> >(x.begin());
    return *this;
}

template<class T_numtype, int N_rank> template<class T_numtype2>
inline Array<T_numtype, N_rank>&
Array<T_numtype, N_rank>::operator^=(const Array<T_numtype2,N_rank>& x)
{
    (*this) ^= _bz_ArrayExpr<ArrayIterator<T_numtype2, N_rank> >(x.begin());
    return *this;
}

template<class T_numtype, int N_rank> template<class T_numtype2>
inline Array<T_numtype, N_rank>&
Array<T_numtype, N_rank>::operator&=(const Array<T_numtype2,N_rank>& x)
{
    (*this) &= _bz_ArrayExpr<ArrayIterator<T_numtype2, N_rank> >(x.begin());
    return *this;
}

template<class T_numtype, int N_rank> template<class T_numtype2>
inline Array<T_numtype, N_rank>&
Array<T_numtype, N_rank>::operator|=(const Array<T_numtype2,N_rank>& x)
{
    (*this) |= _bz_ArrayExpr<ArrayIterator<T_numtype2, N_rank> >(x.begin());
    return *this;
}

template<class T_numtype, int N_rank> template<class T_numtype2>
inline Array<T_numtype, N_rank>&
Array<T_numtype, N_rank>::operator>>=(const Array<T_numtype2,N_rank>& x)
{
    (*this) >>= _bz_ArrayExpr<ArrayIterator<T_numtype2, N_rank> >(x.begin());
    return *this;
}

template<class T_numtype, int N_rank> template<class T_numtype2>
inline Array<T_numtype, N_rank>&
Array<T_numtype, N_rank>::operator<<=(const Array<T_numtype2,N_rank>& x)
{
    (*this) <<= _bz_ArrayExpr<ArrayIterator<T_numtype2, N_rank> >(x.begin());
    return *this;
}

/*
 * Array expression operands
 */

template<class T_numtype, int N_rank> template<class T_expr>
inline Array<T_numtype, N_rank>&
Array<T_numtype, N_rank>::operator=(_bz_ArrayExpr<T_expr> expr)
{
    evaluate(expr, _bz_update<T_numtype, _bz_typename T_expr::T_numtype>());
    return *this;
}

template<class T_numtype, int N_rank> template<class T_expr>
inline Array<T_numtype, N_rank>&
Array<T_numtype, N_rank>::operator+=(_bz_ArrayExpr<T_expr> expr)
{
    evaluate(expr, _bz_plus_update<T_numtype, _bz_typename T_expr::T_numtype>());
    return *this;
}

template<class T_numtype, int N_rank> template<class T_expr>
inline Array<T_numtype, N_rank>&
Array<T_numtype, N_rank>::operator-=(_bz_ArrayExpr<T_expr> expr)
{
    evaluate(expr, _bz_minus_update<T_numtype, 
        _bz_typename T_expr::T_numtype>());
    return *this;
}

template<class T_numtype, int N_rank> template<class T_expr>
inline Array<T_numtype, N_rank>&
Array<T_numtype, N_rank>::operator*=(_bz_ArrayExpr<T_expr> expr)
{
    evaluate(expr, _bz_multiply_update<T_numtype,
        _bz_typename T_expr::T_numtype>());
    return *this;
}

template<class T_numtype, int N_rank> template<class T_expr>
inline Array<T_numtype, N_rank>&
Array<T_numtype, N_rank>::operator/=(_bz_ArrayExpr<T_expr> expr)
{
    evaluate(expr, _bz_divide_update<T_numtype,
        _bz_typename T_expr::T_numtype>());
    return *this;
}

template<class T_numtype, int N_rank> template<class T_expr>
inline Array<T_numtype, N_rank>&
Array<T_numtype, N_rank>::operator%=(_bz_ArrayExpr<T_expr> expr)
{
    evaluate(expr, _bz_mod_update<T_numtype,
        _bz_typename T_expr::T_numtype>());
    return *this;
}

template<class T_numtype, int N_rank> template<class T_expr>
inline Array<T_numtype, N_rank>&
Array<T_numtype, N_rank>::operator^=(_bz_ArrayExpr<T_expr> expr)
{
    evaluate(expr, _bz_xor_update<T_numtype,
        _bz_typename T_expr::T_numtype>());
    return *this;
}

template<class T_numtype, int N_rank> template<class T_expr>
inline Array<T_numtype, N_rank>&
Array<T_numtype, N_rank>::operator&=(_bz_ArrayExpr<T_expr> expr)
{
    evaluate(expr, _bz_bitand_update<T_numtype,
        _bz_typename T_expr::T_numtype>());
    return *this;
}

template<class T_numtype, int N_rank> template<class T_expr>
inline Array<T_numtype, N_rank>&
Array<T_numtype, N_rank>::operator|=(_bz_ArrayExpr<T_expr> expr)
{
    evaluate(expr, _bz_bitor_update<T_numtype,
        _bz_typename T_expr::T_numtype>());
    return *this;
}

template<class T_numtype, int N_rank> template<class T_expr>
inline Array<T_numtype, N_rank>&
Array<T_numtype, N_rank>::operator>>=(_bz_ArrayExpr<T_expr> expr)
{
    evaluate(expr, _bz_shiftr_update<T_numtype,
        _bz_typename T_expr::T_numtype>());
    return *this;
}

template<class T_numtype, int N_rank> template<class T_expr>
inline Array<T_numtype, N_rank>&
Array<T_numtype, N_rank>::operator<<=(_bz_ArrayExpr<T_expr> expr)
{
    evaluate(expr, _bz_shiftl_update<T_numtype,
        _bz_typename T_expr::T_numtype>());
    return *this;
}

BZ_NAMESPACE_END

#endif // BZ_ARRAYOPS_CC
