.\" (c) 1994 by Harald Kirsch (kir@iitb.fhg.de)
.\"
.\" $Id: clig.man,v 1.2 1997/08/10 17:04:18 kir Exp $
.\"
.\" HISTORY:
.\" $Log: clig.man,v $
.\" Revision 1.2  1997/08/10 17:04:18  kir
.\" Added new command `Commandline' which, if present, generates code to
.\" concatenate the whole command line into one string and put it into the
.\" structure returned by parseCmdline.
.\"
.\" Revision 1.1.1.1  1997/03/27 21:19:58  kir
.\" clig -- the Command Line Interface Generator
.\"
.\"
.\" -----------------------------------------------------------------
.TH CLIG 1  "|Version|" "Kir" "Programmer's Manual"
.SH NAME
clig \- Command Line Interface Generator
.SH SYNOPSIS
.BI clig
.I clifile
.RB [ -o
.IR outprefix ]
.RB [ -m
.IR manpage ]
.RB [ -d ]

.SH OPTIONS
.IP -o
Clig generates a .c and a .h file. Their name-prefix, i.e. without
the .c or .h, can be specified by -o. By default the name is
.I clifile
without suffix.

.IP -m
is used to define the name of the manual page to generate or edit. The
default is equal to the string specified with the
.BR Name -command
in
.I clifile
suffixed with .1

.IP -d
in addition to the command-line parser, the generated .c-file contains
the function
.nf

.B "  void showOptionValues(void)"

.fi
which, when called after calling 
.B parseCmdline(),
will print all parameters defined by default or found on the command
line. 
.B ShowOptionValues()
is mainly used for debugging purposes.


.\"*********************************************************************
.SH EXAMPLE
An example demonstrating features of clig is the
file `|Example|/cmdline.cli'. Together with `main.c' and
`makefile' in the same directory you can construct an example program
to play with.

.\"*********************************************************************
.SH DESCRIPTION
One of the main reasons to use
.B clig
is, that besides the command line parser a
.B usage()
function
and a manual page are generated, which are always up-to-date with
respect to the options actually understood by the program.

From the description in
.IR clifile ,
clig generates C source code, which is put into
.IB outprefix .c
and
.IB outprefix .h.
The source code contains a command line parser with the prototype

.RS
.B Cmdline *parseCmdline(int argc, char **argv)
.RE

which returns its result in a structure of type
.BR Cmdline .
The section `DESCRIPTION FILE' details, which variables will be found
in
.BR Cmdline .

Besides 
.BR parseCmdline() ,
the function

.RS
.B void usage(void)
.RE

is generated and will be called by the command-line parser, if the
command line contains obvious errors. An example
.B main()
function which calls the parser is shown in the section `EXAMPLE MAIN
PROGRAM'.

Additionally, clig generates or edits a manual page. It fills the contents
of the sections NAME, SYNOPSIS and OPTIONS with information
from
.IR clifile .
See the section `MANUAL PAGE GENERATION' for more details.

The structure
.B Cmdline
and the functions
.BR parseCmdline() ", " usage() " and "
.BR showOptionValues() " (see below), "
will be declared in 
.IB outprefix .h.
In addition,
.IB outprefix .c
defines the external variable
.BR "char* Program" ,
which is set equal to 
.BR argv[0] " by " parseCmdline() .

Currently, options of type flag, string, floating point and integer
are supported. Except for flag options, all option-descriptions allow
to specify how many arguments are expected for the option and whether
the option is mandatory or not. For non-mandatory options, default
values can be specified and will be returned by
.B parseCmdline()
if necessary. In addtion, for floating point
and integer options, a range can be declared, and the parser will
exit the program with an error message, if the option's argument lies
outside the given range.

In some applications where files are created by programs with
complicated command lines, it is often desireable to store the full
command line in the generated file for documentation
purposes. Therefore clig can generate code to concatenate the
whole command line into one string before it is parsed and store it in
a variable in the generated structure.
(See command
.I Commandline
in section `DESCRIPTION FILE' for details.)

.B Clig
is implemented in Tcl and
.I clifile
actually contains tcl-code, but under normal circumstances the user
does not need to know anything about tcl, because the syntax of the
description-file is described below. (I admit that this is probably a
lie, because under `normal circumstances'
.I clifile
may contain syntax errors resulting in really tcl-ish error messages.)

.\"*********************************************************************
.SH DESCRIPTION FILE
The description-file,
.IR clifile ,
is a line-oriented ascii-file. Each line contains
a command which either describes an option or specifies additional
information necessary to generate
.BR parseCmdline() ", " usage() " , " showOptionValues()
and the manual page.
A command starts with the command-name followed by mandatory parameters
and possibly followed by optional parameters.
If a command does not fit on a line, it may be continued on the next
line if the previous line is terminated by a backslash (\\).

Before the commands are described in detail, let's consider a simple
example, e.g. a command to describe a flag option named
.B -v
which is meant to instruct the program to operate verbosely: (Note the
backslash on the next line!)

.RS
.nf
.B  Flag -v verbose \\\\
.B "    {verbose operation generating blurb}"
.fi
.RE

The command's name is 
.BR Flag .
It has three parameters: The first,
.BR -v ,
is the string to be detected by the command line parser. The second,
.BR verbose ,
is the name of a variable in the structure
.B Cmdline
which will be set by the parser, if
.B -v
is on the command line. (Actually the variable's name will be 
.BR verboseP .
More about that later.) The third parameter, i.e. everything between the
braces, is a string which will be printed by 
.BR usage() .

In general,
.I every parameter 
of a description-command
.IR "should be enclosed in braces" ,
as soon as it contains white space.

The detailed description of all commands follows. As usual, parameters
enclosed in brackets are optional.

.\"*********************************************************************
.SS MANDATORY COMMANDS
The description file must contain at least the following two commands:

.BI Name " program-name"
.RS
The
.BR Name -command
specifies the name of the program. The string
.I program-name
is used in the generated manual page and also specifies the default
name of the manual page. However the specified name is not used
anywhere in the C-code, because use of argv[0] is preferred there.
A trivial but sufficient example would be

.RS 2
.nf
Name doit
.fi
.RE

.RE

.\"*********************************************************************
.BI Usage " one-liner"
.RS
The 
.B Usage
command specifies a one line description of the program's intent and
function. The string
.I one-liner
is printed --- besides other sutff --- by the generated function
.BR usage() .
(Remember to enclose 
.I one-liner
in braces.) A (not so) typical example would be

.RS 2
.nf
Usage {program to delete your home directory}
.fi
.RE

In fact, as of version 1997-07-27, the
.I one-liner
can be longer than one line. Best results are obtained, if
.I one-liner 
is not put in braces but is surrounded by double quotes. The quoted
string may than contain newlines. Clig automatically adds backslashes
where necessary in the generated C-code so that the C-compiler does
not go wild.

.RE

.\"*********************************************************************
.SS STRING OPTIONS
.BI String " option variable usage " 
[
.BI count=  lo , hi 
]
[
.BR  " mandatory " |
.BI default= values
]

The
.B String 
command declares
.I option
to have zero or more string arguments. The structure
.B Cmdline
will contain the entries 
.IR variable , 
.IB variable P
and 
.IB  variable C.
The value of
.IB variable P
will be set nonzero, if the option was found on the command line.
If the optional parameter
.B count=
is not present, 
.I variable
is of type 
.B char*
and will point to the string found after the option. The parser will
abort the program, if there is no string after the option.

The parameter 
.I usage
specifies a string printed by 
.B usage()
as a description of the option.

The optional parameter 
.BI count= lo , hi
declares, how many strings are expected as arguments to
.IR option .
An example is

.RS
.BR  {count = 3,7} ,
.RE

telling the parser that at least three and at most seven strings must be
present after the option. As a special case, the upper bound may be 
.BR oo ,
indicating that there is no upper limit for the number of strings
expected after
.IR option .
If the count allows more than one option argument
.RI ( hi ">1)," 
the type of
.BI Cmdline. variable
will be
.BR char** .
If the 
.BR count= -parameter
allows at most one option argument, the type of 
.BI Cmdline. variable
will be
.BR char* .
In both cases, the value of
.BI Cmdline. variable C
will be set to the number of option arguments found. 

The optional parameter 
.B mandatory
tells the parser, that this option must be present. The parser will
print an error message and terminate the program, if the option is
not on the command line. The parameter
.B mandatory 
cannot be use together with 
.BI default= values .

The optional parameter
.BI default= values
specifies one or more default values to be returned in
.BI Cmdline. variable
if
.I option
is not on the comand line. In
.BR main() ,
no difference can be detected  between
actual command line arguments and default values inserted by the
parser.

Example use of
.BR String :

.RS 2
.nf
String -l labels {labels for x and y-axis} \\
    {count = 2,2} \\
    {default = {samples} {f in Hz} }
.fi
.RE

Please note how each default value is enclosed in braces. Actually
.B samples
need not be enclosed in braces here, since it contains no whitespace.
The parameter
.B {count = 2,2}
specifies that
.B -l
must be followed by exactly two strings.


.\"*********************************************************************
.SS FLOAT OPTIONS
.BI Float " option variable usage " 
[
.BI count=  lo , hi 
]
[
.BR " mandatory " |
.BI default= values
]
[
.BI range= lo , hi
]

The
.B Float
command declares
.I option
to have zero or more floating point arguments. The description of 
.IR variable ", " usage ", " 
.BR count= " and " mandatory
applies as for the 
.BR String -command.
The type of
.BI Cmdline. variable
is
.BR float ,
if there is no 
.BR count= -parameter
or if it allows at most one option argument. It is
.B float*
otherwise.

The optional parameter
.BI range= lo , hi
specifies a range for the option arguments. The special values
.B -oo
for
.I lo
and 
.B oo
for
.I hi
are recognized. As an example,

.RS
.B {range = -oo,1.0}
.RE

specifies, that each option argument must be less or equal to 1.0.
If the command line parser finds an argument of
.I option
which is not in the given range, it prints a suitable error messages
and exits the program.

.B WARNING:
The implementation of the 
.BR default= -parameter
is currently incomplete insofar, as the specified default values are
not checked by 
.BR clig ,
i.e. the following would go unnoticed:

.RS
.B "{default = 1.0} {range = 500.0, 600.0}"
.RE

In this case, if
.I option
is not on the command line,
.B main()
would find in
.BI Cmdline. variable
the out-of-range value 1.0. (Maybe this is a feature?)


Example use of
.BR Float :

.RS 2
.nf
Float -p prob {list of probabilities adding up to one} \\
    {range = 0.0, 1.0}  {default = 0.1 0.2 0.7} \\
    {count = 1,oo}
.fi
.RE

Please note, that the additional constraint requiring the values
summing to 1.0 cannot be checked by the parser, but must be checked by
your
.B main()
function.


.\"*********************************************************************
.SS INT OPTIONS
.BI Int " option variable usage " 
[
.BI count=  lo , hi 
]
[
.BR " mandatory " |
.BI default= values
]
[
.BI range= lo , hi
]

The
.B Int
command declares
.I option
to have zero or more integer arguments. The description of 
.IR variable ", " usage ", " 
.BR count= ", " mandatory " and " range=
applies as for the 
.BR Float -command.
Even the note about the unchecked default values applies.
However, the type of
.BI Cmdline. variable
is
.BR int " or " int*
depending on the
.BR count= -parameter.

Example use of
.BR Int :

.RS 2
.nf
Int -b blocksize {size of internal buffer} \\
    {range = 1024,oo} \\
    {default = 1024}
.fi
.RE



.\"*********************************************************************
.SS FLAG OPTIONS
.BI Flag " option variable usage "

The
.B Flag
command declares an option without any parameters. The command line
parser merely checks for the existence of
.I option
on the command line. If it is found, the parser returns a nonzero
value in
.BI Cmdline. variable P
as for all other option types. However, there are no variables named
.BI Cmdline. variable
and
.BI Cmdline. variable C
in the structure returned to
.BR main() .

Example use of
.BR Flag :

.RS 2
.nf
Flag -v verbose {verbose operation}
.fi
.RE


.\"*********************************************************************
.SS OTHER COMMANDS
.BI Rest " name usage "
[
.BI count= lo , hi
]

.RS 2
The
.B Rest
command specifies, what the parser should do with command line
arguments not associated with any option. If
.I clifile
does not contain a
.B Rest
command, the parser will generate an error message for those
arguments and terminate the program. If
.B Rest
is present, non-option arguments are left in
.B "char** Cmdline.argv"
while their number is recorded in
.BR "int Cmdline.argc" .
The parameters
.IR name " and " usage
are printed by
.BR usage() .
The optional
.BR count= -parameter
works as described for the
.B String
command. It does not, however, influence the type of
.BR Cmdline.argv ,
because this is always set equal to
.BR argv+1 ,
where
.B argv
is the value passed to
.BR parseCmdline() .

Example use of
.BR Rest :

.RS 2
.nf
Rest infiles {input files} {count = 1,oo}
.fi
.RE
.RE

.\"*********************************************************************

.BI Commandline " argvstr"

.RS 2
If you want to record the whole command line of a program in one of
its output files for documentation purposes, this command comes in
handy. If
.B clig
finds it in the description file it generates code to concatenate all
command line arguments in one string. The code is called automatically
within the function
parseCmdline()
just before the command line is actually parsed. The result is stored
in the structure returned by 
parseCmdline()
in entry
.IR argvstr .

Example use of 
.BR Commandline :

.RS 2
.nf
Commandline tool
.fi
.RE

In your main() you can access the whole command line as one string
like this:
.RS 2
.nf
 ...
Cmdline *cmd = parseCmdline(argc, argv);
printf("Full command line is `%s'\\n", cmd->tool);
 ...
.fi
.RE
.RE

.\"*********************************************************************
.BI Version " version"
.RS 2
The
.B Version
command specifies a string to be used as a version-identification of
the generated parser. Currently it is merely printed as part of the
usage-information. An example using my favorite type of version
numbers would be

.RS 2
.nf
Version 1995-08-22
.fi
.RE

.RE

.\"*********************************************************************
.BI Description " description"
.RS 2
The
.BR Description
command should not be used. Instead, the respective section in the
generated manual page should be filled out. The main reason for this
advice is, that clig copies
.I description
AS IS into the manual page, so it can be typed into the manual page
file in the first place. Please remember that the generated manual
page needs some hand-tuning anyway, because for example the `SEE
ALSO'-section cannot be generated. Since this command should not be
used, no example is given.

.\"*********************************************************************
.SH EXAMPLE MAIN PROGRAM
The following example demonstrates the use of the command line parser,
provided that 
.I outprefix
.RB "= " cmdline
and that 
.B clig
was called with option
.B -d
to generate the function
.BR showOptionValues() .

.RS 2
.nf
#include <cmdline.h> 

int main(int argc, char **argv)
{
  Cmdline *cmd = parseCmdline(argc, argv);
  showOptionValues();

  /* Program is set by parseCmdline */
  printf("argv[0] = `%s'\\n", Program);

  /*****
    Your code goes here. Option parameters and cleaned-up 
    argc and argv are referenced with cmd->...
  *****/

  return 0;
}
.fi
.RE

.\"*********************************************************************
.SH MANUAL PAGE GENERATION
Clig will always generate or edit a manual page in *roff format. The
name of the manual page file can be specified with option
.BR -m .
By default, the file name will be the string specified with the
.BR Name -command
in the description file suffixed with .1.

If the manual page file exists, clig edits specially marked sections of
the file by filling in up-to-date information. If the file does not yet
exist, it copies a template file into it and then edits the template
in the same way.

Clig is able to fill out the manual page sections `NAME', `SYNOPSIS',
`OPTIONS' and, in a very limited way, `DESCRIPTION'. In addition it will
supply a default title macro (.TH). The lines of the manual page file
which are replaced by clig must be clearly marked by matching pairs of
tag lines like
.nf

  .\\" cligPart <section>

and

  .\\" cligPart <section> end

where <section> is one of the section names listed above.
.fi

The idea is, that you edit the manual page, while
clig fills in the parts that can be deduced from the description
file. If you don't like, what clig fills in, simply remove both
tag-lines of a section and clig will leave it alone. You certainly want
to do this for the DESCRIPTION-section.


.\"*********************************************************************
.SH BUGS
The description file
.I clifile
is read by
.B clig
with the tcl-command
.BR source ,
since the option descriptions are actually tcl-procedures. This has
the effect of irritating non-TCLers with uncomprehendable error
messages, if there are syntax errors in the description.

The generated C-code might contain functions which are never used.

See
.RB ` WARNING: '
above for another bug.

Non-TCLers might feel uncomfortable with the description syntax. In
particular, forgetting to enclose parameters in braces will cause
strange errors.

The function
.B showOptionValues()
does not ascertain that
.B parseCmdline()
was called before.

Possibly some more...

.\"*********************************************************************
.SH FUTURE FEATURES
.nf
o enumeration type options,
o file type options,
o `Rest'-command not only with string parameters,
o better error messages,
o generation of a Tcl/Tk-GUI driving the specified program,
.fi
 
.SH NO-FUTURE FEATURES
.nf
o Tcl/Tk-GUI for clig,
o neural net type command line parser,
o fuzzy logic command line parser,
o inheritance hierarchy for command line options,
o visual basic support,
o command lines shorter than 128 characters,
o generation of WINDOOF program group,
o OLE, NILS or JENS support,
o automatic buzzword implementation.
.fi

.\"*********************************************************************
.SH "SEE ALSO"
.BR Tcl (n)
.BR tclsh (1)
