(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                              abstraction.ml                              *)
(****************************************************************************)

open Std;;
open Vectops;;
open Names;;
open Generic;;
open Term;;
open Libobject;;

type abstraction_object = 
  { abs_kind : path_kind
  ; abs_arity : int array
  ; abs_rhs : constr
  }
;;

let load_abstraction _ = ();;

let cache_abstraction = function
    (sp,ao) ->
    Nametab.push (basename sp) (coerce_path ao.abs_kind sp)
;;

let specification_abstraction x = x;;

let (inAbstraction,outAbstraction) =
    declare_object ("ABSTRACTION",
                    {load_function = load_abstraction;
                     cache_function = cache_abstraction;
                     specification_function = specification_abstraction});;


let abst_of_path sp =
    match Lib.leaf_object_tag (objsp_of sp) with
    "ABSTRACTION" ->
    let ao = outAbstraction(Lib.map_leaf (objsp_of sp))
    in (sp,ao)

  | _ -> invalid_arg "abst_of_path called with non-abstraction"
;;

let abst_option_of_path sp =
try Some(abst_of_path sp)
with Not_found -> None
;;

let rec count_dlam = function
    DLAM(_,c) -> 1+(count_dlam c)
  | _ -> 0
;;

let execute_abstraction pk arity rhs =
    if for_all_vect (fun i -> i >= 0) arity &
        closed0 rhs & global_vars rhs = [] then
        {abs_kind = pk;
         abs_arity = arity;
         abs_rhs = rhs}
    else error "malformed abstraction object"
;;

let is_abstraction sp =
    Lib.leaf_object_tag sp = "ABSTRACTION"
;;

let contract_abstraction = function
    DOPN(Abst sp,args) ->
    let (_,ao) = abst_of_path sp
    in if for_all2eq_vect (fun c i ->
                               (count_dlam c) = i) args ao.abs_arity then
        Sosub.soexecute(it_vect sAPP ao.abs_rhs args)
       else failwith "contract_abstraction"
  | _ -> invalid_arg "contract_abstraction"
;;

let make_abstraction sp args =
    let (_,ao) = abst_of_path sp
    in if for_all2eq_vect (fun c i ->
                               (count_dlam c) = i) args ao.abs_arity then
        DOPN(Abst sp,args)
       else failwith "make_abstraction"
;;

(* $Id: abstraction.ml,v 1.12 1999/10/29 23:18:53 barras Exp $ *)
