(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                             constrtypes.mli                              *)
(****************************************************************************)

open Names
open Generic
open Term

(****************************************************************************)
(*            The Type of Constructions Constant Bodies                     *)
(****************************************************************************)

type discharge_recipe = {d_expand : section_path list;
                         d_modify : (sorts oper * sorts oper modification) list;
                         d_abstract : identifier list;
                         d_from : section_path}


type implicits_typ = IMPL_AUTO of (int list) | IMPL_MANUAL of (int list) | NO_IMPL

type recipe =
    COOKED of constr
  | RECIPE of discharge_recipe


type constant_body = {cONSTKIND : path_kind;
                      cONSTHYPS : type_judgement signature;
                      mutable cONSTBODY : recipe ref option;
                      cONSTTYPE : type_judgement;
                      mutable cONSTOPAQUE : bool;
                      mutable cONSTEVAL : (int * (int * constr) list * int * bool) option option;
                      mutable cONSTIMPARGS : implicits_typ}


type const_entry = section_path * constant_body
type constdecl_body = (path_kind,constant_body) Listmap.t

val specification_of_constant : constdecl_body -> constdecl_body

(* implicites *)

val is_impl_auto : implicits_typ -> bool
val list_of_implicits : implicits_typ -> int list

(****************************************************************************)
(*       The Type of Constructions Mutually Inductive Bodies                *)
(****************************************************************************)

type recarg = 
    Param of int 
  | Norec 
  | Mrec of int 
(*  | Imbr of (recarg list) array *)
  | Imbr of section_path*int*(recarg list) 

(* Modified by E.G 11/10/94.
   A boolean MINDFINITE tels us if the recursive type is inductive (=true) or
   co-inductive  (=false) *)

type mutual_inductive_packet =
    {mINDCONSNAMES : identifier array;
     mINDTYPENAME : identifier;
     mINDLC : constr;
     mINDSTAMP : name;
     mINDARITY : type_judgement;
     mINDLAMEXP : constr option;
     mINDKD : sorts list;
     mINDKN : sorts list;
     mINDLISTREC : (recarg list) array;
     mINDFINITE : bool;
     mINDIMPLICITS : implicits_typ;
     mINDCONSIMPLICITS : implicits_typ array
     }

and mutual_inductive_body =
    {mINDKIND : path_kind;
     mINDNTYPES : int;
     mINDHYPS : type_judgement signature;
     mINDPACKETS : mutual_inductive_packet array;
     mINDSINGL : constr option;
     mINDNPARAMS : int}


type mutual_ind_entry = section_path * mutual_inductive_body
type mutual_inddecl_body = (path_kind,mutual_inductive_body) Listmap.t

(* Based at zero *)
val mind_type_name_index : mutual_inductive_body -> identifier -> int
val mind_nth_type_packet : mutual_inductive_body -> int -> mutual_inductive_packet
val mind_singl : mutual_inductive_body -> constr option
val mind_oper_of_id : section_path -> mutual_inductive_body -> identifier -> (sorts oper * type_judgement signature)
val mind_oper_of_id1 : section_path -> mutual_inductive_body -> identifier -> (sorts oper * type_judgement signature) * int list
val specification_of_minductive : mutual_inddecl_body -> mutual_inddecl_body
val mind_type_finite : mutual_inductive_body -> int -> bool
val is_recursive : int list -> recarg list array -> bool

(* the closure at which the object will be discharged *)
type strength = DischargeAt of section_path | NeverDischarge
val make_strength : string list -> strength

(* $Id: constrtypes.mli,v 1.14 1999/11/30 19:25:43 mohring Exp $ *)
