(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                             vernacinterp.mli                             *)
(****************************************************************************)

open Std;;
open Names;;
open More_util;;
open Pp;;
open Himsg;;
open Proof_trees;;
 
exception Drop;;
exception ProtectedLoop;;
exception Quit;;

val disable_drop : exn -> exn;;

type vernac_arg = 
    VARG_VARGLIST of vernac_arg list
  | VARG_STRING of string
  | VARG_NUMBER of int
  | VARG_NUMBERLIST of int list
  | VARG_IDENTIFIER of identifier
  | VCALL of string * vernac_arg list
  | VARG_COMMAND of CoqAst.t
  | VARG_COMMANDLIST of CoqAst.t list
  | VARG_TACTIC of CoqAst.t
  | VARG_TACTIC_ARG of tactic_arg
  | VARG_BINDER of identifier list * CoqAst.t
  | VARG_BINDERLIST of (identifier list * CoqAst.t) list
  | VARG_AST of CoqAst.t
  | VARG_ASTLIST of CoqAst.t list
  | VARG_UNIT
  | VARG_DYN of Dyn.t   (* to put whatever you want *)
;;

val vernac_tab : (string, vernac_arg list -> unit -> unit) Mhm.t;;
val vinterp_add : string * (vernac_arg list -> unit -> unit) -> unit;;
val overwriting_vinterp_add : string * (vernac_arg list -> unit -> unit) -> unit;;
val vinterp_map : string -> vernac_arg list -> unit -> unit;;
val vinterp_init : unit -> unit;;
val cvt_varg : CoqAst.t -> vernac_arg;;
val call : string * vernac_arg list -> unit;;
val interp : CoqAst.t -> unit;;

(* raises an user error telling that the vernac commanand was called
   with bad arguments *)
val bad_vernac_args : string -> 'a

(* $Id: vernacinterp.mli,v 1.13 1999/07/01 11:57:46 bertot Exp $ *)
