(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                coq_map.ml                                *)
(****************************************************************************)
(* Association tables over ordered types *)




open Baltree;;

type ('a, 'b) binding =
  { key: 'a; data: 'b; prev: 'b list };;

type ('a, 'b) t =
  { tree: ('a, 'b) binding Baltree.t;
    order: 'a -> ('a, 'b) binding -> int };;

type ('a,'b) frozen_t = ('a,'b) binding Baltree.t;;
let read_tree m = m.tree;;
let set_tree t m = {tree = t; order = m.order};;

let empty ord =
  { tree = Empty; order = fun x y -> ord x y.key };;

let clone_empty m = {tree = Empty; order = m.order};;

let bind x y b =
  Some
    { key = x;
      data = y;
      prev = match b with None -> [] | Some b -> b.data :: b.prev };;

let add x y m =
  { tree = Baltree.modify (m.order x) (bind x y) m.tree;
    order = m.order };;

let find x m =
  (Baltree.find (m.order x) m.tree).data;;

let unbind = function
    Some({prev = x::l} as b) ->
      Some { key = b.key; data = x; prev = l }
  | _ -> None;;

let remove x m =
  { tree = Baltree.modify (m.order x) unbind m.tree;
    order = m.order };;

let iter f m =
  let rec iter = function
    Empty -> ()
  | Node(l, b, r, _) ->
      iter l;
      f b.key b.data;
      List.iter (f b.key) b.prev;
      iter r
  in iter m.tree;;

(* $Id: coq_map.ml,v 1.5 1999/06/29 07:47:14 loiseleu Exp $ *)
