(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                 fmavm.ml                                 *)
(****************************************************************************)

type ('a,'b) t = ('a,'b) Mavm.t * ('a,'b) Mhm.t;;
type ('a,'b) frozen_t = ('a,'b) Mavm.frozen_t;;

let create (ord,n) = (Mavm.create ord,Mhm.create n);;

let empty (am,hm) = (Mavm.empty am;Mhm.empty hm);;
let map (am,hm) k =
    try Mhm.map hm k
    with Not_found ->
        let v = Mavm.map am k
        in (Mhm.add hm (k,v);
            v)
;;

let rmv (am,hm) k =
    if Mhm.in_dom hm k then
        (Mhm.rmv hm k; Mavm.rmv am k)
    else (Mavm.rmv am k)
;;

let add (am,hm) (k,v) = Mavm.add am (k,v);;
let dom (am,hm) = Mavm.dom am;;
let rng (am,hm) = Mavm.rng am;;
let in_dom (am,hm) k = Mavm.in_dom am k;;
let inv (am,hm) v = Mavm.inv am v;;
let remap (am,hm) k v =
    (rmv (am,hm) k;
     add (am,hm) (k,v));;
let app f (am,hm) = Mavm.app f am;;
let toList (am,hm) = Mavm.toList am;;

let freeze ((am,hm):('a,'b) t) = Mavm.freeze am;;

(* WARNING: PHYSEQ: BUG:
 * This code relies on the implementation of physical equality
 * in a safe way.  But if there are any bugs, then the following
 * true-branch can be killed off, at a price in speed.
 *)
let unfreeze fm (am,hm) =
    let oam = Mavm.freeze am
    in if oam == fm then ()
       else (empty (am,hm);
             Mavm.unfreeze fm am)
;;

(* $Id: fmavm.ml,v 1.5 1999/06/29 07:47:15 loiseleu Exp $ *)
