(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                               initial.mli                                *)
(****************************************************************************)

val make_silent : bool -> unit;;
val is_silent : unit -> bool;;
val silently : ('a -> 'b) -> 'a -> 'b;;

val make_implicit_args : bool -> unit;;
val is_implicit_args : unit -> bool;;
val implicitely : ('a -> 'b) -> 'a -> 'b;;

val make_mes_ambig : bool -> unit;;
val is_mes_ambig : unit -> bool;;
val  without_mes_ambig : ('a -> 'b) -> 'a -> 'b;;

val add_unsafe : string -> unit;;
val is_unsafe : string -> bool;;


type 'a timestamped;;
(* ts_mod gives a 'b timestamped with a new stamp *)
val ts_mod : ('a -> 'b) -> 'a timestamped -> 'b timestamped;;
val ts_it : 'a timestamped -> 'a;;
val ts_mk : 'a -> 'a timestamped;;
val ts_eq : 'a timestamped -> 'a timestamped -> bool;;
val ts_stamp : 'a timestamped -> int;;

type 'a idstamped;;
(* ids_mod gives a 'b stamped with the same stamp *)
val ids_mod : ('a -> 'b) -> 'a idstamped -> 'b idstamped;;
val ids_it : 'a idstamped -> 'a;;
val ids_mk : 'a -> 'a idstamped;;
val ids_eq : 'a idstamped -> 'a idstamped -> bool;;

val make_focus : int -> unit;;
val focus : unit -> int;;
val focused_goal : unit -> int;;
val set_print_hyps_limit : int -> unit;;
val unset_print_hyps_limit : unit -> unit;;
val print_hyps_limit : unit -> int option;;

(* $Id: initial.mli,v 1.9 1999/07/09 17:57:17 mohring Exp $ *)
