
type loc = (int * int);;

type t =
    Node of loc * string * t list
  | Nvar of loc * string
  | Slam of loc * string option * t
  | Num of loc * int
  | Id of loc * string
  | Str of loc * string
  | Path of loc * string list* string
  | Dynamic of loc * Dyn.t
;;


(* bl : (int * t) list *)
(* ast : t *)
(* for each binding (i,c) in bl, substitutes the metavar i by the ast c
  in ast *)

let subst_meta bl ast =
  let rec aux = function
      Node (_,"META", [Num(_, n)]) -> List.assoc n bl
    | Node(loc, node_name, args) -> 
	Node(loc, node_name, List.map aux args)
    | Slam(loc, var, arg) -> Slam(loc, var, aux arg)
    | other -> other
  in 
    aux ast
;;

let rec collect_metas = function
      Node (_,"META", [Num(_, n)]) -> [n]
    | Node(_, _, args) -> List.concat (List.map collect_metas args)
    | Slam(loc, var, arg) -> collect_metas arg
    | _ -> []

(* $Id: coqAst.ml,v 1.8 1998/11/17 16:33:06 loiseleu Exp $ *)
