(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                  CAML.v                                  *)
(****************************************************************************)

(* Grammar and Syntax for extraction toward Caml light. *)

Declare ML Module "ml_import" "mlterm" "fw_env"
      	       	  "fwtoml" "optimise" "genpp" "caml" "haskell" "ocaml".

(* Grammar. *)

Grammar vernac vernac :=

(* Write commands *)

  writecaml [ "Write" "Caml" "File" stringarg($file) ext_args($arg) "." ]
     -> [(WRITECAMLFILE $file ($LIST $arg))]

(** comment pour l'instant
| writecamlmodule [ "Write" "Caml" "Module" identarg($m) "." ]
     -> [(WRITECAMLMODULE $m)]
**)

| writecamllight 
            [ "Write" "CamlLight" "File" stringarg($file) ext_args($arg) "." ]
     -> [(WRITECAMLLIGHTFILE $file ($LIST $arg))]

| writehaskell [ "Write" "Haskell" "File" stringarg($file) ext_args($arg) "." ]
     -> [(WRITEHASKELLFILE $file ($LIST $arg))]

(* Import commands *)

| mlimport [ "ML" "Import" "Constant" idorstring($cid) "==" 
             identarg($id) ":" comarg($c) "." ]
            -> [(ML_IMPORT $cid $id $c)]

| mloneinduc [ "ML" "Import" "Inductive" ne_mindnames_list($nl) "=="
    "Inductive" identarg($id) indpar($indpar) ":" comarg($c) 
    ":=" lidcom($lidcom) "." ]
     -> [(ML_ONEINDUCTIVE (VERNACARGLIST ($LIST $nl)) $id $c $indpar $lidcom)]

| mlmutinduc [ "ML" "Import" "Inductive" ne_mindnames_list($nl) "=="
    "Mutual" indpar($indpar) "Inductive" block_old_style($indl) "." ]
     -> [(ML_MUTUALINDUCTIVE (VERNACARGLIST ($LIST $nl))
      	       	       	       	  $indpar (VERNACARGLIST ($LIST $indl)))]

| link [ "Link" identarg($id) ":=" comarg($c) "." ]
     -> [(LINK $id $c)]

| fwprint [ "Fw" "Print" identarg($id) "." ]
     -> [(FWPRINT $id)]

| polyextr [ "Poly" "Extraction" "." ] ->  [(LOOSET)]

| mlextr [ "ML" "Extraction" "." ] ->  [(LOOSEF)]

| extract_constant 
  [ "Extract" "Constant" identarg($x) "=>" idorstring($y) "." ]
  -> [ (EXTRACT_CONSTANT $x $y) ]

| extract_inductive 
  [ "Extract" "Inductive" identarg($x) "=>" mindnames($y) "."]
  -> [ (EXTRACT_INDUCTIVE $x $y) ]

with ext_args : List :=
  ext_args [ "[" ne_identarg_list($idl) "]" ext_options($o) ]
        -> [ (VERNACARGLIST ($LIST $idl)) ($LIST $o) ]

with ext_options : List :=
  ext_option_some [ ext_option($o) ext_options($l) ] -> 
                  [ ($LIST $o) ($LIST $l) ]
| ext_option_none [ ] -> [ ]

with ext_option : List :=
  ext_op_noopt [ "noopt" ] -> [ "noopt" ]
| ext_op_exact [ "exact" ] -> [ "exact" ]
| ext_op_expan [ "expand" "[" ne_identarg_list($idl) "]" ] -> 
               [ "expand" (VERNACARGLIST ($LIST $idl)) ]

(* Names *)

with mindnames :=
  mlconstr [ idorstring($id) "[" ne_idorstring_list($idl) "]" ]
     -> [(VERNACARGLIST $id ($LIST $idl))]

with ne_mindnames_list: List :=
  mlconstrs   [ mindnames($n) ne_mindnames_list($nl) ] -> [$n ($LIST $nl)]
| mloneconstr [ mindnames($n) ] -> [$n]

with ne_idorstring_list: List :=
  ne_ids_nil  [ idorstring($x) ] -> [$x]
| ne_ids_cons [ idorstring($x) ne_idorstring_list($l) ] -> [ $x ($LIST $l) ]

with idorstring :=
  ids_ident  [ identarg($id) ] -> [ $id ]
| ids_string [ stringarg($s) ] -> [ $s ].


(* $Id: Extraction.v,v 1.18 1999/06/29 07:48:04 loiseleu Exp $ *)
