(**************************************************************************
  *********                    ntaux.ml                           *********
  **************************************************************************)
open Std;;
open More_util;;
open Generic;;
open Term;;
open Names;;
open Tutil;;
open Ntdef;;
open Ntparam;;

let nc_is_type_False c = is_False c;;

let rec nc_rec_suppress_annotation_aux nc =
 match nc with
 | DOP1 ((Inr _), nc') -> fst (nc_rec_suppress_annotation_aux nc'), true
 | DOP1 (op, nc') ->
  let nc', touch' = nc_rec_suppress_annotation_aux nc' in
  if touch' then (DOP1 (op, nc'), true)
   else (nc, false)
 | DOP2 (op, nc', nc'') ->
  let nc', touch' = nc_rec_suppress_annotation_aux nc'
  and nc'', touch'' = nc_rec_suppress_annotation_aux nc'' in
  if touch' || touch'' then (DOP2 (op, nc', nc''), true)
   else (nc, false)
 | DOPN (op, v) ->
  let v' = Array.copy v
  and touch = ref false in
  for i = 0 to Array.length v - 1 do
    let nc', touch' = nc_rec_suppress_annotation_aux v.(0) in
    if touch' then (touch:=true; v'.(0) <- nc')
    done; if !touch then (DOPN (op, v'), true)
           else (nc, false)
 | DOPL (op, l) ->
  let l' = List.map nc_rec_suppress_annotation_aux l in
  if List.exists snd l' then (DOPL (op, List.map fst l'), true)
   else (nc, false)
 | DLAM (na, nc') ->
  let nc', touch' = nc_rec_suppress_annotation_aux nc' in
  if touch' then (DLAM (na, nc'), true)
   else (nc, false)
 | DLAMV (na, v) ->
  let v' = Array.copy v
  and touch = ref false in
  for i = 0 to Array.length v - 1 do
    let nc', touch' = nc_rec_suppress_annotation_aux v.(0) in
    if touch' then (touch:=true; v'.(0) <- nc')
    done; if !touch then (DLAMV (na, v'), true)
           else (nc, false)
 | DOP0 _ | VAR _ | Rel _ -> nc, false;;

let nc_rec_suppress_annotation nc = fst (nc_rec_suppress_annotation_aux nc);;

let select_list_of_DOPN f nc =
 match nc_body nc with
 | DOPN (_, v) -> select_list_of_vect f v
 | _ -> [];;

let select_DOPN_first f nc =
 match nc_body nc with
 | DOPN (_, v) -> select_vect_first f v
 | _ -> raise Not_found;;

let flat_map_list_of_DOPN f nc =
 match nc_body nc with
 | DOPN (_, v) -> flat_map_list_of_vect f v
 | _ -> [];;

(***************************************************************************)
let nc_suppress_annotation nc =
 match nc with
 | DOP1 ((Inr _), nc') -> nc'
 | _ -> nc;;

(********************
  |     text info     |
  ********************)
(**********
  | lambda  |
  **********)
let nc_lambda_case nc =
 match nc_get_n_i nc with
 | Ni_lambda (_, _, ((case, _, _), _)) -> case
 | _ -> false;;

let nc_lambda_sort nc =
 match nc_get_n_i nc with
 | Ni_lambda ((sort, _, _), _, _) -> sort
 | _ -> Ns_Prop;;

let nc_lambda_var_right nc =
 match nc_get_n_i nc with
 | Ni_lambda (_, _, (_, (_, (i, _, _)))) -> i
 | _ -> 0;;

let nc_lambda_var_list_length nc =
 match nc_get_n_i nc with
 | Ni_lambda (_, _, (_, (_, (i, _, _)))) -> i + 1
 | _ -> 0;;

let nc_lambda_type_right nc =
 match nc_get_n_i nc with
 | Ni_lambda (_, _, (_, (_, (_, i, _)))) -> i
 | _ -> 0;;

let nc_lambda_sort_right nc =
 match nc_get_n_i nc with
 | Ni_lambda (_, _, (_, (_, (_, _, i)))) -> i
 | _ -> 0;;

let nc_is_lambda_right_0 nc =
 match nc_get_n_i nc with
 | Ni_lambda (_, _, (_, (_, (0, 0, 0)))) -> true
 | _ -> false;;

let nc_lambda_coord nc =
 match nc_get_n_i nc with
 | Ni_lambda (_, _, ((_, _, coord), _)) -> coord
 | _ -> Nc_misc;;

let nc_is_lambda_in_case nc =
 match nc_get_n_i nc with
 | Ni_lambda (_, _, ((true, _, _), _)) -> true
 | _ -> false;;

let nc_lambda_nat nc =
 match nc_get_n_i nc with
 | Ni_lambda (_, _, (_, (nat, _))) -> nat
 | _ -> Nln_std;;

let nc_lambda_typ_is_a_sort nc =
 match nc_body nc with
 | DOP2 (_, (DOP0 (Inl (Sort sort))), _) -> Some sort
 | _ -> None;;

let nc_set_lambda_in_case in_case nc =
 match nc with
 | DOP1 ((Inr ({n_i=Ni_lambda ((sort, occ, _), data2, use_count)})), _) ->
  let n_i = Ni_lambda (
   (sort, occ, in_case), data2, use_count) in
  nc_set_n_i n_i nc
 | _ -> ();;

let rec nc_set_n_lambda_in_case n in_case nc = if n > 0 then (match nc with
 | DOP1 ((Inr ({n_i=Ni_lambda ((sort, occ, _), data2, use_count)})),
           (DOP2 (_, _, (DLAM (_, nc'))))) ->
  let n_i = Ni_lambda (
   (sort, occ, in_case), data2, use_count) in
  nc_set_n_i n_i nc; nc_set_n_lambda_in_case (n - 1) in_case nc'
 | _ -> ());;

let nc_is_lambda_var_list_anonymous nc =
 match nc_body nc with
 | DOP2 (_, _, (DLAM (Anonymous, _))) -> true
 | _ -> false;;

(**********
  |   app   |
  **********)
let nc_is_apply_head_up nc =
 match nc_get_n_i nc with
 | Ni_app (_, (Nauc_apply ((_, (_, Up)), _))) -> true
 | _ -> false;;

let nc_apply_subs_number nc =
 match nc_get_n_i nc with
 | Ni_app (_, (Nauc_apply (_, (_, (_, i))))) -> i
 | _ -> 0;;

let nc_nbr_elim_cases nc =
 match nc_get_n_i nc with
 | Ni_app (_, (Nauc_elim (_, (_, i, _)))) -> i
 | _ -> 0;;

(**********
  |  fix    |
  **********)
(**********
  | metavar |
  **********)
(**********
  |   id    |
  **********)
let nc_is_immediate_hypothesis nc =
 match nc_get_n_i nc with
 | Ni_id (Nin_var imm) -> imm
 | _ -> false;;

let nc_id_nat nc =
 match nc_get_n_i nc with
 | Ni_id nat -> nat
 | _ -> Nin;;

let nc_is_identifier nc =
 match nc_get_n_i nc with
 | Ni_id _ -> true
 | _ -> false;;

let nc_is_construct nc =
 match nc_get_n_i nc with
 | Ni_id (Nin_construct _) -> true
 | _ -> false;;

(********************
  |     text arg      |
  ********************)
(**********
  | lambda  |
  **********)
(**********
  |   app   |
  **********)
let nc_is_apply_sub nc =
 match nc_get_n_a nc with
 | Na_app_son (_, (Nasa_sub _), _) -> true
 | _ -> false;;

(*elim_head *)
let nc_is_elim_head nc =
 match nc_get_n_a nc with
 | Na_app_son (_, _, (Nase_destruct _)) -> true
 | _ -> false;;

(*elim_case *)
let nc_is_elim_case nc =
 match nc_get_n_a nc with
 | Na_app_son (_, _, (Nase_case _)) -> true
 | _ -> false;;

let nc_is_case_of_induc_elim nc =
 match nc_get_n_a nc with
 | Na_app_son (_, _, (Nase_case (_, (Some _), _, _, _))) -> true
 | _ -> false;;

let nc_is_induc_case nc =
 match nc_get_n_a nc with
 | Na_app_son (_, _, (Nase_case (_, (Some true), _, _, _))) -> true
 | _ -> false;;

let nc_is_some_case_number nc =
 match nc_get_n_a nc with
 | Na_app_son (_, _, (Nase_case (_, _, _, _, (Some _)))) -> true
 | _ -> false;;

let nc_elim_case_nat nc =
 match nc_get_n_a nc with
 | Na_app_son (_, _, (Nase_case (_, _, _, nat, _))) -> nat
 | _ -> Ncn_std;;

(**********
  |  fix    |
  **********)
(********************
  |     text type     |
  ********************)
let nc_is_type_expected nc =
 (function expected, _, _, _ -> expected) (nc_get_n_t nc);;

let nc_is_type_used nc =
 match nc_get_n_t nc with
 | _, true, true, (_ :: _) -> true
 | _, true, false, (_ :: (_ :: [])) -> true
 | _ -> false;;

let nc_are_sev_types_used nc =
 match nc_get_n_t nc with
 | _, true, true, (_ :: (_ :: _)) -> true
 | _, true, false, (_ :: (_ :: (_ :: _))) -> true
 | _ -> false;;

let nc_set_type_use use nc =
 (function expec, _, use_first, l -> nc_set_n_t (expec, use, use_first, l) nc)
  (nc_get_n_t nc);;

let nc_set_first_type_use use_first nc =
 (function expec, use, _, l -> nc_set_n_t (expec, use, use_first, l) nc)
  (nc_get_n_t nc);;

let nc_get_type_list nc =
 if nc_get_n_j nc = None then ((function _, _, _, l1 -> l1) (nc_get_n_t nc))
 else begin
  let l1 =
   match nc_get_n_t nc with
   | _, _, _, (_ :: l1) -> l1
   | _, _, _, _ -> [] in
  let i, nc' = nc_jump_count nc in
  (function _, _, _, l2 -> List.map (lift (-i)) l2 @ l1) (nc_get_n_t nc')
end;;

let nc_get_type_list_if_used nc =
 if nc_get_n_j nc = None then (match nc_get_n_t nc with
 | _, true, true, l1 -> l1
 | _, true, false, (_ :: l1) -> l1
 | _ -> [])
 else begin
  let use, l1 =
   match nc_get_n_t nc with
   | _, true, _, (_ :: l1) -> true, l1
   | _, use, _, _ -> use, [] in
  if use then begin
    let i, nc' = nc_jump_count nc in
    match nc_get_n_t nc' with
     | _, _, true, l2 -> List.map (lift (-i)) l2 @ l1
     | _, _, false, (_ :: l2) -> List.map (lift (-i)) l2 @ l1
     | _ -> l1
  end
   else []
end;;

let nc_number_of_types nc = List.length (nc_get_type_list_if_used nc);;

(*GRUGE*)
let nc_is_concl_false nc =
 (function _, _, _, type_l -> List.exists is_False type_l) (nc_get_n_t nc);;

(********************
  |  text format dot  |
  ********************)
let nc_select_rule_family i nc =
 try (function _, str, _ -> str.[0]) (List.nth (snd (nc_get_n_f nc)) (i - 1))
 with
 | Failure "nth" | Invalid_argument "nth_char" -> ' ';;

let rec select_on_family c =
 function
    | (_, str, _ as n) :: l -> if try c = str.[0]
                                  with
                                  | Invalid_argument "nth_char" -> false then n
                                else select_on_family c l
    | _ -> raise (Failure "select_on_family");;

let nc_select_rule c nc =
 try
  (function _, str, _ -> String.sub str 1 (String.length str - 1))
   (select_on_family c (snd (nc_get_n_f nc)))
 with
 | Failure "select_on_family" -> "";;

let nc_select_elements c nc =
 try (function _, _, str -> str) (select_on_family c (snd (nc_get_n_f nc)))
 with
 | Failure "select_on_family" -> 0;;

let nc_dot i nc = if nc_get_n_d nc then begin
  try (function c, _, _ -> c) (List.nth (snd (nc_get_n_f nc)) (i - 1))
  with
  | Failure "nth" -> ' '
end
 else ' ';;

let nc_is_with_dot nc = nc_get_n_d nc;;

let nc_set_type_pos pos nc =
 (function pos', l -> if pos <> pos' then nc_set_n_f (pos, l) nc)
  (nc_get_n_f nc);;

