(**************************************************************************
  *********                     ntdef.mli                         *********
  **************************************************************************)
open Generic;;
open Term;;
open Std;;
open More_util;;
open Names;;

type natural_oper = (sorts oper, annotation) union
 and natural_constr = natural_oper term
 and annotation = {(*from father*)
                   mutable n_a : n_arg;
                  mutable n_t : n_type;
                  mutable n_d : n_dot;
                  (*shortcut*)
                  mutable n_j : n_jump;
                  (*from itself*)
                  mutable n_i : n_info;
                  mutable n_f : n_format}
 and n_arg =   Na
             | Na_lambda_son of nt_lambda_son
             | Na_app_son of bool * nt_app_son_apply * nt_app_son_elim
             | Na_fix_son of nt_fix_son
 and n_dot = bool
 and n_type = (*expected*)
               bool * (*use*) bool * (*use_first*) bool * constr list
 and n_jump = int option
 and n_info =   Ni
              | Ni_lambda of nt_lambda_data * nt_lambda_data_elim option *
                             nt_lambda_use_count
              | Ni_app of (nt_app_data_apply * nt_app_data_elim option) *
                          nt_app_use_count
              | Ni_fix of nt_fix_data
              | Ni_metavar of nt_metavar_data
              | Ni_id of nt_id_data
 and n_format = (*Up*)
                 (bool * (*Dn*) bool) * (char * string * int) list
 and nt_lambda_data = nt_sort * (nt_occ * nt_occ) * nt_lambda_in_case
 and nt_lambda_data_elim = constr
 and nt_lambda_use_count = (*in_case*)
                            (bool * (*link*) nt_lambda_link * (*coord*) nt_coord) *
                            (nt_lambda_nat * nt_lambda_link_count)
 and nt_sort =   Ns_Prop
               | Ns_Set
               | Ns_Type
               | Ns_TypeSet
 and nt_occ =   No0
              | No1
              | NoS
 and nt_lambda_in_case = bool option
 and nt_lambda_link =   Nll_type
                      | Nll_sort
                      | Nll_sentence
                      | Nll_none
 and nt_lambda_link_count = int * int * int
 and nt_coord =   Nc_misc
                | Nc_such_that
 and nt_lambda_nat =   Nln_std
                     | Nln_triv
                     | Nln_not
                     | Nln_abs
                     | Nln_noocc
 and nt_lambda_son =   Nls_std
                     | Nls_triv
                     | Nls_not
                     | Nls_abs
                     | Nls_noocc
 and nt_app_data_apply = (*construct*)
                          bool * (*omit*) bool *
                          (*sub*)
                          (bool * (*wit*) bool * (*obv*) bool * (*dep*) bool)
 and nt_app_data_elim = (*induc*)
                         bool * (*omit *) bool * (*cst*) constr
 and nt_app_use_count =   Nauc_apply of (*construct*)
                                        (bool * (*omit*) (bool * (*pos*) nt_pos)) *
                                        (*ident*)
                                        (nt_is_ident *
                                         (*ident*)
                                         (nt_is_ident * (*n_subs*) int))
                        | Nauc_elim of (*induc*)
                                       (bool * (*omit*) bool) *
                                       (*ident*)
                                       (nt_is_ident * (*n_cases*) int *
                                        (int * int * int))
 and nt_pos =   Up
              | Dn
 and nt_is_ident =   Nii_not
                   | Nii_id of (*imm*)
                               bool
 and nt_app_son_apply =   Nasa_head
                        | Nasa_sub of (*recur*)
                                      (nt_is_ident * int) option *
                                      (*n_right*) int
                        | Nasa_wit
                        | Nasa_obv
                        | Nasa_dep
 and nt_app_son_elim =   Nase
                       | Nase_prop
                       | Nase_destruct of (*dep*)
                                          bool
                       | Nase_case of (*recur*)
                                      bool * (*induc elim *) bool option *
                                      (*nbr_lambdas*) int * nt_case_nat *
                                      nt_case_number option
 and nt_fix_data = int
 and nt_fix_son = identifier * constr
 and nt_metavar_data = goal_path
 and goal_path = int list
 and nt_id_data = nt_id_nat
 and nt_id_nat =   Nin
                 | Nin_var of bool
                 | Nin_theorem
                 | Nin_axiom
                 | Nin_construct of constr
                 | Nin_elim_theorem of constr
 and nt_case_number = int list
 and nt_case_nat =   Ncn_std
                   | Ncn_triv
                   | Ncn_abs
                   | Ncn_base
                   | Ncn_induc;;

type nt_definition =
       N_prooftext of string * identifier * natural_constr * constr
     | N_definition of string * identifier * constr * constr
     | N_axiom of string * identifier * constr;;

(***************************************************************************)
val d_n_a : n_arg;;

val d_n_t : n_type;;

val d_n_d : n_dot;;

val d_n_j : n_jump;;

val d_n_i : n_info;;

val d_n_f : n_format;;

val nc_set_n_a : n_arg -> natural_constr -> unit;;

val nc_set_n_t : n_type -> natural_constr -> unit;;

val nc_set_n_d : n_dot -> natural_constr -> unit;;

val nc_set_n_j : n_jump -> natural_constr -> unit;;

val nc_set_n_i : n_info -> natural_constr -> unit;;

val nc_set_n_f : n_format -> natural_constr -> unit;;

val nc_get_n_a : natural_constr -> n_arg;;

val nc_get_n_t : natural_constr -> n_type;;

val nc_get_n_d : natural_constr -> n_dot;;

val nc_get_n_j : natural_constr -> n_jump;;

val nc_get_n_i : natural_constr -> n_info;;

val nc_get_n_f : natural_constr -> n_format;;

val make_annotation :
      n_arg -> n_type -> n_dot -> n_jump -> n_info -> n_format -> annotation;;

val nc_body : natural_constr -> natural_constr;;

val nc_note : natural_constr -> annotation option;;

val nc_jump : natural_constr -> natural_constr;;

val nc_jump_count : natural_constr -> int * natural_constr;;

val nc_jump_fun :
      natural_constr -> (natural_constr -> natural_constr) * natural_constr;;

(***************************************************************************)
val nc_strip_outer_annotation : natural_constr -> natural_constr;;

val c_of_nc : natural_constr -> constr;;

val nc_of_c : constr -> natural_constr;;

(***************************************************************************)
val nc_from_Rel_to_VAR : natural_constr -> natural_constr;;

val nc_from_VAR_to_Rel : natural_constr -> natural_constr;;

val def_from_Rel_to_VAR : nt_definition -> nt_definition;;

val def_from_VAR_to_Rel : nt_definition -> nt_definition;;

