(**************************************************************************
  *********                     nttrans.ml                        *********
  **************************************************************************)

open Generic;;
open Term;;
open Names;;
open Reduction;;
open Std;;
open Pp;;
open More_util;;
open Mach;;

open Vectops;;
open Typing;;
open Termenv;;
open Util;;
open Tutil;;
open Ntparam;;
open Ntdef;;
open Ntaux;;

(**************************************************************************
  let spy = ref [];;
  let add_spy x = spy:= x :: !spy;;
  *************************************************************************
  *************************************************************************
  **************************************************************************)
let judgement_of_open_rel rc mv vl c =
 try core_fmachine true (rc, mv) vl c
 with
 | Invalid_argument s -> error ("Invalid arg " ^ s);;

let nt_sort_of_sort =
 function
    | Prop Null -> Ns_Prop
    | Prop Pos -> Ns_Set
(* remplacement de 
    | Type (Null, _) -> Ns_Type
    | Type (Pos, _) -> Ns_TypeSet;;
par *)
    | Type _   -> Ns_Type;;
(* pour adaptation a la V6 (o'caml) qui renonce a TypeSet *)

let out_sort c =
 match strip_outer_app_cast c with
 | DOP0 (Sort s) -> s
 | _ -> errorlabstrm "nttrans__out_sort" [< 'sTR "not a sort" >];;

let get_occurence_in_term i nc =
 let n = ref No0 in
 let hop () =
  match !n with
  | No0 -> n:=No1
  | _ -> raise (Failure "get_occurence_in_term:hop") in
 let rec f i =
  function
     | Rel j -> if i = j then hop ()
     | VAR _ -> ()
     | DOP0 (Inl (Meta _)) -> hop (); hop ()
     | DOP0 _ -> ()
     | DOP1 (_, c) -> f i c
     | DOP2 (_, c1, c2) -> f i c1; f i c2
     | DOPN (_, cv) -> Array.iter (f i) cv
     | DOPL (_, cl) -> List.iter (f i) cl
     | DLAM (_, c) -> f (i + 1) c
     | DLAMV (_, cv) -> Array.iter (f (i + 1)) cv in
 try f i nc; !n
 with
 | Failure "get_occurence_in_term:hop" -> NoS;;

let nc_get_occurence_in_type i nc =
 let n = ref No0 in
 let hop () =
  match !n with
  | No0 -> n:=No1
  | _ -> raise (Failure "nc_get_occurence_in_type:hop") in
 let rec f i =
  function
     | Rel j -> if i = j then hop ()
     | VAR _ -> ()
     | DOP0 (Meta _) -> hop (); hop ()
     | DOP0 _ -> ()
     | DOP1 (_, c) -> f i c
     | DOP2 (_, c1, c2) -> f i c1; f i c2
     | DOPN (_, cv) -> Array.iter (f i) cv
     | DOPL (_, cl) -> List.iter (f i) cl
     | DLAM (_, c) -> f (i + 1) c
     | DLAMV (_, cv) -> Array.iter (f (i + 1)) cv in
 let rec g i =
  function
     | Rel j -> ()
     | VAR _ -> ()
     | DOP0 _ -> ()
     | DOP1 ((Inr ({n_t=_, _, _, l; n_a=Na_fix_son (_, t)})), c) ->
      List.iter (f i) l;
      f i t;
      g i c
     | DOP1 ((Inr ({n_t=_, _, _, l})), c) -> List.iter (f i) l; g i c
     | DOP1 (_, c) -> g i c
     | DOP2 (_, c1, c2) -> g i c1; g i c2
     | DOPN (_, cv) -> Array.iter (g i) cv
     | DOPL (_, cl) -> List.iter (g i) cl
     | DLAM (_, c) -> g (i + 1) c
     | DLAMV (_, cv) -> Array.iter (g (i + 1)) cv in
 try g i nc; !n
 with
 | Failure "nc_get_occurence_in_type:hop" -> NoS;;

let nc_get_occurence i nc =
 get_occurence_in_term i nc, nc_get_occurence_in_type i nc;;

let def_app_data_elim = false, Rel 0;;

let def_app_use_count = Nauc_apply (
 (false, 
  (false, Up)), 
 (Nii_not, 
  (Nii_not, 0)));;

let rec red_head_immediate_conv rc i t =
 let t = strip_outer_app_cast t in
 if i > 0 then begin
   let t = strip_outer_app_cast t in
   match t with
    | DOP2 (Prod, typ, (DLAM (na, t'))) ->
     DOP2 (Prod, typ, DLAM (na, red_head_immediate_conv rc (i - 1) t'))
    | DOPN ((Const sp), v') ->
     if ref_list_mem sp immediate_delta_red_list then
      red_head_immediate_conv rc i (const_value rc t)
      else t
    | DOPN (AppL, v) ->
     (match v.(0) with
     | DOPN ((Const sp), v') -> if ref_list_mem sp immediate_delta_red_list then begin
                                  let h = const_value rc v.(0) in
                                  red_head_immediate_conv rc i
                                   (whd_betaiota
                                   (DOPN (AppL, cons_vect h (tl_vect v))))
                                end
                                 else t
     | _ -> t)
    | _ -> t
 end
  else t;;

let rec get_dd d i t =
 match i, strip_outer_cast t with
 | 0, t -> false, dependent (Rel d) t
 | i, (DOP2 (Prod, typ, (DLAM (_, t')))) ->
  let dep1, dep2 = get_dd (d + 1) (i - 1) t' in
  dep1 || dependent (Rel d) typ, dep2
 | _ -> false, dependent (Rel d) t;;

let nc_of_not_proof_constr n_t c =
 let note = make_annotation d_n_a n_t d_n_d d_n_j d_n_i d_n_f in
 DOP1 (Inr note, nc_of_c c);;

let cmp_sort s s' =
 match s, s' with
 | Ns_Prop, Ns_Prop -> true
 | Ns_Set, Ns_Set -> true
 | (Ns_Prop | Ns_Set), (Ns_Prop | Ns_Set) -> false
 | _ -> true;;

let get_lambda_link typ sort nc' =
 match nc' with
 | DOP1 ((Inr ({n_i=Ni_lambda ((sort', _, _), _, _)})),
           (DOP2 ((Inl Lambda), typ', _))) ->
  if cmp_sort sort sort' then
   (if conv (Evd.mt_evd()) typ (lift 1 (c_of_nc typ')) then Nll_type
   else Nll_sort)
   else Nll_none
 | _ -> Nll_none;;

let natural_constr_of_constr rc mv vl c t_out =
 let mv_types, mv_paths = split_snd mv in
 let rec f_all ok_prop vl c t_out =
  let c = strip_outer_app_cast c in
  let ok_prop, t_in = if ok_prop then (true, None)
   else begin
    let judge = judgement_of_open_rel rc mv_types vl c in
    let t_in = red_to_show rc judge._TYPE
    and sort = out_sort judge._KIND in
    sort = Prop Null, Some t_in
  end in
  if (not (ok_prop)) then begin
    let t_in =
     match t_in with
     | Some t -> t
     | None ->
      let judge = judgement_of_open_rel rc mv_types vl c in
      red_to_show rc judge._TYPE in
    let n_t =
     match t_out with
     | Some t -> true, true, true, [t_in; t]
     | None -> false, true, true, [t_in] in
    nc_of_not_proof_constr n_t c
  end
   else (match c with
   | (***************************************************************************)
     (*|                                 lambda                                |*)
     (***************************************************************************)
     DOP2 (Lambda, typ, (DLAM (na, c'))) ->
    let t_prod = option_app (try_red_to_prod rc) t_out in
    let t_out_son =
     match t_prod with
     | Some (DOP2 (Prod, _, (DLAM (_, t')))) -> Some t'
     | Some _ -> error "nttrans__ lambda_red_to_prod"
     | None -> None in
    let typ = red_to_show rc typ in
    let jtyp = fexemeta_type rc mv_types vl typ in
    let vl' = add_rel (na, jtyp) vl in
    let nc' = f_all true vl' c' t_out_son in
    let sort = nt_sort_of_sort (level_of_type jtyp)
    and occ = nc_get_occurence 1 nc'
    and in_case = None in
    let data = sort, occ, in_case
    and data_elim = None
    and use_count = 
     (false, Nll_none, Nc_misc), 
     (Nln_std, 
      (0, 0, 0)) in
    let n_i = Ni_lambda (data, data_elim, use_count) in
    let n_t =
     match t_out, t_prod with
     | (Some (DOP2 (Prod, _, _) as t)), _ -> true, true, true, [t]
     | (Some t), (Some t') -> true, true, true, [t'; t]
     | (Some _), _ -> error "nttrans__ lambda_red_to_prod"
     | None, _ ->
      (match nc_get_n_t nc' with
      | _, _, _, l ->
       (match list_last l with
       | Some t -> false, true, true, [DOP2 (Prod, typ, DLAM (na, t))]
       | None -> false, true, true, [])) in
    let note = make_annotation d_n_a n_t d_n_d d_n_j n_i d_n_f in
    nc_set_n_a (Na_lambda_son Nls_std) nc';
    DOP1 (Inr note, DOP2 (Inl Lambda, nc_of_c typ, DLAM (na, nc')))
   | (***************************************************************************)
     (*|                                 apply                                 |*)
     (***************************************************************************)
     DOPN (AppL, cv) ->
    let break_apply_arg_list t arg_list =
     let rec f ll_left l_left l_left_subst t l_right =
      match l_right, t with
      | (c :: l_right'), (DOP2 (Prod, typ, (DLAM (_, t')))) ->
       let l_left_subst' = c::l_left_subst
       and l_left' =
        let typ_subst = substl l_left_subst typ
        and dd = get_dd 1 (List.length l_right') t' in
        (c, typ_subst, dd)::l_left in
       f ll_left l_left' l_left_subst' t' l_right'
      | _ ->
       let t_subs = substl l_left_subst t in
       let ll_left' = (List.rev l_left, t_subs)::ll_left in
       if l_right = [] then ll_left'
        else begin
         let
         t_subs =
          red_head_immediate_conv rc (List.length l_right)
          (force_red_to_prod rc t_subs) in
         f ll_left' [] [] t_subs l_right
       end in
     if arg_list = [] then []
      else begin
       let
       t =
        red_head_immediate_conv rc (List.length arg_list)
        (force_red_to_prod rc t) in
       List.rev (f [] [] [] t arg_list)
     end in
    let compute_one_arg (c, t, (d1, d2 as dd)) =
     let nc = if d1 || d2 then nc_of_not_proof_constr (false, true, true, [t]) c
      else f_all false vl c (Some (red_to_show rc t)) in
     let n =
      match dd with
      | false, false -> Nasa_sub (None, 0)
      | true, false -> Nasa_wit
      | false, true -> Nasa_obv
      | true, true -> Nasa_dep in
     let n_a = Na_app_son (true, n, Nase) in
     nc_set_n_a n_a nc; nc, dd in
    let compute_one_app head (l, t) =
     let arg_list, dd_list = List.split (List.map compute_one_arg l) in
     let is_construct = nc_is_construct head
     and nbr_subs = list_number (function a, b -> (not ((a || b)))) dd_list in
     let can_omit =
      match nc_body head with
      | DOPN ((Inl (Const sp)), _) -> ref_set_mem sp apply_omit_const_set
      | DOPN ((Inl (MutConstruct (x0,x1))), _) ->
       ref_set_mem (x0,x1) apply_omit_construct_set
      | _ -> false in
     let data_apply =
      let sub = nbr_subs <> 0
      and wit = List.mem (true, false) dd_list
      and obv = List.mem (false, true) dd_list
      and dep = List.mem (true, true) dd_list in
      is_construct, can_omit, 
       (sub, wit, obv, dep)
     and data_elim = None
     and use_count = Nauc_apply (
      (is_construct, 
       (can_omit, Dn)), 
      (Nii_not, 
       (Nii_not, nbr_subs)))
     and dep = List.mem (true, true) dd_list in
     let n_i = Ni_app (
      (data_apply, data_elim), use_count) in
     let n_t = false, true, true, [red_to_show rc t] in
     let note = make_annotation d_n_a n_t d_n_d d_n_j n_i d_n_f in
     let ncv = Array.of_list (head::arg_list) in
     let n_a_h = Na_app_son (true, Nasa_head, Nase) in
     nc_set_n_a n_a_h head; DOP1 (Inr note, DOPN (Inl AppL, ncv)) in
    let compute_all_apps head ll = List.fold_left compute_one_app head ll in
    let head, arg_list =
     let l = Array.to_list cv in
     List.hd l, List.tl l in
    let head = f_all true vl head None in
    let head_type =
     match nc_get_n_t head with
     | _, _, _, (t :: _) -> t
     | _ -> error "nttrans__ apply_head_type" in
    let ll = break_apply_arg_list head_type arg_list in
    let nc = compute_all_apps head ll in
    (match t_out with
     | Some t -> nc_set_n_t (true, true, true, 
                  ((function _, _, _, l -> l @ [t]) (nc_get_n_t nc))) nc
     | _ -> ()); nc
   | (***************************************************************************)
     (*|                                mutcase                                |*)
     (***************************************************************************)
     DOPN (MutCase _, _) as mt ->
    (let (_,p,h,case_array) = destCase mt in
     let case_list = Array.to_list case_array in
     let p_judge = judgement_of_open_rel rc mv_types vl p
     and h_judge = judgement_of_open_rel rc mv_types vl h in
     let cst, spi =
      match apply_head (whd_betadeltaiotaeta rc h_judge._TYPE) with
      | DOPN ((MutInd (x0,x1)), _) as c -> c, (x0,x1)
      | c ->
       errorlabstrm "nttrans__proof_natural_constr_of_constr"
        [< 'sTR "malformed MutCase in nttrans__proof_natural_constr_of_constr";
        Printer.term0 vl c >] in
     let prop_h = out_sort h_judge._KIND = Prop Null in
     let (_,case_type_vect, t_in) =
       type_case_branches vl rc h_judge._TYPE p_judge._TYPE p h
     in
     let t_in = Array.iter (fun e -> let _ = red_to_show rc in ()) case_type_vect; red_to_show rc t_in in
     let nparams, constr_type_vect =
      let mispec = mind_specif_of_mind cst in
      mis_nparams mispec, snd (mis_type_mconstructs mispec) in
     let
     n_prod_expected_product_list =
      map_vect_list (function c -> count_prod c - nparams) constr_type_vect in
     let case_list =
      try
       combine_3 case_list (Array.to_list case_type_vect)
       n_prod_expected_product_list
      with
      | Failure "combine_3" -> error "nttrans__proof_natural_constr_of_constr"
     in
     let nc_vect =
      let compute_case (c, t, n) =
       let nc = f_all true vl c (Some t)
       and n_a =
        Na_app_son
        (true, Nasa_sub (None, 0), Nase_case (false, None, n, Ncn_std, Some []))
       in
       nc_set_n_a n_a nc;
       nc_set_n_lambda_in_case n (Some false) nc;
       nc in
      let p = nc_of_not_proof_constr (false, true, true, []) p
      and n_a_p = Na_app_son (true, Nasa_head, Nase_prop)
      and n_i_p = Ni_id (Nin_elim_theorem cst)
      and h = if prop_h then f_all prop_h vl h None
       else
       nc_of_not_proof_constr (false, true, true, [red_to_show rc h_judge._TYPE])
       h
      and n_a_h = Na_app_son (true, Nasa_sub (None, 0), Nase_destruct prop_h)
      and l = List.map compute_case case_list in
      nc_set_n_a n_a_h h;
      nc_set_n_a n_a_p p;
      nc_set_n_i n_i_p p;
      Array.of_list (p::h::l) in
     let omit = ref_set_mem spi elim_omit_cst_set in
     let data_apply = false, false, 
      (true, false, false, true)
     and data_elim = Some (false, omit, cst)
     and use_count = Nauc_elim (
      (false, true), 
      (Nii_not, 0, 
       (0, 0, 0))) in
     let n_p = true
     and n_i = Ni_app (
      (data_apply, data_elim), use_count) in
     let n_t =
      match t_out with
      | Some t -> true, true, true, [t_in; t]
      | None -> false, true, true, [t_in] in
     let note = make_annotation d_n_a n_t d_n_d d_n_j n_i d_n_f in
     DOP1 (Inr note, DOPN (Inl (MutCase None (* Que mettre ? HH 1/98 *)), nc_vect)))
   | (***************************************************************************)
     (*|                                  fix                                  |*)
     (***************************************************************************)
     DOPN (Fix _, _) ->
    let (vn,i,lar,lfi,vdef) = destFix c in
    let nbfix = Array.length lar in
    let
    newvl =
     it_vect2 (fun vl name ar -> add_rel (name, ar) vl) vl
     (Array.of_list lfi) (map_i_vect (fun i -> type_app (lift i)) 0 lar) in
    let lar = Array.map body_of_type lar in
    let larj = Array.map nc_of_c lar in
    let vdefj =
     let f na c t =
      let nc = f_all false newvl c (Some t) in
      nc_set_n_a (Na_fix_son (id_of_name def_id na, t)) nc; nc in
     map3_vect f (Array.of_list (List.rev lfi)) vdef (Array.map (lift nbfix) lar) in
    let vdefv = put_DLAMSV (List.rev lfi) vdefj in
    let larv = larj in
    let fix = DOPN (Inl (Fix (vn, i)), Array.append larv ([|vdefv|])) in
    let n_i = Ni_fix nbfix in
    let t_in =
     match t_in with
     | Some t -> t
     | None ->
      let judge = judgement_of_open_rel rc mv_types vl c in
      red_to_show rc judge._TYPE in
    let n_t =
     match t_out with
     | Some t -> true, true, true, [t_in; t]
     | None -> false, true, true, [t_in] in
    let note = make_annotation d_n_a n_t d_n_d d_n_j n_i d_n_f in
    DOP1 (Inr note, fix)
   | (***************************************************************************)
     (*|                               identifier                              |*)
     (***************************************************************************)
     DOPN ((Const _), _) | DOPN ((MutConstruct _), _) | Rel _ | VAR _ ->
    let nat =
     match c with
     | DOPN ((Const sp), v) -> if is_const_defined sp then Nin_theorem
                                else Nin_axiom
     | DOPN ((MutConstruct ((sp,i), j)), v) -> Nin_construct (DOPN (MutInd (sp,i), v))
     | VAR _ | Rel _ -> Nin_var false
     | _ -> error "nttrans__proof_natural_constr_of_constr" in
    let t_in =
     match t_in with
     | Some t -> t
     | None ->
      let judge = judgement_of_open_rel rc mv_types vl c in
      red_to_show rc judge._TYPE in
    let n_i = Ni_id nat in
    let n_t =
     match t_out with
     | Some t -> true, true, true, [t_in; t]
     | None -> false, true, true, [t_in] in
    let note = make_annotation d_n_a n_t d_n_d d_n_j n_i d_n_f in
    DOP1 (Inr note, nc_of_c c)
   | (***************************************************************************)
     (*|                                metavar                                |*)
     (***************************************************************************)
     DOP0 (Meta i) ->
    let p =
     try List.assoc i mv_paths
     with
     | Not_found -> [] in
    let n_i = Ni_metavar p in
    let t_in =
     try List.assoc i mv_types
     with
     | Not_found -> error "nttrans__metavar_type" in
    let n_t =
     match t_out with
     | Some t -> true, true, true, [t_in; t]
     | None -> false, true, true, [t_in] in
    let note = make_annotation d_n_a n_t d_n_d d_n_j n_i d_n_f in
    DOP1 (Inr note, DOP0 (Inl (Meta i)))
   | (***************************************************************************)
     (*|                                 misc                                  |*)
     (***************************************************************************)
     _ ->
    let t_in =
     match t_in with
     | Some t -> t
     | None ->
      let judge = judgement_of_open_rel rc mv_types vl c in
      red_to_show rc judge._TYPE in
    let n_t =
     match t_out with
     | Some t -> true, true, true, [t_in; t]
     | None -> false, true, true, [t_in] in
    nc_of_not_proof_constr n_t c) in
 f_all false vl c (Some (red_to_show rc t_out));;
(**************************************************************************
  **************************************************************************)

