(* $Id: camlp4dep.ml,v 1.2 1997/10/18 20:52:44 ddr Exp $ *)

value main () =
  for i = 1 to Array.length Sys.argv - 1 do
    let fname = Sys.argv.(i) in
    if Filename.check_suffix fname ".ml4" then
      let (comm, args) = Get_comm.f fname in
      let deps =
        List.fold_right
          (fun x xl ->
             if (Filename.check_suffix x ".cmo"
                 || Filename.check_suffix x ".cma")
             && x.[0] == '.' || x.[0] == '/' then [x :: xl]
             else xl)
        args []
      in
      if deps <> [] then
        do Printf.printf "%s.cmo:" (Filename.chop_suffix fname ".ml4");
           List.iter (fun x -> Printf.printf " %s" x) deps;
           Printf.printf "\n";
           Printf.printf "%s.cmx:" (Filename.chop_suffix fname ".ml4");
           List.iter (fun x -> Printf.printf " %s" x) deps;
           Printf.printf "\n";
           flush stdout;
        return ()
      else ()
    else ();
  done
;

Printexc.catch main ();
