-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for Gtk?Box objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"

deferred class GTK_BOX_WRITER

inherit

	GTK_COMPOSED_BIN_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation, append_add_widget_code
		end

	CHILD

feature

	type:STRING is "GTK_BOX"
	
	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			homogeneous := widget_tree.get_boolean_string_from_field("homogeneous")
			if homogeneous = "" then
				homogeneous := "False"
			end
			spacing := widget_tree.get_string_from_field("spacing")
			create_child_class_array(widget_tree.find_children("widget"))
		end
			
	spacing:STRING
	
	homogeneous:STRING

	append_add_widget_code(code: ARRAY[STRING]; widget: CAN_BE_CREATED) is
		local
			temp_child: CHILD
		do
			temp_child ?= widget
			code.add_last(name + ".pack("+widget.name+", "+
				temp_child.boolean_property("expand") + ", " + 
				temp_child.boolean_property("fill") + ", "+
				temp_child.property("padding") + ")")
		end
	
	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("!!" + name + "." + creation_feature +"("+homogeneous+", "+spacing+")")
			add_widget_code(code)
			precursor(code)
		end

	creation_feature: STRING is
		deferred
		end

end
