-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkCheckMenuItem objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"

class GTK_CHECK_MENU_ITEM_WRITER

inherit

	GTK_MENU_ITEM_WRITER
		redefine
			make, append_parent_creation, type
		end
	
creation

	make

feature

		
	type: STRING is "GTK_CHECK_MENU_ITEM"

	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		local
			radio_writer_list: ARRAY[GTK_RADIO_MENU_ITEM_WRITER]
		do
			precursor(attr_name, tree, src)
			-- the precursor will create a list of sub widgets which is pretty
			-- pointless as noone would want a submenu to come out of a check
			-- item, but glade will let you do it.
			active := widget_tree.get_boolean_string_from_field("active")
			always_show_toggle :=
				widget_tree.get_boolean_string_from_field("always_show_toggle")
		end

	active: STRING
	always_show_toggle: STRING

	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("!!" + name + ".make_with_label(%""+label+"%")")
			add_common_menu_item_code(code)
			code.add_last(name + ".set_active("+ active + ")")
			code.add_last(name + ".set_show_toggle(" +always_show_toggle+ ")")
		end

	groups_list: DICTIONARY[ARRAY[GTK_RADIO_MENU_ITEM_WRITER], STRING] is
		once
			!!Result.make
		end

end
