-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkPixmap objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"

class GTK_PIXMAP_WRITER
-- Doesn't work as there are problems with having to give the parent object in it's
-- initial creation when the parent object probably only gets created later!

inherit

	GTK_ATTRIBUTE_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation
		end
	
	CHILD

creation

	make

feature

		
	type: STRING is "GTK_PIXMAP"

	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			filename := widget_tree.get_string_from_field("filename")
            xalign := widget_tree.get_real_string_from_field("xalign")
            yalign := widget_tree.get_real_string_from_field("yalign")
            xpad := widget_tree.get_integer_string_from_field("xpad")
            ypad := widget_tree.get_integer_string_from_field("ypad")
		end
			
	filename: STRING
    xalign: STRING
    yalign: STRING
    xpad: STRING
    ypad: STRING
	
	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("!!" + name + ".make_from_xpm(Current, %""+filename+"%")")
            code.add_last(name + ".set_alignment("+xalign+", "+yalign+")")
            code.add_last(name + ".set_padding("+xpad+", "+ypad+")")
			add_widget_code(code)
		end

end
