-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for Gtk?Scrollbar objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"

deferred class GTK_SCROLLBAR_WRITER

inherit

	GTK_ATTRIBUTE_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_declaration, append_parent_creation
		end
	
	CHILD

feature

	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			policy := widget_tree.get_string_from_field("policy")
			value := widget_tree.get_real_string_from_field("hvalue")
			lower := widget_tree.get_real_string_from_field("hlower")
			upper := widget_tree.get_real_string_from_field("hupper")
			step := widget_tree.get_real_string_from_field("hstep")
			page := widget_tree.get_real_string_from_field("hpage")
			page_size := widget_tree.get_real_string_from_field("hpage_size")
		end
			
	policy: STRING
	value: STRING
	lower: STRING
	upper: STRING
	step: STRING
	page: STRING
	page_size: STRING
	
	append_parent_declaration(code: ARRAY[STRING]) is
		do
			code.add_last(name + "_adjustment: GTK_ADJUSTMENT")
			code.add_last(name + ": "+type)
		end

	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("!!" + name + "_adjustment.make("+ value + ", " +
				lower + ", " + upper + ", " + step + ", " + page + ", " +
				page_size + ")")
			code.add_last("!!" + name + ".make("+name+"_adjustment)")
			code.add_last(name + ".set_update_policy("+policy+")")
			add_widget_code(code)
		end

end
