/*
   Copyright 1999 Richie Bielak and others
   Licensed under Eiffel Forum Freeware License, version 1;
   (see forum.txt)
*/
/*

  eif_gtk.c - v 0.3.3

  This file contains the external routines whose code is common between
  all Eiffel compilers.


 */

#include <gtk/gtk.h>

#include "eif_gtk.h"


/*****  GtkObject fields *****/
GtkObjectClass *c_gtk_object_klass (GtkObject *o) {
  return (o->klass);
}

guint32 c_gtk_object_flags (GtkObject *o) {
  return (o->flags);
}

GData *c_gtk_object_data (GtkObject *o) {
  return (o->object_data);
}

/***** GtkWidget fields *****/
gchar *c_gtk_widget_name (GtkWidget *w) {
  return (w->name);
}

GtkStyle* c_gtk_widget_get_style (GtkWidget* widget)
{
	return widget -> style;
}

GdkWindow *c_gtk_widget_window (GtkWidget *w) 
{
  return (w->window);
}

GtkWidget *c_gtk_widget_parent (GtkWidget *w) {
  return (w->parent);
}

/* Set widget flags */
void c_gtk_widget_set_flags (GtkWidget *widget, int flags) 
{
  GTK_WIDGET_SET_FLAGS (widget, flags);
}

EIF_BOOLEAN c_gtk_widget_visible (GtkWidget *w) 
{
  if (GTK_WIDGET_VISIBLE(w))
	return (1);
  else
	return (0);
}

EIF_INTEGER c_gtk_widget_width (GtkWidget *w)
{
  EIF_INTEGER result = 0;
  if (w != NULL)
	result = w->allocation.width;
  return (result);
}

EIF_INTEGER c_gtk_widget_height (GtkWidget *w)
{
  EIF_INTEGER result = 0;
  if (w != NULL)
	result = w->allocation.height;
  return (result);
}


GtkWidget *c_focus_child (GtkWidget *w) {
  return (GTK_CONTAINER(w)->focus_child);
}

gchar *c_label_text (GtkWidget *w) {
  return (GTK_LABEL(w)->label);
}

/****** GTK_BIN *********/
GtkWidget *c_gtk_bin_child (GtkWidget *w) {
  return (GTK_BIN(w)->child);
}

/****** GTK_BUTTON ******/

/* Return a state of a toggle button */
int c_gtk_toggle_button_active (GtkWidget *button) 
{
  return (GTK_TOGGLE_BUTTON(button)->active);
}


/****** Dialogs ******/

GtkWidget* c_dialog_vbox(GtkDialog *p) { 
  return p->vbox;
}

GtkWidget* c_dialog_action_area(GtkDialog *p) { 
  return p->action_area;
}

/****** Notebooks ******/

int c_gtk_notebook_is_tabs_shown(GtkNotebook *p)
{
  return p->show_tabs;
}

int c_gtk_notebook_is_border_shown(GtkNotebook *p)
{
  return p->show_border;
}

int c_gtk_notebook_current_tab_pos(GtkNotebook *p)
{
  return p->tab_pos;
}

/****** file selector ******/
GtkWidget *c_gtk_file_selection_ok_button (GtkFileSelection *fs) {
  return (fs->ok_button);
}

GtkWidget *c_gtk_file_selection_cancel_button (GtkFileSelection *fs) {
  return (fs->cancel_button);
}

/***** Color selection *****/
GtkWidget *c_gtk_color_selection_dialog_ok_button (GtkColorSelectionDialog *cs) {
  return (cs->ok_button);
}

GtkWidget *c_gtk_color_selection_dialog_cancel_button (GtkColorSelectionDialog *cs) {
  return (cs->cancel_button);
}
GtkWidget *c_gtk_color_selection_dialog_colorsel (GtkColorSelectionDialog *cs) {
  return (cs->colorsel);
}

/***** Font selection ******/
GtkWidget *c_gtk_font_selection_dialog_ok_button(GtkFontSelectionDialog *fs)
{
	return fs->ok_button;
}

GtkWidget *c_gtk_font_selection_dialog_apply_button(GtkFontSelectionDialog *fs)
{
	return fs->apply_button;
}

GtkWidget *c_gtk_font_selection_dialog_cancel_button(GtkFontSelectionDialog *fs)
{
	return fs->cancel_button;
}

GtkWidget *c_gtk_font_selection_dialog_fontsel (GtkFontSelectionDialog *fs) {
  return (fs->fontsel);
}

GtkWidget *c_gtk_gamma_curve_curve(GtkGammaCurve *gc) {
	return (gc->curve);
}

GdkImage* c_gdk_image_new (GdkVisual* visual, int width, int height)
{
	return gdk_image_new (GDK_IMAGE_FASTEST, visual, width, height);
}

/* xxiii ISE forces external "C" names to lower case */
GdkWindow* c_gtk_widget_get_window (GtkWidget* widget)
{
	return widget -> window;
}

/* frido 1999-10-01 */
GtkWidget *c_gtk_color_selection_dialog_help_button(GtkColorSelectionDialog
                                                    *cs) {
  return (cs->help_button);
}

GdkGC* c_gtk_style_get_fg_gc (GtkStyle* style, int index)
{
	if ((index < 0) || (index >= sizeof (style -> fg_gc)))
		return 0;
	return style -> fg_gc [index];
}

GdkGC* c_gtk_style_get_bg_gc (GtkStyle* style, int index)
{
	if ((index < 0) || (index >= sizeof (style -> bg_gc)))
		return 0;
	return style -> bg_gc [index];
}

GdkGC* c_gtk_style_get_light_gc (GtkStyle* style, int index)
{
	if ((index < 0) || (index >= sizeof (style -> light_gc)))
		return 0;
	return style -> light_gc [index];
}

GdkGC* c_gtk_style_get_dark_gc (GtkStyle* style, int index)
{
	if ((index < 0) || (index >= sizeof (style -> dark_gc)))
		return 0;
	return style -> dark_gc [index];
}

GdkGC* c_gtk_style_get_mid_gc (GtkStyle* style, int index)
{
	if ((index < 0) || (index >= sizeof (style -> mid_gc)))
		return 0;
	return style -> mid_gc [index];
}

GdkGC* c_gtk_style_get_text_gc (GtkStyle* style, int index)
{
	if ((index < 0) || (index >= sizeof (style -> text_gc)))
		return 0;
	return style -> text_gc [index];
}

GdkGC* c_gtk_style_get_base_gc (GtkStyle* style, int index)
{
	if ((index < 0) || (index >= sizeof (style -> base_gc)))
		return 0;
	return style -> base_gc [index];
}

GdkGC* c_gtk_style_get_black_gc (GtkStyle* style)
{
	return style -> black_gc;
}

GdkGC* c_gtk_style_get_white_gc (GtkStyle* style)
{
	return style -> white_gc;
}

/****** GdkEvent ******/

GdkEventType c_gdk_event_type (GdkEvent *event) {
  return (event -> type);
}

/****** GdkEventMotion ******/
GdkWindow* c_gdk_event_motion_get_window (GdkEventMotion* gme)
{
	return gme -> window;
}

gint8 c_gdk_event_motion_get_send_event (GdkEventMotion* gme)
{
	return gme -> send_event;
}

guint32 c_gdk_event_motion_get_time (GdkEventMotion* gme)
{
	return gme -> time;
}

gdouble c_gdk_event_motion_get_x (GdkEventMotion* gme)
{
	return gme -> x;
}

gdouble c_gdk_event_motion_get_y (GdkEventMotion* gme)
{
	return gme -> y;
}

gdouble c_gdk_event_motion_get_pressure (GdkEventMotion* gme)
{
	return gme -> pressure;
}

gdouble c_gdk_event_motion_get_xtilt (GdkEventMotion* gme)
{
	return gme -> xtilt;
}

gdouble c_gdk_event_motion_get_ytilt (GdkEventMotion* gme)
{
	return gme -> ytilt;
}

guint c_gdk_event_motion_get_state (GdkEventMotion* gme)
{
	return gme -> state;
}

gint16 c_gdk_event_motion_get_is_hint (GdkEventMotion* gme)
{
	return gme -> is_hint;
}

guint32 c_gdk_event_motion_get_deviceid (GdkEventMotion* gme)
{
	return gme -> deviceid;
}

gdouble c_gdk_event_motion_get_x_root (GdkEventMotion* gme)
{
	return gme -> x_root;
}

gdouble c_gdk_event_motion_get_y_root (GdkEventMotion* gme)
{
	return gme -> y_root;
}

/****** GdkEventButton ******/
/* at the time this comment was written (199903210601 utc)
 * this is an almost exact duplicate of GdkEventMotion (is_state/button is
 * different)
 */
GdkWindow* c_gdk_event_button_get_window (GdkEventButton* gme)
{
	return gme -> window;
}

gint8 c_gdk_event_button_get_send_event (GdkEventButton* gme)
{
	return gme -> send_event;
}

guint32 c_gdk_event_button_get_time (GdkEventButton* gme)
{
	return gme -> time;
}

gdouble c_gdk_event_button_get_x (GdkEventButton* gme)
{
	return gme -> x;
}

gdouble c_gdk_event_button_get_y (GdkEventButton* gme)
{
	return gme -> y;
}

gdouble c_gdk_event_button_get_pressure (GdkEventButton* gme)
{
	return gme -> pressure;
}

gdouble c_gdk_event_button_get_xtilt (GdkEventButton* gme)
{
	return gme -> xtilt;
}

gdouble c_gdk_event_button_get_ytilt (GdkEventButton* gme)
{
	return gme -> ytilt;
}

guint c_gdk_event_button_get_state (GdkEventButton* gme)
{
	return gme -> state;
}

guint c_gdk_event_button_get_button (GdkEventButton* gme)
{
	return gme -> button;
}

guint32 c_gdk_event_button_get_deviceid (GdkEventButton* gme)
{
	return gme -> deviceid;
}

gdouble c_gdk_event_button_get_x_root (GdkEventButton* gme)
{
	return gme -> x_root;
}

gdouble c_gdk_event_button_get_y_root (GdkEventButton* gme)
{
	return gme -> y_root;
}

guint32 c_gtk_object_get_flags (GtkObject* object)
{
	return GTK_OBJECT_FLAGS(object);
}

/* C MACRO boolean queries, return 0 for false, non-0 for true */
int c_gtk_widget_no_window (GtkWidget* widget)
{
	return GTK_WIDGET_NO_WINDOW(widget);
}

int c_gtk_widget_realized (GtkWidget* widget)
{
	return GTK_WIDGET_REALIZED(widget);
}


int c_gtk_is_widget (GtkWidget *widget) {
  return GTK_IS_WIDGET (widget);
}
/* end C MACRO boolean queries */


/****** gc_values accessors ******/

int c_gdk_gc_values_get_function (GdkGCValues* values)
{
	return values -> function;
}

void c_gdk_gc_values_set_function (GdkGCValues* values, int value)
{
	values -> function = value;
}

/* end gc_values accessors */


/* C helpers, these don't generally call a gdk/gtk function */
/* but do or setup something necessary for some gdk/gtk functions */
/* that can't be done directly in eiffel code */

GdkGCValues* c_gdk_make_gc_values ()
{
	GdkGCValues* p;
	p = (GdkGCValues*) g_malloc (sizeof (*p));
	/* HERE TODO:, but under control of the Eiffel memory system */
	return p;
}

/* end C helpers */

/****** GtkAdjustment accessors ******/

float c_gtk_adjustment_get_lower (GtkAdjustment* adjustment)
{
	return adjustment -> lower;
}

void c_gtk_adjustment_set_lower (GtkAdjustment* adjustment, float value)
{
	adjustment -> lower = value;
}

float c_gtk_adjustment_get_upper (GtkAdjustment* adjustment)
{
	return adjustment -> upper;
}

void c_gtk_adjustment_set_upper (GtkAdjustment* adjustment, float value)
{
	adjustment -> upper = value;
}

float c_gtk_adjustment_get_page_increment (GtkAdjustment* adjustment)
{
	return adjustment -> page_increment;
}

void c_gtk_adjustment_set_page_increment (GtkAdjustment* adjustment, float value)
{
	adjustment -> page_increment = value;
}

float c_gtk_adjustment_get_page_size (GtkAdjustment* adjustment)
{
	return adjustment -> page_size;
}

void c_gtk_adjustment_set_page_size (GtkAdjustment* adjustment, float value)
{
	adjustment -> page_size = value;
}

float c_gtk_adjustment_get_step_increment (GtkAdjustment* adjustment)
{
	return adjustment -> step_increment;
}

void c_gtk_adjustment_set_step_increment (GtkAdjustment* adjustment, float value)
{
	adjustment -> step_increment = value;
}

float c_gtk_adjustment_get_value (GtkAdjustment* adjustment)
{
	return adjustment -> value;
}
/* set value is present in the gtk library, and directly called from the eiffel
 * code.
 */

/* end GtkAdjustment accessors */

/****** GtkText adjustments ******/

GtkAdjustment * c_gtk_text_hadj (GtkText * text)
{
		return text->hadj;
}

GtkAdjustment * c_gtk_text_vadj (GtkText * text)
{
		return text->vadj;
}

/* end of GtkText adjustments */

/****** GtkCList features *****/

EIF_INTEGER c_gtk_clist_col_count (GtkCList * clist)
{
	return (EIF_INTEGER) clist->columns;
}

EIF_INTEGER c_gtk_clist_row_count (GtkCList * clist)
{
	return (EIF_INTEGER) clist->rows;
}

EIF_BOOLEAN c_gtk_clist_autosorting (GtkCList * clist)
{
	return (EIF_BOOLEAN) GTK_CLIST_AUTO_SORT(clist);
}

/* ----------------------------------------------------- */
/* Create a pixmap widget from an xpm file */
GtkWidget *c_gtk_pixmap_create_from_xpm (GtkWidget *widget, char *fname) 
{
  GdkBitmap *mask;
  GdkPixmap *pixmap;
  
  /* Widget must be realized before we can attach a pixmap to it */
  if (widget->window == NULL)
	gtk_widget_realize (widget);
  pixmap = gdk_pixmap_create_from_xpm (widget->window,
		   &mask, 
		   &widget->style->bg[GTK_STATE_NORMAL],
		   fname);
  return (gtk_pixmap_new (pixmap, mask));
}

/* Combo Boxes */

/* Create a GList from an array of char *'s */
void c_gtk_combo_set_popdown_strings(GtkCombo *combo, char **strings, int count)
{
	int i;
	GList *list;
	GList *temp;

	if(count > 0)
	{
		list = g_list_alloc();
		list->data = strings[0];
		temp = list;
		for(i = 1; i < count; i++)
		{
			temp->next = g_list_alloc();
			temp->next->prev = temp;
			temp = temp->next;
			temp->data = strings[i];
		}
	}
	else
		list = NULL;
	gtk_combo_set_popdown_strings(combo, list);
}

/* Return a pointer to the entry component of a combo box */
GtkWidget* c_gtk_combo_entry(GtkCombo* combo) {
		return combo->entry;
}

/* Return a pointer to the list component of a combo box */
GtkWidget* c_gtk_combo_list(GtkCombo* combo) {
		return combo->list;
}

/* Button Boxes */

int c_gtk_button_box_get_child_size_min_width_default()
{
	int width, height;
	gtk_button_box_get_child_size_default(&width, &height);
	return width;
}

int c_gtk_button_box_get_child_size_min_height_default()
{
	int width, height;
	gtk_button_box_get_child_size_default(&width, &height);
	return height;
}

int c_gtk_button_box_get_child_ipadding_x_default()
{
	int ipad_x, ipad_y;
	gtk_button_box_get_child_ipadding_default(&ipad_x, &ipad_y);
	return ipad_x;
}

int c_gtk_button_box_get_child_ipadding_y_default()
{
	int ipad_x, ipad_y;
	gtk_button_box_get_child_ipadding_default(&ipad_x, &ipad_y);
	return ipad_y;
}

int c_gtk_button_box_get_child_size_min_width(GtkButtonBox* box)
{
	int width, height;
	gtk_button_box_get_child_size(box, &width, &height);
	return width;
}

int c_gtk_button_box_get_child_size_min_height(GtkButtonBox* box)
{
	int width, height;
	gtk_button_box_get_child_size(box, &width, &height);
	return height;
}

int c_gtk_button_box_get_child_ipadding_x(GtkButtonBox* box)
{
	int ipad_x, ipad_y;
	gtk_button_box_get_child_ipadding(box, &ipad_x, &ipad_y);
	return ipad_x;
}

int c_gtk_button_box_get_child_ipadding_y(GtkButtonBox* box)
{
	int ipad_x, ipad_y;
	gtk_button_box_get_child_ipadding(box, &ipad_x, &ipad_y);
	return ipad_y;
}

void c_gtk_paned_set_handle_size(GtkPaned *paned, int size)
{
	gtk_paned_set_handle_size(paned, (guint16) size);
}

void c_gtk_paned_set_gutter_size(GtkPaned *paned, int size)
{
	gtk_paned_set_gutter_size(paned, (guint16) size);
}
