
/*
   Copyright 1999 Richie Bielak and others
   Licensed under Eiffel Forum Freeware License, version 1;
   (see forum.txt)
*/
/*

  eif_gtk_ise.c - v 0.3.3

  This file contains C code specific to ISE compiler.


 */

#include <gtk/gtk.h>
#include "eif_gtk.h"

/* Data needed for callbacks */
typedef  struct _callback_data {
  EIF_PROC rtn;
  EIF_OBJ obj;
  void *data;
} callback_data;


/* Callback arguments */
typedef struct _args_data {
  guint   nparams;
  GtkArg  *args;
  GtkType *arg_types;
  GtkArg  *return_valuep;
} args_data;


void callback_entry_func (GtkObject *object, 
						  gpointer        data,
						  guint           nparams,
						  GtkArg         *args,
						  GtkType        *arg_types,
						  GtkType         return_type);


/* -------- Initialization -----------------------------------*/
/* Pass command line arguments to the GTK initialization code */
/* In ISE's runtime there are references to these in "argv.h" */
void c_gtk_init_tool_kit () {
  gtk_init (&eif_argc, &eif_argv);
  gtk_signal_set_funcs(callback_entry_func, NULL); 
}

/* --------------- Callbacks ------------------*/
/* Connect a call back to a widget/event pair */
gint c_gtk_signal_connect (GtkObject *widget, 
						   gchar *name, 
						   EIF_PROC func,
						   EIF_OBJ object,
						   callback_data **p)
{
  callback_data *cbd;
  int name_len;

  eif_freeze (object);  
  cbd = (callback_data *)g_malloc (sizeof (callback_data));
  /* Return the pointer of the allocated block to Eiffel, so it
	 can be deallocated later
  */
  *p = cbd;
  cbd->rtn = func;
  cbd->obj = eif_access (object);
  /* No callback routine here, all callbacks come through "callback_entry_func" */
  return (gtk_signal_connect (widget, name, NULL, (gpointer)cbd));
}

/* This function dispatches all the callbacks from GTK+ to Eiffel */
/* "data" is the Eiffel callback structure.                       */
void callback_entry_func (GtkObject *object, 
						  gpointer        data,
						  guint           nparams,
						  GtkArg         *args,
						  GtkType        *arg_types,
						  GtkType         return_type)
{
  callback_data *cbd;
  args_data argsd;

  /* Get the pointer to the callback block */
  cbd = (callback_data *)data;
  /* Save the arguments in a local struct */
  argsd.nparams = nparams;
  argsd.args = args;
  argsd.arg_types = arg_types;
  /* Set pointer to the return value */
  if (return_type == GTK_TYPE_NONE) 
	argsd.return_valuep = NULL;
  else
	argsd.return_valuep = &args[nparams];

  /* Call Eiffel */
  /*  printf ("callback= %d object= %d cbd= %d\n", cbd->rtn, (cbd->obj), cbd); */
  (cbd->rtn)(cbd->obj, nparams, &argsd);

}

/* Free callback data. Called from "dispose" */

void c_free_call_back_block (callback_data *p) 
{
  if (p != NULL)
	g_free (p);
}


/*------ Routines for fetching callback args ----- */

gpointer c_fetch_pointer (args_data *ap, int i) {
  /* Return i-th argument as a pointer */
  gpointer result;
  result = GTK_VALUE_POINTER (ap->args[i]);
  return (result);
}

/* Set return value for a callback */
void c_set_return_value_bool (args_data *ap, int ret_val) {
  if (ap->return_valuep != NULL)
	*GTK_RETLOC_BOOL(*(ap->return_valuep)) = ret_val;
}

