indexing
	description: "Load enums from a C header file"
	status: "see notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/10/31 10:36:41 $"
	revision: "$Revision: 1.1.1.1 $"

class
	C_ENUM_LOADER

inherit
	EXECUTION_ENVIRONMENT

	TMP_FILE_NAMER

	C_ENUM_SCANNER

creation

	run

feature -- Initialization

	run (pp_file_name, new_h_file_name, new_c_flags: STRING; enums: C_ENUMS; t: TICKER) is
			-- Load `enums' from `pp_file_name'
		local
			pp_file: RAW_FILE
		do
			loaded_enums := enums
			h_file_name := new_h_file_name
			c_flags := new_c_flags
			ticker := t
			!!pp_file.make_open_read (pp_file_name)
			make_with_file (pp_file)
			load_enums
			pp_file.close
		end

feature {NONE} -- Implementation

	load_enums is
			-- enums with values, loaded from C header file
			-- Only loads enums once, return `loaded_enums' subsequently
			-- loading: read enums names from scanner, load enum values
		local
			enum: C_ENUM
		do
			from
				read_token
			until
				last_token <= 0
			loop
				!!enum.make (text)
				loaded_enums.extend (enum)
				ticker.tick
				read_token
			end
			load_enum_values
		end

	load_enum_values is
			-- set values of `loaded_enums' according to definitions in C header file
			-- Builds an runs a C program that prints out enum values
		require
			valid_enums: loaded_enums /= Void
		local
			c_file: RAW_FILE
			c_file_name: STRING
			bin_file: RAW_FILE
			bin_file_name: STRING
			out_file: RAW_FILE
			out_file_name: STRING
		do
			bin_file_name := tmp_file_name
			!!bin_file.make (bin_file_name)

			out_file_name := tmp_file_name
			!!out_file.make (out_file_name)

			c_file_name := tmp_file_name
			c_file_name.append (".c")
			!!c_file.make (c_file_name)

			generate_c_file (c_file_name)
			compile_c_file (c_file_name, bin_file_name)
			execute_binary (bin_file_name, out_file_name)
			set_enum_values_from_file (out_file_name)

			bin_file.delete
			out_file.delete
			c_file.delete
		end

	generate_c_file (c_file_name: STRING) is
			-- create a C program that will print a list of `enums'
			-- and thier values as specified in the `headers'
		require
			valid_enums: loaded_enums /= Void
			valid_c_file_name: c_file_name /= Void
		local
			c_file: RAW_FILE
		do
			!!c_file.make_open_write (c_file_name)

			c_file.put_string ("#include <stdio.h>%N")
			c_file.put_string ("#include %"")
			c_file.put_string (h_file_name)
			c_file.put_string ("%"")
			c_file.put_new_line

			c_file.put_string ("void main(void) {%N")
			from
				loaded_enums.start
			until
				loaded_enums.after
			loop
				c_file.put_string ("printf(%"%%d\n%", ")
				c_file.put_string (loaded_enums.item.name)
				c_file.put_string (");%N")
				loaded_enums.forth
			end
			c_file.put_string ("}%N")

			c_file.close
		end

	compile_c_file (c_file_name, bin_file_name: STRING) is
			-- compile a C file
		require
			valid_c_file_name: c_file_name /= Void
			valid_bin_file_name: bin_file_name /= Void
		local
			cmd: STRING
		do
			!!cmd.make (0)
			cmd.append ("gcc ")
			if c_flags /= Void then
				cmd.append (c_flags)
			end
			cmd.append (" -o ")
			cmd.append (bin_file_name)
			cmd.append (" ")
			cmd.append (c_file_name)
			system (cmd)
		end

	execute_binary (bin_file_name, out_file_name: STRING) is
			-- execute a binary file and save its output 
		require
			valid_bin_file_name: bin_file_name /= Void
			valid_out_file_name: out_file_name /= Void
		local
			cmd: STRING
		do
			!!cmd.make (0)
			cmd.append (bin_file_name)
			cmd.append (" > ")
			cmd.append (out_file_name)
			system (cmd)
		end

	set_enum_values_from_file (file_name: STRING) is
			-- load values from `file' into `enums'
		require
			valid_enums: loaded_enums /= Void
			valid_file_name: file_name /= Void
		local
			file: PLAIN_TEXT_FILE
		do
			from
				!!file.make_open_read (file_name);
				loaded_enums.start
			until
				loaded_enums.after
			loop
				file.read_line
				loaded_enums.item.set_value (file.last_string.to_integer)
				loaded_enums.forth
				ticker.tick
			end
		end

	loaded_enums: C_ENUMS

	h_file_name, c_flags: STRING

	ticker: TICKER

invariant

	h_file_name_valid: h_file_name /= Void

	c_flags_valid: c_flags /= Void

end -- class C_ENUM_LOADER


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
