%{
indexing
	description: "Parse type definitions from a C header file"
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/10/31 10:36:45 $"
	revision: "$Revision: 1.1.1.1 $"

class C_TYPEDEF_PARSER

inherit

	YY_PARSER_SKELETON [STRING]
		rename
			make as yy_parser_skeleton_make
		redefine
			report_error
		end

	C_TYPEDEF_SCANNER
		rename
			make_with_file as c_typedef_scanner_make_with_file
		end

creation

	make_with_file

%}

%token TOK_TYPEDEF
%token TOK_ENUM
%token TOK_STRUCT
%token TOK_UNION
%token TOK_INDIR
%token TOK_IDENTIFIER
%token TOK_NAME
%token TOK_FNAME
%token TOK_SEMICOLON

%%

input:   -- empty
         | input typedef {
            parsed_typedefs.extend (typedef)
            ticker.tick
         };

typedef:   type TOK_IDENTIFIER TOK_SEMICOLON {
            !!typedef.make ($2, 0, $1)
         }
         | type TOK_INDIR TOK_IDENTIFIER TOK_SEMICOLON {
            !!typedef.make ($3, $2.count, $1)
         }
         | type TOK_FNAME TOK_SEMICOLON {
            !!typedef.make ($2, 1, "C_FUNCTION_POINTER")
         }
         | type TOK_INDIR TOK_FNAME TOK_SEMICOLON {
            !!typedef.make ($3, 1, "C_FUNCTION_POINTER")
         };

type:      type typename   { $$ := $2        }
         | typename        { $$ := $1        }
         ;

typename:  TOK_IDENTIFIER  { $$ := $1        }
         | TOK_ENUM        { $$ := "INTEGER" }
         | TOK_UNION       { $$ := "union"   }
         | TOK_STRUCT      { $$ := $1        }
         ;

%%

feature -- Initialization

	make_with_file (file: IO_MEDIUM; typedefs: C_TYPEDEFS; t: TICKER)  is
			-- Initialize scanner with file
			-- Initialize parser
		require
			file_open_for_read: file.is_open_read
		do
			c_typedef_scanner_make_with_file (file)
			yy_parser_skeleton_make
			ticker := t
		end

feature -- Implementation

	report_error (a_message: STRING) is
		do
			io.put_string("C_TYPEDEF_PARSER ")
			io.put_string(a_message)
			io.put_new_line
			io.put_string("last_value ")
			io.put_string(last_value)
			io.put_new_line
			io.put_string("typedef ")
			io.put_string(typedef.base)
			io.put_string(" ")
			io.put_integer(typedef.indir)
			io.put_string(" ")
			io.put_string(typedef.name)
			io.put_string(" ")
			io.put_new_line
		end

	base: STRING

	indir: INTEGER

	typedef: C_TYPEDEF

	parsed_typedefs: C_TYPEDEFS

	ticker: TICKER

end


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
