%{
indexing
	description: "Scan C header file for type definitions"
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/10/31 10:36:45 $"
	revision: "$Revision: 1.1.1.1 $"

class C_TYPEDEF_SCANNER

inherit

	C_TYPEDEF_TOKENS

	YY_COMPRESSED_SCANNER_SKELETON

creation

	make_with_file

%}

WS		[ \r\f\v\t\n]
INDIR	\*+
ID		[_a-zA-Z][_a-zA-Z0-9]*
STRING	(\"([^\n"\\]|\\[ntvbrfa\\?'"])*\"{WS}*)+

%x TYPEDEF_STATE
%x BRACE_STATE

%%

<*>{STRING}									-- chew character constants
typedef										{ set_start_condition (TYPEDEF_STATE) }
<TYPEDEF_STATE>";"							{ set_start_condition (INITIAL); last_token := TOK_SEMICOLON }
<TYPEDEF_STATE>struct{WS}+{ID}/{WS}+{ID}	{ last_token := TOK_STRUCT; last_value := text }
<TYPEDEF_STATE>enum{WS}+{ID}/{WS}+{ID}		{ last_token := TOK_ENUM; }
<TYPEDEF_STATE>union{WS}+{ID}/{WS}+{ID}		{ last_token := TOK_UNION; }
<TYPEDEF_STATE>struct						{ last_token := TOK_STRUCT; last_value := text  }
<TYPEDEF_STATE>enum							{ last_token := TOK_ENUM; }
<TYPEDEF_STATE>union						{ last_token := TOK_UNION; }
<TYPEDEF_STATE>{INDIR}						{ last_token := TOK_INDIR; last_value := text }
<TYPEDEF_STATE>{INDIR}{ID}[^;(]+"("[^);]*")" { last_token := TOK_FNAME; last_value := text; last_value.head (last_value.index_of (')', 1)-1); last_value.prune_all ('*') }
<TYPEDEF_STATE>__{ID}__						-- chew weird intrnal C stuff
--<TYPEDEF_STATE>{ID}/;						{ last_token := TOK_NAME; last_value := text }
<TYPEDEF_STATE>{ID}							{ last_token := TOK_IDENTIFIER; last_value := text }
<TYPEDEF_STATE>[^{]							-- chew leftovers
<TYPEDEF_STATE>"{"							{ set_start_condition (BRACE_STATE); brace_depth := 1 }
<BRACE_STATE>"{"							{ brace_depth := brace_depth + 1 }
<BRACE_STATE>"}"							{ brace_depth := brace_depth - 1; if brace_depth = 0 then set_start_condition (TYPEDEF_STATE) end }
<BRACE_STATE>[^{}]*							-- chew leftovers

[^t"]*										-- chew leftovers
t|\"										-- chew leftovers

%%

feature -- Access

	last_value: STRING

	brace_depth: INTEGER

end


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
