indexing
	description: "External C calls to the GTK library."
	gtk_klass: "GtkCTree"
	gtk_file: "gtkctree.h"
	status: "See notice at end of class"
	signals: "tree_select_row tree_unselect_row tree_expand tree_collapse tree_move change_focus_row_expansion "
	events: ""

class
	C_GTK_CTREE

feature -- External C functions

	gtk_ctree_get_type: INTEGER is 
			-- Parsed as:
			-- GtkType gtk_ctree_get_type (
			-- );
			--
			-- Original C code from gtkctree.h:
			-- GtkType gtk_ctree_get_type                       (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_construct (a_ctree: POINTER; a_columns: INTEGER; a_tree_column: INTEGER; a_titles: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_construct (
			--     GtkCTree *a_ctree,
			--     gint a_columns,
			--     gint a_tree_column,
			--     gchar **a_titles
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_construct                         (GtkCTree     *ctree,
			-- 						  gint          columns, 
			-- 						  gint          tree_column,
			-- 						  gchar        *titles[]);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_new_with_titles (a_columns: INTEGER; a_tree_column: INTEGER; a_titles: POINTER): POINTER is 
			-- Parsed as:
			-- GtkWidget* gtk_ctree_new_with_titles (
			--     gint a_columns,
			--     gint a_tree_column,
			--     gchar **a_titles
			-- );
			--
			-- Original C code from gtkctree.h:
			-- GtkWidget * gtk_ctree_new_with_titles            (gint          columns, 
			-- 						  gint          tree_column,
			-- 						  gchar        *titles[]);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_new (a_columns: INTEGER; a_tree_column: INTEGER): POINTER is 
			-- Parsed as:
			-- GtkWidget* gtk_ctree_new (
			--     gint a_columns,
			--     gint a_tree_column
			-- );
			--
			-- Original C code from gtkctree.h:
			-- GtkWidget * gtk_ctree_new                        (gint          columns, 
			-- 						  gint          tree_column);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_insert_node (a_ctree: POINTER; a_parent: POINTER; a_sibling: POINTER; a_text: POINTER; a_spacing: INTEGER; a_pixmap_closed: POINTER; a_mask_closed: POINTER; a_pixmap_opened: POINTER; a_mask_opened: POINTER; a_is_leaf: BOOLEAN; a_expanded: BOOLEAN): POINTER is 
			-- Parsed as:
			-- GtkCTreeNode* gtk_ctree_insert_node (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_parent,
			--     GtkCTreeNode *a_sibling,
			--     gchar **a_text,
			--     guint8 a_spacing,
			--     GdkPixmap *a_pixmap_closed,
			--     GdkBitmap *a_mask_closed,
			--     GdkPixmap *a_pixmap_opened,
			--     GdkBitmap *a_mask_opened,
			--     gboolean a_is_leaf,
			--     gboolean a_expanded
			-- );
			--
			-- Original C code from gtkctree.h:
			-- GtkCTreeNode * gtk_ctree_insert_node             (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *parent, 
			-- 						  GtkCTreeNode *sibling,
			-- 						  gchar        *text[],
			-- 						  guint8        spacing,
			-- 						  GdkPixmap    *pixmap_closed,
			-- 						  GdkBitmap    *mask_closed,
			-- 						  GdkPixmap    *pixmap_opened,
			-- 						  GdkBitmap    *mask_opened,
			-- 						  gboolean      is_leaf,
			-- 						  gboolean      expanded);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_remove_node (a_ctree: POINTER; a_node: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_remove_node (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_remove_node                       (GtkCTree     *ctree, 
			-- 						  GtkCTreeNode *node);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_insert_gnode (a_ctree: POINTER; a_parent: POINTER; a_sibling: POINTER; a_gnode: POINTER; a_func: POINTER; a_data: POINTER): POINTER is 
			-- Parsed as:
			-- GtkCTreeNode* gtk_ctree_insert_gnode (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_parent,
			--     GtkCTreeNode *a_sibling,
			--     GNode *a_gnode,
			--     GtkCTreeGNodeFunc a_func,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtkctree.h:
			-- GtkCTreeNode * gtk_ctree_insert_gnode            (GtkCTree          *ctree,
			-- 						  GtkCTreeNode      *parent,
			-- 						  GtkCTreeNode      *sibling,
			-- 						  GNode             *gnode,
			-- 						  GtkCTreeGNodeFunc  func,
			-- 						  gpointer           data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_export_to_gnode (a_ctree: POINTER; a_parent: POINTER; a_sibling: POINTER; a_node: POINTER; a_func: POINTER; a_data: POINTER): POINTER is 
			-- Parsed as:
			-- GNode* gtk_ctree_export_to_gnode (
			--     GtkCTree *a_ctree,
			--     GNode *a_parent,
			--     GNode *a_sibling,
			--     GtkCTreeNode *a_node,
			--     GtkCTreeGNodeFunc a_func,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtkctree.h:
			-- GNode * gtk_ctree_export_to_gnode                (GtkCTree          *ctree,
			-- 						  GNode             *parent,
			-- 						  GNode             *sibling,
			-- 						  GtkCTreeNode      *node,
			-- 						  GtkCTreeGNodeFunc  func,
			-- 						  gpointer           data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_post_recursive (a_ctree: POINTER; a_node: POINTER; a_func: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_post_recursive (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     GtkCTreeFunc a_func,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_post_recursive                    (GtkCTree     *ctree, 
			-- 						  GtkCTreeNode *node,
			-- 						  GtkCTreeFunc  func,
			-- 						  gpointer      data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_post_recursive_to_depth (a_ctree: POINTER; a_node: POINTER; a_depth: INTEGER; a_func: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_post_recursive_to_depth (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gint a_depth,
			--     GtkCTreeFunc a_func,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_post_recursive_to_depth           (GtkCTree     *ctree, 
			-- 						  GtkCTreeNode *node,
			-- 						  gint          depth,
			-- 						  GtkCTreeFunc  func,
			-- 						  gpointer      data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_pre_recursive (a_ctree: POINTER; a_node: POINTER; a_func: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_pre_recursive (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     GtkCTreeFunc a_func,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_pre_recursive                     (GtkCTree     *ctree, 
			-- 						  GtkCTreeNode *node,
			-- 						  GtkCTreeFunc  func,
			-- 						  gpointer      data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_pre_recursive_to_depth (a_ctree: POINTER; a_node: POINTER; a_depth: INTEGER; a_func: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_pre_recursive_to_depth (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gint a_depth,
			--     GtkCTreeFunc a_func,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_pre_recursive_to_depth            (GtkCTree     *ctree, 
			-- 						  GtkCTreeNode *node,
			-- 						  gint          depth,
			-- 						  GtkCTreeFunc  func,
			-- 						  gpointer      data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_is_viewable (a_ctree: POINTER; a_node: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gtk_ctree_is_viewable (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node
			-- );
			--
			-- Original C code from gtkctree.h:
			-- gboolean gtk_ctree_is_viewable                   (GtkCTree     *ctree, 
			-- 					          GtkCTreeNode *node);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_last (a_ctree: POINTER; a_node: POINTER): POINTER is 
			-- Parsed as:
			-- GtkCTreeNode* gtk_ctree_last (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node
			-- );
			--
			-- Original C code from gtkctree.h:
			-- GtkCTreeNode * gtk_ctree_last                    (GtkCTree     *ctree,
			-- 					          GtkCTreeNode *node);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_find_node_ptr (a_ctree: POINTER; a_ctree_row: POINTER): POINTER is 
			-- Parsed as:
			-- GtkCTreeNode* gtk_ctree_find_node_ptr (
			--     GtkCTree *a_ctree,
			--     GtkCTreeRow *a_ctree_row
			-- );
			--
			-- Original C code from gtkctree.h:
			-- GtkCTreeNode * gtk_ctree_find_node_ptr           (GtkCTree     *ctree,
			-- 					          GtkCTreeRow  *ctree_row);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_node_nth (a_ctree: POINTER; a_row: INTEGER): POINTER is 
			-- Parsed as:
			-- GtkCTreeNode* gtk_ctree_node_nth (
			--     GtkCTree *a_ctree,
			--     guint a_row
			-- );
			--
			-- Original C code from gtkctree.h:
			-- GtkCTreeNode * gtk_ctree_node_nth                (GtkCTree     *ctree,
			-- 						  guint         row);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_find (a_ctree: POINTER; a_node: POINTER; a_child: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gtk_ctree_find (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     GtkCTreeNode *a_child
			-- );
			--
			-- Original C code from gtkctree.h:
			-- gboolean gtk_ctree_find                          (GtkCTree     *ctree,
			-- 					          GtkCTreeNode *node,
			-- 					          GtkCTreeNode *child);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_is_ancestor (a_ctree: POINTER; a_node: POINTER; a_child: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gtk_ctree_is_ancestor (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     GtkCTreeNode *a_child
			-- );
			--
			-- Original C code from gtkctree.h:
			-- gboolean gtk_ctree_is_ancestor                   (GtkCTree     *ctree,
			-- 					          GtkCTreeNode *node,
			-- 					          GtkCTreeNode *child);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_find_by_row_data (a_ctree: POINTER; a_node: POINTER; a_data: POINTER): POINTER is 
			-- Parsed as:
			-- GtkCTreeNode* gtk_ctree_find_by_row_data (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtkctree.h:
			-- GtkCTreeNode * gtk_ctree_find_by_row_data        (GtkCTree     *ctree,
			-- 					          GtkCTreeNode *node,
			-- 					          gpointer      data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_find_all_by_row_data (a_ctree: POINTER; a_node: POINTER; a_data: POINTER): POINTER is 
			-- Parsed as:
			-- GList* gtk_ctree_find_all_by_row_data (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtkctree.h:
			-- GList * gtk_ctree_find_all_by_row_data           (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  gpointer      data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_find_by_row_data_custom (a_ctree: POINTER; a_node: POINTER; a_data: POINTER; a_func: POINTER): POINTER is 
			-- Parsed as:
			-- GtkCTreeNode* gtk_ctree_find_by_row_data_custom (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gpointer a_data,
			--     GCompareFunc a_func
			-- );
			--
			-- Original C code from gtkctree.h:
			-- GtkCTreeNode * gtk_ctree_find_by_row_data_custom (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  gpointer      data,
			-- 						  GCompareFunc  func);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_find_all_by_row_data_custom (a_ctree: POINTER; a_node: POINTER; a_data: POINTER; a_func: POINTER): POINTER is 
			-- Parsed as:
			-- GList* gtk_ctree_find_all_by_row_data_custom (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gpointer a_data,
			--     GCompareFunc a_func
			-- );
			--
			-- Original C code from gtkctree.h:
			-- GList * gtk_ctree_find_all_by_row_data_custom    (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  gpointer      data,
			-- 						  GCompareFunc  func);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_is_hot_spot (a_ctree: POINTER; a_x: INTEGER; a_y: INTEGER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gtk_ctree_is_hot_spot (
			--     GtkCTree *a_ctree,
			--     gint a_x,
			--     gint a_y
			-- );
			--
			-- Original C code from gtkctree.h:
			-- gboolean gtk_ctree_is_hot_spot                   (GtkCTree     *ctree,
			-- 					          gint          x,
			-- 					          gint          y);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_move (a_ctree: POINTER; a_node: POINTER; a_new_parent: POINTER; a_new_sibling: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_move (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     GtkCTreeNode *a_new_parent,
			--     GtkCTreeNode *a_new_sibling
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_move                              (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  GtkCTreeNode *new_parent, 
			-- 						  GtkCTreeNode *new_sibling);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_expand (a_ctree: POINTER; a_node: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_expand (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_expand                            (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_expand_recursive (a_ctree: POINTER; a_node: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_expand_recursive (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_expand_recursive                  (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_expand_to_depth (a_ctree: POINTER; a_node: POINTER; a_depth: INTEGER) is 
			-- Parsed as:
			-- void gtk_ctree_expand_to_depth (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gint a_depth
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_expand_to_depth                   (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  gint          depth);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_collapse (a_ctree: POINTER; a_node: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_collapse (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_collapse                          (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_collapse_recursive (a_ctree: POINTER; a_node: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_collapse_recursive (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_collapse_recursive                (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_collapse_to_depth (a_ctree: POINTER; a_node: POINTER; a_depth: INTEGER) is 
			-- Parsed as:
			-- void gtk_ctree_collapse_to_depth (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gint a_depth
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_collapse_to_depth                 (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  gint          depth);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_toggle_expansion (a_ctree: POINTER; a_node: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_toggle_expansion (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_toggle_expansion                  (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_toggle_expansion_recursive (a_ctree: POINTER; a_node: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_toggle_expansion_recursive (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_toggle_expansion_recursive        (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_select (a_ctree: POINTER; a_node: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_select (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_select                            (GtkCTree     *ctree, 
			-- 						  GtkCTreeNode *node);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_select_recursive (a_ctree: POINTER; a_node: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_select_recursive (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_select_recursive                  (GtkCTree     *ctree, 
			-- 						  GtkCTreeNode *node);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_unselect (a_ctree: POINTER; a_node: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_unselect (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_unselect                          (GtkCTree     *ctree, 
			-- 						  GtkCTreeNode *node);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_unselect_recursive (a_ctree: POINTER; a_node: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_unselect_recursive (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_unselect_recursive                (GtkCTree     *ctree, 
			-- 						  GtkCTreeNode *node);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_real_select_recursive (a_ctree: POINTER; a_node: POINTER; a_state: INTEGER) is 
			-- Parsed as:
			-- void gtk_ctree_real_select_recursive (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gint a_state
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_real_select_recursive             (GtkCTree     *ctree, 
			-- 						  GtkCTreeNode *node, 
			-- 						  gint          state);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_node_set_text (a_ctree: POINTER; a_node: POINTER; a_column: INTEGER; a_text: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_node_set_text (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gint a_column,
			--     gchar *a_text
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_node_set_text                     (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  gint          column,
			-- 						  const gchar  *text);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_node_set_pixmap (a_ctree: POINTER; a_node: POINTER; a_column: INTEGER; a_pixmap: POINTER; a_mask: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_node_set_pixmap (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gint a_column,
			--     GdkPixmap *a_pixmap,
			--     GdkBitmap *a_mask
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_node_set_pixmap                   (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  gint          column,
			-- 						  GdkPixmap    *pixmap,
			-- 						  GdkBitmap    *mask);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_node_set_pixtext (a_ctree: POINTER; a_node: POINTER; a_column: INTEGER; a_text: POINTER; a_spacing: INTEGER; a_pixmap: POINTER; a_mask: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_node_set_pixtext (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gint a_column,
			--     gchar *a_text,
			--     guint8 a_spacing,
			--     GdkPixmap *a_pixmap,
			--     GdkBitmap *a_mask
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_node_set_pixtext                  (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  gint          column,
			-- 						  const gchar  *text,
			-- 						  guint8        spacing,
			-- 						  GdkPixmap    *pixmap,
			-- 						  GdkBitmap    *mask);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_set_node_info (a_ctree: POINTER; a_node: POINTER; a_text: POINTER; a_spacing: INTEGER; a_pixmap_closed: POINTER; a_mask_closed: POINTER; a_pixmap_opened: POINTER; a_mask_opened: POINTER; a_is_leaf: BOOLEAN; a_expanded: BOOLEAN) is 
			-- Parsed as:
			-- void gtk_ctree_set_node_info (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gchar *a_text,
			--     guint8 a_spacing,
			--     GdkPixmap *a_pixmap_closed,
			--     GdkBitmap *a_mask_closed,
			--     GdkPixmap *a_pixmap_opened,
			--     GdkBitmap *a_mask_opened,
			--     gboolean a_is_leaf,
			--     gboolean a_expanded
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_set_node_info                     (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  const gchar  *text,
			-- 						  guint8        spacing,
			-- 						  GdkPixmap    *pixmap_closed,
			-- 						  GdkBitmap    *mask_closed,
			-- 						  GdkPixmap    *pixmap_opened,
			-- 						  GdkBitmap    *mask_opened,
			-- 						  gboolean      is_leaf,
			-- 						  gboolean      expanded);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_node_set_shift (a_ctree: POINTER; a_node: POINTER; a_column: INTEGER; a_vertical: INTEGER; a_horizontal: INTEGER) is 
			-- Parsed as:
			-- void gtk_ctree_node_set_shift (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gint a_column,
			--     gint a_vertical,
			--     gint a_horizontal
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_node_set_shift                    (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  gint          column,
			-- 						  gint          vertical,
			-- 						  gint          horizontal);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_node_set_selectable (a_ctree: POINTER; a_node: POINTER; a_selectable: BOOLEAN) is 
			-- Parsed as:
			-- void gtk_ctree_node_set_selectable (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gboolean a_selectable
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_node_set_selectable               (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  gboolean      selectable);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_node_get_selectable (a_ctree: POINTER; a_node: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gtk_ctree_node_get_selectable (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node
			-- );
			--
			-- Original C code from gtkctree.h:
			-- gboolean gtk_ctree_node_get_selectable           (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_node_get_cell_type (a_ctree: POINTER; a_node: POINTER; a_column: INTEGER): INTEGER is 
			-- Parsed as:
			-- GtkCellType gtk_ctree_node_get_cell_type (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gint a_column
			-- );
			--
			-- Original C code from gtkctree.h:
			-- GtkCellType gtk_ctree_node_get_cell_type         (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  gint          column);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_node_get_text (a_ctree: POINTER; a_node: POINTER; a_column: INTEGER; a_text: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_ctree_node_get_text (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gint a_column,
			--     gchar **a_text
			-- );
			--
			-- Original C code from gtkctree.h:
			-- gint gtk_ctree_node_get_text                     (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  gint          column,
			-- 						  gchar       **text);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_node_get_pixmap (a_ctree: POINTER; a_node: POINTER; a_column: INTEGER; a_pixmap: POINTER; a_mask: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_ctree_node_get_pixmap (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gint a_column,
			--     GdkPixmap **a_pixmap,
			--     GdkBitmap **a_mask
			-- );
			--
			-- Original C code from gtkctree.h:
			-- gint gtk_ctree_node_get_pixmap                   (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  gint          column,
			-- 						  GdkPixmap   **pixmap,
			-- 						  GdkBitmap   **mask);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_node_get_pixtext (a_ctree: POINTER; a_node: POINTER; a_column: INTEGER; a_text: POINTER; a_spacing: POINTER; a_pixmap: POINTER; a_mask: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_ctree_node_get_pixtext (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gint a_column,
			--     gchar **a_text,
			--     guint8 *a_spacing,
			--     GdkPixmap **a_pixmap,
			--     GdkBitmap **a_mask
			-- );
			--
			-- Original C code from gtkctree.h:
			-- gint gtk_ctree_node_get_pixtext                  (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  gint          column,
			-- 						  gchar       **text,
			-- 						  guint8       *spacing,
			-- 						  GdkPixmap   **pixmap,
			-- 						  GdkBitmap   **mask);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_get_node_info (a_ctree: POINTER; a_node: POINTER; a_text: POINTER; a_spacing: POINTER; a_pixmap_closed: POINTER; a_mask_closed: POINTER; a_pixmap_opened: POINTER; a_mask_opened: POINTER; a_is_leaf: POINTER; a_expanded: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_ctree_get_node_info (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gchar **a_text,
			--     guint8 *a_spacing,
			--     GdkPixmap **a_pixmap_closed,
			--     GdkBitmap **a_mask_closed,
			--     GdkPixmap **a_pixmap_opened,
			--     GdkBitmap **a_mask_opened,
			--     gboolean *a_is_leaf,
			--     gboolean *a_expanded
			-- );
			--
			-- Original C code from gtkctree.h:
			-- gint gtk_ctree_get_node_info                     (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  gchar       **text,
			-- 						  guint8       *spacing,
			-- 						  GdkPixmap   **pixmap_closed,
			-- 						  GdkBitmap   **mask_closed,
			-- 						  GdkPixmap   **pixmap_opened,
			-- 						  GdkBitmap   **mask_opened,
			-- 						  gboolean     *is_leaf,
			-- 						  gboolean     *expanded);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_node_set_row_style (a_ctree: POINTER; a_node: POINTER; a_style: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_node_set_row_style (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     GtkStyle *a_style
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_node_set_row_style                (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  GtkStyle     *style);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_node_get_row_style (a_ctree: POINTER; a_node: POINTER): POINTER is 
			-- Parsed as:
			-- GtkStyle* gtk_ctree_node_get_row_style (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node
			-- );
			--
			-- Original C code from gtkctree.h:
			-- GtkStyle * gtk_ctree_node_get_row_style          (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_node_set_cell_style (a_ctree: POINTER; a_node: POINTER; a_column: INTEGER; a_style: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_node_set_cell_style (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gint a_column,
			--     GtkStyle *a_style
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_node_set_cell_style               (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  gint          column,
			-- 						  GtkStyle     *style);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_node_get_cell_style (a_ctree: POINTER; a_node: POINTER; a_column: INTEGER): POINTER is 
			-- Parsed as:
			-- GtkStyle* gtk_ctree_node_get_cell_style (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gint a_column
			-- );
			--
			-- Original C code from gtkctree.h:
			-- GtkStyle * gtk_ctree_node_get_cell_style         (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  gint          column);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_node_set_foreground (a_ctree: POINTER; a_node: POINTER; a_color: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_node_set_foreground (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     GdkColor *a_color
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_node_set_foreground               (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  GdkColor     *color);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_node_set_background (a_ctree: POINTER; a_node: POINTER; a_color: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_node_set_background (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     GdkColor *a_color
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_node_set_background               (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  GdkColor     *color);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_node_set_row_data (a_ctree: POINTER; a_node: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_node_set_row_data (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_node_set_row_data                 (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  gpointer      data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_node_set_row_data_full (a_ctree: POINTER; a_node: POINTER; a_data: POINTER; a_destroy: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_node_set_row_data_full (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gpointer a_data,
			--     GtkDestroyNotify a_destroy
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_node_set_row_data_full            (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  gpointer      data,
			-- 						  GtkDestroyNotify destroy);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_node_get_row_data (a_ctree: POINTER; a_node: POINTER): POINTER is 
			-- Parsed as:
			-- gpointer gtk_ctree_node_get_row_data (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node
			-- );
			--
			-- Original C code from gtkctree.h:
			-- gpointer gtk_ctree_node_get_row_data             (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_node_moveto (a_ctree: POINTER; a_node: POINTER; a_column: INTEGER; a_row_align: REAL; a_col_align: REAL) is 
			-- Parsed as:
			-- void gtk_ctree_node_moveto (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node,
			--     gint a_column,
			--     gfloat a_row_align,
			--     gfloat a_col_align
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_node_moveto                       (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node,
			-- 						  gint          column,
			-- 						  gfloat        row_align,
			-- 						  gfloat        col_align);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_node_is_visible (a_ctree: POINTER; a_node: POINTER): INTEGER is 
			-- Parsed as:
			-- GtkVisibility gtk_ctree_node_is_visible (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node
			-- );
			--
			-- Original C code from gtkctree.h:
			-- GtkVisibility gtk_ctree_node_is_visible          (GtkCTree     *ctree,
			-- 						  GtkCTreeNode *node);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_set_indent (a_ctree: POINTER; a_indent: INTEGER) is 
			-- Parsed as:
			-- void gtk_ctree_set_indent (
			--     GtkCTree *a_ctree,
			--     gint a_indent
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_set_indent            (GtkCTree                *ctree, 
			-- 				      gint                     indent);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_set_spacing (a_ctree: POINTER; a_spacing: INTEGER) is 
			-- Parsed as:
			-- void gtk_ctree_set_spacing (
			--     GtkCTree *a_ctree,
			--     gint a_spacing
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_set_spacing           (GtkCTree                *ctree, 
			-- 				      gint                     spacing);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_set_show_stub (a_ctree: POINTER; a_show_stub: BOOLEAN) is 
			-- Parsed as:
			-- void gtk_ctree_set_show_stub (
			--     GtkCTree *a_ctree,
			--     gboolean a_show_stub
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_set_show_stub         (GtkCTree                *ctree, 
			-- 				      gboolean                 show_stub);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_set_line_style (a_ctree: POINTER; a_line_style: INTEGER) is 
			-- Parsed as:
			-- void gtk_ctree_set_line_style (
			--     GtkCTree *a_ctree,
			--     GtkCTreeLineStyle a_line_style
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_set_line_style        (GtkCTree                *ctree, 
			-- 				      GtkCTreeLineStyle        line_style);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_set_expander_style (a_ctree: POINTER; a_expander_style: INTEGER) is 
			-- Parsed as:
			-- void gtk_ctree_set_expander_style (
			--     GtkCTree *a_ctree,
			--     GtkCTreeExpanderStyle a_expander_style
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_set_expander_style    (GtkCTree                *ctree, 
			-- 				      GtkCTreeExpanderStyle    expander_style);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_set_drag_compare_func (a_ctree: POINTER; a_cmp_func: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_set_drag_compare_func (
			--     GtkCTree *a_ctree,
			--     GtkCTreeCompareDragFunc a_cmp_func
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_set_drag_compare_func (GtkCTree     	      *ctree,
			-- 				      GtkCTreeCompareDragFunc  cmp_func);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_sort_node (a_ctree: POINTER; a_node: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_sort_node (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_sort_node                         (GtkCTree     *ctree, 
			-- 						  GtkCTreeNode *node);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_ctree_sort_recursive (a_ctree: POINTER; a_node: POINTER) is 
			-- Parsed as:
			-- void gtk_ctree_sort_recursive (
			--     GtkCTree *a_ctree,
			--     GtkCTreeNode *a_node
			-- );
			--
			-- Original C code from gtkctree.h:
			-- void gtk_ctree_sort_recursive                    (GtkCTree     *ctree, 
			-- 						  GtkCTreeNode *node);
		external
			" C | <gtk/gtk.h>"
		end

end -- class C_GTK_CTREE

--! This file was generated by the GOTE converter.
--! It is derived from the headers of GTK.
--! It is licenced under LGPL. (see www.gnu.org)