indexing
	description: "External C calls to the GTK library."
	gtk_klass: "GtkEditable"
	gtk_file: "gtkeditable.h"
	status: "See notice at end of class"
	signals: "changed insert_text delete_text activate set_editable move_cursor move_word move_page move_to_row move_to_column kill_char kill_word kill_line cut_clipboard copy_clipboard paste_clipboard "
	events: ""

class
	C_GTK_EDITABLE

feature -- External C functions

	gtk_editable_get_type: INTEGER is 
			-- Parsed as:
			-- GtkType gtk_editable_get_type (
			-- );
			--
			-- Original C code from gtkeditable.h:
			-- GtkType    gtk_editable_get_type       (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_editable_select_region (a_editable: POINTER; a_start: INTEGER; a_end: INTEGER) is 
			-- Parsed as:
			-- void gtk_editable_select_region (
			--     GtkEditable *a_editable,
			--     gint a_start,
			--     gint a_end
			-- );
			--
			-- Original C code from gtkeditable.h:
			-- void       gtk_editable_select_region  (GtkEditable      *editable,
			-- 					gint              start,
			-- 					gint              end);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_editable_insert_text (a_editable: POINTER; a_new_text: POINTER; a_new_text_length: INTEGER; a_position: POINTER) is 
			-- Parsed as:
			-- void gtk_editable_insert_text (
			--     GtkEditable *a_editable,
			--     gchar *a_new_text,
			--     gint a_new_text_length,
			--     gint *a_position
			-- );
			--
			-- Original C code from gtkeditable.h:
			-- void       gtk_editable_insert_text   (GtkEditable       *editable,
			-- 					const gchar      *new_text,
			-- 					gint              new_text_length,
			-- 					gint             *position);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_editable_delete_text (a_editable: POINTER; a_start_pos: INTEGER; a_end_pos: INTEGER) is 
			-- Parsed as:
			-- void gtk_editable_delete_text (
			--     GtkEditable *a_editable,
			--     gint a_start_pos,
			--     gint a_end_pos
			-- );
			--
			-- Original C code from gtkeditable.h:
			-- void       gtk_editable_delete_text    (GtkEditable      *editable,
			-- 					gint              start_pos,
			-- 					gint              end_pos);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_editable_get_chars (a_editable: POINTER; a_start_pos: INTEGER; a_end_pos: INTEGER): POINTER is 
			-- Parsed as:
			-- gchar* gtk_editable_get_chars (
			--     GtkEditable *a_editable,
			--     gint a_start_pos,
			--     gint a_end_pos
			-- );
			--
			-- Original C code from gtkeditable.h:
			-- gchar*     gtk_editable_get_chars      (GtkEditable      *editable,
			-- 					gint              start_pos,
			-- 					gint              end_pos);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_editable_cut_clipboard (a_editable: POINTER) is 
			-- Parsed as:
			-- void gtk_editable_cut_clipboard (
			--     GtkEditable *a_editable
			-- );
			--
			-- Original C code from gtkeditable.h:
			-- void       gtk_editable_cut_clipboard  (GtkEditable      *editable);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_editable_copy_clipboard (a_editable: POINTER) is 
			-- Parsed as:
			-- void gtk_editable_copy_clipboard (
			--     GtkEditable *a_editable
			-- );
			--
			-- Original C code from gtkeditable.h:
			-- void       gtk_editable_copy_clipboard (GtkEditable      *editable);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_editable_paste_clipboard (a_editable: POINTER) is 
			-- Parsed as:
			-- void gtk_editable_paste_clipboard (
			--     GtkEditable *a_editable
			-- );
			--
			-- Original C code from gtkeditable.h:
			-- void       gtk_editable_paste_clipboard (GtkEditable     *editable);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_editable_claim_selection (a_editable: POINTER; a_claim: BOOLEAN; a_time: INTEGER) is 
			-- Parsed as:
			-- void gtk_editable_claim_selection (
			--     GtkEditable *a_editable,
			--     gboolean a_claim,
			--     guint32 a_time
			-- );
			--
			-- Original C code from gtkeditable.h:
			-- void       gtk_editable_claim_selection (GtkEditable     *editable, 
			-- 					 gboolean         claim, 
			-- 					 guint32          time);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_editable_delete_selection (a_editable: POINTER) is 
			-- Parsed as:
			-- void gtk_editable_delete_selection (
			--     GtkEditable *a_editable
			-- );
			--
			-- Original C code from gtkeditable.h:
			-- void       gtk_editable_delete_selection (GtkEditable    *editable);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_editable_changed (a_editable: POINTER) is 
			-- Parsed as:
			-- void gtk_editable_changed (
			--     GtkEditable *a_editable
			-- );
			--
			-- Original C code from gtkeditable.h:
			-- void       gtk_editable_changed         (GtkEditable    *editable);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_editable_set_position (a_editable: POINTER; a_position: INTEGER) is 
			-- Parsed as:
			-- void gtk_editable_set_position (
			--     GtkEditable *a_editable,
			--     gint a_position
			-- );
			--
			-- Original C code from gtkeditable.h:
			-- void       gtk_editable_set_position    (GtkEditable    *editable,
			-- 					 gint            position);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_editable_get_position (a_editable: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_editable_get_position (
			--     GtkEditable *a_editable
			-- );
			--
			-- Original C code from gtkeditable.h:
			-- gint       gtk_editable_get_position    (GtkEditable    *editable);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_editable_set_editable (a_editable: POINTER; a_is_editable: BOOLEAN) is 
			-- Parsed as:
			-- void gtk_editable_set_editable (
			--     GtkEditable *a_editable,
			--     gboolean a_is_editable
			-- );
			--
			-- Original C code from gtkeditable.h:
			-- void       gtk_editable_set_editable    (GtkEditable    *editable,
			-- 					 gboolean        is_editable);
		external
			" C | <gtk/gtk.h>"
		end

end -- class C_GTK_EDITABLE

--! This file was generated by the GOTE converter.
--! It is derived from the headers of GTK.
--! It is licenced under LGPL. (see www.gnu.org)