indexing
	description: "External C calls to the GTK library."
	gtk_klass: "GtkList"
	gtk_file: "gtklist.h"
	status: "See notice at end of class"
	signals: "selection_changed select_child unselect_child "
	events: ""

class
	C_GTK_LIST

feature -- External C functions

	gtk_list_get_type: INTEGER is 
			-- Parsed as:
			-- GtkType gtk_list_get_type (
			-- );
			--
			-- Original C code from gtklist.h:
			-- GtkType	   gtk_list_get_type		  (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_new: POINTER is 
			-- Parsed as:
			-- GtkWidget* gtk_list_new (
			-- );
			--
			-- Original C code from gtklist.h:
			-- GtkWidget* gtk_list_new			  (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_insert_items (a_list: POINTER; a_items: POINTER; a_position: INTEGER) is 
			-- Parsed as:
			-- void gtk_list_insert_items (
			--     GtkList *a_list,
			--     GList *a_items,
			--     gint a_position
			-- );
			--
			-- Original C code from gtklist.h:
			-- void	   gtk_list_insert_items	  (GtkList	    *list,
			-- 					   GList	    *items,
			-- 					   gint		     position);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_append_items (a_list: POINTER; a_items: POINTER) is 
			-- Parsed as:
			-- void gtk_list_append_items (
			--     GtkList *a_list,
			--     GList *a_items
			-- );
			--
			-- Original C code from gtklist.h:
			-- void	   gtk_list_append_items	  (GtkList	    *list,
			-- 					   GList	    *items);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_prepend_items (a_list: POINTER; a_items: POINTER) is 
			-- Parsed as:
			-- void gtk_list_prepend_items (
			--     GtkList *a_list,
			--     GList *a_items
			-- );
			--
			-- Original C code from gtklist.h:
			-- void	   gtk_list_prepend_items	  (GtkList	    *list,
			-- 					   GList	    *items);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_remove_items (a_list: POINTER; a_items: POINTER) is 
			-- Parsed as:
			-- void gtk_list_remove_items (
			--     GtkList *a_list,
			--     GList *a_items
			-- );
			--
			-- Original C code from gtklist.h:
			-- void	   gtk_list_remove_items	  (GtkList	    *list,
			-- 					   GList	    *items);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_remove_items_no_unref (a_list: POINTER; a_items: POINTER) is 
			-- Parsed as:
			-- void gtk_list_remove_items_no_unref (
			--     GtkList *a_list,
			--     GList *a_items
			-- );
			--
			-- Original C code from gtklist.h:
			-- void	   gtk_list_remove_items_no_unref (GtkList	    *list,
			-- 					   GList	    *items);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_clear_items (a_list: POINTER; a_start: INTEGER; a_end: INTEGER) is 
			-- Parsed as:
			-- void gtk_list_clear_items (
			--     GtkList *a_list,
			--     gint a_start,
			--     gint a_end
			-- );
			--
			-- Original C code from gtklist.h:
			-- void	   gtk_list_clear_items		  (GtkList	    *list,
			-- 					   gint		     start,
			-- 					   gint		     end);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_select_item (a_list: POINTER; a_item: INTEGER) is 
			-- Parsed as:
			-- void gtk_list_select_item (
			--     GtkList *a_list,
			--     gint a_item
			-- );
			--
			-- Original C code from gtklist.h:
			-- void	   gtk_list_select_item		  (GtkList	    *list,
			-- 					   gint		     item);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_unselect_item (a_list: POINTER; a_item: INTEGER) is 
			-- Parsed as:
			-- void gtk_list_unselect_item (
			--     GtkList *a_list,
			--     gint a_item
			-- );
			--
			-- Original C code from gtklist.h:
			-- void	   gtk_list_unselect_item	  (GtkList	    *list,
			-- 					   gint		     item);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_select_child (a_list: POINTER; a_child: POINTER) is 
			-- Parsed as:
			-- void gtk_list_select_child (
			--     GtkList *a_list,
			--     GtkWidget *a_child
			-- );
			--
			-- Original C code from gtklist.h:
			-- void	   gtk_list_select_child	  (GtkList	    *list,
			-- 					   GtkWidget	    *child);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_unselect_child (a_list: POINTER; a_child: POINTER) is 
			-- Parsed as:
			-- void gtk_list_unselect_child (
			--     GtkList *a_list,
			--     GtkWidget *a_child
			-- );
			--
			-- Original C code from gtklist.h:
			-- void	   gtk_list_unselect_child	  (GtkList	    *list,
			-- 					   GtkWidget	    *child);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_child_position (a_list: POINTER; a_child: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_list_child_position (
			--     GtkList *a_list,
			--     GtkWidget *a_child
			-- );
			--
			-- Original C code from gtklist.h:
			-- gint	   gtk_list_child_position	  (GtkList	    *list,
			-- 					   GtkWidget	    *child);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_set_selection_mode (a_list: POINTER; a_mode: INTEGER) is 
			-- Parsed as:
			-- void gtk_list_set_selection_mode (
			--     GtkList *a_list,
			--     GtkSelectionMode a_mode
			-- );
			--
			-- Original C code from gtklist.h:
			-- void	   gtk_list_set_selection_mode	  (GtkList	    *list,
			-- 					   GtkSelectionMode  mode);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_extend_selection (a_list: POINTER; a_scroll_type: INTEGER; a_position: REAL; a_auto_start_selection: BOOLEAN) is 
			-- Parsed as:
			-- void gtk_list_extend_selection (
			--     GtkList *a_list,
			--     GtkScrollType a_scroll_type,
			--     gfloat a_position,
			--     gboolean a_auto_start_selection
			-- );
			--
			-- Original C code from gtklist.h:
			-- void       gtk_list_extend_selection      (GtkList          *list,
			-- 					   GtkScrollType     scroll_type,
			-- 					   gfloat            position,
			-- 					   gboolean          auto_start_selection);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_start_selection (a_list: POINTER) is 
			-- Parsed as:
			-- void gtk_list_start_selection (
			--     GtkList *a_list
			-- );
			--
			-- Original C code from gtklist.h:
			-- void       gtk_list_start_selection       (GtkList          *list);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_end_selection (a_list: POINTER) is 
			-- Parsed as:
			-- void gtk_list_end_selection (
			--     GtkList *a_list
			-- );
			--
			-- Original C code from gtklist.h:
			-- void       gtk_list_end_selection         (GtkList          *list);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_select_all (a_list: POINTER) is 
			-- Parsed as:
			-- void gtk_list_select_all (
			--     GtkList *a_list
			-- );
			--
			-- Original C code from gtklist.h:
			-- void       gtk_list_select_all            (GtkList          *list);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_unselect_all (a_list: POINTER) is 
			-- Parsed as:
			-- void gtk_list_unselect_all (
			--     GtkList *a_list
			-- );
			--
			-- Original C code from gtklist.h:
			-- void       gtk_list_unselect_all          (GtkList          *list);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_scroll_horizontal (a_list: POINTER; a_scroll_type: INTEGER; a_position: REAL) is 
			-- Parsed as:
			-- void gtk_list_scroll_horizontal (
			--     GtkList *a_list,
			--     GtkScrollType a_scroll_type,
			--     gfloat a_position
			-- );
			--
			-- Original C code from gtklist.h:
			-- void       gtk_list_scroll_horizontal     (GtkList          *list,
			-- 					   GtkScrollType     scroll_type,
			-- 					   gfloat            position);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_scroll_vertical (a_list: POINTER; a_scroll_type: INTEGER; a_position: REAL) is 
			-- Parsed as:
			-- void gtk_list_scroll_vertical (
			--     GtkList *a_list,
			--     GtkScrollType a_scroll_type,
			--     gfloat a_position
			-- );
			--
			-- Original C code from gtklist.h:
			-- void       gtk_list_scroll_vertical       (GtkList          *list,
			-- 					   GtkScrollType     scroll_type,
			-- 					   gfloat            position);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_toggle_add_mode (a_list: POINTER) is 
			-- Parsed as:
			-- void gtk_list_toggle_add_mode (
			--     GtkList *a_list
			-- );
			--
			-- Original C code from gtklist.h:
			-- void       gtk_list_toggle_add_mode       (GtkList          *list);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_toggle_focus_row (a_list: POINTER) is 
			-- Parsed as:
			-- void gtk_list_toggle_focus_row (
			--     GtkList *a_list
			-- );
			--
			-- Original C code from gtklist.h:
			-- void       gtk_list_toggle_focus_row      (GtkList          *list);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_toggle_row (a_list: POINTER; a_item: POINTER) is 
			-- Parsed as:
			-- void gtk_list_toggle_row (
			--     GtkList *a_list,
			--     GtkWidget *a_item
			-- );
			--
			-- Original C code from gtklist.h:
			-- void       gtk_list_toggle_row            (GtkList          *list,
			-- 					   GtkWidget        *item);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_undo_selection (a_list: POINTER) is 
			-- Parsed as:
			-- void gtk_list_undo_selection (
			--     GtkList *a_list
			-- );
			--
			-- Original C code from gtklist.h:
			-- void       gtk_list_undo_selection        (GtkList          *list);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_list_end_drag_selection (a_list: POINTER) is 
			-- Parsed as:
			-- void gtk_list_end_drag_selection (
			--     GtkList *a_list
			-- );
			--
			-- Original C code from gtklist.h:
			-- void       gtk_list_end_drag_selection    (GtkList          *list);
		external
			" C | <gtk/gtk.h>"
		end

end -- class C_GTK_LIST

--! This file was generated by the GOTE converter.
--! It is derived from the headers of GTK.
--! It is licenced under LGPL. (see www.gnu.org)