indexing
	description: "External C calls to the GTK library."
	gtk_klass: "GtkObject"
	gtk_file: "gtkobject.h"
	status: "See notice at end of class"
	signals: "destroy "
	events: ""

class
	C_GTK_OBJECT

feature -- External C functions

	gtk_object_get_type: INTEGER is 
			-- Parsed as:
			-- GtkType gtk_object_get_type (
			-- );
			--
			-- Original C code from gtkobject.h:
			-- GtkType	gtk_object_get_type		(void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_class_user_signal_newv (a_klass: POINTER; a_name: POINTER; a_signal_flags: INTEGER; a_marshaller: POINTER; a_return_val: INTEGER; a_nparams: INTEGER; a_params: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_object_class_user_signal_newv (
			--     GtkObjectClass *a_klass,
			--     gchar *a_name,
			--     GtkSignalRunType a_signal_flags,
			--     GtkSignalMarshaller a_marshaller,
			--     GtkType a_return_val,
			--     guint a_nparams,
			--     GtkType *a_params
			-- );
			--
			-- Original C code from gtkobject.h:
			-- guint	gtk_object_class_user_signal_newv (GtkObjectClass     *klass,
			-- 					   const gchar	      *name,
			-- 					   GtkSignalRunType    signal_flags,
			-- 					   GtkSignalMarshaller marshaller,
			-- 					   GtkType	       return_val,
			-- 					   guint	       nparams,
			-- 					   GtkType	      *params);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_newv (a_object_type: INTEGER; a_n_args: INTEGER; a_args: POINTER): POINTER is 
			-- Parsed as:
			-- GtkObject* gtk_object_newv (
			--     GtkType a_object_type,
			--     guint a_n_args,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkobject.h:
			-- GtkObject*	gtk_object_newv		  (GtkType	       object_type,
			-- 					   guint	       n_args,
			-- 					   GtkArg	      *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_default_construct (a_object: POINTER) is 
			-- Parsed as:
			-- void gtk_object_default_construct (
			--     GtkObject *a_object
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void gtk_object_default_construct         (GtkObject	      *object);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_constructed (a_object: POINTER) is 
			-- Parsed as:
			-- void gtk_object_constructed (
			--     GtkObject *a_object
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void gtk_object_constructed		  (GtkObject	      *object);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_sink (a_object: POINTER) is 
			-- Parsed as:
			-- void gtk_object_sink (
			--     GtkObject *a_object
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void gtk_object_sink	  (GtkObject	    *object);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_ref (a_object: POINTER) is 
			-- Parsed as:
			-- void gtk_object_ref (
			--     GtkObject *a_object
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void gtk_object_ref	  (GtkObject	    *object);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_unref (a_object: POINTER) is 
			-- Parsed as:
			-- void gtk_object_unref (
			--     GtkObject *a_object
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void gtk_object_unref	  (GtkObject	    *object);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_weakref (a_object: POINTER; a_notify: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void gtk_object_weakref (
			--     GtkObject *a_object,
			--     GtkDestroyNotify a_notify,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void gtk_object_weakref	  (GtkObject	    *object,
			-- 			   GtkDestroyNotify  notify,
			-- 			   gpointer	     data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_weakunref (a_object: POINTER; a_notify: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void gtk_object_weakunref (
			--     GtkObject *a_object,
			--     GtkDestroyNotify a_notify,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void gtk_object_weakunref (GtkObject	    *object,
			-- 			   GtkDestroyNotify  notify,
			-- 			   gpointer	     data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_destroy (a_object: POINTER) is 
			-- Parsed as:
			-- void gtk_object_destroy (
			--     GtkObject *a_object
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void gtk_object_destroy	  (GtkObject *object);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_getv (a_object: POINTER; a_n_args: INTEGER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_object_getv (
			--     GtkObject *a_object,
			--     guint a_n_args,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void	gtk_object_getv		(GtkObject	*object,
			-- 				 guint		n_args,
			-- 				 GtkArg		*args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_setv (a_object: POINTER; a_n_args: INTEGER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_object_setv (
			--     GtkObject *a_object,
			--     guint a_n_args,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void	gtk_object_setv		(GtkObject	*object,
			-- 				 guint		n_args,
			-- 				 GtkArg		*args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_query_args (a_class_type: INTEGER; a_arg_flags: POINTER; a_n_args: POINTER): POINTER is 
			-- Parsed as:
			-- GtkArg* gtk_object_query_args (
			--     GtkType a_class_type,
			--     guint32 **a_arg_flags,
			--     guint *a_n_args
			-- );
			--
			-- Original C code from gtkobject.h:
			-- GtkArg* gtk_object_query_args	(GtkType	  class_type,
			-- 				 guint32	**arg_flags,
			-- 				 guint		 *n_args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_set_data (a_object: POINTER; a_key: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void gtk_object_set_data (
			--     GtkObject *a_object,
			--     gchar *a_key,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void	 gtk_object_set_data	     (GtkObject	     *object,
			-- 				      const gchar    *key,
			-- 				      gpointer	      data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_set_data_full (a_object: POINTER; a_key: POINTER; a_data: POINTER; a_destroy: POINTER) is 
			-- Parsed as:
			-- void gtk_object_set_data_full (
			--     GtkObject *a_object,
			--     gchar *a_key,
			--     gpointer a_data,
			--     GtkDestroyNotify a_destroy
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void	 gtk_object_set_data_full    (GtkObject	     *object,
			-- 				      const gchar    *key,
			-- 				      gpointer	      data,
			-- 				      GtkDestroyNotify destroy);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_remove_data (a_object: POINTER; a_key: POINTER) is 
			-- Parsed as:
			-- void gtk_object_remove_data (
			--     GtkObject *a_object,
			--     gchar *a_key
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void	 gtk_object_remove_data	     (GtkObject	     *object,
			-- 				      const gchar    *key);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_get_data (a_object: POINTER; a_key: POINTER): POINTER is 
			-- Parsed as:
			-- gpointer gtk_object_get_data (
			--     GtkObject *a_object,
			--     gchar *a_key
			-- );
			--
			-- Original C code from gtkobject.h:
			-- gpointer gtk_object_get_data	     (GtkObject	     *object,
			-- 				      const gchar    *key);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_remove_no_notify (a_object: POINTER; a_key: POINTER) is 
			-- Parsed as:
			-- void gtk_object_remove_no_notify (
			--     GtkObject *a_object,
			--     gchar *a_key
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void	 gtk_object_remove_no_notify (GtkObject	     *object,
			-- 				      const gchar    *key);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_set_user_data (a_object: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void gtk_object_set_user_data (
			--     GtkObject *a_object,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void	 gtk_object_set_user_data (GtkObject	*object,
			-- 				   gpointer	 data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_get_user_data (a_object: POINTER): POINTER is 
			-- Parsed as:
			-- gpointer gtk_object_get_user_data (
			--     GtkObject *a_object
			-- );
			--
			-- Original C code from gtkobject.h:
			-- gpointer gtk_object_get_user_data (GtkObject	*object);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_class_add_signals (a_klass: POINTER; a_signals: POINTER; a_nsignals: INTEGER) is 
			-- Parsed as:
			-- void gtk_object_class_add_signals (
			--     GtkObjectClass *a_klass,
			--     guint *a_signals,
			--     guint a_nsignals
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void	gtk_object_class_add_signals	(GtkObjectClass	*klass,
			-- 					 guint		*signals,
			-- 					 guint		 nsignals);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_add_arg_type (a_arg_name: POINTER; a_arg_type: INTEGER; a_arg_flags: INTEGER; a_arg_id: INTEGER) is 
			-- Parsed as:
			-- void gtk_object_add_arg_type (
			--     gchar *a_arg_name,
			--     GtkType a_arg_type,
			--     guint a_arg_flags,
			--     guint a_arg_id
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void	gtk_object_add_arg_type		(const gchar	*arg_name,
			-- 					 GtkType	 arg_type,
			-- 					 guint		 arg_flags,
			-- 					 guint		 arg_id);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_set_data_by_id (a_object: POINTER; a_data_id: INTEGER; a_data: POINTER) is 
			-- Parsed as:
			-- void gtk_object_set_data_by_id (
			--     GtkObject *a_object,
			--     GQuark a_data_id,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void gtk_object_set_data_by_id		(GtkObject	 *object,
			-- 					 GQuark		  data_id,
			-- 					 gpointer	  data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_set_data_by_id_full (a_object: POINTER; a_data_id: INTEGER; a_data: POINTER; a_destroy: POINTER) is 
			-- Parsed as:
			-- void gtk_object_set_data_by_id_full (
			--     GtkObject *a_object,
			--     GQuark a_data_id,
			--     gpointer a_data,
			--     GtkDestroyNotify a_destroy
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void gtk_object_set_data_by_id_full	(GtkObject	 *object,
			-- 					 GQuark		  data_id,
			-- 					 gpointer	  data,
			-- 					 GtkDestroyNotify destroy);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_get_data_by_id (a_object: POINTER; a_data_id: INTEGER): POINTER is 
			-- Parsed as:
			-- gpointer gtk_object_get_data_by_id (
			--     GtkObject *a_object,
			--     GQuark a_data_id
			-- );
			--
			-- Original C code from gtkobject.h:
			-- gpointer gtk_object_get_data_by_id	(GtkObject	 *object,
			-- 					 GQuark		  data_id);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_remove_data_by_id (a_object: POINTER; a_data_id: INTEGER) is 
			-- Parsed as:
			-- void gtk_object_remove_data_by_id (
			--     GtkObject *a_object,
			--     GQuark a_data_id
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void  gtk_object_remove_data_by_id	(GtkObject	 *object,
			-- 					 GQuark		  data_id);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_remove_no_notify_by_id (a_object: POINTER; a_key_id: INTEGER) is 
			-- Parsed as:
			-- void gtk_object_remove_no_notify_by_id (
			--     GtkObject *a_object,
			--     GQuark a_key_id
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void  gtk_object_remove_no_notify_by_id	(GtkObject	 *object,
			-- 					 GQuark		  key_id);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_arg_set (a_object: POINTER; a_arg: POINTER; a_info: POINTER) is 
			-- Parsed as:
			-- void gtk_object_arg_set (
			--     GtkObject *a_object,
			--     GtkArg *a_arg,
			--     GtkArgInfo *a_info
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void	gtk_object_arg_set	(GtkObject   *object,
			-- 				 GtkArg	     *arg,
			-- 				 GtkArgInfo  *info);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_arg_get (a_object: POINTER; a_arg: POINTER; a_info: POINTER) is 
			-- Parsed as:
			-- void gtk_object_arg_get (
			--     GtkObject *a_object,
			--     GtkArg *a_arg,
			--     GtkArgInfo *a_info
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void	gtk_object_arg_get	(GtkObject   *object,
			-- 				 GtkArg	     *arg,
			-- 				 GtkArgInfo  *info);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_args_collect (a_object_type: INTEGER; a_arg_list_p: POINTER; a_info_list_p: POINTER; a_first_arg_name: POINTER; a_var_args: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* gtk_object_args_collect (
			--     GtkType a_object_type,
			--     GSList **a_arg_list_p,
			--     GSList **a_info_list_p,
			--     gchar *a_first_arg_name,
			--     va_list a_var_args
			-- );
			--
			-- Original C code from gtkobject.h:
			-- gchar*	gtk_object_args_collect (GtkType      object_type,
			-- 				 GSList	    **arg_list_p,
			-- 				 GSList	    **info_list_p,
			-- 				 const gchar *first_arg_name,
			-- 				 va_list      var_args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_object_arg_get_info (a_object_type: INTEGER; a_arg_name: POINTER; a_info_p: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* gtk_object_arg_get_info (
			--     GtkType a_object_type,
			--     gchar *a_arg_name,
			--     GtkArgInfo **a_info_p
			-- );
			--
			-- Original C code from gtkobject.h:
			-- gchar*	gtk_object_arg_get_info (GtkType      object_type,
			-- 				 const gchar *arg_name,
			-- 				 GtkArgInfo **info_p);
		external
			" C | <gtk/gtk.h>"
		end

end -- class C_GTK_OBJECT

--! This file was generated by the GOTE converter.
--! It is derived from the headers of GTK.
--! It is licenced under LGPL. (see www.gnu.org)