indexing
	description: "GEL classes"
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/10/31 10:36:43 $"
	revision: "$Revision: 1.1.1.1 $"

class
	GEL_CLASSES


inherit
	LINKED_LIST [GEL_CLASS]
		rename
			make as linked_list_make
		end

creation
	make

feature -- Initialization

	make is
			-- Initilize with any class
		local
			af_file: PLAIN_TEXT_FILE
			f: GEL_FEATURE
		do
			linked_list_make
			create any_class.make ("ANY")
			create gel_any_class.make ("GTK_ANY")
			gel_any_class.set_parent (any_class)
			gel_any_class.set_description ("Root class of the GEL, the GTK Eiffel Librart")

			from
				create af_file.make_open_read ("any_features")
			until
				af_file.after
			loop
				af_file.read_line
				if af_file.last_string.count > 0 then
					create f.make (any_class, af_file.last_string)
				end
			end
		end

feature -- Access

	class_by_name (nm: STRING): GEL_CLASS is
			-- class called `nm'
		local
			i: INTEGER
			found: BOOLEAN
		do
			i := index
			found := False
			from start until after or found loop
				if item.name.is_equal (nm) then
					Result := item
					Found := true
				end
				forth
			end
			if not found then
				print ("warning: class_by_name (")
				print (nm)
				print (") not found%N")
			end
			go_i_th (i)
		end


feature -- Status Report

	text: STRING is
			-- Sum of all class texts 
		do
			Result := any_class.text
			Result.append ("%N")
			from start until after loop
				Result.append (item.text)
				Result.append ("%N")
				forth
			end
		end

feature -- Output

	dump (dir: DIRECTORY; ticker: TICKER) is
			-- Dump all class texts to files in `dir'.
		do
			from start until after loop
				item.dump (dir)
				ticker.tick
				forth
			end
		end

feature -- Access

	any_class: GEL_CLASS

	gel_any_class: GEL_CLASS

end -- class GEL_CLASSES


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
