indexing
	description:
		"Root class for the gote converter %
		% gote: Gtk Objects To Eiffel %
		% Gtk: GIMP Tool Kit %
		% GIMP: GNU Image Manipulation Program %
		% GNU: GNU is Not Unix %
		% The gote converter produces the GEL library from the gtk source code. "
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/11/19 21:21:30 $"
	revision: "$Revision: 1.3 $"

class
	GOTE

inherit
	EXECUTION_ENVIRONMENT

	EXCEPTIONS

creation
	make

feature -- Initilization

	make is 
		local
			cpp: C_PREPROCESSOR
			input_file: RAW_FILE
			input_file_name: FMT_STRING
			pp_file: RAW_FILE
			typedef_loader: C_TYPEDEF_LOADER
			enum_loader: C_ENUM_LOADER
			struct_loader: C_STRUCT_LOADER
			prototype_loader: C_PROTOTYPE_LOADER
			class_loader: GTK_CLASS_LOADER

			ticker: CONSOLE_TICKER

			gel_directory: DIRECTORY

			s, status: FMT_STRING

			gtk_universe: GTK_UNIVERSE
			gtk_classes: GTK_CLASSES
			gel_classes: GEL_CLASSES
			a: GEL_ARGUMENT
			f: GEL_FEATURE
			i, c: GEL_CLASS
			st: C_STRUCT
		do
			create cpp
			create gtk_universe.make
			gtk_classes := gtk_universe.classes
			create gel_classes.make

			create ticker.make

			print ("gote $Id: gote.e,v 1.3 1999/11/19 21:21:30 sam Exp $%N")

				-- Check command line arguments
			if command_line.argument_count < 1 or command_line.argument_count > 3 then
				print ("usage: gote path_to_gtk.h [include_directive] [cflags]%N")
				print ("   eg: gote /usr/local/include/gtk/gtk.h %"<gtk/gtk.h>%" %"`gtk-config --cflags`%"%N")
				die (1)
			end
			create input_file_name.make
			input_file_name.append (command_line.argument (1))
			if command_line.argument_count > 1 then
				gtk_universe.set_include_directive (command_line.argument (2))
				if command_line.argument_count > 2 then
					gtk_universe.set_c_flags (command_line.argument (3))
				end
			end 

			create status.make
			status.append ("%N--! This file was generated by the GOTE converter.%N")
			status.append ("--! It is derived from the headers of GTK.%N")
			status.append ("--! It is licenced under LGPL. (see www.gnu.org)")

				-- Preprocess the GTK header files
			print ("preprocessing "); print (input_file_name); print ("%N")
			create pp_file.make (cpp.preprocess (input_file_name, gtk_universe.c_flags))

				-- Grab all the typedefs from the headers
			print ("parsing typedefs%N")
			create typedef_loader.run (pp_file.name, gtk_universe.typedefs, ticker)
			print ("%N")

				-- Grab all the enums from the headers
			print ("parsing enums%N")
			create enum_loader.run (pp_file.name, input_file_name, gtk_universe.c_flags, gtk_universe.enums, ticker)
			print ("%N")

				-- Grab all the structs from the headers
			print ("parsing structs%N")
			create struct_loader.run (pp_file.name, gtk_universe.structs, ticker)
			gtk_universe.structs.resolve_member_typedefs (gtk_universe.typedefs)
			print ("%N")

				-- Grab all the C prototypes from the headers
			print ("parsing prototypes%N")
			create prototype_loader.run (pp_file.name, gtk_universe.prototypes, ticker)
			gtk_universe.prototypes.resolve_typedefs (gtk_universe.typedefs)
			print ("%N")

				-- Grab all the GTK class definitions from the headers
			print ("parsing gtk classes%N")
			create class_loader.run ("gtkclass.defs", gtk_universe.classes, ticker)
			gtk_universe.classes.attach_prototypes (gtk_universe.prototypes)
			print ("%N")

				-- Create a gel directory for the output
			!!gel_directory.make ("gel")
			if not gel_directory.exists then
				gel_directory.create_dir
			end

			print ("dumping C enums class%N")
			gtk_universe.enums.dump ("GTK_ENUMS", gel_directory, status)

			print ("dumping C struct classes%N")
			gtk_universe.structs.dump (gel_directory, gtk_universe.include_directive, status, ticker)
			print ("%N")

			print ("dumping C externals classes%N")
			gtk_universe.classes.dump (gel_directory, status, ticker)
			print ("%N")

			print ("generating wrapper classes%N")
			from gtk_classes.start
			until gtk_classes.after
			loop
				c := gtk_classes.item.gel_class
				c.set_status (status)
				gel_classes.extend (c)
				gtk_classes.forth
				ticker.tick
			end
			print ("%N")

			print ("linking inhetitance heirachy%N")
			from gel_classes.start
			until gel_classes.after
			loop
				i := gel_classes.item
				if i.parent_name /= Void then
					c := gel_classes.class_by_name (i.parent_name)
					if c /= Void then
						i.set_parent (c)
					end
					i.creation_features.extend ("make_from_c_pointer")
				end
				if i.parent = Void then
					i.set_parent (gel_classes.gel_any_class)
					i.creation_features.extend ("make_from_c_pointer")
				end
				ticker.tick
				gel_classes.forth
			end
			print ("%N")

			print ("dumping wrapper classes%N")
			gel_classes.dump (gel_directory, ticker)
			print ("%N")

				-- Copy files from the static directory
			create s.make
			s.append ("cp static/*.e ")
			s.append (gel_directory.name)
			system (s)

			-- Clean up the preprocessed output
			pp_file.delete
			print ("done")
		end

end


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
