%{
indexing
	description: "Parse class definitions from a Gtk header file"
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/10/31 10:37:41 $"
	revision: "$Revision: 1.1.1.1 $"

class GTK_CLASS_PARSER

inherit

	YY_PARSER_SKELETON [STRING]
		rename
			make as yy_parser_skeleton_make
		redefine
			report_error
		end

	GTK_CLASS_SCANNER
		rename
			make_with_file as gtk_class_scanner_make_with_file
		end

creation

	make_with_file

%}

%token TOK_FILE_NAME
%token TOK_CLASS_NAME
%token TOK_PARENT_CLASS_NAME

%%

input:   -- empty
         |  input TOK_FILE_NAME classdefs {
		parsed_classes.set_new_h_file_name ($2)
         };

classdefs:  --empty
         |  classdef classdefs {
            parsed_classes.extend (new_class)
            ticker.tick
         };

classdef:   TOK_CLASS_NAME {
            !!new_class.make ($1)
         }
         |  TOK_CLASS_NAME TOK_PARENT_CLASS_NAME {
            !!new_class.make ($1)
            new_class.set_parent_name ($2)
         };

%%

feature -- Initialization

	make_with_file (file: IO_MEDIUM; t: TICKER)  is
			-- Initialize scanner with file
			-- Initialize parser
			-- Initialize `parsed_classes'
		require
			file_open_for_read: file.is_open_read
		do
			gtk_class_scanner_make_with_file (file)
			yy_parser_skeleton_make
			ticker := t
		end

feature -- Implementation

	report_error (a_message: STRING) is
		do
			io.put_string("GTK_CLASS_PARSER ")
			io.put_string(a_message)
			io.put_new_line
		end

	new_class: GTK_CLASS

	parsed_classes: GTK_CLASSES

	ticker: TICKER

end


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
