-- Copyright (C) 1999 Richie Bielak and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "GTK_LIST_ITEM - an item in a list box"
	version: "v 0.3.3 GTK+ 1.2.x"
	author: "Richie Bielak"
	cvs: "$Id: gtk_list_item.e,v 1.6 1999/10/03 02:07:19 richieb Exp $"

class GTK_LIST_ITEM

-- An item to go in a list box
--
-- Signals (from gtklistitem.c):
--    "end_selection"
--    "extend_selection"
--    "scroll_horizontal"
--    "scroll_vertical"
--    "select_all"
--    "start_selection"
--    "toggle_add_mode"
--    "toggle_focus_row"
--    "undo_selection"
--    "unselect_all"


inherit
	
	GTK_ITEM
		redefine
			focus_child, child
		end

	GTK_LIST_ITEM_EXTERNALS
		undefine
			copy, is_equal
		end
	
creation
	
	make,
	make_with_label

feature

	make_with_label (label: STRING) is
		require
			label_not_void: label /= Void
		do
			widget := npc.np_gtk_list_item_new_with_label (label)
			register_widget
		end

	make is
		do
			widget := gtk_list_item_new
			register_widget
		end

	select_item is
		do
			gtk_list_item_select (widget)
		end

	deselect_item is
		do
			gtk_list_item_deselect (widget)
		end

	child: GTK_LABEL
	
	focus_child: GTK_LABEL is
		local
			childp: POINTER
		do
			childp := c_focus_child (widget)
			if childp /= default_pointer then
				if child.widget = childp then
					Result := child
				else
					!!Result.make_from_pointer (childp)
					child := Result
				end
			end
		end

feature {GTK_COMMAND_TYPE}

	gtk_object: POINTER is
			-- this feature is here to get around a bug in SE-078b5
		do
			Result := widget
		end

end -- GTK_LIST_ITEM
