-- Copyright 1999 Pirmin Kalberer and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "GTK_TREE_ITEM - an item to be attached to a tree widget"
	author: "Pirmin Kalberer"
	CVS: "$Id: gtk_tree_item.e,v 1.4 1999/08/22 16:30:50 richieb Exp $"

class GTK_TREE_ITEM

-- A widget for an item to be attached to a tree widget
--
-- Signals (from gtktreeitem.c):
--    "collapse"
--    "expand"

inherit
	
   GTK_ITEM
		redefine
			deselection,
			selection
		end

   GTK_TREE_ITEM_EXTERNALS
		undefine
			copy, is_equal
		end

   EGTK_NON_PORTABLE
		undefine
			copy, is_equal
		end

creation
	
	make,
	make_from_pointer,
	make_with_label
	
feature
	
	make is
		do
			widget := gtk_tree_item_new
			register_widget
		end
	
	make_with_label (text: STRING) is
		require
			text_not_void: text /= Void
		do
			widget := npc.np_gtk_tree_item_new_with_label (text)
			register_widget
		end
	
	set_subtree (subtree: GTK_TREE) is
		do
			gtk_tree_item_set_subtree (widget, subtree.widget)
		end
	
	selection is
		do
			gtk_tree_item_select (widget)
		end
	
	deselection is
		do
			gtk_tree_item_deselect (widget)
		end
	
	label_text: STRING is
			-- Return the text of the label
		do
			if child_is_label then
				Result := label.text
			end
		end
	
	child_is_label: BOOLEAN is
			-- Returns true if the widget is a label
		do
			Result := (label /= Void)
		end
	
	label: GTK_LABEL is
		do
			-- This code is broken, because "child" doesn't return 
			-- the right object just yet (richieb August 11th, 1999)
			Result ?= child
		end
	
	
feature {GTK_COMMAND_TYPE}
	
	gtk_object: POINTER is
			-- this feature is here to get around a bug in SE-078b5
		do
			Result := widget
		end
	
end -- GTK_TREE_ITEM
