/* IMPORTANT: Read the comment below on how to compile this file.  It
 * is NOT sufficient to just hand it to the C compiler.  It must first
 * be preprocessed.
 */
/* 
 * This file has been generated by 
 *
 *                 D. Richard Hipp
 *                 drh@world.std.com
 *
 * The contributions of Dr. Hipp are placed in the public domain.  However,
 * portions of this file are subject to the copyrights shown below.
 *
 * The changes necessary to use TclX are by Michael Schumacher at
 * mike@hightec.saarlink.de.
 *
 * Copyright (c) 1990-1993 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
/*
**
** The function Et_Eval() is an extension of Tcl_VarEval().
**
** The first and second arguments are the name of the file which
** contains the call to Et_Eval() and the line number within that
** file from which Et_Eval() was called.  This information is used
** to print an error message to stderr if necessary.
**
** The third argument is a format string built from three characters:
** 's', 'd', and 'f'.  This format string determines the number and
** type of subsequent arguments.  Each 's' in the format string
** corresponds to a string argument, each 'd' cooresponds to an integer,
** and each 'f' corresponds to a double.
**
** A format string may now also contain a 'q' character.  'q' means that
** the any of the characters which have special meaning to the Tcl
** interpreter (any of  "{", "}", "[", "\"", "\\" or "$") are escaped.
**
** The operation of Et_Eval() is to concatenate all arguments and
** send the result to Tcl_GlobalEval().  The return of Tcl_GlobalEval()
** is returned from Et_Eval().
**
** In addition to Et_Eval(), this file defines three other functions:
**
**      Et_EvalInt()
**      Et_EvalString()
**      Et_EvalDouble()
**
** In each of these other functions, the value returned is not the status
** string from Tcl_VarEval(), but rather the result string.  The result
** string is converted to an integer or a double for Et_EvalInt() and
** Et_EvalDouble(), respectively.
**
**      Et_EvalInclude()
**
** This function is used to implement the ET_INCLUDE() macro of the ET
** system.  It takes two arguments which are the name of a file and 
** null-terminated string containing the contents of that file.  The
** the function simply calls Tcl_GlobalEval on the string, and then prints
** an appropriate error message if something goes wrong.
**
** The Tcl/Tk interpreter used by all these functions is obtained from
** the global variable "Tcl_Interp *Et_Interp;".  This variable
** should be set to a valid interpreter before calling any function
** in this file.
**
** The function Et_InstallCmd() creates a new command for the
** Tcl/Tk interpreter pointed to by the global variable Et_Interp.
** This function was added in support of the ET_INSTALL_COMMANDS macro.
**
** All of the above functions are normally called from ET macros, not
** directly by the user.  The next set of functions are called directly
** by the user:
**
**     Et_Init(int *,char **);
**     Et_ReadStdin(void);
**     Et_MainLoop(void);
**
** The Et_Init() function should be the first function called from within
** the main() procedure of an application.  This function initializes the
** ET interpreter.  Command line arguments used by the interpreter are
** removed from  argc and argv.
**
** Et_MainLoop() should be the last function in the main() procedure.  It
** implements the event loop.
**
** If the function Et_ReadStdin() is called prior to Et_MainLoop(), then
** arrangements are made to read standard input and pass the results to
** the ET interpreter.
**
********************* HOW TO COMPILE THIS FILE **************************
**
** This file is mostly C code, but it is not completely C code.  It can
** not be handed to the C compiler directory, but must first be preprocessed
** using the "et2c" macro preprocessors.
**
** This version of the ET library file is for use with Tk version 4.1 and
** Tcl version 7.5.
**
***************************** NOTICE ************************************
**
** This version of et.c is especially hacked up to support Windows 95.
*/
#include "tk.h"
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#undef WIN32_LEAN_AND_MEAN
#include <malloc.h>
#include <locale.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>

/*
** The following variable points to the Tcl/Tk interpreter which is
** used by all functions in this file.
*/
Tcl_Interp *Et_Interp = 0;

/* The next variables are made available as a convenience to the
** ET programmer. */
Tk_Window Et_MainWindow;      /* The main window of the application */
Display *Et_Display;          /* The X11 display holding the main window */

/* This flag is TRUE if all scripts processed by ET() macros should
** be printed to standard output. This variable can only be set from
** within the debugger. */
static int et_trace_flag = 0;

/*
** This is the function which does most of the work.  All the Et_EvalXXXX()
** functions call this core to process the variable-length argument list,
** and then do different things with the return parameter
*/
static int
Et_VaEval(
  const char *fileName,      /* Name of the file containing the ET macro */
  int lineNumber,            /* Line number of start of ET macro */
  const char *format,        /* Format string */
  va_list ap                 /* Pointer to the argument list */
){
  int i;                     /* Loop counter */
  int retc;                  /* Return code from Tcl_Eval() */
  char *buf;                 /* Buffer to hold the Tcl command string  */
  char *cp;                  /* For scanning strings */
  char c;                    /* Next character being scanned */
  char *next;                /* Pointer to the next unused slot in buf[] */
  int spaceNeeded;           /* Amount of spaced needed in buf to hold
                             ** the entire Tcl command string */
  va_list firstArg;          /* A pointer to the first argument of the
                             ** variant part of the argument list. */
  char smallSpace[40];       /* A space large enough to hold the ascii
                             ** value of an integer or floating point number */
  char bigSpace[1000];       /* The initial buffer.  Hopefully this is enough,
                             ** but if not we can malloc() for more */

  if( Et_Interp==0 ){
    fprintf(stderr,
      "ERROR: %s line %d: Et_Interp does not point to a valid Tk interpreter\n",
      fileName,lineNumber);
    return TCL_ERROR;
  }

  /* Make a pass thru the argument list and tally up the size of the
  ** buffer needed */
  firstArg = ap;
  spaceNeeded = 1;   /* One for the null-terminator */
  for(i=0; format[i]; i++){
    switch( format[i] ){
      case 's':    /* A string */
        spaceNeeded += strlen(va_arg(ap,char*));
        break;

      case 'd':    /* An integer */
        spaceNeeded += 20;
        (void)va_arg(ap,int);
        break;

      case 'f':    /* A double */
        spaceNeeded += 20;
        (void)va_arg(ap,double);
        break;

      case 'q':    /* A quoted string */
        cp = va_arg(ap,char*);
        while( (c=*cp++)!=0 ){
          if( c=='$' || c=='[' || c=='\"' || c=='\\' || c=='{' || c=='}' ){
            spaceNeeded++;
          }
          spaceNeeded++;
	}
        break;
    }
  }

  /* Get a buf which is large enough to hold it all */
  if( spaceNeeded<=sizeof(bigSpace) ){
    buf = bigSpace;
  }else{
    buf = malloc( spaceNeeded );
    if( buf==0 ){
       sprintf(bigSpace,"File %s line %d: can't allocate %d bytes of memory",
          fileName,lineNumber,spaceNeeded);
       Tcl_AppendResult(Et_Interp,bigSpace,0);
       return TCL_ERROR;
    }
  }

  /* Now make another pass thru the argument list in order to
  ** build the Tcl command string */
  ap = firstArg;
  next = buf;
  for(i=0; format[i]; i++){
    char *str;       /* Pointer to a source string which is to be
                     ** copied into buf */
    switch( format[i] ){
      case 's':    /* A string */
        str = va_arg(ap,char*);
        break;

      case 'd':    /* An integer */
        str = smallSpace;
        sprintf(str,"%d",va_arg(ap,int));
        break;

      case 'f':    /* A double */
        str = smallSpace;
        sprintf(str,"%g",va_arg(ap,double));
        break;

      case 'q':    /* A quoted string */
        str = va_arg(ap,char*);
        while( (c=*str)!=0 ){
          if( c=='$' || c=='[' || c=='\"' || c=='\\' || c=='{' || c=='}' ){
            *next++ = '\\';
	  }
          *next++ = c;
          str++;
	}
        break;

      default:     /* Can't happen */
        str = "";
        break;
    }
    while( (*next++ = *str++)!=0 );
    next--;
  }

  /* Evaluate the Tcl command string.  Generate an error message
  ** if an error occurs */
  retc = Tcl_GlobalEval(Et_Interp,buf);
  if( et_trace_flag ){
    char *cp = buf;
    while( *cp ){
      if( *cp=='\\' && cp[1]=='\n' ){ *cp=' '; cp[1]=' '; }
      cp++;
    }
    printf("%s\n",buf);
  }
  if( retc==TCL_ERROR ){
    char buf[40];
    fprintf(stderr,"ERROR at %s line %d: %s\n",
       fileName,Et_Interp->errorLine + lineNumber - 1,Et_Interp->result);
    sprintf(buf,"%d",Et_Interp->errorLine + lineNumber + 1);
    Tcl_VarEval(Et_Interp,"tkerror {",fileName," line ",buf,"}",0);
  }

  /* clean up and return */
  if( buf!=bigSpace ) free(buf);
  return retc;
}

/*
** This version of Et_Eval() evaluates a single string as the Tcl command,
** just as Tcl_Eval() would.  The difference is in the processing of
** error message.  This function is called by the ET_INCLUDE() macro.
** Et_Eval() could have been used, but this version avoids an extra
** copy of the script from one buffer into another.
*/
void
Et_EvalInclude(
  const char *zFilename, /* The file from which the script was taken */
  char *script           /* The Tcl/Tk command script */
){
  if( Et_Interp==0 ){
    fprintf(stderr,
      "ERROR: %s: Et_Interp does not point to a valid Tk interpreter\n",
      zFilename);
    return;
  }
  if( Tcl_GlobalEval(Et_Interp,script)==TCL_ERROR ){
    char buf[40];
    fprintf(stderr,"ERROR at %s line %d: %s\n",
       zFilename,Et_Interp->errorLine,Et_Interp->result);
    sprintf(buf,"%d",Et_Interp->errorLine);
    Tcl_VarEval(Et_Interp,"tkerror {",zFilename," line ",buf,"}",0);
  }
}

/*
** Execute the Tcl/Tk command string and return an status code
*/
int Et_Eval(const char *filename, int lineNumber, const char *format, ...){
  va_list ap;
  int retc;
  va_start(ap,format);
  retc = Et_VaEval(filename,lineNumber,format,ap);
  va_end(ap);
  return retc;
}

/*
** Execute the Tcl/Tk command string and return the result string
*/
char *
Et_EvalString(const char *filename, int lineNumber, const char *format, ...){
  va_list ap;
  int status;
  va_start(ap,format);
  status = Et_VaEval(filename,lineNumber,format,ap);
  va_end(ap);
  return Et_Interp->result;
}

/*
** Execute the Tcl/Tk command string and return the result converted
** into an integer
*/
int
Et_EvalInt(const char *filename, int lineNumber, const char *format, ...){
  va_list ap;
  int status;
  va_start(ap,format);
  status = Et_VaEval(filename,lineNumber,format,ap);
  va_end(ap);
  return atoi(Et_Interp->result);
}

/*
** Execute the Tcl/Tk command string and return the result converted
** into an double
*/
double
Et_EvalDouble(const char *filename, int lineNumber, const char *format, ...){
  va_list ap;
  int status;
  va_start(ap,format);
  status = Et_VaEval(filename,lineNumber,format,ap);
  va_end(ap);
  return atof(Et_Interp->result);
}

/*
** Install a new command into the interpreter.
*/
void
Et_InstallCommand(
  char *zName, 
  int (*cmdProc)(void*,struct Tcl_Interp*,int,char**)
){
  Tcl_CreateCommand(Et_Interp,zName,(Tcl_CmdProc*)cmdProc,
    Tk_MainWindow(Et_Interp),0);
}

/* Platform-specific initialization
*/
int TkPlatformInit(interp)
  Tcl_Interp *interp;
{ 
 /* Load the Tcl/Tk startup scripts.
  */
  ET( set tk_library {}; set tcl_library {} );
  ET_INCLUDE( init.tcl );

  /* The native "tk.tcl" file won't work in ET.  The following is a
  ** substitute. */
  ET(
    package require -exact Tk 4.1
    package require -exact Tcl 7.5

    # Turn off strict Motif look and feel as a default.
    set tk_strictMotif 0

    # tkScreenChanged --
    # This procedure is invoked by the binding mechanism whenever the
    # "current" screen is changing.  The procedure does two things.
    # First, it uses "upvar" to make global variable "tkPriv" point at an
    # array variable that holds state for the current display.  Second,
    # it initializes the array if it didn't already exist.
    #
    # Arguments:
    # screen -		The name of the new screen.

    proc tkScreenChanged screen {
      set disp [file rootname $screen]
      uplevel #0 upvar #0 tkPriv.$disp tkPriv
      global tkPriv
      if [info exists tkPriv] {
        set tkPriv(screen) $screen
        return
      }
      set tkPriv(afterId) {}
      set tkPriv(buttons) 0
      set tkPriv(buttonWindow) {}
      set tkPriv(dragging) 0
      set tkPriv(focus) {}
      set tkPriv(grab) {}
      set tkPriv(initPos) {}
      set tkPriv(inMenubutton) {}
      set tkPriv(listboxPrev) {}
      set tkPriv(mouseMoved) 0
      set tkPriv(oldGrab) {}
      set tkPriv(popup) {}
      set tkPriv(postedMb) {}
      set tkPriv(pressX) 0
      set tkPriv(pressY) 0
      set tkPriv(screen) $screen
      set tkPriv(selectMode) char
      set tkPriv(window) {}
    }

    # Do initial setup for tkPriv, so that it is always bound to something
    # (otherwise, if someone references it, it may get set to a non-upvar-ed
    # value, which will cause trouble later).
    tkScreenChanged [winfo screen .]

    # ----------------------------------------------------------------------
    # Default bindings for keyboard traversal.
    # ----------------------------------------------------------------------

    bind all <Tab> {focus [tk_focusNext %W]}
    bind all <Shift-Tab> {focus [tk_focusPrev %W]}

    # tkCancelRepeat --
    # This procedure is invoked to cancel an auto-repeat action described
    # by tkPriv(afterId).  It's used by several widgets to auto-scroll
    # the widget when the mouse is dragged out of the widget with a
    # button pressed.
    #
    # Arguments:
    # None.
    proc tkCancelRepeat {} {
      global tkPriv
      after cancel $tkPriv(afterId)
      set tkPriv(afterId) {}
    }
  );
  ET_INCLUDE( bgerror.tcl );
  ET_INCLUDE( button.tcl );
  ET_INCLUDE( dialog.tcl );
  ET_INCLUDE( entry.tcl );
  ET_INCLUDE( focus.tcl );
  ET_INCLUDE( listbox.tcl );
  ET_INCLUDE( menu.tcl );
  ET_INCLUDE( obsolete.tcl );
  ET_INCLUDE( optMenu.tcl );
  ET_INCLUDE( palette.tcl );
  ET_INCLUDE( parray.tcl );
  ET_INCLUDE( text.tcl );
  ET_INCLUDE( scale.tcl );
  ET_INCLUDE( scrlbar.tcl );
  ET_INCLUDE( tearoff.tcl );
  ET( proc init {} {# do nothing}; init );
  return ET_OK;
}

/*
** Initialize the Tcl/Tk interpreter.
**
** This is a highly modified version of "main()" from the
** file "tkMain.c" in the standard Tcl/Tk distribution.
*/
static void
EtInit(int argc,char **argv){
    char *args;

    Tcl_FindExecutable(argv[0]);
    Et_Interp = Tcl_CreateInterp();

    /*
     * Make command-line arguments available in the Tcl variables "argc"
     * and "argv".
     */

    args = Tcl_Merge(argc-1, argv+1);
    Tcl_SetVar(Et_Interp, "argv", args, TCL_GLOBAL_ONLY);
    ckfree(args);
    ET( set argc %d(argc-1) );
    ET( set argv0 "%q(argv[0])" );

    /*
     * Set the "tcl_interactive" variable.
     */
    ET( set tcl_interactive 0 );

    /*
     * Invoke application-specific initialization.
     */
    Tk_Init(Et_Interp);
    Tcl_StaticPackage(Et_Interp, "Tk", Tk_Init, (Tcl_PackageInitProc *) NULL);
    TkPlatformInit(Et_Interp);

    /* Set the et_trace_flag */
    Tcl_LinkVar(Et_Interp, "et_trace_flag", (char*)&et_trace_flag,TCL_LINK_INT);

    /* Set up some convenience global variables.
    **
    ** This only works if there is a single display and screen.  But, then
    ** again, ET only works with a single screen...
    */
    Et_MainWindow = Tk_MainWindow(Et_Interp);
    Et_Display = Tk_Display(Et_MainWindow);

    /*
     * Create variables "cmd_name" and "cmd_dir" which contain the
     * base name of the application and the name of the directory 
     * which contains the executable for the application.
     */
#if 0
    ET(
      set cmd_name [file tail $argv0]
      set cmd_dir [file dirname $argv0]
      if "![file readable $argv0] || ![file isfile $argv0]" {
        foreach i [split $env(PATH) :] {
          if "[file readable $i/$cmd_name] && [file isfile $i/$cmd_name]" {
            set cmd_dir $i
            break;
          }
        }
      }
    );
#endif
    ET( set Win32 1 );  /* Let the TCL code know this is windows */
}
/*
 *----------------------------------------------------------------------
 *
 * WishPanic --
 *
 *	Display a message and exit.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Exits the program.
 *
 *----------------------------------------------------------------------
 */
void
WishPanic TCL_VARARGS_DEF(char *,arg1)
{
    va_list argList;
    char buf[1024];
    char *format;
    
    format = TCL_VARARGS_START(char *,arg1,argList);
    vsprintf(buf, format, argList);

    MessageBeep(MB_ICONEXCLAMATION);
    MessageBox(NULL, buf, "Fatal Error in Wish",
	    MB_ICONSTOP | MB_OK | MB_TASKMODAL | MB_SETFOREGROUND);
    ExitProcess(1);
}

/*
** This is the main routine for the application -- the procedure that
** runs before all others.
**
** Much of the code is stolen from Tk4.1
*/
int APIENTRY
WinMain(hInstance, hPrevInstance, lpszCmdLine, nCmdShow)
    HINSTANCE hInstance;
    HINSTANCE hPrevInstance;
    LPSTR lpszCmdLine;
    int nCmdShow;
{
    char **argv, **argvlist, *p;
    int argc, size, i;
    char buffer[MAX_PATH];

    /*
     * Set up the default locale to be Windows ANSI character set.
     */

    setlocale(LC_ALL, "");

    Tcl_SetPanicProc(WishPanic);

    /*
     * Increase the application queue size from default value of 8.
     * At the default value, cross application SendMessage of WM_KILLFOCUS
     * will fail because the handler will not be able to do a PostMessage!
     * This is only needed for Windows 3.x, since NT dynamically expands
     * the queue.
     */
    SetMessageQueue(64);

    /*
     * Create the console channels and install them as the standard
     * channels.  All I/O will be discarded until TkConsoleInit is
     * called to attach the console to a text widget.
     */

    /* TkConsoleCreate(); */

    /*
     * Precompute an overly pessimistic guess at the number of arguments
     * in the command line by counting non-space spans.  Note that we
     * have to allow room for the executable name and the trailing NULL
     * argument.
     */

    for (size = 3, p = lpszCmdLine; *p != '\0'; p++) {
	if (isspace(*p)) {
	    size++;
	    while (isspace(*p)) {
		p++;
	    }
	    if (*p == '\0') {
		break;
	    }
	}
    }
    argvlist = (char **) ckalloc((unsigned) (size * sizeof(char *)));
    argv = argvlist;

    /*
     * Parse the Windows command line string.  If an argument begins with a
     * double quote, then spaces are considered part of the argument until the
     * next double quote.  The argument terminates at the second quote.  Note
     * that this is different from the usual Unix semantics.
     */

    for (i = 1, p = lpszCmdLine; *p != '\0'; i++) {
	while (isspace(*p)) {
	    p++;
	}
	if (*p == '\0') {
	    break;
	}
	if (*p == '"') {
	    p++;
	    argv[i] = p;
	    while ((*p != '\0') && (*p != '"')) {
		p++;
	    }
	} else {
	    argv[i] = p;
	    while (*p != '\0' && !isspace(*p)) {
		p++;
	    }
	}
	if (*p != '\0') {
	    *p = '\0';
	    p++;
	}
    }
    argv[i] = NULL;
    argc = i;

    /*
     * Since Windows programs don't get passed the command name as the
     * first argument, we need to fetch it explicitly.
     */

    GetModuleFileName(NULL, buffer, sizeof(buffer));
    argv[0] = buffer;

    EtInit(argc, argv);
    Et_Main(argc,argv);
    Tk_MainLoop();
    Tcl_DeleteInterp(Et_Interp);
    Tcl_Exit(0);
    return 1;
}
