/* ---
 * f77 bit functions.
 * are not part of f2c but heavily used by HEP code. CERNLIB includes them
 * however there are HEP programs linked without CERNLIB - so we have to
 * provide them again.
 * ----------------------------------------------------------------------
 * (C) Wolfgang Wander 1996
 */

void
mvbits_( unsigned *m, int *i, int *len, int *n, int *j)
{
  unsigned mask = ~(0xffffffff << (*len));
  unsigned maskm = mask << *i;
  unsigned maskn = mask << *j;
  unsigned pm = *m & maskm;
  if( *i > *j )
    pm >>= (*i - *j);
  else if( *j > *i )
    pm <<= (*j - *i);
  *n = (*n & ~maskn) | pm;
  return;
}

#ifdef TEST
main( )
{
  int i, len, j;
  unsigned m, n;
  
  while( scanf("%x %d %d %x %d",&m,&i,&len,&n,&j) == 5 ) {
    mvbits_(&m,&i,&len,&n,&j);
    printf("%x\n", n);
  }
}
#endif
