#!/bin/sh
#
#	fhist - file history and comparison tools
#	Copyright (C) 1993, 1994, 1998, 1999 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: shell script to generate the Makefile file
#
clean_files="core common/lib.\$(LIBEXT) .bin .bindir"
man_files=
man_i18n_files=
po_files=
install_po_files=
doc_files=
install_doc_files=
test_files=
progs=
progsa=
progsi=

#
# Emit the rules to build a directory, and all the ones above it.
#
recursive_mkdir()
{
	src_dir="$1"
	dst_dir="$2"
	flavor="${3-datadir}"
	while :
	do
		dirvar=`echo $src_dir | sed 's|[^a-zA-Z]|_|g'`
		dotdot1=`dirname ${src_dir-.}`
		dotdot2=`dirname ${dst_dir-.}`
		if eval "test \${${dirvar}_${flavor}-no} != yes" ; then
			echo ""
			if test "$dotdot1" != "." -a "$dotdot2" != "." ; then
				echo "$src_dir/.${flavor}: $dotdot1/.${flavor}"
			else
				echo "$src_dir/.${flavor}:"
			fi
			echo "	-\$(INSTALL) -m 0755 -d $dst_dir"
			echo "	@-test -d $dst_dir && touch \$@"
			echo "	@sleep 1"
			eval "${dirvar}_${flavor}=yes"
			clean_files="$clean_files $src_dir/.${flavor}"
		fi
		src_dir=$dotdot1
		dst_dir=$dotdot2
		if test "$src_dir" = "." -o "$dst_dir" = "." ; then break; fi
	done
}

echo
for file in $*
do
	case $file in

	*.y)
		dir=`echo $file | sed 's|^\([^/]*\)/.*$|\1|'`
		stem=`echo $file | sed 's/\.y$//'`
		eval "${dir}_files=\"\$${dir}_files ${stem}.gen.\\\$(OBJEXT)\""
		clean_files="$clean_files ${stem}.gen.c ${stem}.gen.h \
${stem}.gen.\$(OBJEXT)"
		;;

	*/*.c)
		dir=`echo $file | sed 's|/.*$||'`
		stem=`echo $file | sed 's|\.c$||'`
		eval "${dir}_files=\"\$${dir}_files ${stem}.\\\$(OBJEXT)\""
		clean_files="$clean_files ${stem}.\$(OBJEXT)"

		case $file in

		*/main.c)
			progs="$progs $dir"
			progsa="$progsa bin/$dir\$(EXEEXT)"
			progsi="$progsi \$(bindir)/\$(PROGRAM_PREFIX)$dir\$(PROGRAM_SUFFIX)\$(EXEEXT)"
			;;

		*)
			;;
		esac
		;;

	lib/*/LC_MESSAGES/common.po)
		;;

	lib/*.po)
		stem=`echo $file | sed 's|^lib/\(.*\)\.po$|\1|'`
		src="lib/$stem.mo"
		po_files="$po_files $src"
		dst="\$(libdir)/$stem.mo"
		install_po_files="$install_po_files $dst"
		recursive_mkdir `dirname $src` `dirname $dst` libdir
		;;

	lib/*/*/*.so)
		;;

	lib/*/man?/*)
		stem=`echo $file | sed 's|^lib/||'`
		man_i18n_files="$man_i18n_files \$(datadir)/$stem"

		case $file in
		lib/en/*)
			stem2=`echo $file | sed 's|^lib/en/||'`
			man_files="$man_files \$(mandir)/$stem2"

			src="lib/$stem"
			dst="\$(mandir)/$stem2"
			recursive_mkdir `dirname $src` `dirname $dst` mandir
			;;
		esac

		src="lib/$stem"
		dst="\$(datadir)/$stem"
		recursive_mkdir `dirname $src` `dirname $dst` datadir
		;;

	lib/*.so)
		;;

	lib/*/*/main.*)
		stem=`echo $file | sed 's|^lib/\(.*\)/main.*$|\1|'`
		doc_files="$doc_files lib/$stem.ps lib/$stem.dvi lib/$stem.txt"
		clean_files="$clean_files lib/$stem.ps lib/$stem.dvi lib/$stem.txt"
		install_doc_files="$install_doc_files \$(datadir)/$stem.ps \$(datadir)/$stem.dvi \$(datadir)/$stem.txt"
		;;

	test/*/*)
		root=`basename $file .sh`
		test_files="$test_files $root"
		;;

	*)
		;;
	esac
done

echo ''
echo "all: binaries po doc"

#
# The variable parts
#
echo
echo "CommonFiles =" $common_files
echo
echo "TestFiles =" $test_files
echo
echo "install-man:" $man_files
echo
echo 'install-iman: install-iman-$(HAVE_I18N)'
echo
echo "install-iman-yes:" $man_i18n_files
echo
echo 'install-iman-no:'
echo ''
echo 'po: po-$(HAVE_I18N)'
echo
echo "po-yes:" $po_files
echo
echo 'po-no:'
echo
echo 'install-po: install-po-$(HAVE_I18N)'
echo
echo "install-po-yes:" $install_po_files
echo
echo 'install-po-no:'
echo ''
echo 'doc: doc-$(HAVE_GROFF)'
echo
echo "doc-yes:" $doc_files
echo
echo 'doc-no:'
echo
echo 'install-doc: install-doc-$(HAVE_GROFF)'
echo
echo "install-doc-yes:" $install_doc_files
echo
echo 'install-doc-no:'

echo ''
echo "binaries: $progsa"

for prog in $progs
do
	echo ''
	eval "echo ${prog}_files = \${${prog}_files}"
	echo ''
	echo "bin/$prog\$(EXEEXT): \$(${prog}_files) common/lib.\$(LIBEXT) .bin"
	echo "	\$(CC) \$(LDFLAGS) -o \$@ \$(${prog}_files) common/lib.\$(LIBEXT) \$(LIBS)"
	echo "	chmod 755 \$@"
	echo ''
	echo "\$(bindir)/\$(PROGRAM_PREFIX)$prog\$(PROGRAM_SUFFIX)\$(EXEEXT): bin/$prog\$(EXEEXT) .bindir"
	echo "	\$(INSTALL_PROGRAM) bin/$prog\$(EXEEXT) \$@"
done

echo ""
echo "clean-obj:"
echo $clean_files | tr ' ' '\12' | gawk '{
	if (pos > 0 && pos + length($1) > 71) { printf("\n"); pos = 0; }
	if (pos == 0) { printf "	rm -f"; pos = 13; }
	printf " %s", $1
	pos += 1 + length($1);
}
END { if (pos) printf "\n"; }'

#
# emit the constant part
#
echo ''
echo 'clean: clean-obj'
echo "	rm -f $progsa"

cat << 'fubar'

distclean: clean
	rm -f config.status config.log config.cache Makefile common/config.h etc/libdir-h

common/lib.$(LIBEXT): $(CommonFiles)
	rm -f $@
	ar cq $@ $(CommonFiles)
	$(RANLIB) $@

.bin:
	-mkdir bin
	-@test -d bin && touch $@
	@sleep 1

.bindir:
	-$(INSTALL) -d -m 0755 $(bindir)
	-@test -d $(bindir) && touch $@
	@sleep 1

sure: $(TestFiles)
	@echo Passed All Tests

install: install-bin install-man install-iman install-po install-doc
	@echo Installation Complete

fubar

echo "install-bin: $progsi" 

exit 0
