#!/bin/sh
#
# Script to insert links from all occurrences of each ftnchek option
# to the main description of the option in ftnchek.html.
#
# Author: Robert Moniot
# Date:   19 Jul 1998
#
#  Get list of all ftnchek main options, excluding the leading '-'.
#  Turn it into a list of sed substitutions to change them into hrefs.
#  The href is "#option" (without the -).  The substitutions look for -opt
#  preceded by non-letter so that, e.g. f77's param-intrinsic won't match
#  -intrinsic.  This will fail if a real option comes at the start of a
#  line, but that shouldn't happen since rman puts bolding around them.
ftnchek -help | \
	  awk '/^ *-/ {split($0,opt);
		 sub(/\[no\]/,"",opt[1]);
		 sub(/=.*$/,"",opt[1]);
		 sub(/^-/,"",opt[1]);
		 printf("s,\\([^a-z]\\)-%s,\\1<A HREF=\"#%s\">-%s</A>,g\n",
		    opt[1],opt[1],opt[1]);
		}' \
	  > option_sub.sed

# Now create the cross-references.

# The first sed command creates anchors for all the option
# descriptions in main description section.  The second one
# substitutes hot-links to the former at all the places where the
# options occur in the text.
# The third one puts hot-links in for the -[no]options in synopsis section
# that are not recognized by the second sed.

sed -e '/<H2><A NAME=.*Options/,/<H2><A NAME=/s,^<DT><B>-\([a-z][a-z0-9]*\)[^<]*</B>,<A NAME="\1"></A>&,' | \
sed -f option_sub.sed $make_hrefs  | \
sed -e '/<H2><A NAME=.*Name/,/<H2><A NAME=.*Description/s,<B>-</B>\[<B>no</B>\]<B>\([a-z][-a-z0-9]*\),<A HREF="#\1">&</A>,g'


