#!/bin/sh
#
# Script to break up ftnchek.html into separate sections in html directory.
#
# Author: Robert Moniot
# Date:   31 Jul 1998
#

	    # This function puts out header needed by all but 1st page.
do_header(){
cat <<EOF
<HTML>
<HEAD>
<TITLE>$*</TITLE>
</HEAD>
<BODY>
EOF
}

	    # This function puts out ref to table of contents that
	    # follows header for all but 1st and toc page.
do_href_toc(){
cat <<EOF
<A HREF="toc.html">Table of Contents</A><P>
EOF
}
	    # This function puts out ref to previous section
do_href_prev(){
  echo "<P>Previous: <A HREF=\"$1.html\">$2</A><HR><P>"
}


	    # This function puts out footer needed by all but last page.
do_footer(){
cat <<EOF
</BODY></HTML>
EOF
}

	    # This function changes the trailing NAME anchor
	    # of a section into an href to the next section.
	    # The first edit is for sections.  The second edit
	    # handles the toc anchor, which has no href and so
	    # is missed by the first edit.  The third edit is
	    # for options.
href_next(){
 sed -e '$s,^.*<A NAME="\([^"]*\)" HREF=[^>]*>\([^<]*\).*$,<P><HR><P>Next: <A HREF="\1.html">\2</A>,' \
     -e '$s,<A NAME="\(toc[^"]*\)",Next: <A HREF="\1.html",' \
     -e '$s,^.*<A NAME="\([^"]*\)".*$,<P><HR><P>Next: <A HREF="\1.html">-\1</A>,'
}

	    # This function adapts internal refs from one-big-file
	    # form into multi-file format.
	    # First edit changes "#tocn" into "toc.html#tocn"
	    # Second edit changes "#sectn" into "sectn.html#sectn"
	    # Third edit changes "#option" into "option.html"
change_hrefs(){
    sed -e 's,HREF="#toc\([0-9][0-9]*\)",HREF="toc.html#toc\1",g' \
	-e 's,HREF="#sect\([0-9][0-9]*\)",HREF="sect\1.html#sect\1",g' \
        -e 's,HREF="#\([^"]*\)",HREF="\1.html",g'
}


#  Execution begins here.

		# Filter the input (file arg or stdin) thru a sed script
		# that fixes cases where an anchor for a section has
		# had its section title split across two or more lines.
		# Put the result in a tmp file so it can be re-read.

filename="/tmp/html_split_$$.html"
trap "rm -f $filename" 0
sed -e ':top' \
    -e '/^<H[1-9]><A NAME="sect.*[^>]$/N' \
    -e '/^<LI><A NAME="toc.*[^>]$/N' \
    -e 's/\n/ /' \
    -e 't top' $1 > $filename

		#  Get a list of all ftnchek main options, excluding the
		#  leading '-'.  Sort them for use on Options page.
options=`ftnchek -help | \
	  awk '/^ *-/ {split($0,command);
		 sub(/\[no\]/,"",command[1]);
		 sub(/=.*$/,"",command[1]);
		 sub(/^-/,"",command[1]);
		 print command[1];
		}' | sort`

		# Get a list of all the sections excluding special ones.
sectlist=`sed -n 's,^.*<A NAME="\(sect[0-9][0-9]*\)".*$,\1,p' $filename |
	    grep -v 'sect[01]$'`


# This little bit, copied from GNU configure, sets ac_n and ac_c such
# that echo $ac_n "stuff $ac_c" yields "stuff " w/o following newline.
if (echo "testing\c"; echo 1,2,3) | grep c >/dev/null; then
  # Stardent Vistra SVR4 grep lacks -e, says ghazi@caip.rutgers.edu.
  if (echo -n testing; echo 1,2,3) | sed s/-n/xn/ | grep xn >/dev/null; then
    ac_n= ac_c='
' ac_t='	'
  else
    ac_n=-n ac_c= ac_t=
  fi
else
  ac_n= ac_c='\c' ac_t=
fi

		# Create html directory if it does not exist.
if [ -d html ]
then
  echo "Re-using directory html."
else
  echo "Creating directory html..."
  if mkdir html
  then
    true
  else
    echo "Failed!"
    exit 1
  fi
fi

echo "Creating section pages..."

		# Produce index page.  It is special, since it combines
		# sect0 and sect1 and uses the rman-generated header.
echo $ac_n "sect0 sect1 $ac_c"
(sed -n -e '1,/^<H2><A NAME="sect2"/p'  $filename | \
 href_next | \
 change_hrefs ;
 do_footer) > html/sect0.html

		# Produce pages for all other sections except toc.
		# Section for options gets special treatment since 
		# individual options will be split off into separate files,
		# and links to all options are placed at end of page.

prevsect=sect1
prevtext=`sed -n 's,^<H2><A NAME="'$prevsect'" HREF="#toc[0-9][0-9]*">\([^<]*\).*$,\1,p' $filename | sed -e 's/ *$//'`
for sect in $sectlist;
do
  echo $ac_n "$sect $ac_c"
  headtext=`sed -n 's,^<H2><A NAME="'$sect'" HREF="#toc[0-9][0-9]*">\([^<]*\).*$,\1,p' $filename | sed -e 's/ *$//'`

  (do_header $headtext ; do_href_toc ;
   do_href_prev "$prevsect" "$prevtext" ;
  if [ "$headtext" = "Options" ]
  then
    (sed -n -e '/<A NAME="'$sect'"/,/<A NAME="sect/p' $filename | \
     href_next | \
     sed -n -e '1,/<A NAME=/p' -e '$p' | \
     sed -e '/<A NAME="[^s]/d' ;
     echo "<P><HR><P>" ;
     echo $options | \
     sed -e 's@\([^ ][^ ]*\)@<B><A HREF="\1.html">-\1,</A></B> @g' \
	 -e 's@,</A></B> *$@.</A></B>@'
    )
  else
    sed -n -e '/<A NAME="'$sect'"/,/<A NAME=/p' $filename | \
    href_next
  fi | \
  change_hrefs ;
  do_footer) > html/$sect.html
  prevsect="$sect"
  prevtext="$headtext"
done


		# Produce table of contents
echo "toc"
(do_header Table of Contents ;
 sed -n -e '/<A NAME="toc">/,$p' $filename | \
 change_hrefs ;
) > html/toc.html

		# Now produce pages for all the options
echo "Creating option pages..."

prevsect=`sed -n 's,^<H2><A NAME="\(sect[0-9][0-9]*\)" HREF="#toc[0-9][0-9]*">Options.*$,\1,p' $filename | sed -e 's/ *$//'`
prevtext="Options"

for opt in $options
do
 echo $ac_n "$opt $ac_c"
(do_header "Option: $opt" ; do_href_toc ;
 do_href_prev "$prevsect" "$prevtext" ;
 echo "<H2>Option: <font color="#FF0080">$opt</font></H2><P>" ;
 sed -n -e '/<A NAME="'$opt'"/,/<A NAME=/p' $filename | \
 href_next | \
 change_hrefs ;
 do_footer) > html/$opt.html
 prevsect="$opt"
 prevtext="-$opt"
done
echo ""

		# Finally, make sure the symlinks index.html and
		# sect1.html -> sect0.html are in place, and if not,
		# create them.
echo "Doing symlinks"
cd html
if [ ! -f index.html  ]
then
   ln -s sect0.html index.html
fi

if [ ! -f sect1.html  ]
then
   ln -s sect0.html sect1.html
fi

