{
GPC demo program about initialized variables and typed constants.

Copyright (C) 1999 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING. If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.

As a special exception, if you incorporate even large parts of the
code of this demo program into another program with substantially
different functionality, this does not cause the other program to
be covered by the GNU General Public License. This exception does
not however invalidate any other reasons why it might be covered
by the GNU General Public License.
}

program InitVarDemo;

var
  Foo : Integer value 42;  { An initialized variable according to ISO 10206 }
  Bar : Integer = 17;      { GPC also supports this syntax }

type
  TBaz = Integer value 19; { A type with an initialization }

var
  Baz : TBaz;              { A variable initialized from its type }

const
  Qux : Integer = 22;      { A typed *constant* }

procedure DemoGlobal;
begin
  Writeln ('Initial values:             Foo = ', Foo, '  Bar = ', Bar, '  Baz = ', Baz, '  Qux = ', Qux);
  Inc (Foo);
  Dec (Bar);
  Baz := 2 * Baz;
  Qux := 0; { A constant cannot be modified. GPC gives only a warning
              because many programs rely on the unfortunate behaviour
              of other compilers, but still one should rather use an
              initialized variable when one wants a variable, and a
              typed constant only for real constants. }
  Writeln ('Values after modification:  Foo = ', Foo, '  Bar = ', Bar, '  Baz = ', Baz, '  Qux = ', Qux);
  Writeln
end;

procedure DemoLocal;
var
  Foo : Integer = 42;        { An initialized local variable. It is
                               initialized whenever the procedure is
                               entered. }

  Bar : static Integer = 17; { A static initialized variable. It is only
                               initialized once at the beginning of the
                               program. `static' is a GNU Pascal extension. }

const
  Baz : Integer = 19;        { A typed constant. Some people use them instead
                               of static variables, because some compilers
                               that don't know `static' automatically make
                               typed constants static. GPC emulates this
                               behaviour, but it is not recommended to make
                               use of it. Better declare your variables
                               `static' when that's what you mean. }

begin
  Writeln ('Initial values:             Foo = ', Foo, '  Bar = ', Bar, '  Baz = ', Baz);
  Inc (Foo);
  Dec (Bar);
  Baz := 2 * Baz; { Again, not recommended }
  Writeln ('Values after modification:  Foo = ', Foo, '  Bar = ', Bar, '  Baz = ', Baz);
  Writeln
end;

begin
  Writeln ('Global variables:');
  DemoGlobal;
  Writeln ('Local variables, first run:');
  DemoLocal;
  Writeln ('Local variables, second run:');
  DemoLocal
end.
