#include "available-stubs.h"

#include <X11/Xlib.h>
#include "checker_api.h"

#define CHKR_CHECK_DISPLAY(display) 
#define CHKR_CHECK_VISUAL(visual)

/* compiled from: . */
#ifdef HAVE_XLoadQueryFont
/* From `/usr/include/X11/Xlib.h:1332'.  */
XFontStruct * chkr_stub_XLoadQueryFont (Display * arg0, const char * arg1) __asm__ (CHKR_PREFIX ("XLoadQueryFont"));
XFontStruct *
chkr_stub_XLoadQueryFont (Display * arg0, const char * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XLoadQueryFont);
#else
  return XLoadQueryFont (arg0, arg1);
  {
    XFontStruct * res;
    res = XLoadQueryFont (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XLoadQueryFont */

#ifdef HAVE_XQueryFont
/* From `/usr/include/X11/Xlib.h:1339'.  */
XFontStruct * chkr_stub_XQueryFont (Display * arg0, XID arg1) __asm__ (CHKR_PREFIX ("XQueryFont"));
XFontStruct *
chkr_stub_XQueryFont (Display * arg0, XID arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XQueryFont);
#else
  return XQueryFont (arg0, arg1);
  {
    XFontStruct * res;
    res = XQueryFont (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XQueryFont */

#ifdef HAVE_XGetMotionEvents
/* From `/usr/include/X11/Xlib.h:1350'.  */
XTimeCoord * chkr_stub_XGetMotionEvents (Display * arg0, Window arg1, Time arg2, Time arg3, int * arg4) __asm__ (CHKR_PREFIX ("XGetMotionEvents"));
XTimeCoord *
chkr_stub_XGetMotionEvents (Display * arg0, Window arg1, Time arg2, Time arg3, int * arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg4, sizeof (int), CHKR_XX, "arg4");
#if USE_BI_JUMP
  __builtin_jump (XGetMotionEvents);
#else
  return XGetMotionEvents (arg0, arg1, arg2, arg3, arg4);
  {
    XTimeCoord * res;
    res = XGetMotionEvents (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetMotionEvents */

#ifdef HAVE_XDeleteModifiermapEntry
/* From `/usr/include/X11/Xlib.h:1362'.  */
XModifierKeymap * chkr_stub_XDeleteModifiermapEntry (XModifierKeymap * arg0, unsigned int arg1, int arg2) __asm__ (CHKR_PREFIX ("XDeleteModifiermapEntry"));
XModifierKeymap *
chkr_stub_XDeleteModifiermapEntry (XModifierKeymap * arg0, unsigned int arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (XModifierKeymap), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDeleteModifiermapEntry);
#else
  return XDeleteModifiermapEntry (arg0, arg1, arg2);
  {
    XModifierKeymap * res;
    res = XDeleteModifiermapEntry (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDeleteModifiermapEntry */

#ifdef HAVE_XGetModifierMapping
/* From `/usr/include/X11/Xlib.h:1368'.  */
XModifierKeymap * chkr_stub_XGetModifierMapping (Display * arg0) __asm__ (CHKR_PREFIX ("XGetModifierMapping"));
XModifierKeymap *
chkr_stub_XGetModifierMapping (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XGetModifierMapping);
#else
  return XGetModifierMapping (arg0);
  {
    XModifierKeymap * res;
    res = XGetModifierMapping (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetModifierMapping */

#ifdef HAVE_XInsertModifiermapEntry
/* From `/usr/include/X11/Xlib.h:1380'.  */
XModifierKeymap * chkr_stub_XInsertModifiermapEntry (XModifierKeymap * arg0, unsigned int arg1, int arg2) __asm__ (CHKR_PREFIX ("XInsertModifiermapEntry"));
XModifierKeymap *
chkr_stub_XInsertModifiermapEntry (XModifierKeymap * arg0, unsigned int arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (XModifierKeymap), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XInsertModifiermapEntry);
#else
  return XInsertModifiermapEntry (arg0, arg1, arg2);
  {
    XModifierKeymap * res;
    res = XInsertModifiermapEntry (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XInsertModifiermapEntry */

#ifdef HAVE_XNewModifiermap
/* From `/usr/include/X11/Xlib.h:1386'.  */
XModifierKeymap * chkr_stub_XNewModifiermap (int arg0) __asm__ (CHKR_PREFIX ("XNewModifiermap"));
XModifierKeymap *
chkr_stub_XNewModifiermap (int arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XNewModifiermap);
#else
  return XNewModifiermap (arg0);
  {
    XModifierKeymap * res;
    res = XNewModifiermap (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XNewModifiermap */

#ifdef HAVE_XCreateImage
/* From `/usr/include/X11/Xlib.h:1401'.  */
XImage * chkr_stub_XCreateImage (Display *display, Visual *visual,
				 unsigned int depth, int format, int offset,
				 char *data,
				 unsigned int width, unsigned int height,
				 int bitmap_pad, int bytes_per_line)
     __asm__ (CHKR_PREFIX ("XCreateImage"));
XImage *
chkr_stub_XCreateImage (Display *display, Visual *visual,
				 unsigned int depth, int format, int offset,
				 char *data,
				 unsigned int width, unsigned int height,
				 int bitmap_pad, int bytes_per_line)
{
  int pad = (bitmap_pad / 8 - 1);
  CHKR_CHECK_DISPLAY (display);
  CHKR_CHECK_VISUAL (visual);
  
  stubs_chkr_check_addr (data,
			 (bytes_per_line + pad) & ~pad,
			 CHKR_RO, "data");
#if USE_BI_JUMP
  __builtin_jump (XCreateImage);
#else
  return XCreateImage (display, visual, depth, format, offset, data,
		       width, height, bitmap_pad, bytes_per_line);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCreateImage */

#ifdef HAVE_XInitImage
/* From `/usr/include/X11/Xlib.h:1406'.  */
int chkr_stub_XInitImage (XImage * arg0) __asm__ (CHKR_PREFIX ("XInitImage"));
int
chkr_stub_XInitImage (XImage * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (XImage), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XInitImage);
#else
  return XInitImage (arg0);
  {
    int res;
    res = XInitImage (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XInitImage */

#ifdef HAVE_XGetImage
/* From `/usr/include/X11/Xlib.h:1418'.  */
XImage * chkr_stub_XGetImage (Display * arg0, Drawable arg1, int arg2, int arg3, unsigned int arg4, unsigned int arg5, long unsigned int arg6, int arg7) __asm__ (CHKR_PREFIX ("XGetImage"));
XImage *
chkr_stub_XGetImage (Display * arg0, Drawable arg1, int arg2, int arg3, unsigned int arg4, unsigned int arg5, long unsigned int arg6, int arg7)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XGetImage);
#else
  return XGetImage (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
  {
    XImage * res;
    res = XGetImage (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetImage */

#ifdef HAVE_XGetSubImage
/* From `/usr/include/X11/Xlib.h:1433'.  */
XImage * chkr_stub_XGetSubImage (Display * arg0, Drawable arg1, int arg2, int arg3, unsigned int arg4, unsigned int arg5, long unsigned int arg6, int arg7, XImage * arg8, int arg9, int arg10) __asm__ (CHKR_PREFIX ("XGetSubImage"));
XImage *
chkr_stub_XGetSubImage (Display * arg0, Drawable arg1, int arg2, int arg3, unsigned int arg4, unsigned int arg5, long unsigned int arg6, int arg7, XImage * arg8, int arg9, int arg10)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg8, sizeof (XImage), CHKR_XX, "arg8");
#if USE_BI_JUMP
  __builtin_jump (XGetSubImage);
#else
  return XGetSubImage (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
  {
    XImage * res;
    res = XGetSubImage (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetSubImage */

#ifdef HAVE_XOpenDisplay
/* From `/usr/include/X11/Xlib.h:1442'.  */
Display * chkr_stub_XOpenDisplay (const char *display_name)
     __asm__ (CHKR_PREFIX ("XOpenDisplay"));
Display *
chkr_stub_XOpenDisplay (const char *display_name)
{
  Display * res;

  if (display_name)
    stubs_chkr_check_str (display_name, CHKR_RO, "display_name");

  res = XOpenDisplay (display_name);
  return res;
}
#endif /* HAVE_XOpenDisplay */

#ifdef HAVE_XrmInitialize
/* From `/usr/include/X11/Xlib.h:1448'.  */
void chkr_stub_XrmInitialize (void ) __asm__ (CHKR_PREFIX ("XrmInitialize"));
void
chkr_stub_XrmInitialize (void )
{
#if USE_BI_JUMP
  __builtin_jump (XrmInitialize);
#else
  XrmInitialize ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XrmInitialize */

#ifdef HAVE_XFetchBytes
/* From `/usr/include/X11/Xlib.h:1455'.  */
char * chkr_stub_XFetchBytes (Display * arg0, int * arg1) __asm__ (CHKR_PREFIX ("XFetchBytes"));
char *
chkr_stub_XFetchBytes (Display * arg0, int * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (int), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XFetchBytes);
#else
  return XFetchBytes (arg0, arg1);
  {
    char * res;
    res = XFetchBytes (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFetchBytes */

#ifdef HAVE_XFetchBuffer
/* From `/usr/include/X11/Xlib.h:1462'.  */
char * chkr_stub_XFetchBuffer (Display * arg0, int * arg1, int arg2) __asm__ (CHKR_PREFIX ("XFetchBuffer"));
char *
chkr_stub_XFetchBuffer (Display * arg0, int * arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (int), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XFetchBuffer);
#else
  return XFetchBuffer (arg0, arg1, arg2);
  {
    char * res;
    res = XFetchBuffer (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFetchBuffer */

#ifdef HAVE_XGetAtomName
/* From `/usr/include/X11/Xlib.h:1468'.  */
char * chkr_stub_XGetAtomName (Display * arg0, Atom arg1) __asm__ (CHKR_PREFIX ("XGetAtomName"));
char *
chkr_stub_XGetAtomName (Display * arg0, Atom arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XGetAtomName);
#else
  return XGetAtomName (arg0, arg1);
  {
    char * res;
    res = XGetAtomName (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetAtomName */

#ifdef HAVE_XGetAtomNames
/* From `/usr/include/X11/Xlib.h:1476'.  */
int chkr_stub_XGetAtomNames (Display * arg0, Atom * arg1, int arg2, char ** arg3) __asm__ (CHKR_PREFIX ("XGetAtomNames"));
int
chkr_stub_XGetAtomNames (Display * arg0, Atom * arg1, int arg2, char ** arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (Atom), CHKR_XX, "arg1");
  stubs_chkr_check_addr (arg3, sizeof (char *), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XGetAtomNames);
#else
  return XGetAtomNames (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XGetAtomNames (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetAtomNames */

#ifdef HAVE_XGetDefault
/* From `/usr/include/X11/Xlib.h:1483'.  */
char * chkr_stub_XGetDefault (Display * arg0, const char * arg1, const char * arg2) __asm__ (CHKR_PREFIX ("XGetDefault"));
char *
chkr_stub_XGetDefault (Display * arg0, const char * arg1, const char * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
  stubs_chkr_check_addr (arg2, sizeof (char), CHKR_RO, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XGetDefault);
#else
  return XGetDefault (arg0, arg1, arg2);
  {
    char * res;
    res = XGetDefault (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetDefault */

#ifdef HAVE_XDisplayName
/* From `/usr/include/X11/Xlib.h:1488'.  */
char *chkr_stub_XDisplayName (const char *name)
     __asm__ (CHKR_PREFIX ("XDisplayName"));
char *
chkr_stub_XDisplayName (const char *name)
{
  char * res;
  
  stubs_chkr_check_str (name, CHKR_RO, "name");
  res = XDisplayName (name);
  if (res)
    stubs_chkr_set_right (res, strlen (res) + 1, CHKR_RW);
  return res;
}
#endif /* HAVE_XDisplayName */

#ifdef HAVE_XKeysymToString
/* From `/usr/include/X11/Xlib.h:1493'.  */
char * chkr_stub_XKeysymToString (KeySym arg0) __asm__ (CHKR_PREFIX ("XKeysymToString"));
char *
chkr_stub_XKeysymToString (KeySym arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XKeysymToString);
#else
  return XKeysymToString (arg0);
  {
    char * res;
    res = XKeysymToString (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XKeysymToString */

#ifdef HAVE_XSynchronize
/* From `/usr/include/X11/Xlib.h:1500'.  */
int (* chkr_stub_XSynchronize (Display * arg0, int arg1) __asm__ (CHKR_PREFIX ("XSynchronize"));
int (*
chkr_stub_XSynchronize (Display * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSynchronize);
#else
  return XSynchronize (arg0, arg1);
  {
    int (* res;
    res = XSynchronize (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSynchronize */

#ifdef HAVE_XSetAfterFunction
/* From `/usr/include/X11/Xlib.h:1510'.  */
int (* chkr_stub_XSetAfterFunction (Display * arg0, int (*) (Display *) arg1) __asm__ (CHKR_PREFIX ("XSetAfterFunction"));
int (*
chkr_stub_XSetAfterFunction (Display * arg0, int (*) (Display *) arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetAfterFunction);
#else
  return XSetAfterFunction (arg0, arg1);
  {
    int (* res;
    res = XSetAfterFunction (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetAfterFunction */

#ifdef HAVE_XInternAtom
/* From `/usr/include/X11/Xlib.h:1517'.  */
Atom chkr_stub_XInternAtom (Display * arg0, const char * arg1, int arg2) __asm__ (CHKR_PREFIX ("XInternAtom"));
Atom
chkr_stub_XInternAtom (Display * arg0, const char * arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XInternAtom);
#else
  return XInternAtom (arg0, arg1, arg2);
  {
    Atom res;
    res = XInternAtom (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XInternAtom */

#ifdef HAVE_XInternAtoms
/* From `/usr/include/X11/Xlib.h:1526'.  */
int chkr_stub_XInternAtoms (Display * arg0, char ** arg1, int arg2, int arg3, Atom * arg4) __asm__ (CHKR_PREFIX ("XInternAtoms"));
int
chkr_stub_XInternAtoms (Display * arg0, char ** arg1, int arg2, int arg3, Atom * arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char *), CHKR_XX, "arg1");
  stubs_chkr_check_addr (arg4, sizeof (Atom), CHKR_XX, "arg4");
#if USE_BI_JUMP
  __builtin_jump (XInternAtoms);
#else
  return XInternAtoms (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = XInternAtoms (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XInternAtoms */

#ifdef HAVE_XCopyColormapAndFree
/* From `/usr/include/X11/Xlib.h:1532'.  */
Colormap chkr_stub_XCopyColormapAndFree (Display * arg0, Colormap arg1) __asm__ (CHKR_PREFIX ("XCopyColormapAndFree"));
Colormap
chkr_stub_XCopyColormapAndFree (Display * arg0, Colormap arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XCopyColormapAndFree);
#else
  return XCopyColormapAndFree (arg0, arg1);
  {
    Colormap res;
    res = XCopyColormapAndFree (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCopyColormapAndFree */

#ifdef HAVE_XCreateColormap
/* From `/usr/include/X11/Xlib.h:1540'.  */
Colormap chkr_stub_XCreateColormap (Display * arg0, Window arg1, Visual * arg2, int arg3) __asm__ (CHKR_PREFIX ("XCreateColormap"));
Colormap
chkr_stub_XCreateColormap (Display * arg0, Window arg1, Visual * arg2, int arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (Visual), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XCreateColormap);
#else
  return XCreateColormap (arg0, arg1, arg2, arg3);
  {
    Colormap res;
    res = XCreateColormap (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCreateColormap */

#ifdef HAVE_XCreatePixmapCursor
/* From `/usr/include/X11/Xlib.h:1551'.  */
Cursor chkr_stub_XCreatePixmapCursor (Display * arg0, Pixmap arg1, Pixmap arg2, XColor * arg3, XColor * arg4, unsigned int arg5, unsigned int arg6) __asm__ (CHKR_PREFIX ("XCreatePixmapCursor"));
Cursor
chkr_stub_XCreatePixmapCursor (Display * arg0, Pixmap arg1, Pixmap arg2, XColor * arg3, XColor * arg4, unsigned int arg5, unsigned int arg6)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg3, sizeof (XColor), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg4, sizeof (XColor), CHKR_XX, "arg4");
#if USE_BI_JUMP
  __builtin_jump (XCreatePixmapCursor);
#else
  return XCreatePixmapCursor (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
  {
    Cursor res;
    res = XCreatePixmapCursor (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCreatePixmapCursor */

#ifdef HAVE_XCreateGlyphCursor
/* From `/usr/include/X11/Xlib.h:1562'.  */
Cursor chkr_stub_XCreateGlyphCursor (Display * arg0, Font arg1, Font arg2, unsigned int arg3, unsigned int arg4, XColor * arg5, XColor * arg6) __asm__ (CHKR_PREFIX ("XCreateGlyphCursor"));
Cursor
chkr_stub_XCreateGlyphCursor (Display * arg0, Font arg1, Font arg2, unsigned int arg3, unsigned int arg4, XColor * arg5, XColor * arg6)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg5, sizeof (XColor), CHKR_XX, "arg5");
  stubs_chkr_check_addr (arg6, sizeof (XColor), CHKR_XX, "arg6");
#if USE_BI_JUMP
  __builtin_jump (XCreateGlyphCursor);
#else
  return XCreateGlyphCursor (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
  {
    Cursor res;
    res = XCreateGlyphCursor (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCreateGlyphCursor */

#ifdef HAVE_XCreateFontCursor
/* From `/usr/include/X11/Xlib.h:1568'.  */
Cursor chkr_stub_XCreateFontCursor (Display * arg0, unsigned int arg1) __asm__ (CHKR_PREFIX ("XCreateFontCursor"));
Cursor
chkr_stub_XCreateFontCursor (Display * arg0, unsigned int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XCreateFontCursor);
#else
  return XCreateFontCursor (arg0, arg1);
  {
    Cursor res;
    res = XCreateFontCursor (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCreateFontCursor */

#ifdef HAVE_XLoadFont
/* From `/usr/include/X11/Xlib.h:1574'.  */
Font chkr_stub_XLoadFont (Display *display, const char *font)
     __asm__ (CHKR_PREFIX ("XLoadFont"));
Font
chkr_stub_XLoadFont (Display *display, const char *font)
{
  CHKR_CHECK_DISPLAY (display);
  stubs_chkr_check_str (font, CHKR_RO, "font");
#if USE_BI_JUMP
  __builtin_jump (XLoadFont);
#else
  return XLoadFont (display, font);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XLoadFont */

#ifdef HAVE_XCreateGC
/* From `/usr/include/X11/Xlib.h:1582'.  */
GC chkr_stub_XCreateGC (Display * arg0, Drawable arg1, long unsigned int arg2, XGCValues * arg3) __asm__ (CHKR_PREFIX ("XCreateGC"));
GC
chkr_stub_XCreateGC (Display * arg0, Drawable arg1, long unsigned int arg2, XGCValues * arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg3, sizeof (XGCValues), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XCreateGC);
#else
  return XCreateGC (arg0, arg1, arg2, arg3);
  {
    GC res;
    res = XCreateGC (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCreateGC */

#ifdef HAVE_XGContextFromGC
/* From `/usr/include/X11/Xlib.h:1587'.  */
GContext chkr_stub_XGContextFromGC (GC arg0) __asm__ (CHKR_PREFIX ("XGContextFromGC"));
GContext
chkr_stub_XGContextFromGC (GC arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XGContextFromGC);
#else
  return XGContextFromGC (arg0);
  {
    GContext res;
    res = XGContextFromGC (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGContextFromGC */

#ifdef HAVE_XFlushGC
/* From `/usr/include/X11/Xlib.h:1593'.  */
void chkr_stub_XFlushGC (Display * arg0, GC arg1) __asm__ (CHKR_PREFIX ("XFlushGC"));
void
chkr_stub_XFlushGC (Display * arg0, GC arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XFlushGC);
#else
  XFlushGC (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFlushGC */

#ifdef HAVE_XCreatePixmap
/* From `/usr/include/X11/Xlib.h:1602'.  */
Pixmap chkr_stub_XCreatePixmap (Display * arg0, Drawable arg1, unsigned int arg2, unsigned int arg3, unsigned int arg4) __asm__ (CHKR_PREFIX ("XCreatePixmap"));
Pixmap
chkr_stub_XCreatePixmap (Display * arg0, Drawable arg1, unsigned int arg2, unsigned int arg3, unsigned int arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XCreatePixmap);
#else
  return XCreatePixmap (arg0, arg1, arg2, arg3, arg4);
  {
    Pixmap res;
    res = XCreatePixmap (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCreatePixmap */

#ifdef HAVE_XCreateBitmapFromData
/* From `/usr/include/X11/Xlib.h:1611'.  */
Pixmap chkr_stub_XCreateBitmapFromData (Display * arg0, Drawable arg1, const char * arg2, unsigned int arg3, unsigned int arg4) __asm__ (CHKR_PREFIX ("XCreateBitmapFromData"));
Pixmap
chkr_stub_XCreateBitmapFromData (Display * arg0, Drawable arg1, const char * arg2, unsigned int arg3, unsigned int arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (char), CHKR_RO, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XCreateBitmapFromData);
#else
  return XCreateBitmapFromData (arg0, arg1, arg2, arg3, arg4);
  {
    Pixmap res;
    res = XCreateBitmapFromData (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCreateBitmapFromData */

#ifdef HAVE_XCreatePixmapFromBitmapData
/* From `/usr/include/X11/Xlib.h:1623'.  */
Pixmap chkr_stub_XCreatePixmapFromBitmapData (Display * arg0, Drawable arg1, char * arg2, unsigned int arg3, unsigned int arg4, long unsigned int arg5, long unsigned int arg6, unsigned int arg7) __asm__ (CHKR_PREFIX ("XCreatePixmapFromBitmapData"));
Pixmap
chkr_stub_XCreatePixmapFromBitmapData (Display * arg0, Drawable arg1, char * arg2, unsigned int arg3, unsigned int arg4, long unsigned int arg5, long unsigned int arg6, unsigned int arg7)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (char), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XCreatePixmapFromBitmapData);
#else
  return XCreatePixmapFromBitmapData (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
  {
    Pixmap res;
    res = XCreatePixmapFromBitmapData (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCreatePixmapFromBitmapData */

#ifdef HAVE_XCreateSimpleWindow
/* From `/usr/include/X11/Xlib.h:1636'.  */
Window chkr_stub_XCreateSimpleWindow (Display * arg0, Window arg1, int arg2, int arg3, unsigned int arg4, unsigned int arg5, unsigned int arg6, long unsigned int arg7, long unsigned int arg8) __asm__ (CHKR_PREFIX ("XCreateSimpleWindow"));
Window
chkr_stub_XCreateSimpleWindow (Display * arg0, Window arg1, int arg2, int arg3, unsigned int arg4, unsigned int arg5, unsigned int arg6, long unsigned int arg7, long unsigned int arg8)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XCreateSimpleWindow);
#else
  return XCreateSimpleWindow (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
  {
    Window res;
    res = XCreateSimpleWindow (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCreateSimpleWindow */

#ifdef HAVE_XGetSelectionOwner
/* From `/usr/include/X11/Xlib.h:1642'.  */
Window chkr_stub_XGetSelectionOwner (Display * arg0, Atom arg1) __asm__ (CHKR_PREFIX ("XGetSelectionOwner"));
Window
chkr_stub_XGetSelectionOwner (Display * arg0, Atom arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XGetSelectionOwner);
#else
  return XGetSelectionOwner (arg0, arg1);
  {
    Window res;
    res = XGetSelectionOwner (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetSelectionOwner */

#ifdef HAVE_XCreateWindow
/* From `/usr/include/X11/Xlib.h:1658'.  */
Window chkr_stub_XCreateWindow (Display * arg0, Window arg1, int arg2, int arg3, unsigned int arg4, unsigned int arg5, unsigned int arg6, int arg7, unsigned int arg8, Visual * arg9, long unsigned int arg10, XSetWindowAttributes * arg11) __asm__ (CHKR_PREFIX ("XCreateWindow"));
Window
chkr_stub_XCreateWindow (Display * arg0, Window arg1, int arg2, int arg3, unsigned int arg4, unsigned int arg5, unsigned int arg6, int arg7, unsigned int arg8, Visual * arg9, long unsigned int arg10, XSetWindowAttributes * arg11)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg9, sizeof (Visual), CHKR_XX, "arg9");
  stubs_chkr_check_addr (arg11, sizeof (XSetWindowAttributes), CHKR_XX, "arg11");
#if USE_BI_JUMP
  __builtin_jump (XCreateWindow);
#else
  return XCreateWindow (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
  {
    Window res;
    res = XCreateWindow (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCreateWindow */

#ifdef HAVE_XListInstalledColormaps
/* From `/usr/include/X11/Xlib.h:1665'.  */
Colormap * chkr_stub_XListInstalledColormaps (Display * arg0, Window arg1, int * arg2) __asm__ (CHKR_PREFIX ("XListInstalledColormaps"));
Colormap *
chkr_stub_XListInstalledColormaps (Display * arg0, Window arg1, int * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (int), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XListInstalledColormaps);
#else
  return XListInstalledColormaps (arg0, arg1, arg2);
  {
    Colormap * res;
    res = XListInstalledColormaps (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XListInstalledColormaps */

#ifdef HAVE_XListFonts
/* From `/usr/include/X11/Xlib.h:1673'.  */
char ** chkr_stub_XListFonts (Display * arg0, const char * arg1, int arg2, int * arg3) __asm__ (CHKR_PREFIX ("XListFonts"));
char **
chkr_stub_XListFonts (Display * arg0, const char * arg1, int arg2, int * arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
  stubs_chkr_check_addr (arg3, sizeof (int), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XListFonts);
#else
  return XListFonts (arg0, arg1, arg2, arg3);
  {
    char ** res;
    res = XListFonts (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XListFonts */

#ifdef HAVE_XListFontsWithInfo
/* From `/usr/include/X11/Xlib.h:1682'.  */
char ** chkr_stub_XListFontsWithInfo (Display * arg0, const char * arg1, int arg2, int * arg3, XFontStruct ** arg4) __asm__ (CHKR_PREFIX ("XListFontsWithInfo"));
char **
chkr_stub_XListFontsWithInfo (Display * arg0, const char * arg1, int arg2, int * arg3, XFontStruct ** arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
  stubs_chkr_check_addr (arg3, sizeof (int), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg4, sizeof (XFontStruct *), CHKR_XX, "arg4");
#if USE_BI_JUMP
  __builtin_jump (XListFontsWithInfo);
#else
  return XListFontsWithInfo (arg0, arg1, arg2, arg3, arg4);
  {
    char ** res;
    res = XListFontsWithInfo (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XListFontsWithInfo */

#ifdef HAVE_XGetFontPath
/* From `/usr/include/X11/Xlib.h:1688'.  */
char ** chkr_stub_XGetFontPath (Display * arg0, int * arg1) __asm__ (CHKR_PREFIX ("XGetFontPath"));
char **
chkr_stub_XGetFontPath (Display * arg0, int * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (int), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XGetFontPath);
#else
  return XGetFontPath (arg0, arg1);
  {
    char ** res;
    res = XGetFontPath (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetFontPath */

#ifdef HAVE_XListExtensions
/* From `/usr/include/X11/Xlib.h:1694'.  */
char ** chkr_stub_XListExtensions (Display * arg0, int * arg1) __asm__ (CHKR_PREFIX ("XListExtensions"));
char **
chkr_stub_XListExtensions (Display * arg0, int * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (int), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XListExtensions);
#else
  return XListExtensions (arg0, arg1);
  {
    char ** res;
    res = XListExtensions (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XListExtensions */

#ifdef HAVE_XListProperties
/* From `/usr/include/X11/Xlib.h:1701'.  */
Atom * chkr_stub_XListProperties (Display * arg0, Window arg1, int * arg2) __asm__ (CHKR_PREFIX ("XListProperties"));
Atom *
chkr_stub_XListProperties (Display * arg0, Window arg1, int * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (int), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XListProperties);
#else
  return XListProperties (arg0, arg1, arg2);
  {
    Atom * res;
    res = XListProperties (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XListProperties */

#ifdef HAVE_XListHosts
/* From `/usr/include/X11/Xlib.h:1708'.  */
XHostAddress * chkr_stub_XListHosts (Display * arg0, int * arg1, int * arg2) __asm__ (CHKR_PREFIX ("XListHosts"));
XHostAddress *
chkr_stub_XListHosts (Display * arg0, int * arg1, int * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (int), CHKR_XX, "arg1");
  stubs_chkr_check_addr (arg2, sizeof (int), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XListHosts);
#else
  return XListHosts (arg0, arg1, arg2);
  {
    XHostAddress * res;
    res = XListHosts (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XListHosts */

#ifdef HAVE_XKeycodeToKeysym
/* From `/usr/include/X11/Xlib.h:1719'.  */
KeySym chkr_stub_XKeycodeToKeysym (Display * arg0, unsigned int arg1, int arg2) __asm__ (CHKR_PREFIX ("XKeycodeToKeysym"));
KeySym
chkr_stub_XKeycodeToKeysym (Display * arg0, unsigned int arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XKeycodeToKeysym);
#else
  return XKeycodeToKeysym (arg0, arg1, arg2);
  {
    KeySym res;
    res = XKeycodeToKeysym (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XKeycodeToKeysym */

#ifdef HAVE_XLookupKeysym
/* From `/usr/include/X11/Xlib.h:1725'.  */
KeySym chkr_stub_XLookupKeysym (XKeyEvent * arg0, int arg1) __asm__ (CHKR_PREFIX ("XLookupKeysym"));
KeySym
chkr_stub_XLookupKeysym (XKeyEvent * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (XKeyEvent), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XLookupKeysym);
#else
  return XLookupKeysym (arg0, arg1);
  {
    KeySym res;
    res = XLookupKeysym (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XLookupKeysym */

#ifdef HAVE_XGetKeyboardMapping
/* From `/usr/include/X11/Xlib.h:1737'.  */
KeySym * chkr_stub_XGetKeyboardMapping (Display * arg0, unsigned int arg1, int arg2, int * arg3) __asm__ (CHKR_PREFIX ("XGetKeyboardMapping"));
KeySym *
chkr_stub_XGetKeyboardMapping (Display * arg0, unsigned int arg1, int arg2, int * arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg3, sizeof (int), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XGetKeyboardMapping);
#else
  return XGetKeyboardMapping (arg0, arg1, arg2, arg3);
  {
    KeySym * res;
    res = XGetKeyboardMapping (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetKeyboardMapping */

#ifdef HAVE_XStringToKeysym
/* From `/usr/include/X11/Xlib.h:1742'.  */
KeySym chkr_stub_XStringToKeysym (const char * arg0) __asm__ (CHKR_PREFIX ("XStringToKeysym"));
KeySym
chkr_stub_XStringToKeysym (const char * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (char), CHKR_RO, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XStringToKeysym);
#else
  return XStringToKeysym (arg0);
  {
    KeySym res;
    res = XStringToKeysym (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XStringToKeysym */

#ifdef HAVE_XMaxRequestSize
/* From `/usr/include/X11/Xlib.h:1747'.  */
long int chkr_stub_XMaxRequestSize (Display * arg0) __asm__ (CHKR_PREFIX ("XMaxRequestSize"));
long int
chkr_stub_XMaxRequestSize (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XMaxRequestSize);
#else
  return XMaxRequestSize (arg0);
  {
    long int res;
    res = XMaxRequestSize (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XMaxRequestSize */

#ifdef HAVE_XExtendedMaxRequestSize
/* From `/usr/include/X11/Xlib.h:1752'.  */
long int chkr_stub_XExtendedMaxRequestSize (Display * arg0) __asm__ (CHKR_PREFIX ("XExtendedMaxRequestSize"));
long int
chkr_stub_XExtendedMaxRequestSize (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XExtendedMaxRequestSize);
#else
  return XExtendedMaxRequestSize (arg0);
  {
    long int res;
    res = XExtendedMaxRequestSize (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XExtendedMaxRequestSize */

#ifdef HAVE_XResourceManagerString
/* From `/usr/include/X11/Xlib.h:1757'.  */
char * chkr_stub_XResourceManagerString (Display * arg0) __asm__ (CHKR_PREFIX ("XResourceManagerString"));
char *
chkr_stub_XResourceManagerString (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XResourceManagerString);
#else
  return XResourceManagerString (arg0);
  {
    char * res;
    res = XResourceManagerString (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XResourceManagerString */

#ifdef HAVE_XScreenResourceString
/* From `/usr/include/X11/Xlib.h:1762'.  */
char * chkr_stub_XScreenResourceString (Screen * arg0) __asm__ (CHKR_PREFIX ("XScreenResourceString"));
char *
chkr_stub_XScreenResourceString (Screen * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Screen), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XScreenResourceString);
#else
  return XScreenResourceString (arg0);
  {
    char * res;
    res = XScreenResourceString (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XScreenResourceString */

#ifdef HAVE_XDisplayMotionBufferSize
/* From `/usr/include/X11/Xlib.h:1767'.  */
long unsigned int chkr_stub_XDisplayMotionBufferSize (Display * arg0) __asm__ (CHKR_PREFIX ("XDisplayMotionBufferSize"));
long unsigned int
chkr_stub_XDisplayMotionBufferSize (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDisplayMotionBufferSize);
#else
  return XDisplayMotionBufferSize (arg0);
  {
    long unsigned int res;
    res = XDisplayMotionBufferSize (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDisplayMotionBufferSize */

#ifdef HAVE_XVisualIDFromVisual
/* From `/usr/include/X11/Xlib.h:1772'.  */
VisualID chkr_stub_XVisualIDFromVisual (Visual * arg0) __asm__ (CHKR_PREFIX ("XVisualIDFromVisual"));
VisualID
chkr_stub_XVisualIDFromVisual (Visual * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Visual), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XVisualIDFromVisual);
#else
  return XVisualIDFromVisual (arg0);
  {
    VisualID res;
    res = XVisualIDFromVisual (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XVisualIDFromVisual */

#ifdef HAVE_XInitThreads
/* From `/usr/include/X11/Xlib.h:1780'.  */
int chkr_stub_XInitThreads (void ) __asm__ (CHKR_PREFIX ("XInitThreads"));
int
chkr_stub_XInitThreads (void )
{
#if USE_BI_JUMP
  __builtin_jump (XInitThreads);
#else
  return XInitThreads ();
  {
    int res;
    res = XInitThreads ();
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XInitThreads */

#ifdef HAVE_XLockDisplay
/* From `/usr/include/X11/Xlib.h:1786'.  */
void chkr_stub_XLockDisplay (Display * arg0) __asm__ (CHKR_PREFIX ("XLockDisplay"));
void
chkr_stub_XLockDisplay (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XLockDisplay);
#else
  XLockDisplay (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XLockDisplay */

#ifdef HAVE_XUnlockDisplay
/* From `/usr/include/X11/Xlib.h:1792'.  */
void chkr_stub_XUnlockDisplay (Display * arg0) __asm__ (CHKR_PREFIX ("XUnlockDisplay"));
void
chkr_stub_XUnlockDisplay (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XUnlockDisplay);
#else
  XUnlockDisplay (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XUnlockDisplay */

#ifdef HAVE_XInitExtension
/* From `/usr/include/X11/Xlib.h:1801'.  */
XExtCodes * chkr_stub_XInitExtension (Display * arg0, const char * arg1) __asm__ (CHKR_PREFIX ("XInitExtension"));
XExtCodes *
chkr_stub_XInitExtension (Display * arg0, const char * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XInitExtension);
#else
  return XInitExtension (arg0, arg1);
  {
    XExtCodes * res;
    res = XInitExtension (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XInitExtension */

#ifdef HAVE_XAddExtension
/* From `/usr/include/X11/Xlib.h:1807'.  */
XExtCodes * chkr_stub_XAddExtension (Display * arg0) __asm__ (CHKR_PREFIX ("XAddExtension"));
XExtCodes *
chkr_stub_XAddExtension (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XAddExtension);
#else
  return XAddExtension (arg0);
  {
    XExtCodes * res;
    res = XAddExtension (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XAddExtension */

#ifdef HAVE_XFindOnExtensionList
/* From `/usr/include/X11/Xlib.h:1813'.  */
XExtData * chkr_stub_XFindOnExtensionList (XExtData ** arg0, int arg1) __asm__ (CHKR_PREFIX ("XFindOnExtensionList"));
XExtData *
chkr_stub_XFindOnExtensionList (XExtData ** arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (XExtData *), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XFindOnExtensionList);
#else
  return XFindOnExtensionList (arg0, arg1);
  {
    XExtData * res;
    res = XFindOnExtensionList (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFindOnExtensionList */

#ifdef HAVE_XEHeadOfExtensionList
/* From `/usr/include/X11/Xlib.h:1818'.  */
XExtData ** chkr_stub_XEHeadOfExtensionList (XEDataObject arg0) __asm__ (CHKR_PREFIX ("XEHeadOfExtensionList"));
XExtData **
chkr_stub_XEHeadOfExtensionList (XEDataObject arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XEHeadOfExtensionList);
#else
  return XEHeadOfExtensionList (arg0);
  {
    XExtData ** res;
    res = XEHeadOfExtensionList (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XEHeadOfExtensionList */

#ifdef HAVE_XRootWindow
/* From `/usr/include/X11/Xlib.h:1826'.  */
Window chkr_stub_XRootWindow (Display * arg0, int arg1) __asm__ (CHKR_PREFIX ("XRootWindow"));
Window
chkr_stub_XRootWindow (Display * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XRootWindow);
#else
  return XRootWindow (arg0, arg1);
  {
    Window res;
    res = XRootWindow (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XRootWindow */

#ifdef HAVE_XDefaultRootWindow
/* From `/usr/include/X11/Xlib.h:1831'.  */
Window chkr_stub_XDefaultRootWindow (Display * arg0) __asm__ (CHKR_PREFIX ("XDefaultRootWindow"));
Window
chkr_stub_XDefaultRootWindow (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDefaultRootWindow);
#else
  return XDefaultRootWindow (arg0);
  {
    Window res;
    res = XDefaultRootWindow (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDefaultRootWindow */

#ifdef HAVE_XRootWindowOfScreen
/* From `/usr/include/X11/Xlib.h:1836'.  */
Window chkr_stub_XRootWindowOfScreen (Screen * arg0) __asm__ (CHKR_PREFIX ("XRootWindowOfScreen"));
Window
chkr_stub_XRootWindowOfScreen (Screen * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Screen), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XRootWindowOfScreen);
#else
  return XRootWindowOfScreen (arg0);
  {
    Window res;
    res = XRootWindowOfScreen (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XRootWindowOfScreen */

#ifdef HAVE_XDefaultVisual
/* From `/usr/include/X11/Xlib.h:1842'.  */
Visual * chkr_stub_XDefaultVisual (Display * arg0, int arg1) __asm__ (CHKR_PREFIX ("XDefaultVisual"));
Visual *
chkr_stub_XDefaultVisual (Display * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDefaultVisual);
#else
  return XDefaultVisual (arg0, arg1);
  {
    Visual * res;
    res = XDefaultVisual (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDefaultVisual */

#ifdef HAVE_XDefaultVisualOfScreen
/* From `/usr/include/X11/Xlib.h:1847'.  */
Visual * chkr_stub_XDefaultVisualOfScreen (Screen * arg0) __asm__ (CHKR_PREFIX ("XDefaultVisualOfScreen"));
Visual *
chkr_stub_XDefaultVisualOfScreen (Screen * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Screen), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDefaultVisualOfScreen);
#else
  return XDefaultVisualOfScreen (arg0);
  {
    Visual * res;
    res = XDefaultVisualOfScreen (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDefaultVisualOfScreen */

#ifdef HAVE_XDefaultGC
/* From `/usr/include/X11/Xlib.h:1853'.  */
GC chkr_stub_XDefaultGC (Display * arg0, int arg1) __asm__ (CHKR_PREFIX ("XDefaultGC"));
GC
chkr_stub_XDefaultGC (Display * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDefaultGC);
#else
  return XDefaultGC (arg0, arg1);
  {
    GC res;
    res = XDefaultGC (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDefaultGC */

#ifdef HAVE_XDefaultGCOfScreen
/* From `/usr/include/X11/Xlib.h:1858'.  */
GC chkr_stub_XDefaultGCOfScreen (Screen * arg0) __asm__ (CHKR_PREFIX ("XDefaultGCOfScreen"));
GC
chkr_stub_XDefaultGCOfScreen (Screen * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Screen), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDefaultGCOfScreen);
#else
  return XDefaultGCOfScreen (arg0);
  {
    GC res;
    res = XDefaultGCOfScreen (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDefaultGCOfScreen */

#ifdef HAVE_XBlackPixel
/* From `/usr/include/X11/Xlib.h:1864'.  */
long unsigned int chkr_stub_XBlackPixel (Display * arg0, int arg1) __asm__ (CHKR_PREFIX ("XBlackPixel"));
long unsigned int
chkr_stub_XBlackPixel (Display * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XBlackPixel);
#else
  return XBlackPixel (arg0, arg1);
  {
    long unsigned int res;
    res = XBlackPixel (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XBlackPixel */

#ifdef HAVE_XWhitePixel
/* From `/usr/include/X11/Xlib.h:1870'.  */
long unsigned int chkr_stub_XWhitePixel (Display * arg0, int arg1) __asm__ (CHKR_PREFIX ("XWhitePixel"));
long unsigned int
chkr_stub_XWhitePixel (Display * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XWhitePixel);
#else
  return XWhitePixel (arg0, arg1);
  {
    long unsigned int res;
    res = XWhitePixel (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XWhitePixel */

#ifdef HAVE_XAllPlanes
/* From `/usr/include/X11/Xlib.h:1875'.  */
long unsigned int chkr_stub_XAllPlanes (void ) __asm__ (CHKR_PREFIX ("XAllPlanes"));
long unsigned int
chkr_stub_XAllPlanes (void )
{
#if USE_BI_JUMP
  __builtin_jump (XAllPlanes);
#else
  return XAllPlanes ();
  {
    long unsigned int res;
    res = XAllPlanes ();
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XAllPlanes */

#ifdef HAVE_XBlackPixelOfScreen
/* From `/usr/include/X11/Xlib.h:1880'.  */
long unsigned int chkr_stub_XBlackPixelOfScreen (Screen * arg0) __asm__ (CHKR_PREFIX ("XBlackPixelOfScreen"));
long unsigned int
chkr_stub_XBlackPixelOfScreen (Screen * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Screen), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XBlackPixelOfScreen);
#else
  return XBlackPixelOfScreen (arg0);
  {
    long unsigned int res;
    res = XBlackPixelOfScreen (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XBlackPixelOfScreen */

#ifdef HAVE_XWhitePixelOfScreen
/* From `/usr/include/X11/Xlib.h:1885'.  */
long unsigned int chkr_stub_XWhitePixelOfScreen (Screen * arg0) __asm__ (CHKR_PREFIX ("XWhitePixelOfScreen"));
long unsigned int
chkr_stub_XWhitePixelOfScreen (Screen * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Screen), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XWhitePixelOfScreen);
#else
  return XWhitePixelOfScreen (arg0);
  {
    long unsigned int res;
    res = XWhitePixelOfScreen (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XWhitePixelOfScreen */

#ifdef HAVE_XNextRequest
/* From `/usr/include/X11/Xlib.h:1890'.  */
long unsigned int chkr_stub_XNextRequest (Display * arg0) __asm__ (CHKR_PREFIX ("XNextRequest"));
long unsigned int
chkr_stub_XNextRequest (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XNextRequest);
#else
  return XNextRequest (arg0);
  {
    long unsigned int res;
    res = XNextRequest (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XNextRequest */

#ifdef HAVE_XLastKnownRequestProcessed
/* From `/usr/include/X11/Xlib.h:1895'.  */
long unsigned int chkr_stub_XLastKnownRequestProcessed (Display * arg0) __asm__ (CHKR_PREFIX ("XLastKnownRequestProcessed"));
long unsigned int
chkr_stub_XLastKnownRequestProcessed (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XLastKnownRequestProcessed);
#else
  return XLastKnownRequestProcessed (arg0);
  {
    long unsigned int res;
    res = XLastKnownRequestProcessed (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XLastKnownRequestProcessed */

#ifdef HAVE_XServerVendor
/* From `/usr/include/X11/Xlib.h:1900'.  */
char * chkr_stub_XServerVendor (Display * arg0) __asm__ (CHKR_PREFIX ("XServerVendor"));
char *
chkr_stub_XServerVendor (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XServerVendor);
#else
  return XServerVendor (arg0);
  {
    char * res;
    res = XServerVendor (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XServerVendor */

#ifdef HAVE_XDisplayString
/* From `/usr/include/X11/Xlib.h:1905'.  */
char * chkr_stub_XDisplayString (Display * arg0) __asm__ (CHKR_PREFIX ("XDisplayString"));
char *
chkr_stub_XDisplayString (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDisplayString);
#else
  return XDisplayString (arg0);
  {
    char * res;
    res = XDisplayString (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDisplayString */

#ifdef HAVE_XDefaultColormap
/* From `/usr/include/X11/Xlib.h:1911'.  */
Colormap chkr_stub_XDefaultColormap (Display * arg0, int arg1) __asm__ (CHKR_PREFIX ("XDefaultColormap"));
Colormap
chkr_stub_XDefaultColormap (Display * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDefaultColormap);
#else
  return XDefaultColormap (arg0, arg1);
  {
    Colormap res;
    res = XDefaultColormap (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDefaultColormap */

#ifdef HAVE_XDefaultColormapOfScreen
/* From `/usr/include/X11/Xlib.h:1916'.  */
Colormap chkr_stub_XDefaultColormapOfScreen (Screen * arg0) __asm__ (CHKR_PREFIX ("XDefaultColormapOfScreen"));
Colormap
chkr_stub_XDefaultColormapOfScreen (Screen * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Screen), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDefaultColormapOfScreen);
#else
  return XDefaultColormapOfScreen (arg0);
  {
    Colormap res;
    res = XDefaultColormapOfScreen (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDefaultColormapOfScreen */

#ifdef HAVE_XDisplayOfScreen
/* From `/usr/include/X11/Xlib.h:1921'.  */
Display * chkr_stub_XDisplayOfScreen (Screen * arg0) __asm__ (CHKR_PREFIX ("XDisplayOfScreen"));
Display *
chkr_stub_XDisplayOfScreen (Screen * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Screen), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDisplayOfScreen);
#else
  return XDisplayOfScreen (arg0);
  {
    Display * res;
    res = XDisplayOfScreen (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDisplayOfScreen */

#ifdef HAVE_XScreenOfDisplay
/* From `/usr/include/X11/Xlib.h:1927'.  */
Screen * chkr_stub_XScreenOfDisplay (Display * arg0, int arg1) __asm__ (CHKR_PREFIX ("XScreenOfDisplay"));
Screen *
chkr_stub_XScreenOfDisplay (Display * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XScreenOfDisplay);
#else
  return XScreenOfDisplay (arg0, arg1);
  {
    Screen * res;
    res = XScreenOfDisplay (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XScreenOfDisplay */

#ifdef HAVE_XDefaultScreenOfDisplay
/* From `/usr/include/X11/Xlib.h:1932'.  */
Screen * chkr_stub_XDefaultScreenOfDisplay (Display * arg0) __asm__ (CHKR_PREFIX ("XDefaultScreenOfDisplay"));
Screen *
chkr_stub_XDefaultScreenOfDisplay (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDefaultScreenOfDisplay);
#else
  return XDefaultScreenOfDisplay (arg0);
  {
    Screen * res;
    res = XDefaultScreenOfDisplay (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDefaultScreenOfDisplay */

#ifdef HAVE_XEventMaskOfScreen
/* From `/usr/include/X11/Xlib.h:1937'.  */
long int chkr_stub_XEventMaskOfScreen (Screen * arg0) __asm__ (CHKR_PREFIX ("XEventMaskOfScreen"));
long int
chkr_stub_XEventMaskOfScreen (Screen * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Screen), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XEventMaskOfScreen);
#else
  return XEventMaskOfScreen (arg0);
  {
    long int res;
    res = XEventMaskOfScreen (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XEventMaskOfScreen */

#ifdef HAVE_XScreenNumberOfScreen
/* From `/usr/include/X11/Xlib.h:1943'.  */
int chkr_stub_XScreenNumberOfScreen (Screen * arg0) __asm__ (CHKR_PREFIX ("XScreenNumberOfScreen"));
int
chkr_stub_XScreenNumberOfScreen (Screen * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Screen), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XScreenNumberOfScreen);
#else
  return XScreenNumberOfScreen (arg0);
  {
    int res;
    res = XScreenNumberOfScreen (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XScreenNumberOfScreen */

#ifdef HAVE_XSetErrorHandler
static XErrorHandler error_handler;
static int
chkr_error_handler (Display *display, XErrorEvent *error_event)
{
  return (*error_handler)(display, error_event);
}

/* From `/usr/include/X11/Xlib.h:1956'.  */
XErrorHandler chkr_stub_XSetErrorHandler (XErrorHandler handler)
     __asm__ (CHKR_PREFIX ("XSetErrorHandler"));
XErrorHandler
chkr_stub_XSetErrorHandler (XErrorHandler handler)
{
  XErrorHandler res;
  XErrorHandler old;

  old = error_handler;
  error_handler = handler;
  if (handler)
    res = XSetErrorHandler (chkr_error_handler);
  else
    res = XSetErrorHandler (NULL);
  return old;
}
#endif /* HAVE_XSetErrorHandler */

#ifdef HAVE_XSetIOErrorHandler
/* From `/usr/include/X11/Xlib.h:1969'.  */
XIOErrorHandler chkr_stub_XSetIOErrorHandler (XIOErrorHandler arg0) __asm__ (CHKR_PREFIX ("XSetIOErrorHandler"));
XIOErrorHandler
chkr_stub_XSetIOErrorHandler (XIOErrorHandler arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XSetIOErrorHandler);
#else
  return XSetIOErrorHandler (arg0);
  {
    XIOErrorHandler res;
    res = XSetIOErrorHandler (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetIOErrorHandler */

#ifdef HAVE_XListPixmapFormats
/* From `/usr/include/X11/Xlib.h:1977'.  */
XPixmapFormatValues * chkr_stub_XListPixmapFormats (Display * arg0, int * arg1) __asm__ (CHKR_PREFIX ("XListPixmapFormats"));
XPixmapFormatValues *
chkr_stub_XListPixmapFormats (Display * arg0, int * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (int), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XListPixmapFormats);
#else
  return XListPixmapFormats (arg0, arg1);
  {
    XPixmapFormatValues * res;
    res = XListPixmapFormats (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XListPixmapFormats */

#ifdef HAVE_XListDepths
/* From `/usr/include/X11/Xlib.h:1984'.  */
int * chkr_stub_XListDepths (Display * arg0, int arg1, int * arg2) __asm__ (CHKR_PREFIX ("XListDepths"));
int *
chkr_stub_XListDepths (Display * arg0, int arg1, int * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (int), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XListDepths);
#else
  return XListDepths (arg0, arg1, arg2);
  {
    int * res;
    res = XListDepths (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XListDepths */

#ifdef HAVE_XReconfigureWMWindow
/* From `/usr/include/X11/Xlib.h:1996'.  */
int chkr_stub_XReconfigureWMWindow (Display * arg0, Window arg1, int arg2, unsigned int arg3, XWindowChanges * arg4) __asm__ (CHKR_PREFIX ("XReconfigureWMWindow"));
int
chkr_stub_XReconfigureWMWindow (Display * arg0, Window arg1, int arg2, unsigned int arg3, XWindowChanges * arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg4, sizeof (XWindowChanges), CHKR_XX, "arg4");
#if USE_BI_JUMP
  __builtin_jump (XReconfigureWMWindow);
#else
  return XReconfigureWMWindow (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = XReconfigureWMWindow (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XReconfigureWMWindow */

#ifdef HAVE_XGetWMProtocols
/* From `/usr/include/X11/Xlib.h:2005'.  */
int chkr_stub_XGetWMProtocols (Display * arg0, Window arg1, Atom ** arg2, int * arg3) __asm__ (CHKR_PREFIX ("XGetWMProtocols"));
int
chkr_stub_XGetWMProtocols (Display * arg0, Window arg1, Atom ** arg2, int * arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (Atom *), CHKR_XX, "arg2");
  stubs_chkr_check_addr (arg3, sizeof (int), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XGetWMProtocols);
#else
  return XGetWMProtocols (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XGetWMProtocols (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetWMProtocols */

#ifdef HAVE_XSetWMProtocols
/* From `/usr/include/X11/Xlib.h:2013'.  */
int chkr_stub_XSetWMProtocols (Display * arg0, Window arg1, Atom * arg2, int arg3) __asm__ (CHKR_PREFIX ("XSetWMProtocols"));
int
chkr_stub_XSetWMProtocols (Display * arg0, Window arg1, Atom * arg2, int arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (Atom), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XSetWMProtocols);
#else
  return XSetWMProtocols (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XSetWMProtocols (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetWMProtocols */

#ifdef HAVE_XIconifyWindow
/* From `/usr/include/X11/Xlib.h:2020'.  */
int chkr_stub_XIconifyWindow (Display * arg0, Window arg1, int arg2) __asm__ (CHKR_PREFIX ("XIconifyWindow"));
int
chkr_stub_XIconifyWindow (Display * arg0, Window arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XIconifyWindow);
#else
  return XIconifyWindow (arg0, arg1, arg2);
  {
    int res;
    res = XIconifyWindow (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XIconifyWindow */

#ifdef HAVE_XWithdrawWindow
/* From `/usr/include/X11/Xlib.h:2027'.  */
int chkr_stub_XWithdrawWindow (Display * arg0, Window arg1, int arg2) __asm__ (CHKR_PREFIX ("XWithdrawWindow"));
int
chkr_stub_XWithdrawWindow (Display * arg0, Window arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XWithdrawWindow);
#else
  return XWithdrawWindow (arg0, arg1, arg2);
  {
    int res;
    res = XWithdrawWindow (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XWithdrawWindow */

#ifdef HAVE_XGetCommand
/* From `/usr/include/X11/Xlib.h:2035'.  */
int chkr_stub_XGetCommand (Display * arg0, Window arg1, char *** arg2, int * arg3) __asm__ (CHKR_PREFIX ("XGetCommand"));
int
chkr_stub_XGetCommand (Display * arg0, Window arg1, char *** arg2, int * arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (char **), CHKR_XX, "arg2");
  stubs_chkr_check_addr (arg3, sizeof (int), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XGetCommand);
#else
  return XGetCommand (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XGetCommand (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetCommand */

#ifdef HAVE_XGetWMColormapWindows
/* From `/usr/include/X11/Xlib.h:2043'.  */
int chkr_stub_XGetWMColormapWindows (Display * arg0, Window arg1, Window ** arg2, int * arg3) __asm__ (CHKR_PREFIX ("XGetWMColormapWindows"));
int
chkr_stub_XGetWMColormapWindows (Display * arg0, Window arg1, Window ** arg2, int * arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (Window *), CHKR_XX, "arg2");
  stubs_chkr_check_addr (arg3, sizeof (int), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XGetWMColormapWindows);
#else
  return XGetWMColormapWindows (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XGetWMColormapWindows (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetWMColormapWindows */

#ifdef HAVE_XSetWMColormapWindows
/* From `/usr/include/X11/Xlib.h:2051'.  */
int chkr_stub_XSetWMColormapWindows (Display * arg0, Window arg1, Window * arg2, int arg3) __asm__ (CHKR_PREFIX ("XSetWMColormapWindows"));
int
chkr_stub_XSetWMColormapWindows (Display * arg0, Window arg1, Window * arg2, int arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (Window), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XSetWMColormapWindows);
#else
  return XSetWMColormapWindows (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XSetWMColormapWindows (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetWMColormapWindows */

#ifdef HAVE_XFreeStringList
/* From `/usr/include/X11/Xlib.h:2056'.  */
void chkr_stub_XFreeStringList (char ** arg0) __asm__ (CHKR_PREFIX ("XFreeStringList"));
void
chkr_stub_XFreeStringList (char ** arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (char *), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XFreeStringList);
#else
  XFreeStringList (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFreeStringList */

#ifdef HAVE_XSetTransientForHint
/* From `/usr/include/X11/Xlib.h:2063'.  */
int chkr_stub_XSetTransientForHint (Display * arg0, Window arg1, Window arg2) __asm__ (CHKR_PREFIX ("XSetTransientForHint"));
int
chkr_stub_XSetTransientForHint (Display * arg0, Window arg1, Window arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetTransientForHint);
#else
  return XSetTransientForHint (arg0, arg1, arg2);
  {
    int res;
    res = XSetTransientForHint (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetTransientForHint */

#ifdef HAVE_XActivateScreenSaver
/* From `/usr/include/X11/Xlib.h:2071'.  */
int chkr_stub_XActivateScreenSaver (Display * arg0) __asm__ (CHKR_PREFIX ("XActivateScreenSaver"));
int
chkr_stub_XActivateScreenSaver (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XActivateScreenSaver);
#else
  return XActivateScreenSaver (arg0);
  {
    int res;
    res = XActivateScreenSaver (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XActivateScreenSaver */

#ifdef HAVE_XAddHost
/* From `/usr/include/X11/Xlib.h:2078'.  */
int chkr_stub_XAddHost (Display * arg0, XHostAddress * arg1) __asm__ (CHKR_PREFIX ("XAddHost"));
int
chkr_stub_XAddHost (Display * arg0, XHostAddress * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (XHostAddress), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XAddHost);
#else
  return XAddHost (arg0, arg1);
  {
    int res;
    res = XAddHost (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XAddHost */

#ifdef HAVE_XAddHosts
/* From `/usr/include/X11/Xlib.h:2086'.  */
int chkr_stub_XAddHosts (Display * arg0, XHostAddress * arg1, int arg2) __asm__ (CHKR_PREFIX ("XAddHosts"));
int
chkr_stub_XAddHosts (Display * arg0, XHostAddress * arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (XHostAddress), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XAddHosts);
#else
  return XAddHosts (arg0, arg1, arg2);
  {
    int res;
    res = XAddHosts (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XAddHosts */

#ifdef HAVE_XAddToExtensionList
/* From `/usr/include/X11/Xlib.h:2093'.  */
int chkr_stub_XAddToExtensionList (struct _XExtData ** arg0, XExtData * arg1) __asm__ (CHKR_PREFIX ("XAddToExtensionList"));
int
chkr_stub_XAddToExtensionList (struct _XExtData ** arg0, XExtData * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (struct _XExtData *), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (XExtData), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XAddToExtensionList);
#else
  return XAddToExtensionList (arg0, arg1);
  {
    int res;
    res = XAddToExtensionList (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XAddToExtensionList */

#ifdef HAVE_XAddToSaveSet
/* From `/usr/include/X11/Xlib.h:2100'.  */
int chkr_stub_XAddToSaveSet (Display * arg0, Window arg1) __asm__ (CHKR_PREFIX ("XAddToSaveSet"));
int
chkr_stub_XAddToSaveSet (Display * arg0, Window arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XAddToSaveSet);
#else
  return XAddToSaveSet (arg0, arg1);
  {
    int res;
    res = XAddToSaveSet (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XAddToSaveSet */

#ifdef HAVE_XAllocColor
/* From `/usr/include/X11/Xlib.h:2108'.  */
int chkr_stub_XAllocColor (Display * arg0, Colormap arg1, XColor * arg2) __asm__ (CHKR_PREFIX ("XAllocColor"));
int
chkr_stub_XAllocColor (Display * arg0, Colormap arg1, XColor * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (XColor), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XAllocColor);
#else
  return XAllocColor (arg0, arg1, arg2);
  {
    int res;
    res = XAllocColor (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XAllocColor */

#ifdef HAVE_XAllocColorCells
/* From `/usr/include/X11/Xlib.h:2120'.  */
int chkr_stub_XAllocColorCells (Display * arg0, Colormap arg1, int arg2, long unsigned int * arg3, unsigned int arg4, long unsigned int * arg5, unsigned int arg6) __asm__ (CHKR_PREFIX ("XAllocColorCells"));
int
chkr_stub_XAllocColorCells (Display * arg0, Colormap arg1, int arg2, long unsigned int * arg3, unsigned int arg4, long unsigned int * arg5, unsigned int arg6)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg3, sizeof (long unsigned int), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg5, sizeof (long unsigned int), CHKR_XX, "arg5");
#if USE_BI_JUMP
  __builtin_jump (XAllocColorCells);
#else
  return XAllocColorCells (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
  {
    int res;
    res = XAllocColorCells (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XAllocColorCells */

#ifdef HAVE_XAllocColorPlanes
/* From `/usr/include/X11/Xlib.h:2136'.  */
int chkr_stub_XAllocColorPlanes (Display * arg0, Colormap arg1, int arg2, long unsigned int * arg3, int arg4, int arg5, int arg6, int arg7, long unsigned int * arg8, long unsigned int * arg9, long unsigned int * arg10) __asm__ (CHKR_PREFIX ("XAllocColorPlanes"));
int
chkr_stub_XAllocColorPlanes (Display * arg0, Colormap arg1, int arg2, long unsigned int * arg3, int arg4, int arg5, int arg6, int arg7, long unsigned int * arg8, long unsigned int * arg9, long unsigned int * arg10)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg3, sizeof (long unsigned int), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg8, sizeof (long unsigned int), CHKR_XX, "arg8");
  stubs_chkr_check_addr (arg9, sizeof (long unsigned int), CHKR_XX, "arg9");
  stubs_chkr_check_addr (arg10, sizeof (long unsigned int), CHKR_XX, "arg10");
#if USE_BI_JUMP
  __builtin_jump (XAllocColorPlanes);
#else
  return XAllocColorPlanes (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
  {
    int res;
    res = XAllocColorPlanes (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XAllocColorPlanes */

#ifdef HAVE_XAllocNamedColor
/* From `/usr/include/X11/Xlib.h:2146'.  */
int chkr_stub_XAllocNamedColor (Display * arg0, Colormap arg1, const char * arg2, XColor * arg3, XColor * arg4) __asm__ (CHKR_PREFIX ("XAllocNamedColor"));
int
chkr_stub_XAllocNamedColor (Display * arg0, Colormap arg1, const char * arg2, XColor * arg3, XColor * arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (char), CHKR_RO, "arg2");
  stubs_chkr_check_addr (arg3, sizeof (XColor), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg4, sizeof (XColor), CHKR_XX, "arg4");
#if USE_BI_JUMP
  __builtin_jump (XAllocNamedColor);
#else
  return XAllocNamedColor (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = XAllocNamedColor (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XAllocNamedColor */

#ifdef HAVE_XAllowEvents
/* From `/usr/include/X11/Xlib.h:2154'.  */
int chkr_stub_XAllowEvents (Display * arg0, int arg1, Time arg2) __asm__ (CHKR_PREFIX ("XAllowEvents"));
int
chkr_stub_XAllowEvents (Display * arg0, int arg1, Time arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XAllowEvents);
#else
  return XAllowEvents (arg0, arg1, arg2);
  {
    int res;
    res = XAllowEvents (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XAllowEvents */

#ifdef HAVE_XAutoRepeatOff
/* From `/usr/include/X11/Xlib.h:2160'.  */
int chkr_stub_XAutoRepeatOff (Display *display)
     __asm__ (CHKR_PREFIX ("XAutoRepeatOff"));
int
chkr_stub_XAutoRepeatOff (Display *display)
{
  CHKR_CHECK_DISPLAY (display);

#if USE_BI_JUMP
  __builtin_jump (XAutoRepeatOff);
#else
  return XAutoRepeatOff (display);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XAutoRepeatOff */

#ifdef HAVE_XAutoRepeatOn
/* From `/usr/include/X11/Xlib.h:2166'.  */
int chkr_stub_XAutoRepeatOn (Display *display)
     __asm__ (CHKR_PREFIX ("XAutoRepeatOn"));
int
chkr_stub_XAutoRepeatOn (Display *display)
{
  CHKR_CHECK_DISPLAY (display);

#if USE_BI_JUMP
  __builtin_jump (XAutoRepeatOn);
#else
  return XAutoRepeatOn (display);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XAutoRepeatOn */

#ifdef HAVE_XBell
/* From `/usr/include/X11/Xlib.h:2173'.  */
int chkr_stub_XBell (Display *display, int percent)
     __asm__ (CHKR_PREFIX ("XBell"));
int
chkr_stub_XBell (Display *display, int percent)
{
  CHKR_CHECK_DISPLAY (display);

#if USE_BI_JUMP
  __builtin_jump (XBell);
#else
  return XBell (display, percent);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XBell */

#ifdef HAVE_XBitmapBitOrder
/* From `/usr/include/X11/Xlib.h:2179'.  */
int chkr_stub_XBitmapBitOrder (Display * arg0) __asm__ (CHKR_PREFIX ("XBitmapBitOrder"));
int
chkr_stub_XBitmapBitOrder (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XBitmapBitOrder);
#else
  return XBitmapBitOrder (arg0);
  {
    int res;
    res = XBitmapBitOrder (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XBitmapBitOrder */

#ifdef HAVE_XBitmapPad
/* From `/usr/include/X11/Xlib.h:2185'.  */
int chkr_stub_XBitmapPad (Display * arg0) __asm__ (CHKR_PREFIX ("XBitmapPad"));
int
chkr_stub_XBitmapPad (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XBitmapPad);
#else
  return XBitmapPad (arg0);
  {
    int res;
    res = XBitmapPad (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XBitmapPad */

#ifdef HAVE_XBitmapUnit
/* From `/usr/include/X11/Xlib.h:2191'.  */
int chkr_stub_XBitmapUnit (Display * arg0) __asm__ (CHKR_PREFIX ("XBitmapUnit"));
int
chkr_stub_XBitmapUnit (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XBitmapUnit);
#else
  return XBitmapUnit (arg0);
  {
    int res;
    res = XBitmapUnit (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XBitmapUnit */

#ifdef HAVE_XCellsOfScreen
/* From `/usr/include/X11/Xlib.h:2197'.  */
int chkr_stub_XCellsOfScreen (Screen * arg0) __asm__ (CHKR_PREFIX ("XCellsOfScreen"));
int
chkr_stub_XCellsOfScreen (Screen * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Screen), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XCellsOfScreen);
#else
  return XCellsOfScreen (arg0);
  {
    int res;
    res = XCellsOfScreen (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCellsOfScreen */

#ifdef HAVE_XChangeActivePointerGrab
/* From `/usr/include/X11/Xlib.h:2206'.  */
int chkr_stub_XChangeActivePointerGrab (Display * arg0, unsigned int arg1, Cursor arg2, Time arg3) __asm__ (CHKR_PREFIX ("XChangeActivePointerGrab"));
int
chkr_stub_XChangeActivePointerGrab (Display * arg0, unsigned int arg1, Cursor arg2, Time arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XChangeActivePointerGrab);
#else
  return XChangeActivePointerGrab (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XChangeActivePointerGrab (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XChangeActivePointerGrab */

#ifdef HAVE_XChangeGC
/* From `/usr/include/X11/Xlib.h:2215'.  */
int chkr_stub_XChangeGC (Display * arg0, GC arg1, long unsigned int arg2, XGCValues * arg3) __asm__ (CHKR_PREFIX ("XChangeGC"));
int
chkr_stub_XChangeGC (Display * arg0, GC arg1, long unsigned int arg2, XGCValues * arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg3, sizeof (XGCValues), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XChangeGC);
#else
  return XChangeGC (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XChangeGC (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XChangeGC */

#ifdef HAVE_XChangeKeyboardControl
/* From `/usr/include/X11/Xlib.h:2223'.  */
int chkr_stub_XChangeKeyboardControl (Display * arg0, long unsigned int arg1, XKeyboardControl * arg2) __asm__ (CHKR_PREFIX ("XChangeKeyboardControl"));
int
chkr_stub_XChangeKeyboardControl (Display * arg0, long unsigned int arg1, XKeyboardControl * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (XKeyboardControl), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XChangeKeyboardControl);
#else
  return XChangeKeyboardControl (arg0, arg1, arg2);
  {
    int res;
    res = XChangeKeyboardControl (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XChangeKeyboardControl */

#ifdef HAVE_XChangeKeyboardMapping
/* From `/usr/include/X11/Xlib.h:2233'.  */
int chkr_stub_XChangeKeyboardMapping (Display * arg0, int arg1, int arg2, KeySym * arg3, int arg4) __asm__ (CHKR_PREFIX ("XChangeKeyboardMapping"));
int
chkr_stub_XChangeKeyboardMapping (Display * arg0, int arg1, int arg2, KeySym * arg3, int arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg3, sizeof (KeySym), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XChangeKeyboardMapping);
#else
  return XChangeKeyboardMapping (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = XChangeKeyboardMapping (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XChangeKeyboardMapping */

#ifdef HAVE_XChangePointerControl
/* From `/usr/include/X11/Xlib.h:2244'.  */
int chkr_stub_XChangePointerControl (Display * arg0, int arg1, int arg2, int arg3, int arg4, int arg5) __asm__ (CHKR_PREFIX ("XChangePointerControl"));
int
chkr_stub_XChangePointerControl (Display * arg0, int arg1, int arg2, int arg3, int arg4, int arg5)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XChangePointerControl);
#else
  return XChangePointerControl (arg0, arg1, arg2, arg3, arg4, arg5);
  {
    int res;
    res = XChangePointerControl (arg0, arg1, arg2, arg3, arg4, arg5);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XChangePointerControl */

#ifdef HAVE_XChangeProperty
/* From `/usr/include/X11/Xlib.h:2257'.  */
int chkr_stub_XChangeProperty (Display * arg0, Window arg1, Atom arg2, Atom arg3, int arg4, int arg5, const unsigned char * arg6, int arg7) __asm__ (CHKR_PREFIX ("XChangeProperty"));
int
chkr_stub_XChangeProperty (Display * arg0, Window arg1, Atom arg2, Atom arg3, int arg4, int arg5, const unsigned char * arg6, int arg7)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg6, sizeof (unsigned char), CHKR_RO, "arg6");
#if USE_BI_JUMP
  __builtin_jump (XChangeProperty);
#else
  return XChangeProperty (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
  {
    int res;
    res = XChangeProperty (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XChangeProperty */

#ifdef HAVE_XChangeSaveSet
/* From `/usr/include/X11/Xlib.h:2265'.  */
int chkr_stub_XChangeSaveSet (Display * arg0, Window arg1, int arg2) __asm__ (CHKR_PREFIX ("XChangeSaveSet"));
int
chkr_stub_XChangeSaveSet (Display * arg0, Window arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XChangeSaveSet);
#else
  return XChangeSaveSet (arg0, arg1, arg2);
  {
    int res;
    res = XChangeSaveSet (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XChangeSaveSet */

#ifdef HAVE_XChangeWindowAttributes
/* From `/usr/include/X11/Xlib.h:2274'.  */
int chkr_stub_XChangeWindowAttributes (Display * arg0, Window arg1, long unsigned int arg2, XSetWindowAttributes * arg3) __asm__ (CHKR_PREFIX ("XChangeWindowAttributes"));
int
chkr_stub_XChangeWindowAttributes (Display * arg0, Window arg1, long unsigned int arg2, XSetWindowAttributes * arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg3, sizeof (XSetWindowAttributes), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XChangeWindowAttributes);
#else
  return XChangeWindowAttributes (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XChangeWindowAttributes (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XChangeWindowAttributes */

#ifdef HAVE_XCheckIfEvent
/* From `/usr/include/X11/Xlib.h:2289'.  */
int chkr_stub_XCheckIfEvent (Display * arg0, XEvent * arg1, int (*) (Display *, XEvent *, XPointer) arg2, XPointer arg3) __asm__ (CHKR_PREFIX ("XCheckIfEvent"));
int
chkr_stub_XCheckIfEvent (Display * arg0, XEvent * arg1, int (*) (Display *, XEvent *, XPointer) arg2, XPointer arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (XEvent), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XCheckIfEvent);
#else
  return XCheckIfEvent (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XCheckIfEvent (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCheckIfEvent */

#ifdef HAVE_XCheckMaskEvent
/* From `/usr/include/X11/Xlib.h:2297'.  */
int chkr_stub_XCheckMaskEvent (Display * arg0, long int arg1, XEvent * arg2) __asm__ (CHKR_PREFIX ("XCheckMaskEvent"));
int
chkr_stub_XCheckMaskEvent (Display * arg0, long int arg1, XEvent * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (XEvent), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XCheckMaskEvent);
#else
  return XCheckMaskEvent (arg0, arg1, arg2);
  {
    int res;
    res = XCheckMaskEvent (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCheckMaskEvent */

#ifdef HAVE_XCheckTypedEvent
/* From `/usr/include/X11/Xlib.h:2305'.  */
int chkr_stub_XCheckTypedEvent (Display * arg0, int arg1, XEvent * arg2) __asm__ (CHKR_PREFIX ("XCheckTypedEvent"));
int
chkr_stub_XCheckTypedEvent (Display * arg0, int arg1, XEvent * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (XEvent), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XCheckTypedEvent);
#else
  return XCheckTypedEvent (arg0, arg1, arg2);
  {
    int res;
    res = XCheckTypedEvent (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCheckTypedEvent */

#ifdef HAVE_XCheckTypedWindowEvent
/* From `/usr/include/X11/Xlib.h:2314'.  */
int chkr_stub_XCheckTypedWindowEvent (Display * arg0, Window arg1, int arg2, XEvent * arg3) __asm__ (CHKR_PREFIX ("XCheckTypedWindowEvent"));
int
chkr_stub_XCheckTypedWindowEvent (Display * arg0, Window arg1, int arg2, XEvent * arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg3, sizeof (XEvent), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XCheckTypedWindowEvent);
#else
  return XCheckTypedWindowEvent (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XCheckTypedWindowEvent (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCheckTypedWindowEvent */

#ifdef HAVE_XCheckWindowEvent
/* From `/usr/include/X11/Xlib.h:2323'.  */
int chkr_stub_XCheckWindowEvent (Display * arg0, Window arg1, long int arg2, XEvent * arg3) __asm__ (CHKR_PREFIX ("XCheckWindowEvent"));
int
chkr_stub_XCheckWindowEvent (Display * arg0, Window arg1, long int arg2, XEvent * arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg3, sizeof (XEvent), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XCheckWindowEvent);
#else
  return XCheckWindowEvent (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XCheckWindowEvent (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCheckWindowEvent */

#ifdef HAVE_XCirculateSubwindows
/* From `/usr/include/X11/Xlib.h:2331'.  */
int chkr_stub_XCirculateSubwindows (Display * arg0, Window arg1, int arg2) __asm__ (CHKR_PREFIX ("XCirculateSubwindows"));
int
chkr_stub_XCirculateSubwindows (Display * arg0, Window arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XCirculateSubwindows);
#else
  return XCirculateSubwindows (arg0, arg1, arg2);
  {
    int res;
    res = XCirculateSubwindows (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCirculateSubwindows */

#ifdef HAVE_XCirculateSubwindowsDown
/* From `/usr/include/X11/Xlib.h:2338'.  */
int chkr_stub_XCirculateSubwindowsDown (Display * arg0, Window arg1) __asm__ (CHKR_PREFIX ("XCirculateSubwindowsDown"));
int
chkr_stub_XCirculateSubwindowsDown (Display * arg0, Window arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XCirculateSubwindowsDown);
#else
  return XCirculateSubwindowsDown (arg0, arg1);
  {
    int res;
    res = XCirculateSubwindowsDown (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCirculateSubwindowsDown */

#ifdef HAVE_XCirculateSubwindowsUp
/* From `/usr/include/X11/Xlib.h:2345'.  */
int chkr_stub_XCirculateSubwindowsUp (Display * arg0, Window arg1) __asm__ (CHKR_PREFIX ("XCirculateSubwindowsUp"));
int
chkr_stub_XCirculateSubwindowsUp (Display * arg0, Window arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XCirculateSubwindowsUp);
#else
  return XCirculateSubwindowsUp (arg0, arg1);
  {
    int res;
    res = XCirculateSubwindowsUp (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCirculateSubwindowsUp */

#ifdef HAVE_XClearArea
/* From `/usr/include/X11/Xlib.h:2357'.  */
int chkr_stub_XClearArea (Display * arg0, Window arg1, int arg2, int arg3, unsigned int arg4, unsigned int arg5, int arg6) __asm__ (CHKR_PREFIX ("XClearArea"));
int
chkr_stub_XClearArea (Display * arg0, Window arg1, int arg2, int arg3, unsigned int arg4, unsigned int arg5, int arg6)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XClearArea);
#else
  return XClearArea (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
  {
    int res;
    res = XClearArea (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XClearArea */

#ifdef HAVE_XClearWindow
/* From `/usr/include/X11/Xlib.h:2364'.  */
int chkr_stub_XClearWindow (Display * arg0, Window arg1) __asm__ (CHKR_PREFIX ("XClearWindow"));
int
chkr_stub_XClearWindow (Display * arg0, Window arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XClearWindow);
#else
  return XClearWindow (arg0, arg1);
  {
    int res;
    res = XClearWindow (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XClearWindow */

#ifdef HAVE_XCloseDisplay
/* From `/usr/include/X11/Xlib.h:2370'.  */
int chkr_stub_XCloseDisplay (Display * arg0) __asm__ (CHKR_PREFIX ("XCloseDisplay"));
int
chkr_stub_XCloseDisplay (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XCloseDisplay);
#else
  return XCloseDisplay (arg0);
  {
    int res;
    res = XCloseDisplay (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCloseDisplay */

#ifdef HAVE_XConfigureWindow
/* From `/usr/include/X11/Xlib.h:2379'.  */
int chkr_stub_XConfigureWindow (Display * arg0, Window arg1, unsigned int arg2, XWindowChanges * arg3) __asm__ (CHKR_PREFIX ("XConfigureWindow"));
int
chkr_stub_XConfigureWindow (Display * arg0, Window arg1, unsigned int arg2, XWindowChanges * arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg3, sizeof (XWindowChanges), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XConfigureWindow);
#else
  return XConfigureWindow (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XConfigureWindow (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XConfigureWindow */

#ifdef HAVE_XConnectionNumber
/* From `/usr/include/X11/Xlib.h:2385'.  */
int chkr_stub_XConnectionNumber (Display * arg0) __asm__ (CHKR_PREFIX ("XConnectionNumber"));
int
chkr_stub_XConnectionNumber (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XConnectionNumber);
#else
  return XConnectionNumber (arg0);
  {
    int res;
    res = XConnectionNumber (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XConnectionNumber */

#ifdef HAVE_XConvertSelection
/* From `/usr/include/X11/Xlib.h:2396'.  */
int chkr_stub_XConvertSelection (Display * arg0, Atom arg1, Atom arg2, Atom arg3, Window arg4, Time arg5) __asm__ (CHKR_PREFIX ("XConvertSelection"));
int
chkr_stub_XConvertSelection (Display * arg0, Atom arg1, Atom arg2, Atom arg3, Window arg4, Time arg5)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XConvertSelection);
#else
  return XConvertSelection (arg0, arg1, arg2, arg3, arg4, arg5);
  {
    int res;
    res = XConvertSelection (arg0, arg1, arg2, arg3, arg4, arg5);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XConvertSelection */

#ifdef HAVE_XCopyArea
/* From `/usr/include/X11/Xlib.h:2411'.  */
int chkr_stub_XCopyArea (Display * arg0, Drawable arg1, Drawable arg2, GC arg3, int arg4, int arg5, unsigned int arg6, unsigned int arg7, int arg8, int arg9) __asm__ (CHKR_PREFIX ("XCopyArea"));
int
chkr_stub_XCopyArea (Display * arg0, Drawable arg1, Drawable arg2, GC arg3, int arg4, int arg5, unsigned int arg6, unsigned int arg7, int arg8, int arg9)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XCopyArea);
#else
  return XCopyArea (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
  {
    int res;
    res = XCopyArea (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCopyArea */

#ifdef HAVE_XCopyGC
/* From `/usr/include/X11/Xlib.h:2420'.  */
int chkr_stub_XCopyGC (Display *display, GC src,
		       long unsigned int valuemask,
		       GC dest)
     __asm__ (CHKR_PREFIX ("XCopyGC"));
int
chkr_stub_XCopyGC (Display *display, GC src, long unsigned int valuemask,
		   GC dest)
{
  CHKR_CHECK_DISPLAY (display);

#if USE_BI_JUMP
  __builtin_jump (XCopyGC);
#else
  return XCopyGC (display, src, valuemask, dest);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCopyGC */

#ifdef HAVE_XCopyPlane
/* From `/usr/include/X11/Xlib.h:2436'.  */
int chkr_stub_XCopyPlane (Display * arg0, Drawable arg1, Drawable arg2, GC arg3, int arg4, int arg5, unsigned int arg6, unsigned int arg7, int arg8, int arg9, long unsigned int arg10) __asm__ (CHKR_PREFIX ("XCopyPlane"));
int
chkr_stub_XCopyPlane (Display * arg0, Drawable arg1, Drawable arg2, GC arg3, int arg4, int arg5, unsigned int arg6, unsigned int arg7, int arg8, int arg9, long unsigned int arg10)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XCopyPlane);
#else
  return XCopyPlane (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
  {
    int res;
    res = XCopyPlane (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCopyPlane */

#ifdef HAVE_XDefaultDepth
/* From `/usr/include/X11/Xlib.h:2443'.  */
int chkr_stub_XDefaultDepth (Display * arg0, int arg1) __asm__ (CHKR_PREFIX ("XDefaultDepth"));
int
chkr_stub_XDefaultDepth (Display * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDefaultDepth);
#else
  return XDefaultDepth (arg0, arg1);
  {
    int res;
    res = XDefaultDepth (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDefaultDepth */

#ifdef HAVE_XDefaultDepthOfScreen
/* From `/usr/include/X11/Xlib.h:2449'.  */
int chkr_stub_XDefaultDepthOfScreen (Screen * arg0) __asm__ (CHKR_PREFIX ("XDefaultDepthOfScreen"));
int
chkr_stub_XDefaultDepthOfScreen (Screen * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Screen), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDefaultDepthOfScreen);
#else
  return XDefaultDepthOfScreen (arg0);
  {
    int res;
    res = XDefaultDepthOfScreen (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDefaultDepthOfScreen */

#ifdef HAVE_XDefaultScreen
/* From `/usr/include/X11/Xlib.h:2455'.  */
int chkr_stub_XDefaultScreen (Display * arg0) __asm__ (CHKR_PREFIX ("XDefaultScreen"));
int
chkr_stub_XDefaultScreen (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDefaultScreen);
#else
  return XDefaultScreen (arg0);
  {
    int res;
    res = XDefaultScreen (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDefaultScreen */

#ifdef HAVE_XDefineCursor
/* From `/usr/include/X11/Xlib.h:2463'.  */
int chkr_stub_XDefineCursor (Display * arg0, Window arg1, Cursor arg2) __asm__ (CHKR_PREFIX ("XDefineCursor"));
int
chkr_stub_XDefineCursor (Display * arg0, Window arg1, Cursor arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDefineCursor);
#else
  return XDefineCursor (arg0, arg1, arg2);
  {
    int res;
    res = XDefineCursor (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDefineCursor */

#ifdef HAVE_XDeleteProperty
/* From `/usr/include/X11/Xlib.h:2471'.  */
int chkr_stub_XDeleteProperty (Display *display, Window win, Atom atom)
     __asm__ (CHKR_PREFIX ("XDeleteProperty"));
int
chkr_stub_XDeleteProperty (Display *display, Window win, Atom atom)
{
  CHKR_CHECK_DISPLAY (display);

#if USE_BI_JUMP
  __builtin_jump (XDeleteProperty);
#else
  return XDeleteProperty (display, win, atom);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDeleteProperty */

#ifdef HAVE_XDestroyWindow
/* From `/usr/include/X11/Xlib.h:2478'.  */
int chkr_stub_XDestroyWindow (Display *display, Window win)
     __asm__ (CHKR_PREFIX ("XDestroyWindow"));
int
chkr_stub_XDestroyWindow (Display *display, Window win)
{
  CHKR_CHECK_DISPLAY (display);

#if USE_BI_JUMP
  __builtin_jump (XDestroyWindow);
#else
  return XDestroyWindow (display, win);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDestroyWindow */

#ifdef HAVE_XDestroySubwindows
/* From `/usr/include/X11/Xlib.h:2485'.  */
int chkr_stub_XDestroySubwindows (Display *display, Window win)
     __asm__ (CHKR_PREFIX ("XDestroySubwindows"));
int
chkr_stub_XDestroySubwindows (Display *display, Window win)
{
  CHKR_CHECK_DISPLAY (display);
#if USE_BI_JUMP
  __builtin_jump (XDestroySubwindows);
#else
  return XDestroySubwindows (display, win);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDestroySubwindows */

#ifdef HAVE_XDoesBackingStore
/* From `/usr/include/X11/Xlib.h:2491'.  */
int chkr_stub_XDoesBackingStore (Screen * arg0) __asm__ (CHKR_PREFIX ("XDoesBackingStore"));
int
chkr_stub_XDoesBackingStore (Screen * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Screen), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDoesBackingStore);
#else
  return XDoesBackingStore (arg0);
  {
    int res;
    res = XDoesBackingStore (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDoesBackingStore */

#ifdef HAVE_XDoesSaveUnders
/* From `/usr/include/X11/Xlib.h:2497'.  */
int chkr_stub_XDoesSaveUnders (Screen * arg0) __asm__ (CHKR_PREFIX ("XDoesSaveUnders"));
int
chkr_stub_XDoesSaveUnders (Screen * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Screen), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDoesSaveUnders);
#else
  return XDoesSaveUnders (arg0);
  {
    int res;
    res = XDoesSaveUnders (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDoesSaveUnders */

#ifdef HAVE_XDisableAccessControl
/* From `/usr/include/X11/Xlib.h:2503'.  */
int chkr_stub_XDisableAccessControl (Display * arg0) __asm__ (CHKR_PREFIX ("XDisableAccessControl"));
int
chkr_stub_XDisableAccessControl (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDisableAccessControl);
#else
  return XDisableAccessControl (arg0);
  {
    int res;
    res = XDisableAccessControl (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDisableAccessControl */

#ifdef HAVE_XDisplayCells
/* From `/usr/include/X11/Xlib.h:2511'.  */
int chkr_stub_XDisplayCells (Display * arg0, int arg1) __asm__ (CHKR_PREFIX ("XDisplayCells"));
int
chkr_stub_XDisplayCells (Display * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDisplayCells);
#else
  return XDisplayCells (arg0, arg1);
  {
    int res;
    res = XDisplayCells (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDisplayCells */

#ifdef HAVE_XDisplayHeight
/* From `/usr/include/X11/Xlib.h:2518'.  */
int chkr_stub_XDisplayHeight (Display * arg0, int arg1) __asm__ (CHKR_PREFIX ("XDisplayHeight"));
int
chkr_stub_XDisplayHeight (Display * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDisplayHeight);
#else
  return XDisplayHeight (arg0, arg1);
  {
    int res;
    res = XDisplayHeight (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDisplayHeight */

#ifdef HAVE_XDisplayHeightMM
/* From `/usr/include/X11/Xlib.h:2525'.  */
int chkr_stub_XDisplayHeightMM (Display * arg0, int arg1) __asm__ (CHKR_PREFIX ("XDisplayHeightMM"));
int
chkr_stub_XDisplayHeightMM (Display * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDisplayHeightMM);
#else
  return XDisplayHeightMM (arg0, arg1);
  {
    int res;
    res = XDisplayHeightMM (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDisplayHeightMM */

#ifdef HAVE_XDisplayKeycodes
/* From `/usr/include/X11/Xlib.h:2533'.  */
int chkr_stub_XDisplayKeycodes (Display * arg0, int * arg1, int * arg2) __asm__ (CHKR_PREFIX ("XDisplayKeycodes"));
int
chkr_stub_XDisplayKeycodes (Display * arg0, int * arg1, int * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (int), CHKR_XX, "arg1");
  stubs_chkr_check_addr (arg2, sizeof (int), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XDisplayKeycodes);
#else
  return XDisplayKeycodes (arg0, arg1, arg2);
  {
    int res;
    res = XDisplayKeycodes (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDisplayKeycodes */

#ifdef HAVE_XDisplayPlanes
/* From `/usr/include/X11/Xlib.h:2540'.  */
int chkr_stub_XDisplayPlanes (Display * arg0, int arg1) __asm__ (CHKR_PREFIX ("XDisplayPlanes"));
int
chkr_stub_XDisplayPlanes (Display * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDisplayPlanes);
#else
  return XDisplayPlanes (arg0, arg1);
  {
    int res;
    res = XDisplayPlanes (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDisplayPlanes */

#ifdef HAVE_XDisplayWidth
/* From `/usr/include/X11/Xlib.h:2547'.  */
int chkr_stub_XDisplayWidth (Display * arg0, int arg1) __asm__ (CHKR_PREFIX ("XDisplayWidth"));
int
chkr_stub_XDisplayWidth (Display * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDisplayWidth);
#else
  return XDisplayWidth (arg0, arg1);
  {
    int res;
    res = XDisplayWidth (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDisplayWidth */

#ifdef HAVE_XDisplayWidthMM
/* From `/usr/include/X11/Xlib.h:2554'.  */
int chkr_stub_XDisplayWidthMM (Display * arg0, int arg1) __asm__ (CHKR_PREFIX ("XDisplayWidthMM"));
int
chkr_stub_XDisplayWidthMM (Display * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDisplayWidthMM);
#else
  return XDisplayWidthMM (arg0, arg1);
  {
    int res;
    res = XDisplayWidthMM (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDisplayWidthMM */

#ifdef HAVE_XDrawArc
/* From `/usr/include/X11/Xlib.h:2568'.  */
int chkr_stub_XDrawArc (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, unsigned int arg5, unsigned int arg6, int arg7, int arg8) __asm__ (CHKR_PREFIX ("XDrawArc"));
int
chkr_stub_XDrawArc (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, unsigned int arg5, unsigned int arg6, int arg7, int arg8)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDrawArc);
#else
  return XDrawArc (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
  {
    int res;
    res = XDrawArc (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDrawArc */

#ifdef HAVE_XDrawArcs
/* From `/usr/include/X11/Xlib.h:2578'.  */
int chkr_stub_XDrawArcs (Display * arg0, Drawable arg1, GC arg2, XArc * arg3, int arg4) __asm__ (CHKR_PREFIX ("XDrawArcs"));
int
chkr_stub_XDrawArcs (Display * arg0, Drawable arg1, GC arg2, XArc * arg3, int arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg3, sizeof (XArc), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XDrawArcs);
#else
  return XDrawArcs (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = XDrawArcs (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDrawArcs */

#ifdef HAVE_XDrawImageString
/* From `/usr/include/X11/Xlib.h:2590'.  */
int chkr_stub_XDrawImageString (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, const char * arg5, int arg6) __asm__ (CHKR_PREFIX ("XDrawImageString"));
int
chkr_stub_XDrawImageString (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, const char * arg5, int arg6)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg5, sizeof (char), CHKR_RO, "arg5");
#if USE_BI_JUMP
  __builtin_jump (XDrawImageString);
#else
  return XDrawImageString (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
  {
    int res;
    res = XDrawImageString (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDrawImageString */

#ifdef HAVE_XDrawImageString16
/* From `/usr/include/X11/Xlib.h:2602'.  */
int chkr_stub_XDrawImageString16 (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, const XChar2b * arg5, int arg6) __asm__ (CHKR_PREFIX ("XDrawImageString16"));
int
chkr_stub_XDrawImageString16 (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, const XChar2b * arg5, int arg6)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg5, sizeof (XChar2b), CHKR_RO, "arg5");
#if USE_BI_JUMP
  __builtin_jump (XDrawImageString16);
#else
  return XDrawImageString16 (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
  {
    int res;
    res = XDrawImageString16 (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDrawImageString16 */

#ifdef HAVE_XDrawLine
/* From `/usr/include/X11/Xlib.h:2614'.  */
int chkr_stub_XDrawLine (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, int arg5, int arg6) __asm__ (CHKR_PREFIX ("XDrawLine"));
int
chkr_stub_XDrawLine (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, int arg5, int arg6)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDrawLine);
#else
  return XDrawLine (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
  {
    int res;
    res = XDrawLine (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDrawLine */

#ifdef HAVE_XDrawLines
/* From `/usr/include/X11/Xlib.h:2625'.  */
int chkr_stub_XDrawLines (Display * arg0, Drawable arg1, GC arg2, XPoint * arg3, int arg4, int arg5) __asm__ (CHKR_PREFIX ("XDrawLines"));
int
chkr_stub_XDrawLines (Display * arg0, Drawable arg1, GC arg2, XPoint * arg3, int arg4, int arg5)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg3, sizeof (XPoint), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XDrawLines);
#else
  return XDrawLines (arg0, arg1, arg2, arg3, arg4, arg5);
  {
    int res;
    res = XDrawLines (arg0, arg1, arg2, arg3, arg4, arg5);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDrawLines */

#ifdef HAVE_XDrawPoint
/* From `/usr/include/X11/Xlib.h:2635'.  */
int chkr_stub_XDrawPoint (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4) __asm__ (CHKR_PREFIX ("XDrawPoint"));
int
chkr_stub_XDrawPoint (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDrawPoint);
#else
  return XDrawPoint (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = XDrawPoint (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDrawPoint */

#ifdef HAVE_XDrawPoints
/* From `/usr/include/X11/Xlib.h:2646'.  */
int chkr_stub_XDrawPoints (Display * arg0, Drawable arg1, GC arg2, XPoint * arg3, int arg4, int arg5) __asm__ (CHKR_PREFIX ("XDrawPoints"));
int
chkr_stub_XDrawPoints (Display * arg0, Drawable arg1, GC arg2, XPoint * arg3, int arg4, int arg5)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg3, sizeof (XPoint), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XDrawPoints);
#else
  return XDrawPoints (arg0, arg1, arg2, arg3, arg4, arg5);
  {
    int res;
    res = XDrawPoints (arg0, arg1, arg2, arg3, arg4, arg5);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDrawPoints */

#ifdef HAVE_XDrawRectangle
/* From `/usr/include/X11/Xlib.h:2658'.  */
int chkr_stub_XDrawRectangle (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, unsigned int arg5, unsigned int arg6) __asm__ (CHKR_PREFIX ("XDrawRectangle"));
int
chkr_stub_XDrawRectangle (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, unsigned int arg5, unsigned int arg6)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XDrawRectangle);
#else
  return XDrawRectangle (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
  {
    int res;
    res = XDrawRectangle (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDrawRectangle */

#ifdef HAVE_XDrawRectangles
/* From `/usr/include/X11/Xlib.h:2668'.  */
int chkr_stub_XDrawRectangles (Display * arg0, Drawable arg1, GC arg2, XRectangle * arg3, int arg4) __asm__ (CHKR_PREFIX ("XDrawRectangles"));
int
chkr_stub_XDrawRectangles (Display * arg0, Drawable arg1, GC arg2, XRectangle * arg3, int arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg3, sizeof (XRectangle), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XDrawRectangles);
#else
  return XDrawRectangles (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = XDrawRectangles (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDrawRectangles */

#ifdef HAVE_XDrawSegments
/* From `/usr/include/X11/Xlib.h:2678'.  */
int chkr_stub_XDrawSegments (Display * arg0, Drawable arg1, GC arg2, XSegment * arg3, int arg4) __asm__ (CHKR_PREFIX ("XDrawSegments"));
int
chkr_stub_XDrawSegments (Display * arg0, Drawable arg1, GC arg2, XSegment * arg3, int arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg3, sizeof (XSegment), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XDrawSegments);
#else
  return XDrawSegments (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = XDrawSegments (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDrawSegments */

#ifdef HAVE_XDrawString
/* From `/usr/include/X11/Xlib.h:2690'.  */
int chkr_stub_XDrawString (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, const char * arg5, int arg6) __asm__ (CHKR_PREFIX ("XDrawString"));
int
chkr_stub_XDrawString (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, const char * arg5, int arg6)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg5, sizeof (char), CHKR_RO, "arg5");
#if USE_BI_JUMP
  __builtin_jump (XDrawString);
#else
  return XDrawString (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
  {
    int res;
    res = XDrawString (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDrawString */

#ifdef HAVE_XDrawString16
/* From `/usr/include/X11/Xlib.h:2702'.  */
int chkr_stub_XDrawString16 (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, const XChar2b * arg5, int arg6) __asm__ (CHKR_PREFIX ("XDrawString16"));
int
chkr_stub_XDrawString16 (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, const XChar2b * arg5, int arg6)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg5, sizeof (XChar2b), CHKR_RO, "arg5");
#if USE_BI_JUMP
  __builtin_jump (XDrawString16);
#else
  return XDrawString16 (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
  {
    int res;
    res = XDrawString16 (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDrawString16 */

#ifdef HAVE_XDrawText
/* From `/usr/include/X11/Xlib.h:2714'.  */
int chkr_stub_XDrawText (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, XTextItem * arg5, int arg6) __asm__ (CHKR_PREFIX ("XDrawText"));
int
chkr_stub_XDrawText (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, XTextItem * arg5, int arg6)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg5, sizeof (XTextItem), CHKR_XX, "arg5");
#if USE_BI_JUMP
  __builtin_jump (XDrawText);
#else
  return XDrawText (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
  {
    int res;
    res = XDrawText (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDrawText */

#ifdef HAVE_XDrawText16
/* From `/usr/include/X11/Xlib.h:2726'.  */
int chkr_stub_XDrawText16 (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, XTextItem16 * arg5, int arg6) __asm__ (CHKR_PREFIX ("XDrawText16"));
int
chkr_stub_XDrawText16 (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, XTextItem16 * arg5, int arg6)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg5, sizeof (XTextItem16), CHKR_XX, "arg5");
#if USE_BI_JUMP
  __builtin_jump (XDrawText16);
#else
  return XDrawText16 (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
  {
    int res;
    res = XDrawText16 (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDrawText16 */

#ifdef HAVE_XEnableAccessControl
/* From `/usr/include/X11/Xlib.h:2732'.  */
int chkr_stub_XEnableAccessControl (Display * arg0) __asm__ (CHKR_PREFIX ("XEnableAccessControl"));
int
chkr_stub_XEnableAccessControl (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XEnableAccessControl);
#else
  return XEnableAccessControl (arg0);
  {
    int res;
    res = XEnableAccessControl (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XEnableAccessControl */

#ifdef HAVE_XEventsQueued
/* From `/usr/include/X11/Xlib.h:2739'.  */
int chkr_stub_XEventsQueued (Display *display, int mode)
     __asm__ (CHKR_PREFIX ("XEventsQueued"));
int
chkr_stub_XEventsQueued (Display *display, int mode)
{
  CHKR_CHECK_DISPLAY (display);

#if USE_BI_JUMP
  __builtin_jump (XEventsQueued);
#else
  return XEventsQueued (display, mode);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XEventsQueued */

#ifdef HAVE_XFetchName
/* From `/usr/include/X11/Xlib.h:2747'.  */
int chkr_stub_XFetchName (Display * arg0, Window arg1, char ** arg2) __asm__ (CHKR_PREFIX ("XFetchName"));
int
chkr_stub_XFetchName (Display * arg0, Window arg1, char ** arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (char *), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XFetchName);
#else
  return XFetchName (arg0, arg1, arg2);
  {
    int res;
    res = XFetchName (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFetchName */

#ifdef HAVE_XFillArc
/* From `/usr/include/X11/Xlib.h:2761'.  */
int chkr_stub_XFillArc (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, unsigned int arg5, unsigned int arg6, int arg7, int arg8) __asm__ (CHKR_PREFIX ("XFillArc"));
int
chkr_stub_XFillArc (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, unsigned int arg5, unsigned int arg6, int arg7, int arg8)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XFillArc);
#else
  return XFillArc (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
  {
    int res;
    res = XFillArc (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFillArc */

#ifdef HAVE_XFillArcs
/* From `/usr/include/X11/Xlib.h:2771'.  */
int chkr_stub_XFillArcs (Display * arg0, Drawable arg1, GC arg2, XArc * arg3, int arg4) __asm__ (CHKR_PREFIX ("XFillArcs"));
int
chkr_stub_XFillArcs (Display * arg0, Drawable arg1, GC arg2, XArc * arg3, int arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg3, sizeof (XArc), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XFillArcs);
#else
  return XFillArcs (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = XFillArcs (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFillArcs */

#ifdef HAVE_XFillPolygon
/* From `/usr/include/X11/Xlib.h:2783'.  */
int chkr_stub_XFillPolygon (Display * arg0, Drawable arg1, GC arg2, XPoint * arg3, int arg4, int arg5, int arg6) __asm__ (CHKR_PREFIX ("XFillPolygon"));
int
chkr_stub_XFillPolygon (Display * arg0, Drawable arg1, GC arg2, XPoint * arg3, int arg4, int arg5, int arg6)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg3, sizeof (XPoint), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XFillPolygon);
#else
  return XFillPolygon (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
  {
    int res;
    res = XFillPolygon (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFillPolygon */

#ifdef HAVE_XFillRectangle
/* From `/usr/include/X11/Xlib.h:2795'.  */
int chkr_stub_XFillRectangle (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, unsigned int arg5, unsigned int arg6) __asm__ (CHKR_PREFIX ("XFillRectangle"));
int
chkr_stub_XFillRectangle (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, unsigned int arg5, unsigned int arg6)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XFillRectangle);
#else
  return XFillRectangle (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
  {
    int res;
    res = XFillRectangle (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFillRectangle */

#ifdef HAVE_XFillRectangles
/* From `/usr/include/X11/Xlib.h:2805'.  */
int chkr_stub_XFillRectangles (Display * arg0, Drawable arg1, GC arg2, XRectangle * arg3, int arg4) __asm__ (CHKR_PREFIX ("XFillRectangles"));
int
chkr_stub_XFillRectangles (Display * arg0, Drawable arg1, GC arg2, XRectangle * arg3, int arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg3, sizeof (XRectangle), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XFillRectangles);
#else
  return XFillRectangles (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = XFillRectangles (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFillRectangles */

#ifdef HAVE_XFlush
/* From `/usr/include/X11/Xlib.h:2811'.  */
int chkr_stub_XFlush (Display *display) __asm__ (CHKR_PREFIX ("XFlush"));
int
chkr_stub_XFlush (Display *display)
{
  CHKR_CHECK_DISPLAY (display);
#if USE_BI_JUMP
  __builtin_jump (XFlush);
#else
  return XFlush (display);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFlush */

#ifdef HAVE_XForceScreenSaver
/* From `/usr/include/X11/Xlib.h:2818'.  */
int chkr_stub_XForceScreenSaver (Display * arg0, int arg1) __asm__ (CHKR_PREFIX ("XForceScreenSaver"));
int
chkr_stub_XForceScreenSaver (Display * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XForceScreenSaver);
#else
  return XForceScreenSaver (arg0, arg1);
  {
    int res;
    res = XForceScreenSaver (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XForceScreenSaver */

#ifdef HAVE_XFree
/* From `/usr/include/X11/Xlib.h:2824'.  */
int chkr_stub_XFree (void * arg0) __asm__ (CHKR_PREFIX ("XFree"));
int
chkr_stub_XFree (void * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (void), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XFree);
#else
  return XFree (arg0);
  {
    int res;
    res = XFree (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFree */

#ifdef HAVE_XFreeColormap
/* From `/usr/include/X11/Xlib.h:2831'.  */
int chkr_stub_XFreeColormap (Display * arg0, Colormap arg1) __asm__ (CHKR_PREFIX ("XFreeColormap"));
int
chkr_stub_XFreeColormap (Display * arg0, Colormap arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XFreeColormap);
#else
  return XFreeColormap (arg0, arg1);
  {
    int res;
    res = XFreeColormap (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFreeColormap */

#ifdef HAVE_XFreeColors
/* From `/usr/include/X11/Xlib.h:2841'.  */
int chkr_stub_XFreeColors (Display * arg0, Colormap arg1, long unsigned int * arg2, int arg3, long unsigned int arg4) __asm__ (CHKR_PREFIX ("XFreeColors"));
int
chkr_stub_XFreeColors (Display * arg0, Colormap arg1, long unsigned int * arg2, int arg3, long unsigned int arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (long unsigned int), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XFreeColors);
#else
  return XFreeColors (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = XFreeColors (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFreeColors */

#ifdef HAVE_XFreeCursor
/* From `/usr/include/X11/Xlib.h:2848'.  */
int chkr_stub_XFreeCursor (Display * arg0, Cursor arg1) __asm__ (CHKR_PREFIX ("XFreeCursor"));
int
chkr_stub_XFreeCursor (Display * arg0, Cursor arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XFreeCursor);
#else
  return XFreeCursor (arg0, arg1);
  {
    int res;
    res = XFreeCursor (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFreeCursor */

#ifdef HAVE_XFreeExtensionList
/* From `/usr/include/X11/Xlib.h:2854'.  */
int chkr_stub_XFreeExtensionList (char ** arg0) __asm__ (CHKR_PREFIX ("XFreeExtensionList"));
int
chkr_stub_XFreeExtensionList (char ** arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (char *), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XFreeExtensionList);
#else
  return XFreeExtensionList (arg0);
  {
    int res;
    res = XFreeExtensionList (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFreeExtensionList */

#ifdef HAVE_XFreeFont
/* From `/usr/include/X11/Xlib.h:2861'.  */
int chkr_stub_XFreeFont (Display * arg0, XFontStruct * arg1) __asm__ (CHKR_PREFIX ("XFreeFont"));
int
chkr_stub_XFreeFont (Display * arg0, XFontStruct * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (XFontStruct), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XFreeFont);
#else
  return XFreeFont (arg0, arg1);
  {
    int res;
    res = XFreeFont (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFreeFont */

#ifdef HAVE_XFreeFontInfo
/* From `/usr/include/X11/Xlib.h:2869'.  */
int chkr_stub_XFreeFontInfo (char ** arg0, XFontStruct * arg1, int arg2) __asm__ (CHKR_PREFIX ("XFreeFontInfo"));
int
chkr_stub_XFreeFontInfo (char ** arg0, XFontStruct * arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (char *), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (XFontStruct), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XFreeFontInfo);
#else
  return XFreeFontInfo (arg0, arg1, arg2);
  {
    int res;
    res = XFreeFontInfo (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFreeFontInfo */

#ifdef HAVE_XFreeFontNames
/* From `/usr/include/X11/Xlib.h:2875'.  */
int chkr_stub_XFreeFontNames (char ** arg0) __asm__ (CHKR_PREFIX ("XFreeFontNames"));
int
chkr_stub_XFreeFontNames (char ** arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (char *), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XFreeFontNames);
#else
  return XFreeFontNames (arg0);
  {
    int res;
    res = XFreeFontNames (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFreeFontNames */

#ifdef HAVE_XFreeFontPath
/* From `/usr/include/X11/Xlib.h:2881'.  */
int chkr_stub_XFreeFontPath (char ** arg0) __asm__ (CHKR_PREFIX ("XFreeFontPath"));
int
chkr_stub_XFreeFontPath (char ** arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (char *), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XFreeFontPath);
#else
  return XFreeFontPath (arg0);
  {
    int res;
    res = XFreeFontPath (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFreeFontPath */

#ifdef HAVE_XFreeGC
/* From `/usr/include/X11/Xlib.h:2888'.  */
int chkr_stub_XFreeGC (Display *display, GC gc)
     __asm__ (CHKR_PREFIX ("XFreeGC"));
int
chkr_stub_XFreeGC (Display *display, GC gc)
{
  CHKR_CHECK_DISPLAY (display);

#if USE_BI_JUMP
  __builtin_jump (XFreeGC);
#else
  return XFreeGC (display, gc);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFreeGC */

#ifdef HAVE_XFreeModifiermap
/* From `/usr/include/X11/Xlib.h:2894'.  */
int chkr_stub_XFreeModifiermap (XModifierKeymap * arg0) __asm__ (CHKR_PREFIX ("XFreeModifiermap"));
int
chkr_stub_XFreeModifiermap (XModifierKeymap * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (XModifierKeymap), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XFreeModifiermap);
#else
  return XFreeModifiermap (arg0);
  {
    int res;
    res = XFreeModifiermap (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFreeModifiermap */

#ifdef HAVE_XFreePixmap
/* From `/usr/include/X11/Xlib.h:2901'.  */
int chkr_stub_XFreePixmap (Display * arg0, Pixmap arg1) __asm__ (CHKR_PREFIX ("XFreePixmap"));
int
chkr_stub_XFreePixmap (Display * arg0, Pixmap arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XFreePixmap);
#else
  return XFreePixmap (arg0, arg1);
  {
    int res;
    res = XFreePixmap (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFreePixmap */

#ifdef HAVE_XGeometry
/* From `/usr/include/X11/Xlib.h:2919'.  */
int chkr_stub_XGeometry (Display * arg0, int arg1, const char * arg2, const char * arg3, unsigned int arg4, unsigned int arg5, unsigned int arg6, int arg7, int arg8, int * arg9, int * arg10, int * arg11, int * arg12) __asm__ (CHKR_PREFIX ("XGeometry"));
int
chkr_stub_XGeometry (Display * arg0, int arg1, const char * arg2, const char * arg3, unsigned int arg4, unsigned int arg5, unsigned int arg6, int arg7, int arg8, int * arg9, int * arg10, int * arg11, int * arg12)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (char), CHKR_RO, "arg2");
  stubs_chkr_check_addr (arg3, sizeof (char), CHKR_RO, "arg3");
  stubs_chkr_check_addr (arg9, sizeof (int), CHKR_XX, "arg9");
  stubs_chkr_check_addr (arg10, sizeof (int), CHKR_XX, "arg10");
  stubs_chkr_check_addr (arg11, sizeof (int), CHKR_XX, "arg11");
  stubs_chkr_check_addr (arg12, sizeof (int), CHKR_XX, "arg12");
#if USE_BI_JUMP
  __builtin_jump (XGeometry);
#else
  return XGeometry (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
  {
    int res;
    res = XGeometry (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGeometry */

#ifdef HAVE_XGetErrorDatabaseText
/* From `/usr/include/X11/Xlib.h:2930'.  */
int chkr_stub_XGetErrorDatabaseText (Display * arg0, const char * arg1, const char * arg2, const char * arg3, char * arg4, int arg5) __asm__ (CHKR_PREFIX ("XGetErrorDatabaseText"));
int
chkr_stub_XGetErrorDatabaseText (Display * arg0, const char * arg1, const char * arg2, const char * arg3, char * arg4, int arg5)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
  stubs_chkr_check_addr (arg2, sizeof (char), CHKR_RO, "arg2");
  stubs_chkr_check_addr (arg3, sizeof (char), CHKR_RO, "arg3");
  stubs_chkr_check_addr (arg4, sizeof (char), CHKR_XX, "arg4");
#if USE_BI_JUMP
  __builtin_jump (XGetErrorDatabaseText);
#else
  return XGetErrorDatabaseText (arg0, arg1, arg2, arg3, arg4, arg5);
  {
    int res;
    res = XGetErrorDatabaseText (arg0, arg1, arg2, arg3, arg4, arg5);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetErrorDatabaseText */

#ifdef HAVE_XGetErrorText
/* From `/usr/include/X11/Xlib.h:2939'.  */
int chkr_stub_XGetErrorText (Display * arg0, int arg1, char * arg2, int arg3) __asm__ (CHKR_PREFIX ("XGetErrorText"));
int
chkr_stub_XGetErrorText (Display * arg0, int arg1, char * arg2, int arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (char), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XGetErrorText);
#else
  return XGetErrorText (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XGetErrorText (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetErrorText */

#ifdef HAVE_XGetFontProperty
/* From `/usr/include/X11/Xlib.h:2947'.  */
int chkr_stub_XGetFontProperty (XFontStruct * arg0, Atom arg1, long unsigned int * arg2) __asm__ (CHKR_PREFIX ("XGetFontProperty"));
int
chkr_stub_XGetFontProperty (XFontStruct * arg0, Atom arg1, long unsigned int * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (XFontStruct), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (long unsigned int), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XGetFontProperty);
#else
  return XGetFontProperty (arg0, arg1, arg2);
  {
    int res;
    res = XGetFontProperty (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetFontProperty */

#ifdef HAVE_XGetGCValues
/* From `/usr/include/X11/Xlib.h:2956'.  */
int chkr_stub_XGetGCValues (Display * arg0, GC arg1, long unsigned int arg2, XGCValues * arg3) __asm__ (CHKR_PREFIX ("XGetGCValues"));
int
chkr_stub_XGetGCValues (Display * arg0, GC arg1, long unsigned int arg2, XGCValues * arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg3, sizeof (XGCValues), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XGetGCValues);
#else
  return XGetGCValues (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XGetGCValues (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetGCValues */

#ifdef HAVE_XGetGeometry
/* From `/usr/include/X11/Xlib.h:2970'.  */
int chkr_stub_XGetGeometry (Display * arg0, Drawable arg1, Window * arg2, int * arg3, int * arg4, unsigned int * arg5, unsigned int * arg6, unsigned int * arg7, unsigned int * arg8) __asm__ (CHKR_PREFIX ("XGetGeometry"));
int
chkr_stub_XGetGeometry (Display * arg0, Drawable arg1, Window * arg2, int * arg3, int * arg4, unsigned int * arg5, unsigned int * arg6, unsigned int * arg7, unsigned int * arg8)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (Window), CHKR_XX, "arg2");
  stubs_chkr_check_addr (arg3, sizeof (int), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg4, sizeof (int), CHKR_XX, "arg4");
  stubs_chkr_check_addr (arg5, sizeof (unsigned int), CHKR_XX, "arg5");
  stubs_chkr_check_addr (arg6, sizeof (unsigned int), CHKR_XX, "arg6");
  stubs_chkr_check_addr (arg7, sizeof (unsigned int), CHKR_XX, "arg7");
  stubs_chkr_check_addr (arg8, sizeof (unsigned int), CHKR_XX, "arg8");
#if USE_BI_JUMP
  __builtin_jump (XGetGeometry);
#else
  return XGetGeometry (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
  {
    int res;
    res = XGetGeometry (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetGeometry */

#ifdef HAVE_XGetIconName
/* From `/usr/include/X11/Xlib.h:2978'.  */
int chkr_stub_XGetIconName (Display * arg0, Window arg1, char ** arg2) __asm__ (CHKR_PREFIX ("XGetIconName"));
int
chkr_stub_XGetIconName (Display * arg0, Window arg1, char ** arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (char *), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XGetIconName);
#else
  return XGetIconName (arg0, arg1, arg2);
  {
    int res;
    res = XGetIconName (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetIconName */

#ifdef HAVE_XGetInputFocus
/* From `/usr/include/X11/Xlib.h:2986'.  */
int chkr_stub_XGetInputFocus (Display * arg0, Window * arg1, int * arg2) __asm__ (CHKR_PREFIX ("XGetInputFocus"));
int
chkr_stub_XGetInputFocus (Display * arg0, Window * arg1, int * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (Window), CHKR_XX, "arg1");
  stubs_chkr_check_addr (arg2, sizeof (int), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XGetInputFocus);
#else
  return XGetInputFocus (arg0, arg1, arg2);
  {
    int res;
    res = XGetInputFocus (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetInputFocus */

#ifdef HAVE_XGetKeyboardControl
/* From `/usr/include/X11/Xlib.h:2993'.  */
int chkr_stub_XGetKeyboardControl (Display * arg0, XKeyboardState * arg1) __asm__ (CHKR_PREFIX ("XGetKeyboardControl"));
int
chkr_stub_XGetKeyboardControl (Display * arg0, XKeyboardState * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (XKeyboardState), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XGetKeyboardControl);
#else
  return XGetKeyboardControl (arg0, arg1);
  {
    int res;
    res = XGetKeyboardControl (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetKeyboardControl */

#ifdef HAVE_XGetPointerControl
/* From `/usr/include/X11/Xlib.h:3002'.  */
int chkr_stub_XGetPointerControl (Display * arg0, int * arg1, int * arg2, int * arg3) __asm__ (CHKR_PREFIX ("XGetPointerControl"));
int
chkr_stub_XGetPointerControl (Display * arg0, int * arg1, int * arg2, int * arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (int), CHKR_XX, "arg1");
  stubs_chkr_check_addr (arg2, sizeof (int), CHKR_XX, "arg2");
  stubs_chkr_check_addr (arg3, sizeof (int), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XGetPointerControl);
#else
  return XGetPointerControl (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XGetPointerControl (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetPointerControl */

#ifdef HAVE_XGetPointerMapping
/* From `/usr/include/X11/Xlib.h:3010'.  */
int chkr_stub_XGetPointerMapping (Display * arg0, unsigned char * arg1, int arg2) __asm__ (CHKR_PREFIX ("XGetPointerMapping"));
int
chkr_stub_XGetPointerMapping (Display * arg0, unsigned char * arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (unsigned char), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XGetPointerMapping);
#else
  return XGetPointerMapping (arg0, arg1, arg2);
  {
    int res;
    res = XGetPointerMapping (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetPointerMapping */

#ifdef HAVE_XGetScreenSaver
/* From `/usr/include/X11/Xlib.h:3020'.  */
int chkr_stub_XGetScreenSaver (Display * arg0, int * arg1, int * arg2, int * arg3, int * arg4) __asm__ (CHKR_PREFIX ("XGetScreenSaver"));
int
chkr_stub_XGetScreenSaver (Display * arg0, int * arg1, int * arg2, int * arg3, int * arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (int), CHKR_XX, "arg1");
  stubs_chkr_check_addr (arg2, sizeof (int), CHKR_XX, "arg2");
  stubs_chkr_check_addr (arg3, sizeof (int), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg4, sizeof (int), CHKR_XX, "arg4");
#if USE_BI_JUMP
  __builtin_jump (XGetScreenSaver);
#else
  return XGetScreenSaver (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = XGetScreenSaver (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetScreenSaver */

#ifdef HAVE_XGetTransientForHint
/* From `/usr/include/X11/Xlib.h:3028'.  */
int chkr_stub_XGetTransientForHint (Display * arg0, Window arg1, Window * arg2) __asm__ (CHKR_PREFIX ("XGetTransientForHint"));
int
chkr_stub_XGetTransientForHint (Display * arg0, Window arg1, Window * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (Window), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XGetTransientForHint);
#else
  return XGetTransientForHint (arg0, arg1, arg2);
  {
    int res;
    res = XGetTransientForHint (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetTransientForHint */

#ifdef HAVE_XGetWindowProperty
/* From `/usr/include/X11/Xlib.h:3045'.  */
int chkr_stub_XGetWindowProperty (Display * arg0, Window arg1, Atom arg2, long int arg3, long int arg4, int arg5, Atom arg6, Atom * arg7, int * arg8, long unsigned int * arg9, long unsigned int * arg10, unsigned char ** arg11) __asm__ (CHKR_PREFIX ("XGetWindowProperty"));
int
chkr_stub_XGetWindowProperty (Display * arg0, Window arg1, Atom arg2, long int arg3, long int arg4, int arg5, Atom arg6, Atom * arg7, int * arg8, long unsigned int * arg9, long unsigned int * arg10, unsigned char ** arg11)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg7, sizeof (Atom), CHKR_XX, "arg7");
  stubs_chkr_check_addr (arg8, sizeof (int), CHKR_XX, "arg8");
  stubs_chkr_check_addr (arg9, sizeof (long unsigned int), CHKR_XX, "arg9");
  stubs_chkr_check_addr (arg10, sizeof (long unsigned int), CHKR_XX, "arg10");
  stubs_chkr_check_addr (arg11, sizeof (unsigned char *), CHKR_XX, "arg11");
#if USE_BI_JUMP
  __builtin_jump (XGetWindowProperty);
#else
  return XGetWindowProperty (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
  {
    int res;
    res = XGetWindowProperty (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetWindowProperty */

#ifdef HAVE_XGetWindowAttributes
/* From `/usr/include/X11/Xlib.h:3053'.  */
int chkr_stub_XGetWindowAttributes (Display * arg0, Window arg1, XWindowAttributes * arg2) __asm__ (CHKR_PREFIX ("XGetWindowAttributes"));
int
chkr_stub_XGetWindowAttributes (Display * arg0, Window arg1, XWindowAttributes * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (XWindowAttributes), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XGetWindowAttributes);
#else
  return XGetWindowAttributes (arg0, arg1, arg2);
  {
    int res;
    res = XGetWindowAttributes (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetWindowAttributes */

#ifdef HAVE_XGrabButton
/* From `/usr/include/X11/Xlib.h:3068'.  */
int chkr_stub_XGrabButton (Display * arg0, unsigned int arg1, unsigned int arg2, Window arg3, int arg4, unsigned int arg5, int arg6, int arg7, Window arg8, Cursor arg9) __asm__ (CHKR_PREFIX ("XGrabButton"));
int
chkr_stub_XGrabButton (Display * arg0, unsigned int arg1, unsigned int arg2, Window arg3, int arg4, unsigned int arg5, int arg6, int arg7, Window arg8, Cursor arg9)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XGrabButton);
#else
  return XGrabButton (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
  {
    int res;
    res = XGrabButton (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGrabButton */

#ifdef HAVE_XGrabKey
/* From `/usr/include/X11/Xlib.h:3080'.  */
int chkr_stub_XGrabKey (Display * arg0, int arg1, unsigned int arg2, Window arg3, int arg4, int arg5, int arg6) __asm__ (CHKR_PREFIX ("XGrabKey"));
int
chkr_stub_XGrabKey (Display * arg0, int arg1, unsigned int arg2, Window arg3, int arg4, int arg5, int arg6)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XGrabKey);
#else
  return XGrabKey (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
  {
    int res;
    res = XGrabKey (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGrabKey */

#ifdef HAVE_XGrabKeyboard
/* From `/usr/include/X11/Xlib.h:3091'.  */
int chkr_stub_XGrabKeyboard (Display * arg0, Window arg1, int arg2, int arg3, int arg4, Time arg5) __asm__ (CHKR_PREFIX ("XGrabKeyboard"));
int
chkr_stub_XGrabKeyboard (Display * arg0, Window arg1, int arg2, int arg3, int arg4, Time arg5)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XGrabKeyboard);
#else
  return XGrabKeyboard (arg0, arg1, arg2, arg3, arg4, arg5);
  {
    int res;
    res = XGrabKeyboard (arg0, arg1, arg2, arg3, arg4, arg5);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGrabKeyboard */

#ifdef HAVE_XGrabPointer
/* From `/usr/include/X11/Xlib.h:3105'.  */
int chkr_stub_XGrabPointer (Display * arg0, Window arg1, int arg2, unsigned int arg3, int arg4, int arg5, Window arg6, Cursor arg7, Time arg8) __asm__ (CHKR_PREFIX ("XGrabPointer"));
int
chkr_stub_XGrabPointer (Display * arg0, Window arg1, int arg2, unsigned int arg3, int arg4, int arg5, Window arg6, Cursor arg7, Time arg8)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XGrabPointer);
#else
  return XGrabPointer (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
  {
    int res;
    res = XGrabPointer (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGrabPointer */

#ifdef HAVE_XGrabServer
/* From `/usr/include/X11/Xlib.h:3111'.  */
int chkr_stub_XGrabServer (Display * arg0) __asm__ (CHKR_PREFIX ("XGrabServer"));
int
chkr_stub_XGrabServer (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XGrabServer);
#else
  return XGrabServer (arg0);
  {
    int res;
    res = XGrabServer (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGrabServer */

#ifdef HAVE_XHeightMMOfScreen
/* From `/usr/include/X11/Xlib.h:3117'.  */
int chkr_stub_XHeightMMOfScreen (Screen * arg0) __asm__ (CHKR_PREFIX ("XHeightMMOfScreen"));
int
chkr_stub_XHeightMMOfScreen (Screen * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Screen), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XHeightMMOfScreen);
#else
  return XHeightMMOfScreen (arg0);
  {
    int res;
    res = XHeightMMOfScreen (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XHeightMMOfScreen */

#ifdef HAVE_XHeightOfScreen
/* From `/usr/include/X11/Xlib.h:3123'.  */
int chkr_stub_XHeightOfScreen (Screen * arg0) __asm__ (CHKR_PREFIX ("XHeightOfScreen"));
int
chkr_stub_XHeightOfScreen (Screen * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Screen), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XHeightOfScreen);
#else
  return XHeightOfScreen (arg0);
  {
    int res;
    res = XHeightOfScreen (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XHeightOfScreen */

#ifdef HAVE_XIfEvent
/* From `/usr/include/X11/Xlib.h:3138'.  */
int chkr_stub_XIfEvent (Display * arg0, XEvent * arg1, int (*) (Display *, XEvent *, XPointer) arg2, XPointer arg3) __asm__ (CHKR_PREFIX ("XIfEvent"));
int
chkr_stub_XIfEvent (Display * arg0, XEvent * arg1, int (*) (Display *, XEvent *, XPointer) arg2, XPointer arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (XEvent), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XIfEvent);
#else
  return XIfEvent (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XIfEvent (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XIfEvent */

#ifdef HAVE_XImageByteOrder
/* From `/usr/include/X11/Xlib.h:3144'.  */
int chkr_stub_XImageByteOrder (Display * arg0) __asm__ (CHKR_PREFIX ("XImageByteOrder"));
int
chkr_stub_XImageByteOrder (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XImageByteOrder);
#else
  return XImageByteOrder (arg0);
  {
    int res;
    res = XImageByteOrder (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XImageByteOrder */

#ifdef HAVE_XInstallColormap
/* From `/usr/include/X11/Xlib.h:3151'.  */
int chkr_stub_XInstallColormap (Display * arg0, Colormap arg1) __asm__ (CHKR_PREFIX ("XInstallColormap"));
int
chkr_stub_XInstallColormap (Display * arg0, Colormap arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XInstallColormap);
#else
  return XInstallColormap (arg0, arg1);
  {
    int res;
    res = XInstallColormap (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XInstallColormap */

#ifdef HAVE_XKeysymToKeycode
/* From `/usr/include/X11/Xlib.h:3158'.  */
KeyCode chkr_stub_XKeysymToKeycode (Display * arg0, KeySym arg1) __asm__ (CHKR_PREFIX ("XKeysymToKeycode"));
KeyCode
chkr_stub_XKeysymToKeycode (Display * arg0, KeySym arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XKeysymToKeycode);
#else
  return XKeysymToKeycode (arg0, arg1);
  {
    KeyCode res;
    res = XKeysymToKeycode (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XKeysymToKeycode */

#ifdef HAVE_XKillClient
/* From `/usr/include/X11/Xlib.h:3165'.  */
int chkr_stub_XKillClient (Display * arg0, XID arg1) __asm__ (CHKR_PREFIX ("XKillClient"));
int
chkr_stub_XKillClient (Display * arg0, XID arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XKillClient);
#else
  return XKillClient (arg0, arg1);
  {
    int res;
    res = XKillClient (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XKillClient */

#ifdef HAVE_XLookupColor
/* From `/usr/include/X11/Xlib.h:3175'.  */
int chkr_stub_XLookupColor (Display * arg0, Colormap arg1, const char * arg2, XColor * arg3, XColor * arg4) __asm__ (CHKR_PREFIX ("XLookupColor"));
int
chkr_stub_XLookupColor (Display * arg0, Colormap arg1, const char * arg2, XColor * arg3, XColor * arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (char), CHKR_RO, "arg2");
  stubs_chkr_check_addr (arg3, sizeof (XColor), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg4, sizeof (XColor), CHKR_XX, "arg4");
#if USE_BI_JUMP
  __builtin_jump (XLookupColor);
#else
  return XLookupColor (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = XLookupColor (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XLookupColor */

#ifdef HAVE_XLowerWindow
/* From `/usr/include/X11/Xlib.h:3182'.  */
int chkr_stub_XLowerWindow (Display *display, Window win)
     __asm__ (CHKR_PREFIX ("XLowerWindow"));
int
chkr_stub_XLowerWindow (Display *display, Window win)
{
  CHKR_CHECK_DISPLAY (display);

#if USE_BI_JUMP
  __builtin_jump (XLowerWindow);
#else
  return XLowerWindow (display, win);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XLowerWindow */

#ifdef HAVE_XMapRaised
/* From `/usr/include/X11/Xlib.h:3189'.  */
int chkr_stub_XMapRaised (Display * arg0, Window arg1) __asm__ (CHKR_PREFIX ("XMapRaised"));
int
chkr_stub_XMapRaised (Display * arg0, Window arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XMapRaised);
#else
  return XMapRaised (arg0, arg1);
  {
    int res;
    res = XMapRaised (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XMapRaised */

#ifdef HAVE_XMapSubwindows
/* From `/usr/include/X11/Xlib.h:3196'.  */
int chkr_stub_XMapSubwindows (Display * arg0, Window arg1) __asm__ (CHKR_PREFIX ("XMapSubwindows"));
int
chkr_stub_XMapSubwindows (Display * arg0, Window arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XMapSubwindows);
#else
  return XMapSubwindows (arg0, arg1);
  {
    int res;
    res = XMapSubwindows (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XMapSubwindows */

#ifdef HAVE_XMapWindow
/* From `/usr/include/X11/Xlib.h:3203'.  */
int chkr_stub_XMapWindow (Display * arg0, Window arg1) __asm__ (CHKR_PREFIX ("XMapWindow"));
int
chkr_stub_XMapWindow (Display * arg0, Window arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XMapWindow);
#else
  return XMapWindow (arg0, arg1);
  {
    int res;
    res = XMapWindow (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XMapWindow */

#ifdef HAVE_XMaskEvent
/* From `/usr/include/X11/Xlib.h:3211'.  */
int chkr_stub_XMaskEvent (Display * arg0, long int arg1, XEvent * arg2) __asm__ (CHKR_PREFIX ("XMaskEvent"));
int
chkr_stub_XMaskEvent (Display * arg0, long int arg1, XEvent * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (XEvent), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XMaskEvent);
#else
  return XMaskEvent (arg0, arg1, arg2);
  {
    int res;
    res = XMaskEvent (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XMaskEvent */

#ifdef HAVE_XMaxCmapsOfScreen
/* From `/usr/include/X11/Xlib.h:3217'.  */
int chkr_stub_XMaxCmapsOfScreen (Screen * arg0) __asm__ (CHKR_PREFIX ("XMaxCmapsOfScreen"));
int
chkr_stub_XMaxCmapsOfScreen (Screen * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Screen), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XMaxCmapsOfScreen);
#else
  return XMaxCmapsOfScreen (arg0);
  {
    int res;
    res = XMaxCmapsOfScreen (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XMaxCmapsOfScreen */

#ifdef HAVE_XMinCmapsOfScreen
/* From `/usr/include/X11/Xlib.h:3223'.  */
int chkr_stub_XMinCmapsOfScreen (Screen * arg0) __asm__ (CHKR_PREFIX ("XMinCmapsOfScreen"));
int
chkr_stub_XMinCmapsOfScreen (Screen * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Screen), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XMinCmapsOfScreen);
#else
  return XMinCmapsOfScreen (arg0);
  {
    int res;
    res = XMinCmapsOfScreen (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XMinCmapsOfScreen */

#ifdef HAVE_XMoveResizeWindow
/* From `/usr/include/X11/Xlib.h:3234'.  */
int chkr_stub_XMoveResizeWindow (Display * arg0, Window arg1, int arg2, int arg3, unsigned int arg4, unsigned int arg5) __asm__ (CHKR_PREFIX ("XMoveResizeWindow"));
int
chkr_stub_XMoveResizeWindow (Display * arg0, Window arg1, int arg2, int arg3, unsigned int arg4, unsigned int arg5)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XMoveResizeWindow);
#else
  return XMoveResizeWindow (arg0, arg1, arg2, arg3, arg4, arg5);
  {
    int res;
    res = XMoveResizeWindow (arg0, arg1, arg2, arg3, arg4, arg5);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XMoveResizeWindow */

#ifdef HAVE_XMoveWindow
/* From `/usr/include/X11/Xlib.h:3243'.  */
int chkr_stub_XMoveWindow (Display * arg0, Window arg1, int arg2, int arg3) __asm__ (CHKR_PREFIX ("XMoveWindow"));
int
chkr_stub_XMoveWindow (Display * arg0, Window arg1, int arg2, int arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XMoveWindow);
#else
  return XMoveWindow (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XMoveWindow (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XMoveWindow */

#ifdef HAVE_XNextEvent
/* From `/usr/include/X11/Xlib.h:3250'.  */
int chkr_stub_XNextEvent (Display * arg0, XEvent * arg1) __asm__ (CHKR_PREFIX ("XNextEvent"));
int
chkr_stub_XNextEvent (Display * arg0, XEvent * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (XEvent), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XNextEvent);
#else
  return XNextEvent (arg0, arg1);
  {
    int res;
    res = XNextEvent (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XNextEvent */

#ifdef HAVE_XNoOp
/* From `/usr/include/X11/Xlib.h:3256'.  */
int chkr_stub_XNoOp (Display * arg0) __asm__ (CHKR_PREFIX ("XNoOp"));
int
chkr_stub_XNoOp (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XNoOp);
#else
  return XNoOp (arg0);
  {
    int res;
    res = XNoOp (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XNoOp */

#ifdef HAVE_XParseColor
/* From `/usr/include/X11/Xlib.h:3265'.  */
int chkr_stub_XParseColor (Display * arg0, Colormap arg1, const char * arg2, XColor * arg3) __asm__ (CHKR_PREFIX ("XParseColor"));
int
chkr_stub_XParseColor (Display * arg0, Colormap arg1, const char * arg2, XColor * arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (char), CHKR_RO, "arg2");
  stubs_chkr_check_addr (arg3, sizeof (XColor), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XParseColor);
#else
  return XParseColor (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XParseColor (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XParseColor */

#ifdef HAVE_XParseGeometry
/* From `/usr/include/X11/Xlib.h:3275'.  */
int chkr_stub_XParseGeometry (const char * arg0, int * arg1, int * arg2, unsigned int * arg3, unsigned int * arg4) __asm__ (CHKR_PREFIX ("XParseGeometry"));
int
chkr_stub_XParseGeometry (const char * arg0, int * arg1, int * arg2, unsigned int * arg3, unsigned int * arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (char), CHKR_RO, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (int), CHKR_XX, "arg1");
  stubs_chkr_check_addr (arg2, sizeof (int), CHKR_XX, "arg2");
  stubs_chkr_check_addr (arg3, sizeof (unsigned int), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg4, sizeof (unsigned int), CHKR_XX, "arg4");
#if USE_BI_JUMP
  __builtin_jump (XParseGeometry);
#else
  return XParseGeometry (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = XParseGeometry (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XParseGeometry */

#ifdef HAVE_XPeekEvent
/* From `/usr/include/X11/Xlib.h:3282'.  */
int chkr_stub_XPeekEvent (Display * arg0, XEvent * arg1) __asm__ (CHKR_PREFIX ("XPeekEvent"));
int
chkr_stub_XPeekEvent (Display * arg0, XEvent * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (XEvent), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XPeekEvent);
#else
  return XPeekEvent (arg0, arg1);
  {
    int res;
    res = XPeekEvent (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XPeekEvent */

#ifdef HAVE_XPeekIfEvent
/* From `/usr/include/X11/Xlib.h:3297'.  */
int chkr_stub_XPeekIfEvent (Display * arg0, XEvent * arg1, int (*) (Display *, XEvent *, XPointer) arg2, XPointer arg3) __asm__ (CHKR_PREFIX ("XPeekIfEvent"));
int
chkr_stub_XPeekIfEvent (Display * arg0, XEvent * arg1, int (*) (Display *, XEvent *, XPointer) arg2, XPointer arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (XEvent), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XPeekIfEvent);
#else
  return XPeekIfEvent (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XPeekIfEvent (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XPeekIfEvent */

#ifdef HAVE_XPending
/* From `/usr/include/X11/Xlib.h:3303'.  */
int chkr_stub_XPending (Display *display) __asm__ (CHKR_PREFIX ("XPending"));
int
chkr_stub_XPending (Display *display)
{
  CHKR_CHECK_DISPLAY (display);

#if USE_BI_JUMP
  __builtin_jump (XPending);
#else
  return XPending (display);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XPending */

#ifdef HAVE_XPlanesOfScreen
/* From `/usr/include/X11/Xlib.h:3310'.  */
int chkr_stub_XPlanesOfScreen (Screen * arg0) __asm__ (CHKR_PREFIX ("XPlanesOfScreen"));
int
chkr_stub_XPlanesOfScreen (Screen * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Screen), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XPlanesOfScreen);
#else
  return XPlanesOfScreen (arg0);
  {
    int res;
    res = XPlanesOfScreen (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XPlanesOfScreen */

#ifdef HAVE_XProtocolRevision
/* From `/usr/include/X11/Xlib.h:3316'.  */
int chkr_stub_XProtocolRevision (Display * arg0) __asm__ (CHKR_PREFIX ("XProtocolRevision"));
int
chkr_stub_XProtocolRevision (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XProtocolRevision);
#else
  return XProtocolRevision (arg0);
  {
    int res;
    res = XProtocolRevision (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XProtocolRevision */

#ifdef HAVE_XProtocolVersion
/* From `/usr/include/X11/Xlib.h:3322'.  */
int chkr_stub_XProtocolVersion (Display * arg0) __asm__ (CHKR_PREFIX ("XProtocolVersion"));
int
chkr_stub_XProtocolVersion (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XProtocolVersion);
#else
  return XProtocolVersion (arg0);
  {
    int res;
    res = XProtocolVersion (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XProtocolVersion */

#ifdef HAVE_XPutBackEvent
/* From `/usr/include/X11/Xlib.h:3330'.  */
int chkr_stub_XPutBackEvent (Display * arg0, XEvent * arg1) __asm__ (CHKR_PREFIX ("XPutBackEvent"));
int
chkr_stub_XPutBackEvent (Display * arg0, XEvent * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (XEvent), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XPutBackEvent);
#else
  return XPutBackEvent (arg0, arg1);
  {
    int res;
    res = XPutBackEvent (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XPutBackEvent */

#ifdef HAVE_XPutImage
/* From `/usr/include/X11/Xlib.h:3345'.  */
int chkr_stub_XPutImage (Display * arg0, Drawable arg1, GC arg2, XImage * arg3, int arg4, int arg5, int arg6, int arg7, unsigned int arg8, unsigned int arg9) __asm__ (CHKR_PREFIX ("XPutImage"));
int
chkr_stub_XPutImage (Display * arg0, Drawable arg1, GC arg2, XImage * arg3, int arg4, int arg5, int arg6, int arg7, unsigned int arg8, unsigned int arg9)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg3, sizeof (XImage), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XPutImage);
#else
  return XPutImage (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
  {
    int res;
    res = XPutImage (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XPutImage */

#ifdef HAVE_XQLength
/* From `/usr/include/X11/Xlib.h:3351'.  */
int chkr_stub_XQLength (Display * arg0) __asm__ (CHKR_PREFIX ("XQLength"));
int
chkr_stub_XQLength (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XQLength);
#else
  return XQLength (arg0);
  {
    int res;
    res = XQLength (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XQLength */

#ifdef HAVE_XQueryBestCursor
/* From `/usr/include/X11/Xlib.h:3362'.  */
int chkr_stub_XQueryBestCursor (Display * arg0, Drawable arg1, unsigned int arg2, unsigned int arg3, unsigned int * arg4, unsigned int * arg5) __asm__ (CHKR_PREFIX ("XQueryBestCursor"));
int
chkr_stub_XQueryBestCursor (Display * arg0, Drawable arg1, unsigned int arg2, unsigned int arg3, unsigned int * arg4, unsigned int * arg5)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg4, sizeof (unsigned int), CHKR_XX, "arg4");
  stubs_chkr_check_addr (arg5, sizeof (unsigned int), CHKR_XX, "arg5");
#if USE_BI_JUMP
  __builtin_jump (XQueryBestCursor);
#else
  return XQueryBestCursor (arg0, arg1, arg2, arg3, arg4, arg5);
  {
    int res;
    res = XQueryBestCursor (arg0, arg1, arg2, arg3, arg4, arg5);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XQueryBestCursor */

#ifdef HAVE_XQueryBestSize
/* From `/usr/include/X11/Xlib.h:3374'.  */
int chkr_stub_XQueryBestSize (Display * arg0, int arg1, Drawable arg2, unsigned int arg3, unsigned int arg4, unsigned int * arg5, unsigned int * arg6) __asm__ (CHKR_PREFIX ("XQueryBestSize"));
int
chkr_stub_XQueryBestSize (Display * arg0, int arg1, Drawable arg2, unsigned int arg3, unsigned int arg4, unsigned int * arg5, unsigned int * arg6)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg5, sizeof (unsigned int), CHKR_XX, "arg5");
  stubs_chkr_check_addr (arg6, sizeof (unsigned int), CHKR_XX, "arg6");
#if USE_BI_JUMP
  __builtin_jump (XQueryBestSize);
#else
  return XQueryBestSize (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
  {
    int res;
    res = XQueryBestSize (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XQueryBestSize */

#ifdef HAVE_XQueryBestStipple
/* From `/usr/include/X11/Xlib.h:3385'.  */
int chkr_stub_XQueryBestStipple (Display * arg0, Drawable arg1, unsigned int arg2, unsigned int arg3, unsigned int * arg4, unsigned int * arg5) __asm__ (CHKR_PREFIX ("XQueryBestStipple"));
int
chkr_stub_XQueryBestStipple (Display * arg0, Drawable arg1, unsigned int arg2, unsigned int arg3, unsigned int * arg4, unsigned int * arg5)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg4, sizeof (unsigned int), CHKR_XX, "arg4");
  stubs_chkr_check_addr (arg5, sizeof (unsigned int), CHKR_XX, "arg5");
#if USE_BI_JUMP
  __builtin_jump (XQueryBestStipple);
#else
  return XQueryBestStipple (arg0, arg1, arg2, arg3, arg4, arg5);
  {
    int res;
    res = XQueryBestStipple (arg0, arg1, arg2, arg3, arg4, arg5);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XQueryBestStipple */

#ifdef HAVE_XQueryBestTile
/* From `/usr/include/X11/Xlib.h:3396'.  */
int chkr_stub_XQueryBestTile (Display * arg0, Drawable arg1, unsigned int arg2, unsigned int arg3, unsigned int * arg4, unsigned int * arg5) __asm__ (CHKR_PREFIX ("XQueryBestTile"));
int
chkr_stub_XQueryBestTile (Display * arg0, Drawable arg1, unsigned int arg2, unsigned int arg3, unsigned int * arg4, unsigned int * arg5)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg4, sizeof (unsigned int), CHKR_XX, "arg4");
  stubs_chkr_check_addr (arg5, sizeof (unsigned int), CHKR_XX, "arg5");
#if USE_BI_JUMP
  __builtin_jump (XQueryBestTile);
#else
  return XQueryBestTile (arg0, arg1, arg2, arg3, arg4, arg5);
  {
    int res;
    res = XQueryBestTile (arg0, arg1, arg2, arg3, arg4, arg5);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XQueryBestTile */

#ifdef HAVE_XQueryColor
/* From `/usr/include/X11/Xlib.h:3404'.  */
int chkr_stub_XQueryColor (Display * arg0, Colormap arg1, XColor * arg2) __asm__ (CHKR_PREFIX ("XQueryColor"));
int
chkr_stub_XQueryColor (Display * arg0, Colormap arg1, XColor * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (XColor), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XQueryColor);
#else
  return XQueryColor (arg0, arg1, arg2);
  {
    int res;
    res = XQueryColor (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XQueryColor */

#ifdef HAVE_XQueryColors
/* From `/usr/include/X11/Xlib.h:3413'.  */
int chkr_stub_XQueryColors (Display * arg0, Colormap arg1, XColor * arg2, int arg3) __asm__ (CHKR_PREFIX ("XQueryColors"));
int
chkr_stub_XQueryColors (Display * arg0, Colormap arg1, XColor * arg2, int arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (XColor), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XQueryColors);
#else
  return XQueryColors (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XQueryColors (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XQueryColors */

#ifdef HAVE_XQueryExtension
/* From `/usr/include/X11/Xlib.h:3423'.  */
int chkr_stub_XQueryExtension (Display * arg0, const char * arg1, int * arg2, int * arg3, int * arg4) __asm__ (CHKR_PREFIX ("XQueryExtension"));
int
chkr_stub_XQueryExtension (Display * arg0, const char * arg1, int * arg2, int * arg3, int * arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
  stubs_chkr_check_addr (arg2, sizeof (int), CHKR_XX, "arg2");
  stubs_chkr_check_addr (arg3, sizeof (int), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg4, sizeof (int), CHKR_XX, "arg4");
#if USE_BI_JUMP
  __builtin_jump (XQueryExtension);
#else
  return XQueryExtension (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = XQueryExtension (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XQueryExtension */

#ifdef HAVE_XQueryKeymap
/* From `/usr/include/X11/Xlib.h:3430'.  */
int chkr_stub_XQueryKeymap (Display * arg0, char * arg1) __asm__ (CHKR_PREFIX ("XQueryKeymap"));
int
chkr_stub_XQueryKeymap (Display * arg0, char * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XQueryKeymap);
#else
  return XQueryKeymap (arg0, arg1);
  {
    int res;
    res = XQueryKeymap (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XQueryKeymap */

#ifdef HAVE_XQueryPointer
/* From `/usr/include/X11/Xlib.h:3444'.  */
int chkr_stub_XQueryPointer (Display * arg0, Window arg1, Window * arg2, Window * arg3, int * arg4, int * arg5, int * arg6, int * arg7, unsigned int * arg8) __asm__ (CHKR_PREFIX ("XQueryPointer"));
int
chkr_stub_XQueryPointer (Display * arg0, Window arg1, Window * arg2, Window * arg3, int * arg4, int * arg5, int * arg6, int * arg7, unsigned int * arg8)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (Window), CHKR_XX, "arg2");
  stubs_chkr_check_addr (arg3, sizeof (Window), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg4, sizeof (int), CHKR_XX, "arg4");
  stubs_chkr_check_addr (arg5, sizeof (int), CHKR_XX, "arg5");
  stubs_chkr_check_addr (arg6, sizeof (int), CHKR_XX, "arg6");
  stubs_chkr_check_addr (arg7, sizeof (int), CHKR_XX, "arg7");
  stubs_chkr_check_addr (arg8, sizeof (unsigned int), CHKR_XX, "arg8");
#if USE_BI_JUMP
  __builtin_jump (XQueryPointer);
#else
  return XQueryPointer (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
  {
    int res;
    res = XQueryPointer (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XQueryPointer */

#ifdef HAVE_XQueryTextExtents
/* From `/usr/include/X11/Xlib.h:3457'.  */
int chkr_stub_XQueryTextExtents (Display * arg0, XID arg1, const char * arg2, int arg3, int * arg4, int * arg5, int * arg6, XCharStruct * arg7) __asm__ (CHKR_PREFIX ("XQueryTextExtents"));
int
chkr_stub_XQueryTextExtents (Display * arg0, XID arg1, const char * arg2, int arg3, int * arg4, int * arg5, int * arg6, XCharStruct * arg7)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (char), CHKR_RO, "arg2");
  stubs_chkr_check_addr (arg4, sizeof (int), CHKR_XX, "arg4");
  stubs_chkr_check_addr (arg5, sizeof (int), CHKR_XX, "arg5");
  stubs_chkr_check_addr (arg6, sizeof (int), CHKR_XX, "arg6");
  stubs_chkr_check_addr (arg7, sizeof (XCharStruct), CHKR_XX, "arg7");
#if USE_BI_JUMP
  __builtin_jump (XQueryTextExtents);
#else
  return XQueryTextExtents (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
  {
    int res;
    res = XQueryTextExtents (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XQueryTextExtents */

#ifdef HAVE_XQueryTextExtents16
/* From `/usr/include/X11/Xlib.h:3470'.  */
int chkr_stub_XQueryTextExtents16 (Display * arg0, XID arg1, const XChar2b * arg2, int arg3, int * arg4, int * arg5, int * arg6, XCharStruct * arg7) __asm__ (CHKR_PREFIX ("XQueryTextExtents16"));
int
chkr_stub_XQueryTextExtents16 (Display * arg0, XID arg1, const XChar2b * arg2, int arg3, int * arg4, int * arg5, int * arg6, XCharStruct * arg7)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (XChar2b), CHKR_RO, "arg2");
  stubs_chkr_check_addr (arg4, sizeof (int), CHKR_XX, "arg4");
  stubs_chkr_check_addr (arg5, sizeof (int), CHKR_XX, "arg5");
  stubs_chkr_check_addr (arg6, sizeof (int), CHKR_XX, "arg6");
  stubs_chkr_check_addr (arg7, sizeof (XCharStruct), CHKR_XX, "arg7");
#if USE_BI_JUMP
  __builtin_jump (XQueryTextExtents16);
#else
  return XQueryTextExtents16 (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
  {
    int res;
    res = XQueryTextExtents16 (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XQueryTextExtents16 */

#ifdef HAVE_XQueryTree
/* From `/usr/include/X11/Xlib.h:3481'.  */
int chkr_stub_XQueryTree (Display * arg0, Window arg1, Window * arg2, Window * arg3, Window ** arg4, unsigned int * arg5) __asm__ (CHKR_PREFIX ("XQueryTree"));
int
chkr_stub_XQueryTree (Display * arg0, Window arg1, Window * arg2, Window * arg3, Window ** arg4, unsigned int * arg5)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (Window), CHKR_XX, "arg2");
  stubs_chkr_check_addr (arg3, sizeof (Window), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg4, sizeof (Window *), CHKR_XX, "arg4");
  stubs_chkr_check_addr (arg5, sizeof (unsigned int), CHKR_XX, "arg5");
#if USE_BI_JUMP
  __builtin_jump (XQueryTree);
#else
  return XQueryTree (arg0, arg1, arg2, arg3, arg4, arg5);
  {
    int res;
    res = XQueryTree (arg0, arg1, arg2, arg3, arg4, arg5);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XQueryTree */

#ifdef HAVE_XRaiseWindow
/* From `/usr/include/X11/Xlib.h:3488'.  */
int chkr_stub_XRaiseWindow (Display *display, Window win)
     __asm__ (CHKR_PREFIX ("XRaiseWindow"));
int
chkr_stub_XRaiseWindow (Display *display, Window win)
{
  CHKR_CHECK_DISPLAY (display);

#if USE_BI_JUMP
  __builtin_jump (XRaiseWindow);
#else
  return XRaiseWindow (display, win);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XRaiseWindow */

#ifdef HAVE_XReadBitmapFile
/* From `/usr/include/X11/Xlib.h:3501'.  */
int chkr_stub_XReadBitmapFile (Display * arg0, Drawable arg1, const char * arg2, unsigned int * arg3, unsigned int * arg4, Pixmap * arg5, int * arg6, int * arg7) __asm__ (CHKR_PREFIX ("XReadBitmapFile"));
int
chkr_stub_XReadBitmapFile (Display * arg0, Drawable arg1, const char * arg2, unsigned int * arg3, unsigned int * arg4, Pixmap * arg5, int * arg6, int * arg7)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (char), CHKR_RO, "arg2");
  stubs_chkr_check_addr (arg3, sizeof (unsigned int), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg4, sizeof (unsigned int), CHKR_XX, "arg4");
  stubs_chkr_check_addr (arg5, sizeof (Pixmap), CHKR_XX, "arg5");
  stubs_chkr_check_addr (arg6, sizeof (int), CHKR_XX, "arg6");
  stubs_chkr_check_addr (arg7, sizeof (int), CHKR_XX, "arg7");
#if USE_BI_JUMP
  __builtin_jump (XReadBitmapFile);
#else
  return XReadBitmapFile (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
  {
    int res;
    res = XReadBitmapFile (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XReadBitmapFile */

#ifdef HAVE_XReadBitmapFileData
/* From `/usr/include/X11/Xlib.h:3512'.  */
int chkr_stub_XReadBitmapFileData (const char * arg0, unsigned int * arg1, unsigned int * arg2, unsigned char ** arg3, int * arg4, int * arg5) __asm__ (CHKR_PREFIX ("XReadBitmapFileData"));
int
chkr_stub_XReadBitmapFileData (const char * arg0, unsigned int * arg1, unsigned int * arg2, unsigned char ** arg3, int * arg4, int * arg5)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (char), CHKR_RO, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (unsigned int), CHKR_XX, "arg1");
  stubs_chkr_check_addr (arg2, sizeof (unsigned int), CHKR_XX, "arg2");
  stubs_chkr_check_addr (arg3, sizeof (unsigned char *), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg4, sizeof (int), CHKR_XX, "arg4");
  stubs_chkr_check_addr (arg5, sizeof (int), CHKR_XX, "arg5");
#if USE_BI_JUMP
  __builtin_jump (XReadBitmapFileData);
#else
  return XReadBitmapFileData (arg0, arg1, arg2, arg3, arg4, arg5);
  {
    int res;
    res = XReadBitmapFileData (arg0, arg1, arg2, arg3, arg4, arg5);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XReadBitmapFileData */

#ifdef HAVE_XRebindKeysym
/* From `/usr/include/X11/Xlib.h:3523'.  */
int chkr_stub_XRebindKeysym (Display * arg0, KeySym arg1, KeySym * arg2, int arg3, const unsigned char * arg4, int arg5) __asm__ (CHKR_PREFIX ("XRebindKeysym"));
int
chkr_stub_XRebindKeysym (Display * arg0, KeySym arg1, KeySym * arg2, int arg3, const unsigned char * arg4, int arg5)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (KeySym), CHKR_XX, "arg2");
  stubs_chkr_check_addr (arg4, sizeof (unsigned char), CHKR_RO, "arg4");
#if USE_BI_JUMP
  __builtin_jump (XRebindKeysym);
#else
  return XRebindKeysym (arg0, arg1, arg2, arg3, arg4, arg5);
  {
    int res;
    res = XRebindKeysym (arg0, arg1, arg2, arg3, arg4, arg5);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XRebindKeysym */

#ifdef HAVE_XRecolorCursor
/* From `/usr/include/X11/Xlib.h:3532'.  */
int chkr_stub_XRecolorCursor (Display * arg0, Cursor arg1, XColor * arg2, XColor * arg3) __asm__ (CHKR_PREFIX ("XRecolorCursor"));
int
chkr_stub_XRecolorCursor (Display * arg0, Cursor arg1, XColor * arg2, XColor * arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (XColor), CHKR_XX, "arg2");
  stubs_chkr_check_addr (arg3, sizeof (XColor), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XRecolorCursor);
#else
  return XRecolorCursor (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XRecolorCursor (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XRecolorCursor */

#ifdef HAVE_XRefreshKeyboardMapping
/* From `/usr/include/X11/Xlib.h:3538'.  */
int chkr_stub_XRefreshKeyboardMapping (XMappingEvent * arg0) __asm__ (CHKR_PREFIX ("XRefreshKeyboardMapping"));
int
chkr_stub_XRefreshKeyboardMapping (XMappingEvent * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (XMappingEvent), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XRefreshKeyboardMapping);
#else
  return XRefreshKeyboardMapping (arg0);
  {
    int res;
    res = XRefreshKeyboardMapping (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XRefreshKeyboardMapping */

#ifdef HAVE_XRemoveFromSaveSet
/* From `/usr/include/X11/Xlib.h:3545'.  */
int chkr_stub_XRemoveFromSaveSet (Display * arg0, Window arg1) __asm__ (CHKR_PREFIX ("XRemoveFromSaveSet"));
int
chkr_stub_XRemoveFromSaveSet (Display * arg0, Window arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XRemoveFromSaveSet);
#else
  return XRemoveFromSaveSet (arg0, arg1);
  {
    int res;
    res = XRemoveFromSaveSet (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XRemoveFromSaveSet */

#ifdef HAVE_XRemoveHost
/* From `/usr/include/X11/Xlib.h:3552'.  */
int chkr_stub_XRemoveHost (Display * arg0, XHostAddress * arg1) __asm__ (CHKR_PREFIX ("XRemoveHost"));
int
chkr_stub_XRemoveHost (Display * arg0, XHostAddress * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (XHostAddress), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XRemoveHost);
#else
  return XRemoveHost (arg0, arg1);
  {
    int res;
    res = XRemoveHost (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XRemoveHost */

#ifdef HAVE_XRemoveHosts
/* From `/usr/include/X11/Xlib.h:3560'.  */
int chkr_stub_XRemoveHosts (Display * arg0, XHostAddress * arg1, int arg2) __asm__ (CHKR_PREFIX ("XRemoveHosts"));
int
chkr_stub_XRemoveHosts (Display * arg0, XHostAddress * arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (XHostAddress), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XRemoveHosts);
#else
  return XRemoveHosts (arg0, arg1, arg2);
  {
    int res;
    res = XRemoveHosts (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XRemoveHosts */

#ifdef HAVE_XReparentWindow
/* From `/usr/include/X11/Xlib.h:3570'.  */
int chkr_stub_XReparentWindow (Display * arg0, Window arg1, Window arg2, int arg3, int arg4) __asm__ (CHKR_PREFIX ("XReparentWindow"));
int
chkr_stub_XReparentWindow (Display * arg0, Window arg1, Window arg2, int arg3, int arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XReparentWindow);
#else
  return XReparentWindow (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = XReparentWindow (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XReparentWindow */

#ifdef HAVE_XResetScreenSaver
/* From `/usr/include/X11/Xlib.h:3576'.  */
int chkr_stub_XResetScreenSaver (Display * arg0) __asm__ (CHKR_PREFIX ("XResetScreenSaver"));
int
chkr_stub_XResetScreenSaver (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XResetScreenSaver);
#else
  return XResetScreenSaver (arg0);
  {
    int res;
    res = XResetScreenSaver (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XResetScreenSaver */

#ifdef HAVE_XResizeWindow
/* From `/usr/include/X11/Xlib.h:3585'.  */
int chkr_stub_XResizeWindow (Display * arg0, Window arg1, unsigned int arg2, unsigned int arg3) __asm__ (CHKR_PREFIX ("XResizeWindow"));
int
chkr_stub_XResizeWindow (Display * arg0, Window arg1, unsigned int arg2, unsigned int arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XResizeWindow);
#else
  return XResizeWindow (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XResizeWindow (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XResizeWindow */

#ifdef HAVE_XRestackWindows
/* From `/usr/include/X11/Xlib.h:3593'.  */
int chkr_stub_XRestackWindows (Display * arg0, Window * arg1, int arg2) __asm__ (CHKR_PREFIX ("XRestackWindows"));
int
chkr_stub_XRestackWindows (Display * arg0, Window * arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (Window), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XRestackWindows);
#else
  return XRestackWindows (arg0, arg1, arg2);
  {
    int res;
    res = XRestackWindows (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XRestackWindows */

#ifdef HAVE_XRotateBuffers
/* From `/usr/include/X11/Xlib.h:3600'.  */
int chkr_stub_XRotateBuffers (Display * arg0, int arg1) __asm__ (CHKR_PREFIX ("XRotateBuffers"));
int
chkr_stub_XRotateBuffers (Display * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XRotateBuffers);
#else
  return XRotateBuffers (arg0, arg1);
  {
    int res;
    res = XRotateBuffers (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XRotateBuffers */

#ifdef HAVE_XRotateWindowProperties
/* From `/usr/include/X11/Xlib.h:3610'.  */
int chkr_stub_XRotateWindowProperties (Display * arg0, Window arg1, Atom * arg2, int arg3, int arg4) __asm__ (CHKR_PREFIX ("XRotateWindowProperties"));
int
chkr_stub_XRotateWindowProperties (Display * arg0, Window arg1, Atom * arg2, int arg3, int arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (Atom), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XRotateWindowProperties);
#else
  return XRotateWindowProperties (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = XRotateWindowProperties (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XRotateWindowProperties */

#ifdef HAVE_XScreenCount
/* From `/usr/include/X11/Xlib.h:3616'.  */
int chkr_stub_XScreenCount (Display * arg0) __asm__ (CHKR_PREFIX ("XScreenCount"));
int
chkr_stub_XScreenCount (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XScreenCount);
#else
  return XScreenCount (arg0);
  {
    int res;
    res = XScreenCount (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XScreenCount */

#ifdef HAVE_XSelectInput
/* From `/usr/include/X11/Xlib.h:3624'.  */
int chkr_stub_XSelectInput (Display * arg0, Window arg1, long int arg2) __asm__ (CHKR_PREFIX ("XSelectInput"));
int
chkr_stub_XSelectInput (Display * arg0, Window arg1, long int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSelectInput);
#else
  return XSelectInput (arg0, arg1, arg2);
  {
    int res;
    res = XSelectInput (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSelectInput */

#ifdef HAVE_XSendEvent
/* From `/usr/include/X11/Xlib.h:3634'.  */
int chkr_stub_XSendEvent (Display * arg0, Window arg1, int arg2, long int arg3, XEvent * arg4) __asm__ (CHKR_PREFIX ("XSendEvent"));
int
chkr_stub_XSendEvent (Display * arg0, Window arg1, int arg2, long int arg3, XEvent * arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg4, sizeof (XEvent), CHKR_XX, "arg4");
#if USE_BI_JUMP
  __builtin_jump (XSendEvent);
#else
  return XSendEvent (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = XSendEvent (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSendEvent */

#ifdef HAVE_XSetAccessControl
/* From `/usr/include/X11/Xlib.h:3641'.  */
int chkr_stub_XSetAccessControl (Display * arg0, int arg1) __asm__ (CHKR_PREFIX ("XSetAccessControl"));
int
chkr_stub_XSetAccessControl (Display * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetAccessControl);
#else
  return XSetAccessControl (arg0, arg1);
  {
    int res;
    res = XSetAccessControl (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetAccessControl */

#ifdef HAVE_XSetArcMode
/* From `/usr/include/X11/Xlib.h:3649'.  */
int chkr_stub_XSetArcMode (Display * arg0, GC arg1, int arg2) __asm__ (CHKR_PREFIX ("XSetArcMode"));
int
chkr_stub_XSetArcMode (Display * arg0, GC arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetArcMode);
#else
  return XSetArcMode (arg0, arg1, arg2);
  {
    int res;
    res = XSetArcMode (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetArcMode */

#ifdef HAVE_XSetBackground
/* From `/usr/include/X11/Xlib.h:3657'.  */
int chkr_stub_XSetBackground (Display * arg0, GC arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("XSetBackground"));
int
chkr_stub_XSetBackground (Display * arg0, GC arg1, long unsigned int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetBackground);
#else
  return XSetBackground (arg0, arg1, arg2);
  {
    int res;
    res = XSetBackground (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetBackground */

#ifdef HAVE_XSetClipMask
/* From `/usr/include/X11/Xlib.h:3665'.  */
int chkr_stub_XSetClipMask (Display *display, GC gc, Pixmap pixmap)
     __asm__ (CHKR_PREFIX ("XSetClipMask"));
int
chkr_stub_XSetClipMask (Display *display, GC gc, Pixmap pixmap)
{
  CHKR_CHECK_DISPLAY (display);

#if USE_BI_JUMP
  __builtin_jump (XSetClipMask);
#else
  return XSetClipMask (display, gc, pixmap);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetClipMask */

#ifdef HAVE_XSetClipOrigin
/* From `/usr/include/X11/Xlib.h:3674'.  */
int chkr_stub_XSetClipOrigin (Display *display, GC gc, int x, int y)
     __asm__ (CHKR_PREFIX ("XSetClipOrigin"));
int
chkr_stub_XSetClipOrigin (Display *display, GC gc, int x, int y)
{
  CHKR_CHECK_DISPLAY (display);

#if USE_BI_JUMP
  __builtin_jump (XSetClipOrigin);
#else
  return XSetClipOrigin (display, gc, x, y);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetClipOrigin */

#ifdef HAVE_XSetClipRectangles
/* From `/usr/include/X11/Xlib.h:3686'.  */
int chkr_stub_XSetClipRectangles (Display *display, GC gc,
				  int x, int y, XRectangle *rectangles,
				  int n, int ordering)
     __asm__ (CHKR_PREFIX ("XSetClipRectangles"));
int
chkr_stub_XSetClipRectangles (Display *display, GC gc, int x, int y,
			      XRectangle *rectangles, int n, int ordering)
{
  CHKR_CHECK_DISPLAY (display);
  /* stubs_chkr_check_addr (arg4, sizeof (XRectangle), CHKR_XX, "arg4"); */
#if USE_BI_JUMP
  __builtin_jump (XSetClipRectangles);
#else
  return XSetClipRectangles (display, gc, x, y, rectangles, n, ordering);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetClipRectangles */

#ifdef HAVE_XSetCloseDownMode
/* From `/usr/include/X11/Xlib.h:3693'.  */
int chkr_stub_XSetCloseDownMode (Display * arg0, int arg1) __asm__ (CHKR_PREFIX ("XSetCloseDownMode"));
int
chkr_stub_XSetCloseDownMode (Display * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetCloseDownMode);
#else
  return XSetCloseDownMode (arg0, arg1);
  {
    int res;
    res = XSetCloseDownMode (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetCloseDownMode */

#ifdef HAVE_XSetCommand
/* From `/usr/include/X11/Xlib.h:3702'.  */
int chkr_stub_XSetCommand (Display * arg0, Window arg1, char ** arg2, int arg3) __asm__ (CHKR_PREFIX ("XSetCommand"));
int
chkr_stub_XSetCommand (Display * arg0, Window arg1, char ** arg2, int arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (char *), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XSetCommand);
#else
  return XSetCommand (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XSetCommand (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetCommand */

#ifdef HAVE_XSetDashes
/* From `/usr/include/X11/Xlib.h:3712'.  */
int chkr_stub_XSetDashes (Display * arg0, GC arg1, int arg2, const char * arg3, int arg4) __asm__ (CHKR_PREFIX ("XSetDashes"));
int
chkr_stub_XSetDashes (Display * arg0, GC arg1, int arg2, const char * arg3, int arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg3, sizeof (char), CHKR_RO, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XSetDashes);
#else
  return XSetDashes (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = XSetDashes (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetDashes */

#ifdef HAVE_XSetFillRule
/* From `/usr/include/X11/Xlib.h:3720'.  */
int chkr_stub_XSetFillRule (Display * arg0, GC arg1, int arg2) __asm__ (CHKR_PREFIX ("XSetFillRule"));
int
chkr_stub_XSetFillRule (Display * arg0, GC arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetFillRule);
#else
  return XSetFillRule (arg0, arg1, arg2);
  {
    int res;
    res = XSetFillRule (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetFillRule */

#ifdef HAVE_XSetFillStyle
/* From `/usr/include/X11/Xlib.h:3728'.  */
int chkr_stub_XSetFillStyle (Display * arg0, GC arg1, int arg2) __asm__ (CHKR_PREFIX ("XSetFillStyle"));
int
chkr_stub_XSetFillStyle (Display * arg0, GC arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetFillStyle);
#else
  return XSetFillStyle (arg0, arg1, arg2);
  {
    int res;
    res = XSetFillStyle (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetFillStyle */

#ifdef HAVE_XSetFont
/* From `/usr/include/X11/Xlib.h:3736'.  */
int chkr_stub_XSetFont (Display * arg0, GC arg1, Font arg2) __asm__ (CHKR_PREFIX ("XSetFont"));
int
chkr_stub_XSetFont (Display * arg0, GC arg1, Font arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetFont);
#else
  return XSetFont (arg0, arg1, arg2);
  {
    int res;
    res = XSetFont (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetFont */

#ifdef HAVE_XSetFontPath
/* From `/usr/include/X11/Xlib.h:3744'.  */
int chkr_stub_XSetFontPath (Display * arg0, char ** arg1, int arg2) __asm__ (CHKR_PREFIX ("XSetFontPath"));
int
chkr_stub_XSetFontPath (Display * arg0, char ** arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char *), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XSetFontPath);
#else
  return XSetFontPath (arg0, arg1, arg2);
  {
    int res;
    res = XSetFontPath (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetFontPath */

#ifdef HAVE_XSetForeground
/* From `/usr/include/X11/Xlib.h:3752'.  */
int chkr_stub_XSetForeground (Display * arg0, GC arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("XSetForeground"));
int
chkr_stub_XSetForeground (Display * arg0, GC arg1, long unsigned int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetForeground);
#else
  return XSetForeground (arg0, arg1, arg2);
  {
    int res;
    res = XSetForeground (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetForeground */

#ifdef HAVE_XSetFunction
/* From `/usr/include/X11/Xlib.h:3760'.  */
int chkr_stub_XSetFunction (Display *display, GC gc, int func)
     __asm__ (CHKR_PREFIX ("XSetFunction"));
int
chkr_stub_XSetFunction (Display *display, GC gc, int func)
{
  CHKR_CHECK_DISPLAY (display);
#if USE_BI_JUMP
  __builtin_jump (XSetFunction);
#else
  return XSetFunction (display, gc, func);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetFunction */

#ifdef HAVE_XSetGraphicsExposures
/* From `/usr/include/X11/Xlib.h:3768'.  */
int chkr_stub_XSetGraphicsExposures (Display * arg0, GC arg1, int arg2) __asm__ (CHKR_PREFIX ("XSetGraphicsExposures"));
int
chkr_stub_XSetGraphicsExposures (Display * arg0, GC arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetGraphicsExposures);
#else
  return XSetGraphicsExposures (arg0, arg1, arg2);
  {
    int res;
    res = XSetGraphicsExposures (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetGraphicsExposures */

#ifdef HAVE_XSetIconName
/* From `/usr/include/X11/Xlib.h:3776'.  */
int chkr_stub_XSetIconName (Display * arg0, Window arg1, const char * arg2) __asm__ (CHKR_PREFIX ("XSetIconName"));
int
chkr_stub_XSetIconName (Display * arg0, Window arg1, const char * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (char), CHKR_RO, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XSetIconName);
#else
  return XSetIconName (arg0, arg1, arg2);
  {
    int res;
    res = XSetIconName (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetIconName */

#ifdef HAVE_XSetInputFocus
/* From `/usr/include/X11/Xlib.h:3785'.  */
int chkr_stub_XSetInputFocus (Display * arg0, Window arg1, int arg2, Time arg3) __asm__ (CHKR_PREFIX ("XSetInputFocus"));
int
chkr_stub_XSetInputFocus (Display * arg0, Window arg1, int arg2, Time arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetInputFocus);
#else
  return XSetInputFocus (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XSetInputFocus (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetInputFocus */

#ifdef HAVE_XSetLineAttributes
/* From `/usr/include/X11/Xlib.h:3796'.  */
int chkr_stub_XSetLineAttributes (Display * arg0, GC arg1, unsigned int arg2, int arg3, int arg4, int arg5) __asm__ (CHKR_PREFIX ("XSetLineAttributes"));
int
chkr_stub_XSetLineAttributes (Display * arg0, GC arg1, unsigned int arg2, int arg3, int arg4, int arg5)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetLineAttributes);
#else
  return XSetLineAttributes (arg0, arg1, arg2, arg3, arg4, arg5);
  {
    int res;
    res = XSetLineAttributes (arg0, arg1, arg2, arg3, arg4, arg5);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetLineAttributes */

#ifdef HAVE_XSetModifierMapping
/* From `/usr/include/X11/Xlib.h:3803'.  */
int chkr_stub_XSetModifierMapping (Display * arg0, XModifierKeymap * arg1) __asm__ (CHKR_PREFIX ("XSetModifierMapping"));
int
chkr_stub_XSetModifierMapping (Display * arg0, XModifierKeymap * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (XModifierKeymap), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XSetModifierMapping);
#else
  return XSetModifierMapping (arg0, arg1);
  {
    int res;
    res = XSetModifierMapping (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetModifierMapping */

#ifdef HAVE_XSetPlaneMask
/* From `/usr/include/X11/Xlib.h:3811'.  */
int chkr_stub_XSetPlaneMask (Display * arg0, GC arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("XSetPlaneMask"));
int
chkr_stub_XSetPlaneMask (Display * arg0, GC arg1, long unsigned int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetPlaneMask);
#else
  return XSetPlaneMask (arg0, arg1, arg2);
  {
    int res;
    res = XSetPlaneMask (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetPlaneMask */

#ifdef HAVE_XSetPointerMapping
/* From `/usr/include/X11/Xlib.h:3819'.  */
int chkr_stub_XSetPointerMapping (Display * arg0, const unsigned char * arg1, int arg2) __asm__ (CHKR_PREFIX ("XSetPointerMapping"));
int
chkr_stub_XSetPointerMapping (Display * arg0, const unsigned char * arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (unsigned char), CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XSetPointerMapping);
#else
  return XSetPointerMapping (arg0, arg1, arg2);
  {
    int res;
    res = XSetPointerMapping (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetPointerMapping */

#ifdef HAVE_XSetScreenSaver
/* From `/usr/include/X11/Xlib.h:3829'.  */
int chkr_stub_XSetScreenSaver (Display * arg0, int arg1, int arg2, int arg3, int arg4) __asm__ (CHKR_PREFIX ("XSetScreenSaver"));
int
chkr_stub_XSetScreenSaver (Display * arg0, int arg1, int arg2, int arg3, int arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetScreenSaver);
#else
  return XSetScreenSaver (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = XSetScreenSaver (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetScreenSaver */

#ifdef HAVE_XSetSelectionOwner
/* From `/usr/include/X11/Xlib.h:3838'.  */
int chkr_stub_XSetSelectionOwner (Display * arg0, Atom arg1, Window arg2, Time arg3) __asm__ (CHKR_PREFIX ("XSetSelectionOwner"));
int
chkr_stub_XSetSelectionOwner (Display * arg0, Atom arg1, Window arg2, Time arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetSelectionOwner);
#else
  return XSetSelectionOwner (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XSetSelectionOwner (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetSelectionOwner */

#ifdef HAVE_XSetState
/* From `/usr/include/X11/Xlib.h:3849'.  */
int chkr_stub_XSetState (Display * arg0, GC arg1, long unsigned int arg2, long unsigned int arg3, int arg4, long unsigned int arg5) __asm__ (CHKR_PREFIX ("XSetState"));
int
chkr_stub_XSetState (Display * arg0, GC arg1, long unsigned int arg2, long unsigned int arg3, int arg4, long unsigned int arg5)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetState);
#else
  return XSetState (arg0, arg1, arg2, arg3, arg4, arg5);
  {
    int res;
    res = XSetState (arg0, arg1, arg2, arg3, arg4, arg5);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetState */

#ifdef HAVE_XSetStipple
/* From `/usr/include/X11/Xlib.h:3857'.  */
int chkr_stub_XSetStipple (Display * arg0, GC arg1, Pixmap arg2) __asm__ (CHKR_PREFIX ("XSetStipple"));
int
chkr_stub_XSetStipple (Display * arg0, GC arg1, Pixmap arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetStipple);
#else
  return XSetStipple (arg0, arg1, arg2);
  {
    int res;
    res = XSetStipple (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetStipple */

#ifdef HAVE_XSetSubwindowMode
/* From `/usr/include/X11/Xlib.h:3865'.  */
int chkr_stub_XSetSubwindowMode (Display * arg0, GC arg1, int arg2) __asm__ (CHKR_PREFIX ("XSetSubwindowMode"));
int
chkr_stub_XSetSubwindowMode (Display * arg0, GC arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetSubwindowMode);
#else
  return XSetSubwindowMode (arg0, arg1, arg2);
  {
    int res;
    res = XSetSubwindowMode (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetSubwindowMode */

#ifdef HAVE_XSetTSOrigin
/* From `/usr/include/X11/Xlib.h:3874'.  */
int chkr_stub_XSetTSOrigin (Display * arg0, GC arg1, int arg2, int arg3) __asm__ (CHKR_PREFIX ("XSetTSOrigin"));
int
chkr_stub_XSetTSOrigin (Display * arg0, GC arg1, int arg2, int arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetTSOrigin);
#else
  return XSetTSOrigin (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XSetTSOrigin (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetTSOrigin */

#ifdef HAVE_XSetTile
/* From `/usr/include/X11/Xlib.h:3882'.  */
int chkr_stub_XSetTile (Display * arg0, GC arg1, Pixmap arg2) __asm__ (CHKR_PREFIX ("XSetTile"));
int
chkr_stub_XSetTile (Display * arg0, GC arg1, Pixmap arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetTile);
#else
  return XSetTile (arg0, arg1, arg2);
  {
    int res;
    res = XSetTile (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetTile */

#ifdef HAVE_XSetWindowBackground
/* From `/usr/include/X11/Xlib.h:3890'.  */
int chkr_stub_XSetWindowBackground (Display * arg0, Window arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("XSetWindowBackground"));
int
chkr_stub_XSetWindowBackground (Display * arg0, Window arg1, long unsigned int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetWindowBackground);
#else
  return XSetWindowBackground (arg0, arg1, arg2);
  {
    int res;
    res = XSetWindowBackground (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetWindowBackground */

#ifdef HAVE_XSetWindowBackgroundPixmap
/* From `/usr/include/X11/Xlib.h:3898'.  */
int chkr_stub_XSetWindowBackgroundPixmap (Display * arg0, Window arg1, Pixmap arg2) __asm__ (CHKR_PREFIX ("XSetWindowBackgroundPixmap"));
int
chkr_stub_XSetWindowBackgroundPixmap (Display * arg0, Window arg1, Pixmap arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetWindowBackgroundPixmap);
#else
  return XSetWindowBackgroundPixmap (arg0, arg1, arg2);
  {
    int res;
    res = XSetWindowBackgroundPixmap (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetWindowBackgroundPixmap */

#ifdef HAVE_XSetWindowBorder
/* From `/usr/include/X11/Xlib.h:3906'.  */
int chkr_stub_XSetWindowBorder (Display * arg0, Window arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("XSetWindowBorder"));
int
chkr_stub_XSetWindowBorder (Display * arg0, Window arg1, long unsigned int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetWindowBorder);
#else
  return XSetWindowBorder (arg0, arg1, arg2);
  {
    int res;
    res = XSetWindowBorder (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetWindowBorder */

#ifdef HAVE_XSetWindowBorderPixmap
/* From `/usr/include/X11/Xlib.h:3914'.  */
int chkr_stub_XSetWindowBorderPixmap (Display * arg0, Window arg1, Pixmap arg2) __asm__ (CHKR_PREFIX ("XSetWindowBorderPixmap"));
int
chkr_stub_XSetWindowBorderPixmap (Display * arg0, Window arg1, Pixmap arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetWindowBorderPixmap);
#else
  return XSetWindowBorderPixmap (arg0, arg1, arg2);
  {
    int res;
    res = XSetWindowBorderPixmap (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetWindowBorderPixmap */

#ifdef HAVE_XSetWindowBorderWidth
/* From `/usr/include/X11/Xlib.h:3922'.  */
int chkr_stub_XSetWindowBorderWidth (Display * arg0, Window arg1, unsigned int arg2) __asm__ (CHKR_PREFIX ("XSetWindowBorderWidth"));
int
chkr_stub_XSetWindowBorderWidth (Display * arg0, Window arg1, unsigned int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetWindowBorderWidth);
#else
  return XSetWindowBorderWidth (arg0, arg1, arg2);
  {
    int res;
    res = XSetWindowBorderWidth (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetWindowBorderWidth */

#ifdef HAVE_XSetWindowColormap
/* From `/usr/include/X11/Xlib.h:3930'.  */
int chkr_stub_XSetWindowColormap (Display * arg0, Window arg1, Colormap arg2) __asm__ (CHKR_PREFIX ("XSetWindowColormap"));
int
chkr_stub_XSetWindowColormap (Display * arg0, Window arg1, Colormap arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetWindowColormap);
#else
  return XSetWindowColormap (arg0, arg1, arg2);
  {
    int res;
    res = XSetWindowColormap (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetWindowColormap */

#ifdef HAVE_XStoreBuffer
/* From `/usr/include/X11/Xlib.h:3939'.  */
int chkr_stub_XStoreBuffer (Display * arg0, const char * arg1, int arg2, int arg3) __asm__ (CHKR_PREFIX ("XStoreBuffer"));
int
chkr_stub_XStoreBuffer (Display * arg0, const char * arg1, int arg2, int arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XStoreBuffer);
#else
  return XStoreBuffer (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XStoreBuffer (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XStoreBuffer */

#ifdef HAVE_XStoreBytes
/* From `/usr/include/X11/Xlib.h:3947'.  */
int chkr_stub_XStoreBytes (Display * arg0, const char * arg1, int arg2) __asm__ (CHKR_PREFIX ("XStoreBytes"));
int
chkr_stub_XStoreBytes (Display * arg0, const char * arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XStoreBytes);
#else
  return XStoreBytes (arg0, arg1, arg2);
  {
    int res;
    res = XStoreBytes (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XStoreBytes */

#ifdef HAVE_XStoreColor
/* From `/usr/include/X11/Xlib.h:3955'.  */
int chkr_stub_XStoreColor (Display * arg0, Colormap arg1, XColor * arg2) __asm__ (CHKR_PREFIX ("XStoreColor"));
int
chkr_stub_XStoreColor (Display * arg0, Colormap arg1, XColor * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (XColor), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XStoreColor);
#else
  return XStoreColor (arg0, arg1, arg2);
  {
    int res;
    res = XStoreColor (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XStoreColor */

#ifdef HAVE_XStoreColors
/* From `/usr/include/X11/Xlib.h:3964'.  */
int chkr_stub_XStoreColors (Display * arg0, Colormap arg1, XColor * arg2, int arg3) __asm__ (CHKR_PREFIX ("XStoreColors"));
int
chkr_stub_XStoreColors (Display * arg0, Colormap arg1, XColor * arg2, int arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (XColor), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XStoreColors);
#else
  return XStoreColors (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XStoreColors (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XStoreColors */

#ifdef HAVE_XStoreName
/* From `/usr/include/X11/Xlib.h:3972'.  */
int chkr_stub_XStoreName (Display * arg0, Window arg1, const char * arg2) __asm__ (CHKR_PREFIX ("XStoreName"));
int
chkr_stub_XStoreName (Display * arg0, Window arg1, const char * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (char), CHKR_RO, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XStoreName);
#else
  return XStoreName (arg0, arg1, arg2);
  {
    int res;
    res = XStoreName (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XStoreName */

#ifdef HAVE_XStoreNamedColor
/* From `/usr/include/X11/Xlib.h:3982'.  */
int chkr_stub_XStoreNamedColor (Display * arg0, Colormap arg1, const char * arg2, long unsigned int arg3, int arg4) __asm__ (CHKR_PREFIX ("XStoreNamedColor"));
int
chkr_stub_XStoreNamedColor (Display * arg0, Colormap arg1, const char * arg2, long unsigned int arg3, int arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (char), CHKR_RO, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XStoreNamedColor);
#else
  return XStoreNamedColor (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = XStoreNamedColor (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XStoreNamedColor */

#ifdef HAVE_XSync
/* From `/usr/include/X11/Xlib.h:3989'.  */
int chkr_stub_XSync (Display *display, Bool discard)
     __asm__ (CHKR_PREFIX ("XSync"));
int
chkr_stub_XSync (Display *display, Bool discard)
{
  CHKR_CHECK_DISPLAY (display);
#if USE_BI_JUMP
  __builtin_jump (XSync);
#else
  return XSync (display, discard);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSync */

#ifdef HAVE_XTextExtents
/* From `/usr/include/X11/Xlib.h:4001'.  */
int chkr_stub_XTextExtents (XFontStruct * arg0, const char * arg1, int arg2, int * arg3, int * arg4, int * arg5, XCharStruct * arg6) __asm__ (CHKR_PREFIX ("XTextExtents"));
int
chkr_stub_XTextExtents (XFontStruct * arg0, const char * arg1, int arg2, int * arg3, int * arg4, int * arg5, XCharStruct * arg6)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (XFontStruct), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
  stubs_chkr_check_addr (arg3, sizeof (int), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg4, sizeof (int), CHKR_XX, "arg4");
  stubs_chkr_check_addr (arg5, sizeof (int), CHKR_XX, "arg5");
  stubs_chkr_check_addr (arg6, sizeof (XCharStruct), CHKR_XX, "arg6");
#if USE_BI_JUMP
  __builtin_jump (XTextExtents);
#else
  return XTextExtents (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
  {
    int res;
    res = XTextExtents (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XTextExtents */

#ifdef HAVE_XTextExtents16
/* From `/usr/include/X11/Xlib.h:4013'.  */
int chkr_stub_XTextExtents16 (XFontStruct * arg0, const XChar2b * arg1, int arg2, int * arg3, int * arg4, int * arg5, XCharStruct * arg6) __asm__ (CHKR_PREFIX ("XTextExtents16"));
int
chkr_stub_XTextExtents16 (XFontStruct * arg0, const XChar2b * arg1, int arg2, int * arg3, int * arg4, int * arg5, XCharStruct * arg6)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (XFontStruct), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (XChar2b), CHKR_RO, "arg1");
  stubs_chkr_check_addr (arg3, sizeof (int), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg4, sizeof (int), CHKR_XX, "arg4");
  stubs_chkr_check_addr (arg5, sizeof (int), CHKR_XX, "arg5");
  stubs_chkr_check_addr (arg6, sizeof (XCharStruct), CHKR_XX, "arg6");
#if USE_BI_JUMP
  __builtin_jump (XTextExtents16);
#else
  return XTextExtents16 (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
  {
    int res;
    res = XTextExtents16 (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XTextExtents16 */

#ifdef HAVE_XTextWidth
/* From `/usr/include/X11/Xlib.h:4021'.  */
int chkr_stub_XTextWidth (XFontStruct * arg0, const char * arg1, int arg2) __asm__ (CHKR_PREFIX ("XTextWidth"));
int
chkr_stub_XTextWidth (XFontStruct * arg0, const char * arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (XFontStruct), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XTextWidth);
#else
  return XTextWidth (arg0, arg1, arg2);
  {
    int res;
    res = XTextWidth (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XTextWidth */

#ifdef HAVE_XTextWidth16
/* From `/usr/include/X11/Xlib.h:4029'.  */
int chkr_stub_XTextWidth16 (XFontStruct * arg0, const XChar2b * arg1, int arg2) __asm__ (CHKR_PREFIX ("XTextWidth16"));
int
chkr_stub_XTextWidth16 (XFontStruct * arg0, const XChar2b * arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (XFontStruct), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (XChar2b), CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XTextWidth16);
#else
  return XTextWidth16 (arg0, arg1, arg2);
  {
    int res;
    res = XTextWidth16 (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XTextWidth16 */

#ifdef HAVE_XTranslateCoordinates
/* From `/usr/include/X11/Xlib.h:4042'.  */
int chkr_stub_XTranslateCoordinates (Display * arg0, Window arg1, Window arg2, int arg3, int arg4, int * arg5, int * arg6, Window * arg7) __asm__ (CHKR_PREFIX ("XTranslateCoordinates"));
int
chkr_stub_XTranslateCoordinates (Display * arg0, Window arg1, Window arg2, int arg3, int arg4, int * arg5, int * arg6, Window * arg7)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg5, sizeof (int), CHKR_XX, "arg5");
  stubs_chkr_check_addr (arg6, sizeof (int), CHKR_XX, "arg6");
  stubs_chkr_check_addr (arg7, sizeof (Window), CHKR_XX, "arg7");
#if USE_BI_JUMP
  __builtin_jump (XTranslateCoordinates);
#else
  return XTranslateCoordinates (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
  {
    int res;
    res = XTranslateCoordinates (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XTranslateCoordinates */

#ifdef HAVE_XUndefineCursor
/* From `/usr/include/X11/Xlib.h:4049'.  */
int chkr_stub_XUndefineCursor (Display * arg0, Window arg1) __asm__ (CHKR_PREFIX ("XUndefineCursor"));
int
chkr_stub_XUndefineCursor (Display * arg0, Window arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XUndefineCursor);
#else
  return XUndefineCursor (arg0, arg1);
  {
    int res;
    res = XUndefineCursor (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XUndefineCursor */

#ifdef HAVE_XUngrabButton
/* From `/usr/include/X11/Xlib.h:4058'.  */
int chkr_stub_XUngrabButton (Display * arg0, unsigned int arg1, unsigned int arg2, Window arg3) __asm__ (CHKR_PREFIX ("XUngrabButton"));
int
chkr_stub_XUngrabButton (Display * arg0, unsigned int arg1, unsigned int arg2, Window arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XUngrabButton);
#else
  return XUngrabButton (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XUngrabButton (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XUngrabButton */

#ifdef HAVE_XUngrabKey
/* From `/usr/include/X11/Xlib.h:4067'.  */
int chkr_stub_XUngrabKey (Display * arg0, int arg1, unsigned int arg2, Window arg3) __asm__ (CHKR_PREFIX ("XUngrabKey"));
int
chkr_stub_XUngrabKey (Display * arg0, int arg1, unsigned int arg2, Window arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XUngrabKey);
#else
  return XUngrabKey (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XUngrabKey (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XUngrabKey */

#ifdef HAVE_XUngrabKeyboard
/* From `/usr/include/X11/Xlib.h:4074'.  */
int chkr_stub_XUngrabKeyboard (Display * arg0, Time arg1) __asm__ (CHKR_PREFIX ("XUngrabKeyboard"));
int
chkr_stub_XUngrabKeyboard (Display * arg0, Time arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XUngrabKeyboard);
#else
  return XUngrabKeyboard (arg0, arg1);
  {
    int res;
    res = XUngrabKeyboard (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XUngrabKeyboard */

#ifdef HAVE_XUngrabPointer
/* From `/usr/include/X11/Xlib.h:4081'.  */
int chkr_stub_XUngrabPointer (Display * arg0, Time arg1) __asm__ (CHKR_PREFIX ("XUngrabPointer"));
int
chkr_stub_XUngrabPointer (Display * arg0, Time arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XUngrabPointer);
#else
  return XUngrabPointer (arg0, arg1);
  {
    int res;
    res = XUngrabPointer (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XUngrabPointer */

#ifdef HAVE_XUngrabServer
/* From `/usr/include/X11/Xlib.h:4087'.  */
int chkr_stub_XUngrabServer (Display * arg0) __asm__ (CHKR_PREFIX ("XUngrabServer"));
int
chkr_stub_XUngrabServer (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XUngrabServer);
#else
  return XUngrabServer (arg0);
  {
    int res;
    res = XUngrabServer (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XUngrabServer */

#ifdef HAVE_XUninstallColormap
/* From `/usr/include/X11/Xlib.h:4094'.  */
int chkr_stub_XUninstallColormap (Display * arg0, Colormap arg1) __asm__ (CHKR_PREFIX ("XUninstallColormap"));
int
chkr_stub_XUninstallColormap (Display * arg0, Colormap arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XUninstallColormap);
#else
  return XUninstallColormap (arg0, arg1);
  {
    int res;
    res = XUninstallColormap (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XUninstallColormap */

#ifdef HAVE_XUnloadFont
/* From `/usr/include/X11/Xlib.h:4101'.  */
int chkr_stub_XUnloadFont (Display * arg0, Font arg1) __asm__ (CHKR_PREFIX ("XUnloadFont"));
int
chkr_stub_XUnloadFont (Display * arg0, Font arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XUnloadFont);
#else
  return XUnloadFont (arg0, arg1);
  {
    int res;
    res = XUnloadFont (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XUnloadFont */

#ifdef HAVE_XUnmapSubwindows
/* From `/usr/include/X11/Xlib.h:4108'.  */
int chkr_stub_XUnmapSubwindows (Display * arg0, Window arg1) __asm__ (CHKR_PREFIX ("XUnmapSubwindows"));
int
chkr_stub_XUnmapSubwindows (Display * arg0, Window arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XUnmapSubwindows);
#else
  return XUnmapSubwindows (arg0, arg1);
  {
    int res;
    res = XUnmapSubwindows (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XUnmapSubwindows */

#ifdef HAVE_XUnmapWindow
/* From `/usr/include/X11/Xlib.h:4115'.  */
int chkr_stub_XUnmapWindow (Display * arg0, Window arg1) __asm__ (CHKR_PREFIX ("XUnmapWindow"));
int
chkr_stub_XUnmapWindow (Display * arg0, Window arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XUnmapWindow);
#else
  return XUnmapWindow (arg0, arg1);
  {
    int res;
    res = XUnmapWindow (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XUnmapWindow */

#ifdef HAVE_XVendorRelease
/* From `/usr/include/X11/Xlib.h:4121'.  */
int chkr_stub_XVendorRelease (Display * arg0) __asm__ (CHKR_PREFIX ("XVendorRelease"));
int
chkr_stub_XVendorRelease (Display * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XVendorRelease);
#else
  return XVendorRelease (arg0);
  {
    int res;
    res = XVendorRelease (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XVendorRelease */

#ifdef HAVE_XWarpPointer
/* From `/usr/include/X11/Xlib.h:4135'.  */
int chkr_stub_XWarpPointer (Display * arg0, Window arg1, Window arg2, int arg3, int arg4, unsigned int arg5, unsigned int arg6, int arg7, int arg8) __asm__ (CHKR_PREFIX ("XWarpPointer"));
int
chkr_stub_XWarpPointer (Display * arg0, Window arg1, Window arg2, int arg3, int arg4, unsigned int arg5, unsigned int arg6, int arg7, int arg8)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XWarpPointer);
#else
  return XWarpPointer (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
  {
    int res;
    res = XWarpPointer (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XWarpPointer */

#ifdef HAVE_XWidthMMOfScreen
/* From `/usr/include/X11/Xlib.h:4141'.  */
int chkr_stub_XWidthMMOfScreen (Screen * arg0) __asm__ (CHKR_PREFIX ("XWidthMMOfScreen"));
int
chkr_stub_XWidthMMOfScreen (Screen * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Screen), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XWidthMMOfScreen);
#else
  return XWidthMMOfScreen (arg0);
  {
    int res;
    res = XWidthMMOfScreen (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XWidthMMOfScreen */

#ifdef HAVE_XWidthOfScreen
/* From `/usr/include/X11/Xlib.h:4147'.  */
int chkr_stub_XWidthOfScreen (Screen * arg0) __asm__ (CHKR_PREFIX ("XWidthOfScreen"));
int
chkr_stub_XWidthOfScreen (Screen * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Screen), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XWidthOfScreen);
#else
  return XWidthOfScreen (arg0);
  {
    int res;
    res = XWidthOfScreen (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XWidthOfScreen */

#ifdef HAVE_XWindowEvent
/* From `/usr/include/X11/Xlib.h:4156'.  */
int chkr_stub_XWindowEvent (Display * arg0, Window arg1, long int arg2, XEvent * arg3) __asm__ (CHKR_PREFIX ("XWindowEvent"));
int
chkr_stub_XWindowEvent (Display * arg0, Window arg1, long int arg2, XEvent * arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg3, sizeof (XEvent), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XWindowEvent);
#else
  return XWindowEvent (arg0, arg1, arg2, arg3);
  {
    int res;
    res = XWindowEvent (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XWindowEvent */

#ifdef HAVE_XWriteBitmapFile
/* From `/usr/include/X11/Xlib.h:4168'.  */
int chkr_stub_XWriteBitmapFile (Display * arg0, const char * arg1, Pixmap arg2, unsigned int arg3, unsigned int arg4, int arg5, int arg6) __asm__ (CHKR_PREFIX ("XWriteBitmapFile"));
int
chkr_stub_XWriteBitmapFile (Display * arg0, const char * arg1, Pixmap arg2, unsigned int arg3, unsigned int arg4, int arg5, int arg6)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XWriteBitmapFile);
#else
  return XWriteBitmapFile (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
  {
    int res;
    res = XWriteBitmapFile (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XWriteBitmapFile */

#ifdef HAVE_XSupportsLocale
/* From `/usr/include/X11/Xlib.h:4174'.  */
int chkr_stub_XSupportsLocale (void)
     __asm__ (CHKR_PREFIX ("XSupportsLocale"));
int
chkr_stub_XSupportsLocale (void)
{
#if USE_BI_JUMP
  __builtin_jump (XSupportsLocale);
#else
  return XSupportsLocale ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSupportsLocale */

#ifdef HAVE_XSetLocaleModifiers
/* From `/usr/include/X11/Xlib.h:4180'.  */
char * chkr_stub_XSetLocaleModifiers (const char * arg0) __asm__ (CHKR_PREFIX ("XSetLocaleModifiers"));
char *
chkr_stub_XSetLocaleModifiers (const char * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (char), CHKR_RO, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XSetLocaleModifiers);
#else
  return XSetLocaleModifiers (arg0);
  {
    char * res;
    res = XSetLocaleModifiers (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetLocaleModifiers */

#ifdef HAVE_XOpenOM
/* From `/usr/include/X11/Xlib.h:4189'.  */
XOM chkr_stub_XOpenOM (Display * arg0, struct _XrmHashBucketRec * arg1, const char * arg2, const char * arg3) __asm__ (CHKR_PREFIX ("XOpenOM"));
XOM
chkr_stub_XOpenOM (Display * arg0, struct _XrmHashBucketRec * arg1, const char * arg2, const char * arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (struct _XrmHashBucketRec), CHKR_XX, "arg1");
  stubs_chkr_check_addr (arg2, sizeof (char), CHKR_RO, "arg2");
  stubs_chkr_check_addr (arg3, sizeof (char), CHKR_RO, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XOpenOM);
#else
  return XOpenOM (arg0, arg1, arg2, arg3);
  {
    XOM res;
    res = XOpenOM (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XOpenOM */

#ifdef HAVE_XCloseOM
/* From `/usr/include/X11/Xlib.h:4195'.  */
int chkr_stub_XCloseOM (XOM arg0) __asm__ (CHKR_PREFIX ("XCloseOM"));
int
chkr_stub_XCloseOM (XOM arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XCloseOM);
#else
  return XCloseOM (arg0);
  {
    int res;
    res = XCloseOM (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCloseOM */

#ifdef HAVE_XSetOMValues
/* From `/usr/include/X11/Xlib.h:4202'.  */
char * chkr_stub_XSetOMValues (XOM arg0, ... ) __asm__ (CHKR_PREFIX ("XSetOMValues"));
char *
chkr_stub_XSetOMValues (XOM arg0, ... )
{
  /* This function must be handled by the user */
#if USE_BI_JUMP
  __builtin_jump (XSetOMValues);
#else
  return XSetOMValues (arg0, );
  {
    char * res;
    res = XSetOMValues (arg0, );
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetOMValues */

#ifdef HAVE_XGetOMValues
/* From `/usr/include/X11/Xlib.h:4209'.  */
char * chkr_stub_XGetOMValues (XOM arg0, ... ) __asm__ (CHKR_PREFIX ("XGetOMValues"));
char *
chkr_stub_XGetOMValues (XOM arg0, ... )
{
  /* This function must be handled by the user */
#if USE_BI_JUMP
  __builtin_jump (XGetOMValues);
#else
  return XGetOMValues (arg0, );
  {
    char * res;
    res = XGetOMValues (arg0, );
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetOMValues */

#ifdef HAVE_XDisplayOfOM
/* From `/usr/include/X11/Xlib.h:4215'.  */
Display * chkr_stub_XDisplayOfOM (XOM arg0) __asm__ (CHKR_PREFIX ("XDisplayOfOM"));
Display *
chkr_stub_XDisplayOfOM (XOM arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XDisplayOfOM);
#else
  return XDisplayOfOM (arg0);
  {
    Display * res;
    res = XDisplayOfOM (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDisplayOfOM */

#ifdef HAVE_XLocaleOfOM
/* From `/usr/include/X11/Xlib.h:4221'.  */
char * chkr_stub_XLocaleOfOM (XOM arg0) __asm__ (CHKR_PREFIX ("XLocaleOfOM"));
char *
chkr_stub_XLocaleOfOM (XOM arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XLocaleOfOM);
#else
  return XLocaleOfOM (arg0);
  {
    char * res;
    res = XLocaleOfOM (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XLocaleOfOM */

#ifdef HAVE_XCreateOC
/* From `/usr/include/X11/Xlib.h:4228'.  */
XOC chkr_stub_XCreateOC (XOM arg0, ... ) __asm__ (CHKR_PREFIX ("XCreateOC"));
XOC
chkr_stub_XCreateOC (XOM arg0, ... )
{
  /* This function must be handled by the user */
#if USE_BI_JUMP
  __builtin_jump (XCreateOC);
#else
  return XCreateOC (arg0, );
  {
    XOC res;
    res = XCreateOC (arg0, );
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCreateOC */

#ifdef HAVE_XDestroyOC
/* From `/usr/include/X11/Xlib.h:4234'.  */
void chkr_stub_XDestroyOC (XOC arg0) __asm__ (CHKR_PREFIX ("XDestroyOC"));
void
chkr_stub_XDestroyOC (XOC arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XDestroyOC);
#else
  XDestroyOC (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDestroyOC */

#ifdef HAVE_XOMOfOC
/* From `/usr/include/X11/Xlib.h:4240'.  */
XOM chkr_stub_XOMOfOC (XOC arg0) __asm__ (CHKR_PREFIX ("XOMOfOC"));
XOM
chkr_stub_XOMOfOC (XOC arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XOMOfOC);
#else
  return XOMOfOC (arg0);
  {
    XOM res;
    res = XOMOfOC (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XOMOfOC */

#ifdef HAVE_XSetOCValues
/* From `/usr/include/X11/Xlib.h:4247'.  */
char * chkr_stub_XSetOCValues (XOC arg0, ... ) __asm__ (CHKR_PREFIX ("XSetOCValues"));
char *
chkr_stub_XSetOCValues (XOC arg0, ... )
{
  /* This function must be handled by the user */
#if USE_BI_JUMP
  __builtin_jump (XSetOCValues);
#else
  return XSetOCValues (arg0, );
  {
    char * res;
    res = XSetOCValues (arg0, );
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetOCValues */

#ifdef HAVE_XGetOCValues
/* From `/usr/include/X11/Xlib.h:4254'.  */
char * chkr_stub_XGetOCValues (XOC arg0, ... ) __asm__ (CHKR_PREFIX ("XGetOCValues"));
char *
chkr_stub_XGetOCValues (XOC arg0, ... )
{
  /* This function must be handled by the user */
#if USE_BI_JUMP
  __builtin_jump (XGetOCValues);
#else
  return XGetOCValues (arg0, );
  {
    char * res;
    res = XGetOCValues (arg0, );
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetOCValues */

#ifdef HAVE_XCreateFontSet
/* From `/usr/include/X11/Xlib.h:4264'.  */
XFontSet chkr_stub_XCreateFontSet (Display * arg0, const char * arg1, char *** arg2, int * arg3, char ** arg4) __asm__ (CHKR_PREFIX ("XCreateFontSet"));
XFontSet
chkr_stub_XCreateFontSet (Display * arg0, const char * arg1, char *** arg2, int * arg3, char ** arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
  stubs_chkr_check_addr (arg2, sizeof (char **), CHKR_XX, "arg2");
  stubs_chkr_check_addr (arg3, sizeof (int), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg4, sizeof (char *), CHKR_XX, "arg4");
#if USE_BI_JUMP
  __builtin_jump (XCreateFontSet);
#else
  return XCreateFontSet (arg0, arg1, arg2, arg3, arg4);
  {
    XFontSet res;
    res = XCreateFontSet (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCreateFontSet */

#ifdef HAVE_XFreeFontSet
/* From `/usr/include/X11/Xlib.h:4271'.  */
void chkr_stub_XFreeFontSet (Display * arg0, XFontSet arg1) __asm__ (CHKR_PREFIX ("XFreeFontSet"));
void
chkr_stub_XFreeFontSet (Display * arg0, XFontSet arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XFreeFontSet);
#else
  XFreeFontSet (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFreeFontSet */

#ifdef HAVE_XFontsOfFontSet
/* From `/usr/include/X11/Xlib.h:4279'.  */
int chkr_stub_XFontsOfFontSet (XFontSet arg0, XFontStruct *** arg1, char *** arg2) __asm__ (CHKR_PREFIX ("XFontsOfFontSet"));
int
chkr_stub_XFontsOfFontSet (XFontSet arg0, XFontStruct *** arg1, char *** arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg1, sizeof (XFontStruct **), CHKR_XX, "arg1");
  stubs_chkr_check_addr (arg2, sizeof (char **), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XFontsOfFontSet);
#else
  return XFontsOfFontSet (arg0, arg1, arg2);
  {
    int res;
    res = XFontsOfFontSet (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFontsOfFontSet */

#ifdef HAVE_XBaseFontNameListOfFontSet
/* From `/usr/include/X11/Xlib.h:4285'.  */
char * chkr_stub_XBaseFontNameListOfFontSet (XFontSet arg0) __asm__ (CHKR_PREFIX ("XBaseFontNameListOfFontSet"));
char *
chkr_stub_XBaseFontNameListOfFontSet (XFontSet arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XBaseFontNameListOfFontSet);
#else
  return XBaseFontNameListOfFontSet (arg0);
  {
    char * res;
    res = XBaseFontNameListOfFontSet (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XBaseFontNameListOfFontSet */

#ifdef HAVE_XLocaleOfFontSet
/* From `/usr/include/X11/Xlib.h:4291'.  */
char * chkr_stub_XLocaleOfFontSet (XFontSet arg0) __asm__ (CHKR_PREFIX ("XLocaleOfFontSet"));
char *
chkr_stub_XLocaleOfFontSet (XFontSet arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XLocaleOfFontSet);
#else
  return XLocaleOfFontSet (arg0);
  {
    char * res;
    res = XLocaleOfFontSet (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XLocaleOfFontSet */

#ifdef HAVE_XContextDependentDrawing
/* From `/usr/include/X11/Xlib.h:4297'.  */
int chkr_stub_XContextDependentDrawing (XFontSet arg0) __asm__ (CHKR_PREFIX ("XContextDependentDrawing"));
int
chkr_stub_XContextDependentDrawing (XFontSet arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XContextDependentDrawing);
#else
  return XContextDependentDrawing (arg0);
  {
    int res;
    res = XContextDependentDrawing (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XContextDependentDrawing */

#ifdef HAVE_XDirectionalDependentDrawing
/* From `/usr/include/X11/Xlib.h:4303'.  */
int chkr_stub_XDirectionalDependentDrawing (XFontSet arg0) __asm__ (CHKR_PREFIX ("XDirectionalDependentDrawing"));
int
chkr_stub_XDirectionalDependentDrawing (XFontSet arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XDirectionalDependentDrawing);
#else
  return XDirectionalDependentDrawing (arg0);
  {
    int res;
    res = XDirectionalDependentDrawing (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDirectionalDependentDrawing */

#ifdef HAVE_XContextualDrawing
/* From `/usr/include/X11/Xlib.h:4309'.  */
int chkr_stub_XContextualDrawing (XFontSet arg0) __asm__ (CHKR_PREFIX ("XContextualDrawing"));
int
chkr_stub_XContextualDrawing (XFontSet arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XContextualDrawing);
#else
  return XContextualDrawing (arg0);
  {
    int res;
    res = XContextualDrawing (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XContextualDrawing */

#ifdef HAVE_XExtentsOfFontSet
/* From `/usr/include/X11/Xlib.h:4315'.  */
XFontSetExtents * chkr_stub_XExtentsOfFontSet (XFontSet arg0) __asm__ (CHKR_PREFIX ("XExtentsOfFontSet"));
XFontSetExtents *
chkr_stub_XExtentsOfFontSet (XFontSet arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XExtentsOfFontSet);
#else
  return XExtentsOfFontSet (arg0);
  {
    XFontSetExtents * res;
    res = XExtentsOfFontSet (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XExtentsOfFontSet */

#ifdef HAVE_XmbTextEscapement
/* From `/usr/include/X11/Xlib.h:4323'.  */
int chkr_stub_XmbTextEscapement (XFontSet arg0, const char * arg1, int arg2) __asm__ (CHKR_PREFIX ("XmbTextEscapement"));
int
chkr_stub_XmbTextEscapement (XFontSet arg0, const char * arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XmbTextEscapement);
#else
  return XmbTextEscapement (arg0, arg1, arg2);
  {
    int res;
    res = XmbTextEscapement (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XmbTextEscapement */

#ifdef HAVE_XwcTextEscapement
/* From `/usr/include/X11/Xlib.h:4331'.  */
int chkr_stub_XwcTextEscapement (XFontSet arg0, const wchar_t * arg1, int arg2) __asm__ (CHKR_PREFIX ("XwcTextEscapement"));
int
chkr_stub_XwcTextEscapement (XFontSet arg0, const wchar_t * arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg1, sizeof (wchar_t), CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (XwcTextEscapement);
#else
  return XwcTextEscapement (arg0, arg1, arg2);
  {
    int res;
    res = XwcTextEscapement (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XwcTextEscapement */

#ifdef HAVE_XmbTextExtents
/* From `/usr/include/X11/Xlib.h:4341'.  */
int chkr_stub_XmbTextExtents (XFontSet arg0, const char * arg1, int arg2, XRectangle * arg3, XRectangle * arg4) __asm__ (CHKR_PREFIX ("XmbTextExtents"));
int
chkr_stub_XmbTextExtents (XFontSet arg0, const char * arg1, int arg2, XRectangle * arg3, XRectangle * arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
  stubs_chkr_check_addr (arg3, sizeof (XRectangle), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg4, sizeof (XRectangle), CHKR_XX, "arg4");
#if USE_BI_JUMP
  __builtin_jump (XmbTextExtents);
#else
  return XmbTextExtents (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = XmbTextExtents (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XmbTextExtents */

#ifdef HAVE_XwcTextExtents
/* From `/usr/include/X11/Xlib.h:4351'.  */
int chkr_stub_XwcTextExtents (XFontSet arg0, const wchar_t * arg1, int arg2, XRectangle * arg3, XRectangle * arg4) __asm__ (CHKR_PREFIX ("XwcTextExtents"));
int
chkr_stub_XwcTextExtents (XFontSet arg0, const wchar_t * arg1, int arg2, XRectangle * arg3, XRectangle * arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg1, sizeof (wchar_t), CHKR_RO, "arg1");
  stubs_chkr_check_addr (arg3, sizeof (XRectangle), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg4, sizeof (XRectangle), CHKR_XX, "arg4");
#if USE_BI_JUMP
  __builtin_jump (XwcTextExtents);
#else
  return XwcTextExtents (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = XwcTextExtents (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XwcTextExtents */

#ifdef HAVE_XmbTextPerCharExtents
/* From `/usr/include/X11/Xlib.h:4365'.  */
int chkr_stub_XmbTextPerCharExtents (XFontSet arg0, const char * arg1, int arg2, XRectangle * arg3, XRectangle * arg4, int arg5, int * arg6, XRectangle * arg7, XRectangle * arg8) __asm__ (CHKR_PREFIX ("XmbTextPerCharExtents"));
int
chkr_stub_XmbTextPerCharExtents (XFontSet arg0, const char * arg1, int arg2, XRectangle * arg3, XRectangle * arg4, int arg5, int * arg6, XRectangle * arg7, XRectangle * arg8)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
  stubs_chkr_check_addr (arg3, sizeof (XRectangle), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg4, sizeof (XRectangle), CHKR_XX, "arg4");
  stubs_chkr_check_addr (arg6, sizeof (int), CHKR_XX, "arg6");
  stubs_chkr_check_addr (arg7, sizeof (XRectangle), CHKR_XX, "arg7");
  stubs_chkr_check_addr (arg8, sizeof (XRectangle), CHKR_XX, "arg8");
#if USE_BI_JUMP
  __builtin_jump (XmbTextPerCharExtents);
#else
  return XmbTextPerCharExtents (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
  {
    int res;
    res = XmbTextPerCharExtents (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XmbTextPerCharExtents */

#ifdef HAVE_XwcTextPerCharExtents
/* From `/usr/include/X11/Xlib.h:4379'.  */
int chkr_stub_XwcTextPerCharExtents (XFontSet arg0, const wchar_t * arg1, int arg2, XRectangle * arg3, XRectangle * arg4, int arg5, int * arg6, XRectangle * arg7, XRectangle * arg8) __asm__ (CHKR_PREFIX ("XwcTextPerCharExtents"));
int
chkr_stub_XwcTextPerCharExtents (XFontSet arg0, const wchar_t * arg1, int arg2, XRectangle * arg3, XRectangle * arg4, int arg5, int * arg6, XRectangle * arg7, XRectangle * arg8)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg1, sizeof (wchar_t), CHKR_RO, "arg1");
  stubs_chkr_check_addr (arg3, sizeof (XRectangle), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg4, sizeof (XRectangle), CHKR_XX, "arg4");
  stubs_chkr_check_addr (arg6, sizeof (int), CHKR_XX, "arg6");
  stubs_chkr_check_addr (arg7, sizeof (XRectangle), CHKR_XX, "arg7");
  stubs_chkr_check_addr (arg8, sizeof (XRectangle), CHKR_XX, "arg8");
#if USE_BI_JUMP
  __builtin_jump (XwcTextPerCharExtents);
#else
  return XwcTextPerCharExtents (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
  {
    int res;
    res = XwcTextPerCharExtents (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XwcTextPerCharExtents */

#ifdef HAVE_XmbDrawText
/* From `/usr/include/X11/Xlib.h:4391'.  */
void chkr_stub_XmbDrawText (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, XmbTextItem * arg5, int arg6) __asm__ (CHKR_PREFIX ("XmbDrawText"));
void
chkr_stub_XmbDrawText (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, XmbTextItem * arg5, int arg6)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg5, sizeof (XmbTextItem), CHKR_XX, "arg5");
#if USE_BI_JUMP
  __builtin_jump (XmbDrawText);
#else
  XmbDrawText (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XmbDrawText */

#ifdef HAVE_XwcDrawText
/* From `/usr/include/X11/Xlib.h:4403'.  */
void chkr_stub_XwcDrawText (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, XwcTextItem * arg5, int arg6) __asm__ (CHKR_PREFIX ("XwcDrawText"));
void
chkr_stub_XwcDrawText (Display * arg0, Drawable arg1, GC arg2, int arg3, int arg4, XwcTextItem * arg5, int arg6)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg5, sizeof (XwcTextItem), CHKR_XX, "arg5");
#if USE_BI_JUMP
  __builtin_jump (XwcDrawText);
#else
  XwcDrawText (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XwcDrawText */

#ifdef HAVE_XmbDrawString
/* From `/usr/include/X11/Xlib.h:4416'.  */
void chkr_stub_XmbDrawString (Display * arg0, Drawable arg1, XFontSet arg2, GC arg3, int arg4, int arg5, const char * arg6, int arg7) __asm__ (CHKR_PREFIX ("XmbDrawString"));
void
chkr_stub_XmbDrawString (Display * arg0, Drawable arg1, XFontSet arg2, GC arg3, int arg4, int arg5, const char * arg6, int arg7)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg6, sizeof (char), CHKR_RO, "arg6");
#if USE_BI_JUMP
  __builtin_jump (XmbDrawString);
#else
  XmbDrawString (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XmbDrawString */

#ifdef HAVE_XwcDrawString
/* From `/usr/include/X11/Xlib.h:4429'.  */
void chkr_stub_XwcDrawString (Display * arg0, Drawable arg1, XFontSet arg2, GC arg3, int arg4, int arg5, const wchar_t * arg6, int arg7) __asm__ (CHKR_PREFIX ("XwcDrawString"));
void
chkr_stub_XwcDrawString (Display * arg0, Drawable arg1, XFontSet arg2, GC arg3, int arg4, int arg5, const wchar_t * arg6, int arg7)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg6, sizeof (wchar_t), CHKR_RO, "arg6");
#if USE_BI_JUMP
  __builtin_jump (XwcDrawString);
#else
  XwcDrawString (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XwcDrawString */

#ifdef HAVE_XmbDrawImageString
/* From `/usr/include/X11/Xlib.h:4442'.  */
void chkr_stub_XmbDrawImageString (Display * arg0, Drawable arg1, XFontSet arg2, GC arg3, int arg4, int arg5, const char * arg6, int arg7) __asm__ (CHKR_PREFIX ("XmbDrawImageString"));
void
chkr_stub_XmbDrawImageString (Display * arg0, Drawable arg1, XFontSet arg2, GC arg3, int arg4, int arg5, const char * arg6, int arg7)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg6, sizeof (char), CHKR_RO, "arg6");
#if USE_BI_JUMP
  __builtin_jump (XmbDrawImageString);
#else
  XmbDrawImageString (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XmbDrawImageString */

#ifdef HAVE_XwcDrawImageString
/* From `/usr/include/X11/Xlib.h:4455'.  */
void chkr_stub_XwcDrawImageString (Display * arg0, Drawable arg1, XFontSet arg2, GC arg3, int arg4, int arg5, const wchar_t * arg6, int arg7) __asm__ (CHKR_PREFIX ("XwcDrawImageString"));
void
chkr_stub_XwcDrawImageString (Display * arg0, Drawable arg1, XFontSet arg2, GC arg3, int arg4, int arg5, const wchar_t * arg6, int arg7)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg6, sizeof (wchar_t), CHKR_RO, "arg6");
#if USE_BI_JUMP
  __builtin_jump (XwcDrawImageString);
#else
  XwcDrawImageString (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XwcDrawImageString */

#ifdef HAVE_XOpenIM
/* From `/usr/include/X11/Xlib.h:4464'.  */
XIM chkr_stub_XOpenIM (Display * arg0, struct _XrmHashBucketRec * arg1, char * arg2, char * arg3) __asm__ (CHKR_PREFIX ("XOpenIM"));
XIM
chkr_stub_XOpenIM (Display * arg0, struct _XrmHashBucketRec * arg1, char * arg2, char * arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (struct _XrmHashBucketRec), CHKR_XX, "arg1");
  stubs_chkr_check_addr (arg2, sizeof (char), CHKR_XX, "arg2");
  stubs_chkr_check_addr (arg3, sizeof (char), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (XOpenIM);
#else
  return XOpenIM (arg0, arg1, arg2, arg3);
  {
    XIM res;
    res = XOpenIM (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XOpenIM */

#ifdef HAVE_XCloseIM
/* From `/usr/include/X11/Xlib.h:4470'.  */
int chkr_stub_XCloseIM (XIM arg0) __asm__ (CHKR_PREFIX ("XCloseIM"));
int
chkr_stub_XCloseIM (XIM arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XCloseIM);
#else
  return XCloseIM (arg0);
  {
    int res;
    res = XCloseIM (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCloseIM */

#ifdef HAVE_XGetIMValues
/* From `/usr/include/X11/Xlib.h:4476'.  */
char * chkr_stub_XGetIMValues (XIM arg0, ... ) __asm__ (CHKR_PREFIX ("XGetIMValues"));
char *
chkr_stub_XGetIMValues (XIM arg0, ... )
{
  /* This function must be handled by the user */
#if USE_BI_JUMP
  __builtin_jump (XGetIMValues);
#else
  return XGetIMValues (arg0, );
  {
    char * res;
    res = XGetIMValues (arg0, );
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetIMValues */

#ifdef HAVE_XDisplayOfIM
/* From `/usr/include/X11/Xlib.h:4482'.  */
Display * chkr_stub_XDisplayOfIM (XIM arg0) __asm__ (CHKR_PREFIX ("XDisplayOfIM"));
Display *
chkr_stub_XDisplayOfIM (XIM arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XDisplayOfIM);
#else
  return XDisplayOfIM (arg0);
  {
    Display * res;
    res = XDisplayOfIM (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDisplayOfIM */

#ifdef HAVE_XLocaleOfIM
/* From `/usr/include/X11/Xlib.h:4488'.  */
char * chkr_stub_XLocaleOfIM (XIM arg0) __asm__ (CHKR_PREFIX ("XLocaleOfIM"));
char *
chkr_stub_XLocaleOfIM (XIM arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XLocaleOfIM);
#else
  return XLocaleOfIM (arg0);
  {
    char * res;
    res = XLocaleOfIM (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XLocaleOfIM */

#ifdef HAVE_XCreateIC
/* From `/usr/include/X11/Xlib.h:4494'.  */
XIC chkr_stub_XCreateIC (XIM arg0, ... ) __asm__ (CHKR_PREFIX ("XCreateIC"));
XIC
chkr_stub_XCreateIC (XIM arg0, ... )
{
  /* This function must be handled by the user */
#if USE_BI_JUMP
  __builtin_jump (XCreateIC);
#else
  return XCreateIC (arg0, );
  {
    XIC res;
    res = XCreateIC (arg0, );
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XCreateIC */

#ifdef HAVE_XDestroyIC
/* From `/usr/include/X11/Xlib.h:4500'.  */
void chkr_stub_XDestroyIC (XIC arg0) __asm__ (CHKR_PREFIX ("XDestroyIC"));
void
chkr_stub_XDestroyIC (XIC arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XDestroyIC);
#else
  XDestroyIC (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XDestroyIC */

#ifdef HAVE_XSetICFocus
/* From `/usr/include/X11/Xlib.h:4506'.  */
void chkr_stub_XSetICFocus (XIC arg0) __asm__ (CHKR_PREFIX ("XSetICFocus"));
void
chkr_stub_XSetICFocus (XIC arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XSetICFocus);
#else
  XSetICFocus (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetICFocus */

#ifdef HAVE_XUnsetICFocus
/* From `/usr/include/X11/Xlib.h:4512'.  */
void chkr_stub_XUnsetICFocus (XIC arg0) __asm__ (CHKR_PREFIX ("XUnsetICFocus"));
void
chkr_stub_XUnsetICFocus (XIC arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XUnsetICFocus);
#else
  XUnsetICFocus (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XUnsetICFocus */

#ifdef HAVE_XwcResetIC
/* From `/usr/include/X11/Xlib.h:4518'.  */
wchar_t * chkr_stub_XwcResetIC (XIC arg0) __asm__ (CHKR_PREFIX ("XwcResetIC"));
wchar_t *
chkr_stub_XwcResetIC (XIC arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XwcResetIC);
#else
  return XwcResetIC (arg0);
  {
    wchar_t * res;
    res = XwcResetIC (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XwcResetIC */

#ifdef HAVE_XmbResetIC
/* From `/usr/include/X11/Xlib.h:4524'.  */
char * chkr_stub_XmbResetIC (XIC arg0) __asm__ (CHKR_PREFIX ("XmbResetIC"));
char *
chkr_stub_XmbResetIC (XIC arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XmbResetIC);
#else
  return XmbResetIC (arg0);
  {
    char * res;
    res = XmbResetIC (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XmbResetIC */

#ifdef HAVE_XSetICValues
/* From `/usr/include/X11/Xlib.h:4530'.  */
char * chkr_stub_XSetICValues (XIC arg0, ... ) __asm__ (CHKR_PREFIX ("XSetICValues"));
char *
chkr_stub_XSetICValues (XIC arg0, ... )
{
  /* This function must be handled by the user */
#if USE_BI_JUMP
  __builtin_jump (XSetICValues);
#else
  return XSetICValues (arg0, );
  {
    char * res;
    res = XSetICValues (arg0, );
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XSetICValues */

#ifdef HAVE_XGetICValues
/* From `/usr/include/X11/Xlib.h:4536'.  */
char * chkr_stub_XGetICValues (XIC arg0, ... ) __asm__ (CHKR_PREFIX ("XGetICValues"));
char *
chkr_stub_XGetICValues (XIC arg0, ... )
{
  /* This function must be handled by the user */
#if USE_BI_JUMP
  __builtin_jump (XGetICValues);
#else
  return XGetICValues (arg0, );
  {
    char * res;
    res = XGetICValues (arg0, );
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XGetICValues */

#ifdef HAVE_XIMOfIC
/* From `/usr/include/X11/Xlib.h:4542'.  */
XIM chkr_stub_XIMOfIC (XIC arg0) __asm__ (CHKR_PREFIX ("XIMOfIC"));
XIM
chkr_stub_XIMOfIC (XIC arg0)
{
#if USE_BI_JUMP
  __builtin_jump (XIMOfIC);
#else
  return XIMOfIC (arg0);
  {
    XIM res;
    res = XIMOfIC (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XIMOfIC */

#ifdef HAVE_XFilterEvent
/* From `/usr/include/X11/Xlib.h:4549'.  */
int chkr_stub_XFilterEvent (XEvent * arg0, Window arg1) __asm__ (CHKR_PREFIX ("XFilterEvent"));
int
chkr_stub_XFilterEvent (XEvent * arg0, Window arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (XEvent), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XFilterEvent);
#else
  return XFilterEvent (arg0, arg1);
  {
    int res;
    res = XFilterEvent (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XFilterEvent */

#ifdef HAVE_XmbLookupString
/* From `/usr/include/X11/Xlib.h:4560'.  */
int chkr_stub_XmbLookupString (XIC arg0, XKeyPressedEvent * arg1, char * arg2, int arg3, KeySym * arg4, int * arg5) __asm__ (CHKR_PREFIX ("XmbLookupString"));
int
chkr_stub_XmbLookupString (XIC arg0, XKeyPressedEvent * arg1, char * arg2, int arg3, KeySym * arg4, int * arg5)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg1, sizeof (XKeyPressedEvent), CHKR_XX, "arg1");
  stubs_chkr_check_addr (arg2, sizeof (char), CHKR_XX, "arg2");
  stubs_chkr_check_addr (arg4, sizeof (KeySym), CHKR_XX, "arg4");
  stubs_chkr_check_addr (arg5, sizeof (int), CHKR_XX, "arg5");
#if USE_BI_JUMP
  __builtin_jump (XmbLookupString);
#else
  return XmbLookupString (arg0, arg1, arg2, arg3, arg4, arg5);
  {
    int res;
    res = XmbLookupString (arg0, arg1, arg2, arg3, arg4, arg5);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XmbLookupString */

#ifdef HAVE_XwcLookupString
/* From `/usr/include/X11/Xlib.h:4571'.  */
int chkr_stub_XwcLookupString (XIC arg0, XKeyPressedEvent * arg1, wchar_t * arg2, int arg3, KeySym * arg4, int * arg5) __asm__ (CHKR_PREFIX ("XwcLookupString"));
int
chkr_stub_XwcLookupString (XIC arg0, XKeyPressedEvent * arg1, wchar_t * arg2, int arg3, KeySym * arg4, int * arg5)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg1, sizeof (XKeyPressedEvent), CHKR_XX, "arg1");
  stubs_chkr_check_addr (arg2, sizeof (wchar_t), CHKR_XX, "arg2");
  stubs_chkr_check_addr (arg4, sizeof (KeySym), CHKR_XX, "arg4");
  stubs_chkr_check_addr (arg5, sizeof (int), CHKR_XX, "arg5");
#if USE_BI_JUMP
  __builtin_jump (XwcLookupString);
#else
  return XwcLookupString (arg0, arg1, arg2, arg3, arg4, arg5);
  {
    int res;
    res = XwcLookupString (arg0, arg1, arg2, arg3, arg4, arg5);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XwcLookupString */

#ifdef HAVE_XVaCreateNestedList
/* From `/usr/include/X11/Xlib.h:4577'.  */
XVaNestedList chkr_stub_XVaCreateNestedList (int arg0, ... ) __asm__ (CHKR_PREFIX ("XVaCreateNestedList"));
XVaNestedList
chkr_stub_XVaCreateNestedList (int arg0, ... )
{
  /* This function must be handled by the user */
#if USE_BI_JUMP
  __builtin_jump (XVaCreateNestedList);
#else
  return XVaCreateNestedList (arg0, );
  {
    XVaNestedList res;
    res = XVaCreateNestedList (arg0, );
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XVaCreateNestedList */

#ifdef HAVE_XRegisterIMInstantiateCallback
/* From `/usr/include/X11/Xlib.h:4590'.  */
int chkr_stub_XRegisterIMInstantiateCallback (Display * arg0, struct _XrmHashBucketRec * arg1, char * arg2, char * arg3, XIMProc arg4, XPointer * arg5) __asm__ (CHKR_PREFIX ("XRegisterIMInstantiateCallback"));
int
chkr_stub_XRegisterIMInstantiateCallback (Display * arg0, struct _XrmHashBucketRec * arg1, char * arg2, char * arg3, XIMProc arg4, XPointer * arg5)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (struct _XrmHashBucketRec), CHKR_XX, "arg1");
  stubs_chkr_check_addr (arg2, sizeof (char), CHKR_XX, "arg2");
  stubs_chkr_check_addr (arg3, sizeof (char), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg5, sizeof (XPointer), CHKR_XX, "arg5");
#if USE_BI_JUMP
  __builtin_jump (XRegisterIMInstantiateCallback);
#else
  return XRegisterIMInstantiateCallback (arg0, arg1, arg2, arg3, arg4, arg5);
  {
    int res;
    res = XRegisterIMInstantiateCallback (arg0, arg1, arg2, arg3, arg4, arg5);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XRegisterIMInstantiateCallback */

#ifdef HAVE_XUnregisterIMInstantiateCallback
/* From `/usr/include/X11/Xlib.h:4601'.  */
int chkr_stub_XUnregisterIMInstantiateCallback (Display * arg0, struct _XrmHashBucketRec * arg1, char * arg2, char * arg3, XIMProc arg4, XPointer * arg5) __asm__ (CHKR_PREFIX ("XUnregisterIMInstantiateCallback"));
int
chkr_stub_XUnregisterIMInstantiateCallback (Display * arg0, struct _XrmHashBucketRec * arg1, char * arg2, char * arg3, XIMProc arg4, XPointer * arg5)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (struct _XrmHashBucketRec), CHKR_XX, "arg1");
  stubs_chkr_check_addr (arg2, sizeof (char), CHKR_XX, "arg2");
  stubs_chkr_check_addr (arg3, sizeof (char), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg5, sizeof (XPointer), CHKR_XX, "arg5");
#if USE_BI_JUMP
  __builtin_jump (XUnregisterIMInstantiateCallback);
#else
  return XUnregisterIMInstantiateCallback (arg0, arg1, arg2, arg3, arg4, arg5);
  {
    int res;
    res = XUnregisterIMInstantiateCallback (arg0, arg1, arg2, arg3, arg4, arg5);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XUnregisterIMInstantiateCallback */

#ifdef HAVE_XInternalConnectionNumbers
/* From `/usr/include/X11/Xlib.h:4620'.  */
int chkr_stub_XInternalConnectionNumbers (Display * arg0, int ** arg1, int * arg2) __asm__ (CHKR_PREFIX ("XInternalConnectionNumbers"));
int
chkr_stub_XInternalConnectionNumbers (Display * arg0, int ** arg1, int * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (int *), CHKR_XX, "arg1");
  stubs_chkr_check_addr (arg2, sizeof (int), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (XInternalConnectionNumbers);
#else
  return XInternalConnectionNumbers (arg0, arg1, arg2);
  {
    int res;
    res = XInternalConnectionNumbers (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XInternalConnectionNumbers */

#ifdef HAVE_XProcessInternalConnection
/* From `/usr/include/X11/Xlib.h:4627'.  */
void chkr_stub_XProcessInternalConnection (Display * arg0, int arg1) __asm__ (CHKR_PREFIX ("XProcessInternalConnection"));
void
chkr_stub_XProcessInternalConnection (Display * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XProcessInternalConnection);
#else
  XProcessInternalConnection (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XProcessInternalConnection */

#ifdef HAVE_XAddConnectionWatch
/* From `/usr/include/X11/Xlib.h:4635'.  */
int chkr_stub_XAddConnectionWatch (Display * arg0, XConnectionWatchProc arg1, XPointer arg2) __asm__ (CHKR_PREFIX ("XAddConnectionWatch"));
int
chkr_stub_XAddConnectionWatch (Display * arg0, XConnectionWatchProc arg1, XPointer arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XAddConnectionWatch);
#else
  return XAddConnectionWatch (arg0, arg1, arg2);
  {
    int res;
    res = XAddConnectionWatch (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XAddConnectionWatch */

#ifdef HAVE_XRemoveConnectionWatch
/* From `/usr/include/X11/Xlib.h:4643'.  */
void chkr_stub_XRemoveConnectionWatch (Display * arg0, XConnectionWatchProc arg1, XPointer arg2) __asm__ (CHKR_PREFIX ("XRemoveConnectionWatch"));
void
chkr_stub_XRemoveConnectionWatch (Display * arg0, XConnectionWatchProc arg1, XPointer arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (Display), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (XRemoveConnectionWatch);
#else
  XRemoveConnectionWatch (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_XRemoveConnectionWatch */

