--                            GCH COMPONENTS                                --
--                                                                          --
--                          G C H . R U L E S                               --
--                                                                          --
--                               Rule_0                                     --
--                                                                          --
--              Copyright (c) 1999, Vitali Sh.Kaufman.                      --
--                                                                          --
--  Gch is distributed as free software; that is with full sources          --
--  and in the hope that it will be useful, but WITHOUT ANY WARRANTY;       --
--  without even the implied warranty of MERCHANTABILITY or FITNESS         --
--  FOR A PARTICULAR PURPOSE. You can freely copy, modify and redistribute  --
--  this software, provided that full sources are available for the version --
--  being distribute (original and modified), and for a modified version,   --
--  any changes that you have made are clearly indicated.                   --
--                                                                          --
--  Gch was developed by Vitali Sh. Kaufman using a prototype               --
--  and consultations by Sergey I. Rybin.                                   --
------------------------------------------------------------------------------
   ----------------
   -- Rule_0 --
   ----------------

   --  As a rule to check we use the
   --  following: "Do not write the 'in' for parameters, especially in functions").

with Asis.Extensions.Flat_Kinds;      use Asis.Extensions.Flat_Kinds;

separate (Gch.Rules)
   function Rule_0 (E : Element) return Boolean is
      Arg_Kind : Flat_Element_Kinds := Flat_Element_Kind (E);
      --  Kind of the Element being visited. We are using the flat Element
      --  classification provided as ASIS-for-GNAT extension to minimize the
      --  number of steps needed for defining the exact position of the
      --  argument Element.

      --  Extension note : We could extend the result type (having Errors-Warning, etc.)
      --  if we need to classify the results

      Result : Boolean := True;
      --  The value of this variable is to be returned by the function. We
      --  initialize it as True, and we reset it to False in case of rule
      --  violation

   begin

      --  First of all we have to test if the ASIS implementation
      --  is supported things that are essential for the rule
      if not Default_In_Mode_Supported then
                raise ASIS_Failed;
                -- ###VK to add more appropriate diagnostics
      end if;

      --  We have to check if the given rule can be applied
      --  to a given element.

      if Arg_Kind in Flat_Declaration_Kinds and then
         (Arg_Kind = A_Parameter_Specification     or else
          Arg_Kind = A_Formal_Object_Declaration)
      then
         --  Now we check the rule for the argument Element and reset Result to
         --  False in case if the Element does not follow the rule:

         if Mode_Kind (E) = An_In_Mode then
            Result := False;
         end if;
      end if;

      return Result;

      --  There is no exception handler in a rule checking function. An
      --  exception, if raised, propagates outside the function and is supposed
      --  to be processed by a caller
   end Rule_0;