/* $Header: /cvs/gnome/gIDE/src/gI_guilesupport.c,v 1.3 1999/11/06 17:45:39 jpr Exp $ */
/*  gIDE
 *  Copyright (C) 1998-2000 Steffen Kern
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#include <config.h>

#ifdef HAVE_LIBGUILE

#include <gtk/gtk.h>
#include <gtkeditor/gtkeditor.h>

#include <guile/gh.h>
#include <libguile.h>

#include "gide.h"
#include "gI_guilesupport.h"

#include "gI_hilite.h"
#include "gI_globpatterns.h"

/* -<local prototypes>----------------------------------------------- */
static void    set_text                       (gchar       *name,
					       gchar      **text);
static void    set_bool                       (gchar       *name,
					       gint        *bool);
static void    set_int                        (gchar       *name,
					       gint        *integer);
static void    set_list                       (gchar       *name,
					       gchar       *array[],
					       gint        *no);


/* -<init>----------------------------------------------------------- */
void
guile_init (void)
{
  return;
}

static void
set_text ( gchar *name, gchar **text )
{
  SCM val;

  g_assert (text);

  val = scm_symbol_value0 (name);
  if (val != SCM_UNDEFINED ) {
    if ( !gh_string_p (val) ) {
      g_warning ("%s was not string as expected!", name);	/* dialog? */
      /* rely on default */
    } else {
      g_free (*text);
      *text = gh_scm2newstr (val, NULL);
    }
  } /* else, rely on default */
}

static void
set_bool ( gchar *name, gint *bool )
{
  SCM val;

  g_assert (bool);

  val = scm_symbol_value0 (name);
  if (val != SCM_UNDEFINED ) {
    if ( !gh_boolean_p (val) ) {
      g_warning ("%s was not bool as expected!", name);	/* dialog? */
      /* rely on default */
    } else {
      *bool = gh_scm2bool (val);
    }
  } /* else, rely on default */
}

static void
set_int ( gchar *name, gint *integer )
{
  SCM val;

  g_assert (integer);

  val = scm_symbol_value0 (name);
  if (val != SCM_UNDEFINED ) {
    if ( !gh_exact_p (val) ) {
      g_warning ("%s was not integer as expected!", name);	/* dialog? */
      /* rely on default */
    } else {
      *integer = (gint)gh_scm2long (val);
    }
  } /* else, rely on default */
}

static void
set_list ( gchar *name, gchar *array[], gint *no )
{
  SCM val;
  SCM car;

  g_assert (array);
  g_assert (no);

  val = scm_symbol_value0 (name);
  *no = 0;
  if ( val != SCM_UNDEFINED ) {
    if ( !gh_list_p (val) ) {
      g_warning ("%s was not a list as expected!", name); /* dialog? */
      /* rely on default */
    } else {
      /* FIXME: another test please... */
      while ( scm_null_p (val) != SCM_BOOL_T ) {
	car = gh_car (val);
	if ( !gh_string_p (car) ) {
	  /* FIXME: when you're not in a hurry, change this */
	  g_warning ("elements in %s should all be text!", name);
	} else {
	  array[(*no)++] = gh_scm2newstr (car, NULL);
	}
	
	/* this is ugly...is this the way to do this? */
	val = gh_cdr (val);
      }
    }
  }
}

void
guile_extract_cfg (void)
{
  /* compile */
  /*set_text ( "cc", &cfg->cc );
  set_text ( "ld", &cfg->ld );*/
  /*set_text ( "incpath", &cfg->incpath );
  set_text ( "ccopt", &cfg->ccopt );
  set_text ( "libpath", &cfg->libpath );
  set_text ( "ldopt", &cfg->ldopt );*/

  /* debug */
  set_text( "db", &cfg->db );

  /* directories */
  set_text ( "tmpdir", &cfg->tmpdir );

  /* editor */
  set_text ( "fontname", &cfg->fontname );
  set_bool ( "disable_font", &cfg->disable_font_stuff );
  set_bool ( "wordwrap", &cfg->wordwrap );
  set_bool ( "autosave", &cfg->autosave );
  set_int  ( "autosave-freq", &cfg->autosave_freq );
  set_bool ( "use-redit", &cfg->use_redit );
  set_text ( "redit", &cfg->redit );
  set_bool ( "highlight", &cfg->highlight );
  set_text ( "ign-file", &cfg->ign_file );
  set_int  ( "tab-width", &cfg->tab_width );
#if HAVE_GTKTEXT_PATCH
  set_bool ( "edtab", &cfg->edtab );
#endif

  /* misc */
  set_bool ( "toolbar", &cfg->toolbar );
  set_bool ( "toolbar-custom", &cfg->toolbar_custom );
  set_list ( "toolbar-custom-list", cfg->toolbar_custom_items,
	     &cfg->toolbar_custom_items_no );
  set_text ( "bash", &cfg->bash );/* shell/bash??? */
  set_text ( "make", &cfg->make );
  set_text ( "man", &cfg->man );
  set_text ( "xterm", &cfg->xterm );
  set_text ( "email", &cfg->email );
  set_text ( "smtp", &cfg->smtp );
  set_bool ( "sor", &cfg->sor );

  /* projects */
  set_bool ( "project-file-tree", &cfg->prjftree );
  set_bool ( "changelog", &cfg->changelog );
  set_bool ( "remove-done", &cfg->remdone );

#if HAVE_GTKTEXT_PATCH
  /* highlight */
  set_text ( "pattern-file", &cfg->patternfile );
  set_text ( "globassoc-file", &cfg->globassocfile );
  set_text ( "highlight-file", &cfg->hli_file );
#endif
}

#if HAVE_GTKTEXT_PATCH
void
guile_extract_pattern_list (void)
{
  SCM plist = scm_symbol_value0 ( "hilite-pattern-list" );
  SCM car, spat;
  gchar *name;
  gint i;
  gI_HilitePattern pat;
  gchar **_pat;
  gchar *ColTemp;

  if ( plist == SCM_UNDEFINED )
    return;

  if ( ! gh_list_p (plist) ) {
    g_warning ("hilite-pattern-list should be a *list*");
    return;
  }

  /* look! Over there! */
  _pat = (gchar**)&pat;		/* No! you didn't see that */

  while ( scm_null_p (plist) == SCM_BOOL_F ) {
    car = gh_car (plist);
    plist = gh_cdr (plist);

    /* pat.* is reset for iteration...this makes the escape in the
     * inner loop much cleaner. */
    pat.name = NULL;
    pat.comment_start = NULL;
    pat.comment_end = NULL;
    pat.string_start = NULL;
    pat.string_end = NULL;
    pat.char_start = NULL;
    pat.char_end = NULL;
    pat.keywords = NULL;
    pat.types = NULL;
    pat.funcs = NULL;

    if ( !gh_symbol_p (car) ) {
      g_warning ("all elements in hilite-pattern-list should be symbols!");
      continue;
    }

    name = gh_symbol2newstr (car, NULL);
    spat = scm_symbol_value0 (name);

    pat.name = g_strdup( name );

    /* check sanity of spat */
    if ( !gh_list_p (spat) ) {
      g_warning ("fucked up pattern!");
      g_free (name);
      continue;
    }

    /* get patterns */
    for (i = 0; i < 9; i++) {
      if ( scm_null_p (spat) == SCM_BOOL_T ) {
	/* if the patten list gets empty here...there's not enough *
	 *  strings...we free and go to the next pattern symbol.  I
	 *  hate to say it, but 'goto' *is* the cleanest way to do
	 *  this, since we can't contine the outer while-loop from
	 *  here. */
	g_warning ("insuficient number of strings in pattern (1)");
	goto ERROR;
      }

      car = gh_car (spat);
      spat = gh_cdr (spat);

      if ( !gh_string_p (car) ) {
	g_warning ("all elements in a pattern should be strings!");
	goto ERROR;
      }

      /* everything went well...now insert string in pat */
      _pat[i+1] = gh_scm2newstr (car, NULL);/* Magick! */
    }

    for (i = 0; i < 5; i++)
    {
      if ( scm_null_p (spat) == SCM_BOOL_T ) {
          /* if the patten list gets empty here...there's not enough *
       	   *  strings...we free and go to the next pattern symbol.  I
	   *  hate to say it, but 'goto' *is* the cleanest way to do
	   *  this, since we can't contine the outer while-loop from
	   *  here. */
          g_warning ("insuficient number of strings in pattern (2)");
          goto ERROR;
      }

      car = gh_car (spat);
      spat = gh_cdr (spat);

      if ( !gh_string_p (car) ) {
	g_warning ("all elements in a pattern should be strings!");
	goto ERROR;
      }

      /* everything went well...now insert string in pat */
      ColTemp = gh_scm2newstr (car, NULL);/* Magick! */

      switch( i )
      {
	case 0:
	{
    	   if( sscanf( ColTemp, "%hu %hu %hu", &pat.comment_color.red,
	                                       &pat.comment_color.green,
	                                       &pat.comment_color.blue) != 3 )

	   {
	      g_warning( "Syntax error in pattern resource file" );
	      goto ERROR;
	   }
	   break;
	}
	case 1:
	{
    	   if( sscanf( ColTemp, "%hu %hu %hu", &pat.string_color.red,
	                                       &pat.string_color.green,
	                                       &pat.string_color.blue) != 3 )
	   {
	      g_warning( "Syntax error in pattern resource file" );
	      goto ERROR;
	   }
	   break;
	}
	case 2:
	{
    	   if( sscanf( ColTemp, "%hu %hu %hu", &pat.char_color.red,
	                                       &pat.char_color.green,
	                                       &pat.char_color.blue) != 3 )
	   {
	      g_warning( "Syntax error in pattern resource file" );
	      goto ERROR;
	   }
	   break;
	}
	case 3:
	{
 	   if( sscanf( ColTemp, "%hu %hu %hu", &pat.keywords_color.red,
	                                       &pat.keywords_color.green,
	                                       &pat.keywords_color.blue) != 3 )
           {
	      g_warning( "Syntax error in pattern resource file" );
	      goto ERROR;
	   }
	   break;
	}
	case 4:
	{
    	   if( sscanf( ColTemp, "%hu %hu %hu", &pat.types_color.red,
	                                       &pat.types_color.green,
	                                       &pat.types_color.blue) != 3 )
	   {
	      g_warning( "Syntax error in pattern resource file" );
	      goto ERROR;
	   }
	   break;
	}
      }

      g_free( ColTemp );
    }

    /* just a little extra service... */
    if ( scm_null_p (spat) == SCM_BOOL_F ) {
      /* there's patterns left...and there shouldn't be...*/
      g_warning ("excess strings in pattern");
    }

    g_free( pat.keywords );
    pat.keywords = create_keywords_pattern( pat.name );
    if( !pat.keywords )
    	pat.keywords = g_strdup( "\\b" );

    /* insert pattern */
    gI_hilite_add_named_pattern (name, &pat);

    /* clean up...DO NOT FREE pat's patterns...they are safe in the
     * pattern list! */
    g_free (name);

    /* this is for error handling...if we get here normally, we simply
     * continue (the first 'continue')...if we get here from an error,
     * we reach the 'ERROR' label, so we free pat, and take the next
     * iteration. */
    continue;
  ERROR:
    /* this should only be reached if an error occurred while reading
     * a pattern */
    g_free (pat.name);
    g_free (pat.comment_start);
    g_free (pat.comment_end);
    g_free (pat.string_start);
    g_free (pat.string_end);
    g_free (pat.char_start);
    g_free (pat.char_end);
    g_free (pat.keywords);
    g_free (pat.types);
    g_free (pat.funcs);
  }
}

void
guile_extract_globassoc (void)
{
  SCM assoc = scm_symbol_value0 ( "globassoc" );
  SCM pair, sglob, spat;
  gchar *glob, *pname;

  if ( assoc == SCM_UNDEFINED )
    return;

  if ( !gh_list_p (assoc) ) {
    g_warning ("globassoc should be an assoc list");
    return;
  }

  while ( scm_null_p (assoc) == SCM_BOOL_F ) {
    pair = gh_car (assoc);
    assoc = gh_cdr (assoc);

    if ( !gh_pair_p (pair) ) {
      g_warning ("all elements in globassoc should be pairs...it's an *assoc*");
      continue;
    }

    sglob = gh_car (pair);
    spat = gh_cdr (pair);

    if ( !gh_string_p (sglob) ) {
      g_warning ("car of the globassoc elements should be strings");
      continue;
    }
    if ( !gh_symbol_p (spat) ) {
      g_warning ("cdr of globassoc elements should be pattern symbols");
      continue;
    }

    glob = gh_scm2newstr (sglob, NULL);
    pname =  gh_symbol2newstr (spat, NULL);

    gI_glob_assoc (glob, pname);

    g_free (glob);
    g_free (pname);
  }
}

#endif /*HAVE_GTKTEXT_PATCH*/

#endif /*HAVE_LIBGUILE*/
