// This is -*- C++ -*-

/* 
 * gc.h
 *
 * Copyright (C) 1998 EMC Capital Management, Inc.
 * Copyright (C) 1998 Karl E. Nelson
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@emccta.com>.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef _GDKMM_INC_GC_H
#define _GDKMM_INC_GC_H

#include <gdk/gdk.h>
#include <gdk--/types.h>
#include <gdk--/font.h>

//: Gdk GC Handle 
// GC is a graphic context used to indicated drawing 
// styles to the server when requesting drawing commands.
// Please read <a href="handles.htm">Handles</a>
class Gdk_GC :public Gdk_Handle<GdkGC>
  {
   protected:
 
     //: (internal function) increment gdk reference counter
     virtual void ref();

     //: (internal function) decrement gdk reference counter 
     virtual void unref();

/* REQUIRED Handle Constructor and Destructors */
#ifdef GDKMM_HANDLES_CONNECTED_ONLY
   protected:
#else
   public:
#endif
     //: Create an unconnect GC Handle.
     Gdk_GC();

   public:
     //: Wrap an existing GdkGC.
     Gdk_GC(GdkGC* gc);

     //: Initialize a GC reference from a existing one.
     Gdk_GC(const Gdk_GC& gc);
  
     //: Create a new GC for this drawable. 
     Gdk_GC(Gdk_Drawable &drawable);

     //: Delete this handle.
     ~Gdk_GC();

     //: Create a GC on server
     // Allocate a remote gc object based on this drawable 
     void create(Gdk_Drawable const &drawable);

   private:
   
     //: Destroy a remote gc. 
     // This is very dangerous and should probably be removed 
     // nuke the GC and make this copy invalid
     void destroy();

   public:
   /* Provided member functions */

     //: Copy server GC.
     // This copies all properties of one remote GC to another
     // GC on the server.  
     void copy(Gdk_GC &src);

     //: Get GC properites.
     void get_values(GdkGCValues &values);

     //: Set foreground color.
     void set_foreground(const Gdk_Color& c);
 
     //: Set background color.
     void set_background(const Gdk_Color& c);

     //: Set the font associated with this GC.
     void set_font(const Gdk_Font& font);
	
     //: Return the current font. 
     // Font will not be initialize if no current font.  
     Gdk_Font get_font();
 
     //: Set the drawing function. 
     // Drawing Functions: GDK_COPY, GDK_INVERT, GDK_XOR
     void set_function(GdkFunction func);

     //: Set the fill style.
     // Fill Styles: GDK_SOLID, GDK_TILED, GDK_STIPPLED, GDK_OPAQUE_STIPPLED
     void set_fill(GdkFill fill);

     //: Set the background tile.
     void set_tile(Gdk_Pixmap &tile);

     void set_stipple(Gdk_Pixmap &stip);

     void set_ts_origin(gint x, gint y);

     void set_clip_origin(gint x, gint y);

     //: Set the clipping mask.
     void set_clip_mask(Gdk_Bitmap &mask);

     //: Deactive the clipping mask.
     void set_clip_mask() ;

     //: Deactive the clipping mask (non-standard) 
     void set_noclip() ;

     //: Set the clipping rectangle.
     void   set_clip_rectangle  (const Gdk_Rectangle &rect);

     //: Set the clipping rectangle.
     void set_clip_rectangle(gint x, gint y, gint w, gint h);

     //: Set the clip region. (needs work)
     void set_clip_region(Gdk_Region &region);
     
     //: Set the clipping mode.
     // Subwindow modes: GDK_CLIP_BY_CHILDREN, GDK_INCLUDE_INFERIORS
     void set_subwindow(GdkSubwindowMode mode);

     //: Set exposures  
     // (what are exposures?)
     void set_exposures(gint exp);

     //: Set the line attributes
     void set_line_attributes(gint line_width,
                              GdkLineStyle line_style=GDK_LINE_SOLID,
                              GdkCapStyle cap_style=GDK_CAP_BUTT,
                              GdkJoinStyle join_style=GDK_JOIN_MITER);


    /* A large set of convience functions (non-standard) (need minor work)  */
    /* We should make a some code for wrapping CGchange, I don't understand */
    /* why Gdk didn't support this.  We should connect them and ask.        */

      void set_line_width(gint line_width);
 
      //: Set the line style. 
      // Lines can be drawn in a number of diffent fashions.
      // Line Styles: GDK_LINE_SOLID, GDK_LINE_ON_OFF_DASH, GDK_LINE_DOUBLE_DASH
      void set_line_style(GdkLineStyle line_style);

      //: Set the cap style.
      // Caps are the ends of lines.
      // Cap Styles: GDK_CAP_NOT_LAST, GDK_CAP_BUTT, GDK_CAP_ROUND,
      //             GDK_CAP_PROJECTING
      void set_cap_style(GdkCapStyle cap_style);

      //: Set the joint style. 
      // Joints describe how one line connects with another.
      // Join Styles: GDK_JOIN_MITER, GDK_JOIN_ROUND, GDK_JOIN_BEVEL
      void set_join_style(GdkJoinStyle join_style);


      /* Here are the two cases that you use most of the time: */
      //: Set the length of dashs.
      // On and off will have the same size.
      void set_dashes(gint size);
     
      //: Set the length of dashs. 
      void set_dashes(gint on, gint off);
         
 
      //: Dash function 
      void set_dashes(gint dash_offset,
                      gchar dash_list[], 
                      gint dash_list_length);


  };

#endif // _GDKMM_INC_GC_H









