
/* functions.cc: Global functions found in Gnome.
 *
 * Copyright (C) 1998 EMC Capital Management Inc.
 * Developed by Havoc Pennington <hp@pobox.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "functions.h"

Gnome_Dialog*
Gnome::ok_dialog(const gchar* message)
{
  return new Gnome_Dialog(GNOME_DIALOG(gnome_ok_dialog(message)));
}

Gnome_Dialog*
Gnome::ok_dialog_parented(const gchar* message, Gtk_Window* parent)
{
  g_return_val_if_fail(parent != 0, 0);
  return new Gnome_Dialog(GNOME_DIALOG(gnome_ok_dialog_parented(message,parent->gtkobj())));
}

Gnome_Dialog*
Gnome::error_dialog(const gchar* message)
{
  return new Gnome_Dialog(GNOME_DIALOG(gnome_error_dialog(message)));
}

Gnome_Dialog*
Gnome::error_dialog_parented(const gchar* message, Gtk_Window* parent)
{
  g_return_val_if_fail(parent != 0, 0);
  return new Gnome_Dialog(GNOME_DIALOG(gnome_error_dialog_parented(message,parent->gtkobj())));
}



