# To build static libraries uncomment the following line,
# or give '--define "STATIC yes"' to rpm's  commandline
#%define STATIC yes

%define  RELEASE 1
%define  rel     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}

Summary: 	A C++ interface for the GTK+ (a GUI library for X).
Name: 		gtk--
Version: 	1.0.3
Release: 	%rel
Copyright: 	LGPL
Group: 		System Environment/Libraries
Source: 	ftp://ftp.gtk.org/pub/gtk/gtk--/Gtk---%{version}.tar.gz
URL: 		http://www.iki.fi/terop/gtk/gtk--.html
Prefix: 	/usr
BuildRoot: 	/var/tmp/%{name}-%{version}-root

%description
This package provides a C++ interface for GTK+ (the Gimp ToolKit) GUI
library.  The interface provides a convenient interface for C++
programmers to create GUIs with GTK+'s flexible object-oriented framework.
Features include type safe callbacks, widgets that are extensible using
inheritance and over 110 classes that can be freely combined to quickly
create complex user interfaces.

%package	devel
Summary: 	Headers for developing programs that will use Gtk--.
Group: 		Development/Libraries
Requires:       %{name}

%description    devel
This package contains the headers that programmers will need to develop
applications which will use Gtk--, the C++ interface to the GTK+
(the Gimp ToolKit) GUI library.

%package	devel-static
Summary: 	Gtk-- static libraries.
Group: 		Development/Libraries
Requires:       %{name}

%description devel-static 
This package contains the static libraries for Gtk--, the C++
interface to the GTK+ (the Gimp ToolKit) GUI library.

%prep
%setup -q -n Gtk---%{version}

%build

%ifarch alpha
	ARCH_FLAGS="--host=alpha-linux-gnu"
%endif

# Needed for snapshot releases.
if [ ! -f configure ]; then
	CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh $ARCH_FLAGS \
		--prefix=%{prefix} \
%{?STATIC:	--enable-static } \
		--enable-shared --enable-docs
else
	CFLAGS="$RPM_OPT_FLAGS" ./configure  $ARCH_FLAGS \
		--prefix=%{prefix} \
		--disable-maintainer-mode \
%{?STATIC:	--enable-static } \
		--enable-shared --enable-docs
fi

if [ "$SMP" != "" ]; then
  make -j$SMP "MAKE=make -j$SMP"
else
  make
fi

%install
if [ -d $RPM_BUILD_ROOT ]; then rm -rf $RPM_BUILD_ROOT; fi
make DESTDIR=$RPM_BUILD_ROOT install

# Remove makefiles from doc dirs
#rm `find docs -type f -name Makefile\*`
#rm `find docs -type f -name \*.3`
#rm `find html -type f -name Makefile\*`

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%doc AUTHORS COPYING ChangeLog INSTALL NEWS README
%{prefix}/lib/*.so.*

%files  devel
%defattr(-, root, root)
%doc examples html docs AUTHORS COPYING ChangeLog INSTALL NEWS README
%{prefix}/bin/*
%{prefix}/include/*.h
%{prefix}/include/gdk--
%{prefix}/include/gnome--
%{prefix}/include/gtk--
%{prefix}/lib/*.sh
%{prefix}/lib/*.so
%{prefix}/lib/Gtk--
%{prefix}/man/man3/*
%{prefix}/share/aclocal/gtk--.m4

%{?STATIC:%files devel-static 		}
%{?STATIC:%defattr(-, root, root)	}
%{?STATIC:%{prefix}/lib/*.a		}
%{?STATIC:%{prefix}/lib/*.la		}

###########################################################################
%changelog
* Sat Sep 11 1999 Herbert Valerio Riedel <hvr@gnu.org>
- added SMP support
- added custom release feature

* Thu Jul 29 1999 Herbert Valerio Riedel <hvr@gnu.org>
- Updated to gtk---1.0.x
- Merged in changes from redhat's gtk--.spec
- conditional build of static libraries by define 'STATIC'

* Thu May 10 1998 Bibek Sahu <scorpio@dodds.net>
- Upgraded to gtk---0.9.3

* Thu Apr 30 1998 Bibek Sahu <scorpio@dodds.net>
- Fixed problem with gtk---devel requiring libgtk-- (not gtk--).  Oops.

* Thu Apr 30 1998 Bibek Sahu <scorpio@dodds.net>
- Fixed problem with most of the headers not being included.

* Thu Apr 30 1998 Bibek Sahu <scorpio@dodds.net>
- Upgraded to gtk---0.9.1

* Tue Apr 28 1998 Bibek Sahu <scorpio@dodds.net>
- Fixed to build gtk-- and gtk---devel packages.

* Tue Apr 28 1998 Bibek Sahu <scorpio@dodds.net>
- First (s)rpm build.

