/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log: kdump.c,v $
 *	Revision 6.2  1999/06/12 17:11:17  kmeyer1
 *	added copyright
 *	
 *	Revision 6.1  1996/11/23 18:14:26  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  13:19:58  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/01/19  16:03:30  gdburns
 * Do not pass client port in kernel request.
 * 
 * Revision 5.2  94/08/22  13:42:36  gdburns
 * Ohio Release
 * 
 * Revision 5.1.1.1  94/08/18  09:48:51  gdburns
 * overhaul for new kernel
 * 
 * Revision 5.1  94/05/18  10:38:55  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:24:20  gdburns
 * Ohio Release
 * 
 *	Function:	- prompts kernel to dump process state
 */

#include <kreq.h>

/*
 * external variables
 */
extern int		errno;

/*
 * external functions
 */
extern int		_cio_kreq();
extern int		_cipc_init();

int
main()

{
	struct kreq	req;		/* kernel request */
	struct kreply	reply;		/* kernel reply */

	if (_cipc_init()) {
		terror("kdump");
		return(errno);
	}

	req.kq_req = KQDUMP;
	req.kq_index = -1;

	if (_cio_kreq(&req, &reply)) {
		terror("kdump");
		return(errno);
	}

	return(0);
}
