package com.jclark.xsl.sax;

import org.xml.sax.*;
import java.io.OutputStream;

public class ResultTypeHandlerImpl implements ResultTypeHandler {
  private XSLProcessor processor;
  private OutputStream out;

  public ResultTypeHandlerImpl(XSLProcessor processor) {
    this.processor = processor;
  }

  public void setOutputStream(OutputStream out) {
    this.out = out;
  }

  public void setResultType(String namespace, boolean indent) {
    String resultClass  = getClassForNamespace(namespace);
    if (resultClass != null) {
      try {
	Class cls = Class.forName(resultClass);
	DocumentHandler handler = (DocumentHandler)cls.newInstance();
	if (handler instanceof OutputStreamConverter)
	  ((OutputStreamConverter)handler).setOutputStream(out);
	processor.setDocumentHandler(handler);
	processor.setStripNamespaces(true);
	return;
      }
      catch (ClassNotFoundException e) { }
      catch (InstantiationException e) { }
      catch (IllegalAccessException e) { }
      catch (ClassCastException e) { }
    }
    DocumentHandler handler = new XMLOutputHandler(out,
						   XMLOutputHandler.MINIMIZE_EMPTY_ELEMENTS);
    if (indent)
      handler = new Indenter(handler);
    processor.setDocumentHandler(handler);
    processor.setStripNamespaces(false);
  }

  private static final String[][] resultNamespaceMap = {
    { "http://www.w3.org/TR/REC-html40", "com.jclark.xsl.sax.HTMLOutputHandler" },
    // Add new entries here.
  };

  private static String getClassForNamespace(String ns) {
    if (ns == null)
      return null;
    for (int i = 0; i < resultNamespaceMap.length; i++) {
      if (ns.equals(resultNamespaceMap[i][0])) {
	return resultNamespaceMap[i][1];
      }
    }
    if (ns.startsWith("java:"))
      return ns.substring(5);
    return null;
  }
    
}
