(* The thread-aware GTK loop *)
val main : unit -> unit

(* After [main] has been spawned, allcalls to GTK must be enclosed
   between lock() and unlock(). This rule does not apply to GTK
   callbacks, as they are executed within the [main] thread. *)
val lock : unit -> unit
val unlock : unit -> unit

(* In case automatic detection of posix/emulated threads fails,
   you can force it here (before calling [main]) *)
val using_pthread : bool ref
