(*
 *  C2caml : parses c headers and produces appropriate caml bindings for it
 *  Copyright (C) 1999  Sven LUTHER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *)

(* $Id: expr.ml,v 1.1 1999/06/19 14:59:19 sven Exp $ *)

type tsize =
  | T_short | T_normal | T_long | T_verylong
type type_qualifier =
  | T_none
  | T_const
  | T_volatile 
  | T_both
type storage_class_specifier =
  | T_auto
  | T_register
  | T_static
  | T_extern
  | T_typedef
type type_specifier =
  | T_void
  | T_char of bool 
  | T_int of bool * tsize
  | T_float of tsize
  | T_type_name of string
  | T_enum of string * ((string*int option) list)
  | T_struct_or_union of string * (bool * unit)
type types =
{
  storage : storage_class_specifier;
  qualifier : type_qualifier;
  t : type_specifier;
}
let ntype s q t = { storage = s; qualifier = q; t = t }
let get_storage e = e.storage
let get_qualifier e = e.qualifier
let get_type e = e.t
let is_typedef_class e = e.storage = T_typedef

type expr_content =
  | E_int of int
  | E_float of float
  | E_char of char
  | E_string of string
  | E_enum of int
  | E_ident of string
  | E_typedef
  | E_liste of expr list
  | E_enum_ident
  | E_none
and expr =
{
  expr : expr_content;
  can_be_constant : bool;
}

let expr e = {expr=e; can_be_constant=true}
let is_cst e = e.can_be_constant
let flip e = {expr=e.expr; can_be_constant=not e.can_be_constant}
let get_value e = e.expr
let e_none = expr E_none

type decl =
  | D_symbol of string
  | D_table of decl * expr
  | D_function of decl
  | D_pointer of decl
  | D_none

let rec get_symbol = function
  | D_symbol i -> i
  | D_table (d, e) -> get_symbol d
  | D_function d -> get_symbol d
  | D_pointer d -> get_symbol d
  | D_none -> ""

type inst =
  | I_goto of string
  | I_continue
  | I_break
  | I_return of expr
type oper =
  | Op_and
  | Op_mult
  | Op_add
  | Op_sub
  | Op_neg
  | Op_not
  | Op_affect
  | Op_mult_affect
  | Op_div_affect
  | Op_mod_affect
  | Op_add_affect
  | Op_sub_affect
  | Op_left_affect
  | Op_right_affect
  | Op_and_affect
  | Op_xor_affect
  | Op_or_affect
