/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleAction;
import com.sun.java.accessibility.AccessibleComponent;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleSelection;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.accessibility.AccessibleText;
import com.sun.java.accessibility.AccessibleValue;
import com.sun.java.swing.DefaultCellEditor;
import com.sun.java.swing.DefaultListSelectionModel;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.JViewport;
import com.sun.java.swing.ListSelectionModel;
import com.sun.java.swing.Scrollable;
import com.sun.java.swing.ToolTipManager;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.border.LineBorder;
import com.sun.java.swing.event.CellEditorListener;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.event.TableColumnModelEvent;
import com.sun.java.swing.event.TableColumnModelListener;
import com.sun.java.swing.event.TableModelEvent;
import com.sun.java.swing.event.TableModelListener;
import com.sun.java.swing.plaf.TableUI;
import com.sun.java.swing.table.AbstractTableModel;
import com.sun.java.swing.table.DefaultTableCellRenderer;
import com.sun.java.swing.table.DefaultTableColumnModel;
import com.sun.java.swing.table.DefaultTableModel;
import com.sun.java.swing.table.JTableHeader;
import com.sun.java.swing.table.TableCellEditor;
import com.sun.java.swing.table.TableCellRenderer;
import com.sun.java.swing.table.TableColumn;
import com.sun.java.swing.table.TableColumnModel;
import com.sun.java.swing.table.TableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class JTable
extends JComponent
implements TableModelListener,
Scrollable,
TableColumnModelListener,
ListSelectionListener,
CellEditorListener,
Accessible {
    public static final int AUTO_RESIZE_OFF = 0;
    public static final int AUTO_RESIZE_LAST_COLUMN = 1;
    public static final int AUTO_RESIZE_ALL_COLUMNS = 2;
    protected TableModel dataModel;
    protected TableColumnModel columnModel;
    protected ListSelectionModel selectionModel;
    protected JTableHeader tableHeader;
    protected int rowHeight;
    protected int rowMargin;
    protected Color gridColor;
    protected boolean showHorizontalLines;
    protected boolean showVerticalLines;
    protected int autoResizeMode;
    protected boolean autoCreateColumnsFromModel;
    protected Dimension preferredViewportSize;
    protected boolean rowSelectionAllowed;
    protected boolean cellSelectionEnabled;
    protected transient Component editorComp;
    protected transient TableCellEditor cellEditor;
    protected transient int editingColumn;
    protected transient int editingRow;
    protected transient Hashtable defaultRenderersByColumnClass;
    protected transient Hashtable defaultEditorsByColumnClass;
    protected Color selectionForeground;
    protected Color selectionBackground;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$com$sun$java$swing$ImageIcon;
    static /* synthetic */ Class class$java$lang$Boolean;

    public JTable() {
        this(null, null, null);
    }

    public JTable(TableModel tableModel) {
        this(tableModel, null, null);
    }

    public JTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        this(tableModel, tableColumnModel, null);
    }

    public JTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        this.setLayout(null);
        if (tableColumnModel == null) {
            tableColumnModel = this.createDefaultColumnModel();
            this.autoCreateColumnsFromModel = true;
        }
        this.setColumnModel(tableColumnModel);
        if (listSelectionModel == null) {
            listSelectionModel = this.createDefaultSelectionModel();
        }
        this.setSelectionModel(listSelectionModel);
        if (tableModel == null) {
            tableModel = this.createDefaultDataModel();
        }
        this.setModel(tableModel);
        this.initializeLocalVars();
        this.updateUI();
    }

    public JTable(int n, int n2) {
        this(new DefaultTableModel(n, n2));
    }

    public JTable(Vector vector, Vector vector2) {
        this(new 1(vector2, vector));
    }

    public JTable(Object[][] objectArray, Object[] objectArray2) {
        this(new 2(objectArray2, objectArray));
    }

    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    protected void configureEnclosingScrollPane() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            jScrollPane.setColumnHeaderView(this.getTableHeader());
            jScrollPane.getViewport().setBackingStoreEnabled(true);
            jScrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
        }
    }

    public static JScrollPane createScrollPaneForTable(JTable jTable) {
        return new JScrollPane(jTable);
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        if (this.tableHeader != jTableHeader) {
            if (this.tableHeader != null) {
                this.tableHeader.setTable(null);
            }
            this.tableHeader = jTableHeader;
            if (this.tableHeader != null) {
                this.tableHeader.setTable(this);
            }
        }
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setRowHeight(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("New row height less than 1");
        }
        this.rowHeight = n;
        this.resizeAndRepaint();
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setIntercellSpacing(Dimension dimension) {
        this.rowMargin = dimension.height;
        this.getColumnModel().setColumnMargin(dimension.width);
        this.resizeAndRepaint();
    }

    public Dimension getIntercellSpacing() {
        return new Dimension(this.getColumnModel().getColumnMargin(), this.rowMargin);
    }

    public void setGridColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("New color is null");
        }
        this.gridColor = color;
        this.repaint();
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setShowGrid(boolean bl) {
        this.setShowHorizontalLines(bl);
        this.setShowVerticalLines(bl);
        this.repaint();
    }

    public void setShowHorizontalLines(boolean bl) {
        this.showHorizontalLines = bl;
        this.repaint();
    }

    public void setShowVerticalLines(boolean bl) {
        this.showVerticalLines = bl;
        this.repaint();
    }

    public boolean getShowHorizontalLines() {
        return this.showHorizontalLines;
    }

    public boolean getShowVerticalLines() {
        return this.showVerticalLines;
    }

    public void setAutoResizeMode(int n) {
        if (n == 2 || n == 1 || n == 0) {
            this.autoResizeMode = n;
            this.resizeAndRepaint();
            this.tableHeader.resizeAndRepaint();
        }
    }

    public int getAutoResizeMode() {
        return this.autoResizeMode;
    }

    public void setAutoCreateColumnsFromModel(boolean bl) {
        if (this.autoCreateColumnsFromModel != bl) {
            this.autoCreateColumnsFromModel = bl;
            if (this.autoCreateColumnsFromModel) {
                this.createDefaultColumnsFromModel();
            }
        }
    }

    public boolean getAutoCreateColumnsFromModel() {
        return this.autoCreateColumnsFromModel;
    }

    public void createDefaultColumnsFromModel() {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            TableColumnModel tableColumnModel = this.getColumnModel();
            tableColumnModel.removeColumnModelListener(this);
            while (tableColumnModel.getColumnCount() > 0) {
                tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
            }
            int n = 0;
            while (n < tableModel.getColumnCount()) {
                TableColumn tableColumn = new TableColumn(n);
                this.addColumn(tableColumn);
                ++n;
            }
            tableColumnModel.addColumnModelListener(this);
        }
    }

    public void setDefaultRenderer(Class clazz, TableCellRenderer tableCellRenderer) {
        this.defaultRenderersByColumnClass.put(clazz, tableCellRenderer);
    }

    public TableCellRenderer getDefaultRenderer(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Object v = this.defaultRenderersByColumnClass.get(clazz);
        if (v != null) {
            return (TableCellRenderer)v;
        }
        return this.getDefaultRenderer(clazz.getSuperclass());
    }

    public void setDefaultEditor(Class clazz, TableCellEditor tableCellEditor) {
        this.defaultEditorsByColumnClass.put(clazz, tableCellEditor);
    }

    public TableCellEditor getDefaultEditor(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Object v = this.defaultEditorsByColumnClass.get(clazz);
        if (v != null) {
            return (TableCellEditor)v;
        }
        return this.getDefaultEditor(clazz.getSuperclass());
    }

    public void setSelectionMode(int n) {
        this.clearSelection();
        this.getSelectionModel().setSelectionMode(n);
        this.getColumnModel().getSelectionModel().setSelectionMode(n);
    }

    public void setRowSelectionAllowed(boolean bl) {
        this.clearSelection();
        this.rowSelectionAllowed = bl;
    }

    public boolean getRowSelectionAllowed() {
        return this.rowSelectionAllowed;
    }

    public void setColumnSelectionAllowed(boolean bl) {
        this.clearSelection();
        this.columnModel.setColumnSelectionAllowed(bl);
    }

    public boolean getColumnSelectionAllowed() {
        return this.columnModel.getColumnSelectionAllowed();
    }

    public void setCellSelectionEnabled(boolean bl) {
        this.clearSelection();
        this.cellSelectionEnabled = bl;
    }

    public boolean getCellSelectionEnabled() {
        return this.cellSelectionEnabled;
    }

    public void selectAll() {
        int n;
        if (this.getSelectedRowCount() > 0 && (n = this.getRowCount()) > 0) {
            this.setRowSelectionInterval(0, n);
        }
        if (this.getSelectedColumnCount() > 0 && (n = this.getColumnCount()) > 0) {
            this.setColumnSelectionInterval(0, n);
        }
    }

    public void clearSelection() {
        this.columnModel.getSelectionModel().clearSelection();
        this.selectionModel.clearSelection();
    }

    public void setRowSelectionInterval(int n, int n2) {
        this.selectionModel.setSelectionInterval(n, n2);
    }

    public void setColumnSelectionInterval(int n, int n2) {
        this.columnModel.getSelectionModel().setSelectionInterval(n, n2);
    }

    public void addRowSelectionInterval(int n, int n2) {
        this.selectionModel.addSelectionInterval(n, n2);
    }

    public void addColumnSelectionInterval(int n, int n2) {
        this.columnModel.getSelectionModel().addSelectionInterval(n, n2);
    }

    public void removeRowSelectionInterval(int n, int n2) {
        this.selectionModel.removeSelectionInterval(n, n2);
    }

    public void removeColumnSelectionInterval(int n, int n2) {
        this.columnModel.getSelectionModel().removeSelectionInterval(n, n2);
    }

    public int getSelectedRow() {
        if (this.selectionModel != null) {
            return this.selectionModel.getAnchorSelectionIndex();
        }
        return -1;
    }

    public int getSelectedColumn() {
        return this.columnModel.getSelectionModel().getAnchorSelectionIndex();
    }

    public int[] getSelectedRows() {
        if (this.selectionModel != null) {
            int n = this.selectionModel.getMinSelectionIndex();
            int n2 = this.selectionModel.getMaxSelectionIndex();
            if (n == -1 || n2 == -1) {
                return new int[0];
            }
            int[] nArray = new int[1 + (n2 - n)];
            int n3 = 0;
            int n4 = n;
            while (n4 <= n2) {
                if (this.selectionModel.isSelectedIndex(n4)) {
                    nArray[n3++] = n4;
                }
                ++n4;
            }
            int[] nArray2 = new int[n3];
            System.arraycopy(nArray, 0, nArray2, 0, n3);
            return nArray2;
        }
        return new int[0];
    }

    public int[] getSelectedColumns() {
        return this.columnModel.getSelectedColumns();
    }

    public int getSelectedRowCount() {
        if (this.selectionModel != null) {
            int n = this.selectionModel.getMinSelectionIndex();
            int n2 = this.selectionModel.getMaxSelectionIndex();
            int n3 = 0;
            int n4 = n;
            while (n4 <= n2) {
                if (this.selectionModel.isSelectedIndex(n4)) {
                    ++n3;
                }
                ++n4;
            }
            return n3;
        }
        return 0;
    }

    public int getSelectedColumnCount() {
        return this.columnModel.getSelectedColumnCount();
    }

    public boolean isRowSelected(int n) {
        if (this.selectionModel != null) {
            return this.selectionModel.isSelectedIndex(n);
        }
        return false;
    }

    public boolean isColumnSelected(int n) {
        return this.columnModel.getSelectionModel().isSelectedIndex(n);
    }

    public boolean isCellSelected(int n, int n2) {
        if (this.cellSelectionEnabled) {
            return this.isRowSelected(n) && this.isColumnSelected(n2);
        }
        return this.getRowSelectionAllowed() && this.isRowSelected(n) || this.getColumnSelectionAllowed() && this.isColumnSelected(n2);
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionForeground(Color color) {
        Color color2 = this.selectionForeground;
        this.selectionForeground = color;
        this.firePropertyChange("selectionForeground", color2, color);
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public void setSelectionBackground(Color color) {
        Color color2 = this.selectionBackground;
        this.selectionBackground = color;
        this.firePropertyChange("selectionBackground", color2, color);
    }

    public TableColumn getColumn(Object object) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnIndex(object);
        return tableColumnModel.getColumn(n);
    }

    public int convertColumnIndexToModel(int n) {
        if (n < 0) {
            return n;
        }
        return this.getColumnModel().getColumn(n).getModelIndex();
    }

    public int convertColumnIndexToView(int n) {
        if (n < 0) {
            return n;
        }
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n2 = 0;
        while (n2 < this.getColumnCount()) {
            if (tableColumnModel.getColumn(n2).getModelIndex() == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int getRowCount() {
        return this.getModel().getRowCount();
    }

    public int getColumnCount() {
        return this.getColumnModel().getColumnCount();
    }

    public String getColumnName(int n) {
        return this.getModel().getColumnName(this.convertColumnIndexToModel(n));
    }

    public Class getColumnClass(int n) {
        return this.getModel().getColumnClass(this.convertColumnIndexToModel(n));
    }

    public Object getValueAt(int n, int n2) {
        return this.getModel().getValueAt(n, this.convertColumnIndexToModel(n2));
    }

    public void setValueAt(Object object, int n, int n2) {
        this.getModel().setValueAt(object, n, this.convertColumnIndexToModel(n2));
    }

    public boolean isCellEditable(int n, int n2) {
        return this.getModel().isCellEditable(n, this.convertColumnIndexToModel(n2));
    }

    public void addColumn(TableColumn tableColumn) {
        int n = tableColumn.getModelIndex();
        String string = this.getModel().getColumnName(n);
        if (tableColumn.getHeaderValue() == null) {
            tableColumn.setHeaderValue(string);
        }
        this.getColumnModel().addColumn(tableColumn);
    }

    public void removeColumn(TableColumn tableColumn) {
        this.getColumnModel().removeColumn(tableColumn);
    }

    public void moveColumn(int n, int n2) {
        this.getColumnModel().moveColumn(n, n2);
    }

    public int columnAtPoint(Point point) {
        return this.getColumnModel().getColumnIndexAtX(point.x);
    }

    public int rowAtPoint(Point point) {
        int n;
        int n2 = point.y;
        int n3 = this.getRowHeight();
        int n4 = n3 + (n = this.getIntercellSpacing().height);
        int n5 = n2 / n4;
        if (n5 < 0) {
            return -1;
        }
        if (n5 >= this.getRowCount()) {
            return -1;
        }
        return n5;
    }

    public Rectangle getCellRect(int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = this.getColumnModel().getColumnMargin();
        Enumeration enumeration = this.getColumnModel().getColumns();
        Rectangle rectangle = new Rectangle();
        rectangle.height = this.getRowHeight() + this.rowMargin;
        rectangle.y = n * rectangle.height;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            rectangle.width = tableColumn.getWidth() + n4;
            if (n3 == n2) break;
            rectangle.x += rectangle.width;
            ++n3;
        }
        if (!bl) {
            Dimension dimension = this.getIntercellSpacing();
            rectangle.setBounds(rectangle.x + dimension.width / 2, rectangle.y + dimension.height / 2, rectangle.width - dimension.width, rectangle.height - dimension.height);
        }
        return rectangle;
    }

    public void sizeColumnsToFit(boolean bl) {
        TableColumn tableColumn;
        Enumeration enumeration;
        int[] nArray;
        int n;
        block18: {
            int n2;
            int n3;
            int[] nArray2;
            int[] nArray3;
            int n4;
            int n5;
            block19: {
                n5 = this.getColumnModel().getColumnMargin();
                int n6 = this.getWidth();
                n4 = 0;
                n = 0;
                nArray = new int[this.getColumnCount()];
                nArray3 = new int[this.getColumnCount()];
                nArray2 = new int[this.getColumnCount()];
                enumeration = this.getColumnModel().getColumns();
                while (enumeration.hasMoreElements()) {
                    tableColumn = (TableColumn)enumeration.nextElement();
                    nArray[n] = tableColumn.getWidth();
                    nArray3[n] = tableColumn.getMaxWidth();
                    nArray2[n] = tableColumn.getMinWidth();
                    n4 += tableColumn.getWidth() + n5;
                    ++n;
                }
                n3 = n6 - n4;
                if (n3 >= -1 && n3 <= 1) {
                    return;
                }
                if (!bl) break block19;
                n = this.getColumnCount() - 1;
                while (n >= 0) {
                    n2 = n3 > 0 ? nArray3[n] - nArray[n] : nArray2[n] - nArray[n];
                    if (Math.abs(n2) >= Math.abs(n3)) {
                        int n7 = n;
                        nArray[n7] = nArray[n7] + n3;
                        break block18;
                    }
                    int n8 = n--;
                    nArray[n8] = nArray[n8] + n2;
                    n3 -= n2;
                }
                break block18;
            }
            float[] fArray = new float[this.getColumnCount()];
            boolean bl2 = true;
            n = 0;
            while (n < this.getColumnCount()) {
                fArray[n] = (float)(nArray[n] + n5) / (float)n4;
                ++n;
            }
            while (n3 != 0 && bl2) {
                int n9 = n3;
                bl2 = false;
                n = 0;
                while (n < this.getColumnCount()) {
                    block22: {
                        int n10;
                        block21: {
                            block20: {
                                n10 = (int)Math.ceil((float)n3 * fArray[n]);
                                if (n9 == 0) break;
                                if (Math.abs(n9) < Math.abs(n10)) {
                                    n10 = n9;
                                }
                                if (n10 <= 0) break block20;
                                n2 = nArray3[n] - nArray[n];
                                break block21;
                            }
                            if (n10 >= 0) break block22;
                            n2 = nArray2[n] - nArray[n];
                        }
                        if (Math.abs(n2) >= Math.abs(n10)) {
                            bl2 = true;
                            int n11 = n;
                            nArray[n11] = nArray[n11] + n10;
                            n9 -= n10;
                        } else if (n2 != 0) {
                            int n12 = n;
                            nArray[n12] = nArray[n12] + n2;
                            n9 -= n2;
                            fArray[n] = 0.0f;
                        }
                    }
                    ++n;
                }
                if ((n3 = n9) == 0) continue;
                float f = 0.0f;
                n = 0;
                while (n < this.getColumnCount()) {
                    f += fArray[n];
                    ++n;
                }
                float f2 = 100.0f / f;
                n = 0;
                while (n < this.getColumnCount()) {
                    int n13 = n++;
                    fArray[n13] = fArray[n13] * f2;
                }
            }
        }
        n = 0;
        enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            tableColumn = (TableColumn)enumeration.nextElement();
            tableColumn.setWidth(nArray[n]);
            ++n;
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        Point point = mouseEvent.getPoint();
        int n = this.columnAtPoint(point);
        int n2 = this.rowAtPoint(point);
        if (n != -1 && n2 != -1) {
            Serializable serializable;
            TableColumn tableColumn = this.getColumnModel().getColumn(n);
            TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
            if (tableCellRenderer == null) {
                serializable = this.getColumnClass(n);
                tableCellRenderer = this.getDefaultRenderer((Class)serializable);
            }
            if ((serializable = tableCellRenderer.getTableCellRendererComponent(this, null, false, false, n2, n)) instanceof JComponent) {
                Rectangle rectangle = this.getCellRect(n2, n, false);
                point.translate(-rectangle.x, -rectangle.y);
                MouseEvent mouseEvent2 = new MouseEvent((Component)serializable, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                string = ((JComponent)serializable).getToolTipText(mouseEvent2);
            }
        }
        if (string == null) {
            string = this.getToolTipText();
        }
        return string;
    }

    public boolean editCellAt(int n, int n2) {
        return this.editCellAt(n, n2, null);
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl;
        if (!this.isCellEditable(n, n2)) {
            return false;
        }
        if (this.isEditing() && this.cellEditor != null && !(bl = this.cellEditor.stopCellEditing())) {
            return false;
        }
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        TableCellEditor tableCellEditor = tableColumn.getCellEditor();
        if (tableCellEditor == null) {
            tableCellEditor = this.getDefaultEditor(this.getColumnClass(n2));
        }
        if (tableCellEditor != null) {
            this.editorComp = this.prepareEditor(tableCellEditor, n, n2);
            if (tableCellEditor.isCellEditable(eventObject)) {
                this.editorComp.setBounds(this.getCellRect(n, n2, false));
                this.add(this.editorComp);
                this.editorComp.validate();
                tableCellEditor.shouldSelectCell(eventObject);
                this.setCellEditor(tableCellEditor);
                this.setEditingRow(n);
                this.setEditingColumn(n2);
                tableCellEditor.addCellEditorListener(this);
                this.repaint();
                return true;
            }
        }
        return false;
    }

    public boolean isEditing() {
        return this.cellEditor != null;
    }

    public Component getEditorComponent() {
        return this.editorComp;
    }

    public int getEditingColumn() {
        return this.editingColumn;
    }

    public int getEditingRow() {
        return this.editingRow;
    }

    public TableUI getUI() {
        return (TableUI)this.ui;
    }

    public void setUI(TableUI tableUI) {
        if (this.ui != tableUI) {
            super.setUI(tableUI);
            this.repaint();
        }
    }

    private void updateSubComponentUI(Object object) {
        if (object == null) {
            return;
        }
        Component component = null;
        if (object instanceof Component) {
            component = (Component)object;
        }
        if (object instanceof DefaultCellEditor) {
            component = ((DefaultCellEditor)object).getComponent();
        }
        if (component != null && component instanceof JComponent) {
            ((JComponent)component).updateUI();
        }
    }

    public void updateUI() {
        Object object;
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = 0;
        while (n < tableColumnModel.getColumnCount()) {
            object = tableColumnModel.getColumn(n);
            this.updateSubComponentUI(((TableColumn)object).getCellEditor());
            ++n;
        }
        object = this.defaultEditorsByColumnClass.elements();
        while (object.hasMoreElements()) {
            this.updateSubComponentUI(object.nextElement());
        }
        this.setUI((TableUI)UIManager.getUI(this));
        this.resizeAndRepaint();
        this.invalidate();
    }

    public String getUIClassID() {
        return "TableUI";
    }

    public void setModel(TableModel tableModel) {
        TableModel tableModel2 = this.dataModel;
        if (tableModel == null) {
            throw new IllegalArgumentException("Cannot set a null TableModel");
        }
        if (tableModel != tableModel2) {
            if (tableModel2 != null) {
                tableModel2.removeTableModelListener(this);
            }
            this.dataModel = tableModel;
            tableModel.addTableModelListener(this);
            if (this.getColumnModel() != null) {
                this.tableChanged(new TableModelEvent(this.dataModel, -1));
            }
        }
    }

    public TableModel getModel() {
        return this.dataModel;
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        if (tableColumnModel == null) {
            throw new IllegalArgumentException("Cannot set a null ColumnModel");
        }
        TableColumnModel tableColumnModel2 = this.columnModel;
        if (tableColumnModel != tableColumnModel2) {
            if (tableColumnModel2 != null) {
                tableColumnModel2.removeColumnModelListener(this);
            }
            this.columnModel = tableColumnModel;
            tableColumnModel.addColumnModelListener(this);
            if (this.tableHeader != null) {
                this.tableHeader.setColumnModel(tableColumnModel);
            }
            this.resizeAndRepaint();
        }
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new IllegalArgumentException("Cannot set a null SelectionModel");
        }
        ListSelectionModel listSelectionModel2 = this.selectionModel;
        if (listSelectionModel != listSelectionModel2) {
            if (listSelectionModel2 != null) {
                listSelectionModel2.removeListSelectionListener(this);
            }
            this.selectionModel = listSelectionModel;
            if (listSelectionModel != null) {
                listSelectionModel.addListSelectionListener(this);
            }
            this.repaint();
        }
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        Rectangle rectangle;
        if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1) {
            this.clearSelection();
            if (this.getAutoCreateColumnsFromModel()) {
                this.createDefaultColumnsFromModel();
            }
            this.resizeAndRepaint();
            if (this.tableHeader != null) {
                this.tableHeader.resizeAndRepaint();
            }
            return;
        }
        if (tableModelEvent.getType() == 1) {
            this.tableRowsInserted(tableModelEvent);
            return;
        }
        if (tableModelEvent.getType() == -1) {
            this.tableRowsDeleted(tableModelEvent);
            return;
        }
        int n = tableModelEvent.getColumn();
        int n2 = tableModelEvent.getFirstRow();
        int n3 = tableModelEvent.getLastRow();
        if (n2 == -1) {
            n2 = 0;
            n3 = Integer.MAX_VALUE;
        }
        int n4 = this.getRowHeight() + this.rowMargin;
        if (n == -1) {
            rectangle = new Rectangle(0, n2 * n4, this.getColumnModel().getTotalColumnWidth(), 0);
        } else {
            int n5 = this.convertColumnIndexToView(n);
            rectangle = this.getCellRect(n2, n5, false);
        }
        if (n3 != Integer.MAX_VALUE) {
            rectangle.height = (n3 - n2 + 1) * n4;
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            return;
        }
        this.resizeAndRepaint();
    }

    private void tableRowsInserted(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        if (n < 0) {
            n = 0;
        }
        int n2 = this.getRowHeight() + this.rowMargin;
        Rectangle rectangle = new Rectangle(0, n * n2, this.getColumnModel().getTotalColumnWidth(), (this.getRowCount() - n) * n2);
        if (this.selectionModel != null) {
            int n3 = tableModelEvent.getLastRow();
            if (n3 < 0) {
                n3 = this.getRowCount() - 1;
            }
            int n4 = n3 - n + 1;
            this.selectionModel.insertIndexInterval(n, n4, true);
        }
        this.revalidate();
        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void tableRowsDeleted(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        if (n < 0) {
            n = 0;
        }
        int n2 = this.getRowHeight() + this.rowMargin;
        Rectangle rectangle = new Rectangle(0, n * n2, this.getColumnModel().getTotalColumnWidth(), (this.getRowCount() - n) * n2);
        if (this.selectionModel != null) {
            int n3 = tableModelEvent.getLastRow();
            if (n3 < 0) {
                n3 = this.getRowCount() - 1;
            }
            this.selectionModel.removeIndexInterval(n, n3);
        }
        this.revalidate();
        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        if (this.isEditing()) {
            this.removeEditor();
        }
        this.resizeAndRepaint();
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        if (this.isEditing()) {
            this.removeEditor();
        }
        this.resizeAndRepaint();
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        if (this.isEditing()) {
            this.removeEditor();
        }
        this.repaint();
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
        if (this.isEditing()) {
            this.removeEditor();
        }
        this.resizeAndRepaint();
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        int n = listSelectionEvent.getFirstIndex();
        int n2 = listSelectionEvent.getLastIndex();
        if (n == -1 && n2 == -1) {
            this.repaint();
        }
        Rectangle rectangle = this.getCellRect(0, n, false);
        Rectangle rectangle2 = this.getCellRect(this.getRowCount(), n2, false);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        this.repaint(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = listSelectionEvent.getFirstIndex();
        int n2 = listSelectionEvent.getLastIndex();
        if (n == -1 && n2 == -1) {
            this.repaint();
        }
        Rectangle rectangle = this.getCellRect(n, 0, false);
        Rectangle rectangle2 = this.getCellRect(n2, this.getColumnCount(), false);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        this.repaint(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
    }

    public void editingStopped(ChangeEvent changeEvent) {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            Object object = tableCellEditor.getCellEditorValue();
            this.setValueAt(object, this.editingRow, this.editingColumn);
            this.removeEditor();
        }
    }

    public void editingCanceled(ChangeEvent changeEvent) {
        this.removeEditor();
    }

    public void setPreferredScrollableViewportSize(Dimension dimension) {
        this.preferredViewportSize = dimension;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.preferredViewportSize;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return 1;
        }
        return this.rowHeight;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return rectangle.height;
        }
        return rectangle.width;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    protected void createDefaultRenderers() {
        this.defaultRenderersByColumnClass = new Hashtable();
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        this.setDefaultRenderer(class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = JComponent.class$("java.lang.Object")), defaultTableCellRenderer);
        DefaultTableCellRenderer defaultTableCellRenderer2 = new DefaultTableCellRenderer();
        defaultTableCellRenderer2.setHorizontalAlignment(4);
        this.setDefaultRenderer(class$java$lang$Number != null ? class$java$lang$Number : (class$java$lang$Number = JComponent.class$("java.lang.Number")), defaultTableCellRenderer2);
        3 var3_3 = new 3();
        var3_3.setHorizontalAlignment(0);
        this.setDefaultRenderer(class$com$sun$java$swing$ImageIcon != null ? class$com$sun$java$swing$ImageIcon : (class$com$sun$java$swing$ImageIcon = JComponent.class$("com.sun.java.swing.ImageIcon")), var3_3);
        CheckBoxRenderer checkBoxRenderer = new CheckBoxRenderer();
        checkBoxRenderer.setHorizontalAlignment(0);
        this.setDefaultRenderer(class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = JComponent.class$("java.lang.Boolean")), checkBoxRenderer);
    }

    protected void createDefaultEditors() {
        this.defaultEditorsByColumnClass = new Hashtable();
        JTextField jTextField = new JTextField();
        jTextField.setBorder(new LineBorder(Color.black));
        this.setDefaultEditor(class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = JComponent.class$("java.lang.Object")), new DefaultCellEditor(jTextField));
        JTextField jTextField2 = new JTextField();
        jTextField2.setHorizontalAlignment(4);
        jTextField2.setBorder(new LineBorder(Color.black));
        this.setDefaultEditor(class$java$lang$Number != null ? class$java$lang$Number : (class$java$lang$Number = JComponent.class$("java.lang.Number")), new DefaultCellEditor(jTextField2));
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setHorizontalAlignment(0);
        this.setDefaultEditor(class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = JComponent.class$("java.lang.Boolean")), new DefaultCellEditor(jCheckBox));
    }

    protected void initializeLocalVars() {
        this.createDefaultRenderers();
        this.createDefaultEditors();
        this.setTableHeader(this.createDefaultTableHeader());
        this.setShowGrid(true);
        this.setAutoResizeMode(2);
        this.setRowHeight(16);
        this.rowMargin = 1;
        this.setSelectionMode(2);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setCellSelectionEnabled(false);
        this.cellEditor = null;
        this.editingRow = -1;
        this.editingColumn = -1;
        this.preferredViewportSize = new Dimension(450, 400);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.setAutoscrolls(true);
        this.tableHeader.setAutoscrolls(true);
    }

    protected TableModel createDefaultDataModel() {
        return new DefaultTableModel();
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModel();
    }

    protected ListSelectionModel createDefaultSelectionModel() {
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        defaultListSelectionModel.setLeadAnchorNotificationEnabled(false);
        return defaultListSelectionModel;
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel);
    }

    protected void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void setCellEditor(TableCellEditor tableCellEditor) {
        this.cellEditor = tableCellEditor;
    }

    public void setEditingColumn(int n) {
        this.editingColumn = n;
    }

    public void setEditingRow(int n) {
        this.editingRow = n;
    }

    public boolean isOpaque() {
        return true;
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Object object = this.getValueAt(n, n2);
        this.getColumnModel().getColumn(n2);
        boolean bl = this.isCellSelected(n, n2);
        Component component = tableCellEditor.getTableCellEditorComponent(this, object, bl, n, n2);
        if (component != null && component.getFont() == null) {
            component.setFont(this.getFont());
        }
        return component;
    }

    public void removeEditor() {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.removeCellEditorListener(this);
            if (this.editorComp instanceof JComboBox) {
                ((JComboBox)this.editorComp).hidePopup();
            }
            this.remove(this.editorComp);
            Rectangle rectangle = this.getCellRect(this.editingRow, this.editingColumn, false);
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (!(this.editorComp instanceof JComponent) || ((JComponent)this.editorComp).hasFocus()) {
                this.requestFocus();
            }
            this.setCellEditor(null);
            this.setEditingColumn(-1);
            this.setEditingRow(-1);
            this.editorComp = null;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.createDefaultRenderers();
        this.createDefaultEditors();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTable();
        }
        return this.accessibleContext;
    }

    private static final class 1
    extends AbstractTableModel {
        private final /* synthetic */ Vector val$rowData;
        private final /* synthetic */ Vector val$columnNames;

        public String getColumnName(int n) {
            return this.val$columnNames.elementAt(n).toString();
        }

        public int getRowCount() {
            return this.val$rowData.size();
        }

        public int getColumnCount() {
            return this.val$columnNames.size();
        }

        public Object getValueAt(int n, int n2) {
            return ((Vector)this.val$rowData.elementAt(n)).elementAt(n2);
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public void setValueAt(Object object, int n, int n2) {
            ((Vector)this.val$rowData.elementAt(n)).setElementAt(object, n2);
        }

        /* synthetic */ 1(Vector vector, Vector vector2) {
            this.val$columnNames = vector;
            this.val$rowData = vector2;
        }
    }

    private static final class 2
    extends AbstractTableModel {
        private final /* synthetic */ Object[][] val$rowData;
        private final /* synthetic */ Object[] val$columnNames;

        public String getColumnName(int n) {
            return this.val$columnNames[n].toString();
        }

        public int getRowCount() {
            return this.val$rowData.length;
        }

        public int getColumnCount() {
            return this.val$columnNames.length;
        }

        public Object getValueAt(int n, int n2) {
            return this.val$rowData[n][n2];
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public void setValueAt(Object object, int n, int n2) {
            this.val$rowData[n][n2] = object;
        }

        /* synthetic */ 2(Object[] objectArray, Object[][] objectArray2) {
            this.val$columnNames = objectArray;
            this.val$rowData = objectArray2;
        }
    }

    private class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setSelected(object != null && (Boolean)object != false);
            return this;
        }

        CheckBoxRenderer() {
            JTable.this = JTable.this;
        }
    }

    private final class 3
    extends DefaultTableCellRenderer {
        public void setValue(Object object) {
            this.setIcon((Icon)object);
        }

        /* synthetic */ 3() {
        }
    }

    protected class AccessibleJTable
    extends JComponent.AccessibleJComponent {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TABLE;
        }

        public Accessible getAccessibleAt(Point point) {
            int n = JTable.this.columnAtPoint(point);
            int n2 = JTable.this.rowAtPoint(point);
            if (n != -1 && n2 != -1) {
                TableColumn tableColumn = JTable.this.getColumnModel().getColumn(n);
                TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
                if (tableCellRenderer == null) {
                    Class clazz = JTable.this.getColumnClass(n);
                    tableCellRenderer = JTable.this.getDefaultRenderer(clazz);
                }
                tableCellRenderer.getTableCellRendererComponent(JTable.this, null, false, false, n2, n);
                return new AccessibleJTableCell(JTable.this, n2, n, this.getAccessibleIndexAt(n2, n));
            }
            return null;
        }

        public int getAccessibleChildrenCount() {
            return JTable.this.getColumnCount() * JTable.this.getRowCount();
        }

        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                return null;
            }
            int n2 = this.getAccessibleColumnAtIndex(n);
            int n3 = this.getAccessibleRowAtIndex(n);
            TableColumn tableColumn = JTable.this.getColumnModel().getColumn(n2);
            TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
            if (tableCellRenderer == null) {
                Class clazz = JTable.this.getColumnClass(n2);
                tableCellRenderer = JTable.this.getDefaultRenderer(clazz);
            }
            tableCellRenderer.getTableCellRendererComponent(JTable.this, null, false, false, n3, n2);
            return new AccessibleJTableCell(JTable.this, n3, n2, this.getAccessibleIndexAt(n3, n2));
        }

        private int getAccessibleRowCount() {
            return JTable.this.getRowCount();
        }

        private int getAccessibleColumnCount() {
            return JTable.this.getColumnCount();
        }

        private int getAccessibleRowAtIndex(int n) {
            return n / this.getAccessibleColumnCount();
        }

        private int getAccessibleColumnAtIndex(int n) {
            return n % this.getAccessibleColumnCount();
        }

        private int getAccessibleIndexAt(int n, int n2) {
            return n * this.getAccessibleColumnCount() + n2;
        }

        private Accessible getAccessibleAt(int n, int n2) {
            return this.getAccessibleChild(n * this.getAccessibleColumnCount() + n2);
        }

        private Accessible getAccessibleRowHeader(int n) {
            return null;
        }

        private Accessible getAccessibleColumnHeader(int n) {
            JTableHeader jTableHeader = JTable.this.getTableHeader();
            AccessibleContext accessibleContext = jTableHeader.getAccessibleContext();
            if (accessibleContext != null) {
                return accessibleContext.getAccessibleChild(n);
            }
            return null;
        }

        AccessibleJTable() {
            JTable.this = JTable.this;
        }

        protected class AccessibleJTableCell
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private JTable parent;
            private int row;
            private int column;
            private int index;

            public AccessibleJTableCell(JTable jTable, int n, int n2, int n3) {
                AccessibleJTable.this = AccessibleJTable.this;
                this.parent = jTable;
                this.row = n;
                this.column = n2;
                this.index = n3;
                this.setAccessibleParent(this.parent);
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            private AccessibleContext getCurrentAccessibleContext() {
                Serializable serializable;
                TableColumn tableColumn = JTable.this.getColumnModel().getColumn(this.column);
                TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
                if (tableCellRenderer == null) {
                    serializable = JTable.this.getColumnClass(this.column);
                    tableCellRenderer = JTable.this.getDefaultRenderer((Class)serializable);
                }
                if ((serializable = tableCellRenderer.getTableCellRendererComponent(JTable.this, null, false, false, this.row, this.column)) instanceof Accessible) {
                    return ((Accessible)((Object)serializable)).getAccessibleContext();
                }
                return null;
            }

            private Component getCurrentComponent() {
                TableColumn tableColumn = JTable.this.getColumnModel().getColumn(this.column);
                TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
                if (tableCellRenderer == null) {
                    Class clazz = JTable.this.getColumnClass(this.column);
                    tableCellRenderer = JTable.this.getDefaultRenderer(clazz);
                }
                return tableCellRenderer.getTableCellRendererComponent(JTable.this, null, false, false, this.row, this.column);
            }

            public String getAccessibleName() {
                String string;
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && (string = accessibleContext.getAccessibleName()) != null && string != "") {
                    return accessibleContext.getAccessibleName();
                }
                if (this.accessibleName != null && this.accessibleName != "") {
                    return this.accessibleName;
                }
                return this.parent.getValueAt(this.row, this.column).toString();
            }

            public void setAccessibleName(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                    return;
                }
                super.setAccessibleName(string);
            }

            public String getAccessibleDescription() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleDescription();
                }
                return super.getAccessibleDescription();
            }

            public void setAccessibleDescription(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(string);
                    return;
                }
                super.setAccessibleDescription(string);
            }

            public AccessibleRole getAccessibleRole() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleRole();
                }
                return AccessibleRole.UNKNOWN;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleStateSet();
                }
                return new AccessibleStateSet();
            }

            public Accessible getAccessibleParent() {
                return this.parent;
            }

            public int getAccessibleIndexInParent() {
                return this.index;
            }

            public int getAccessibleChildrenCount() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleChildrenCount();
                }
                return 0;
            }

            public Accessible getAccessibleChild(int n) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    Accessible accessible = accessibleContext.getAccessibleChild(n);
                    accessibleContext.setAccessibleParent(this);
                    return accessible;
                }
                return null;
            }

            public Locale getLocale() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getLocale();
                }
                return null;
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.addPropertyChangeListener(propertyChangeListener);
                    return;
                }
                super.addPropertyChangeListener(propertyChangeListener);
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.removePropertyChangeListener(propertyChangeListener);
                    return;
                }
                super.removePropertyChangeListener(propertyChangeListener);
            }

            public AccessibleAction getAccessibleAction() {
                return this.getCurrentAccessibleContext().getAccessibleAction();
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public AccessibleSelection getAccessibleSelection() {
                return this.getCurrentAccessibleContext().getAccessibleSelection();
            }

            public AccessibleText getAccessibleText() {
                return this.getCurrentAccessibleContext().getAccessibleText();
            }

            public AccessibleValue getAccessibleValue() {
                return this.getCurrentAccessibleContext().getAccessibleValue();
            }

            public Color getBackground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getBackground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getBackground();
                }
                return null;
            }

            public void setBackground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBackground(color);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setBackground(color);
                }
            }

            public Color getForeground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getForeground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getForeground();
                }
                return null;
            }

            public void setForeground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setForeground(color);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setForeground(color);
                }
            }

            public Cursor getCursor() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getCursor();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getCursor();
                }
                Accessible accessible = this.getAccessibleParent();
                if (accessible instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessible)).getCursor();
                }
                return null;
            }

            public void setCursor(Cursor cursor) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setCursor(cursor);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setCursor(cursor);
                }
            }

            public Font getFont() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFont();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFont();
                }
                return null;
            }

            public void setFont(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setFont(font);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setFont(font);
                }
            }

            public FontMetrics getFontMetrics(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFontMetrics(font);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFontMetrics(font);
                }
                return null;
            }

            public boolean isEnabled() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isEnabled();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isEnabled();
                }
                return false;
            }

            public void setEnabled(boolean bl) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setEnabled(bl);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setEnabled(bl);
                }
            }

            public boolean isVisible() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isVisible();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isVisible();
                }
                return false;
            }

            public void setVisible(boolean bl) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setVisible(bl);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setVisible(bl);
                }
            }

            public boolean isShowing() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isShowing();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isShowing();
                }
                return false;
            }

            public boolean contains(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                    return rectangle.contains(point);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.contains(point);
                }
                return this.getBounds().contains(point);
            }

            public Point getLocationOnScreen() {
                if (this.parent != null) {
                    Point point = this.parent.getLocationOnScreen();
                    Point point2 = this.getLocation();
                    point2.translate(point.x, point.y);
                    return point2;
                }
                return null;
            }

            public Point getLocation() {
                Rectangle rectangle;
                if (this.parent != null && (rectangle = this.parent.getCellRect(this.row, this.column, false)) != null) {
                    return rectangle.getLocation();
                }
                return null;
            }

            public void setLocation(Point point) {
            }

            public Rectangle getBounds() {
                if (this.parent != null) {
                    return this.parent.getCellRect(this.row, this.column, false);
                }
                return null;
            }

            public void setBounds(Rectangle rectangle) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBounds(rectangle);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setBounds(rectangle);
                }
            }

            public Dimension getSize() {
                Rectangle rectangle;
                if (this.parent != null && (rectangle = this.parent.getCellRect(this.row, this.column, false)) != null) {
                    return rectangle.getSize();
                }
                return null;
            }

            public void setSize(Dimension dimension) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setSize(dimension);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setSize(dimension);
                }
            }

            public Accessible getAccessibleAt(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getAccessibleAt(point);
                }
                return null;
            }

            public boolean isFocusTraversable() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isFocusTraversable();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isFocusTraversable();
                }
                return false;
            }

            public void requestFocus() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).requestFocus();
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.requestFocus();
                }
            }

            public void addFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).addFocusListener(focusListener);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.addFocusListener(focusListener);
                }
            }

            public void removeFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).removeFocusListener(focusListener);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.removeFocusListener(focusListener);
                }
            }
        }
    }
}

