/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JMenu;
import com.sun.java.swing.JMenuBar;
import com.sun.java.swing.JMenuItem;
import com.sun.java.swing.JPopupMenu;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.MenuElement;
import com.sun.java.swing.MenuSelectionManager;
import com.sun.java.swing.Timer;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.MenuUI;
import com.sun.java.swing.plaf.UIResource;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;
import com.sun.java.swing.plaf.basic.BasicMenuMouseMotionListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public class BasicMenuUI
extends MenuUI
implements Serializable {
    protected JMenu menu;
    protected MouseListener mouseListener;
    protected MouseMotionListener dragListener;
    protected ChangeListener menuChangeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected static Color pressedBackground;
    protected static Color pressedForeground;
    private int lastMnemonic;
    protected static final int defaultTextIconGap = 4;
    protected Icon menuArrow;
    protected Icon checkIcon;
    protected boolean oldBorderPainted;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuUI();
    }

    public void installUI(JComponent jComponent) {
        this.menu = (JMenu)jComponent;
        this.menu.setDelay(200);
        this.initListeners(jComponent);
        this.addListeners(jComponent);
        jComponent.setOpaque(true);
        LookAndFeel.installBorder(jComponent, "Menu.border");
        this.oldBorderPainted = this.menu.isBorderPainted();
        this.menu.setBorderPainted((Boolean)UIManager.get("MenuItem.borderPainted"));
        LookAndFeel.installColorsAndFont(jComponent, "Menu.background", "Menu.foreground", "Menu.font");
        this.validateKeyboardAccelerator();
        if (pressedBackground == null || pressedBackground instanceof UIResource) {
            pressedBackground = UIManager.getColor("Menu.pressedBackground");
        }
        if (pressedForeground == null || pressedForeground instanceof UIResource) {
            pressedForeground = UIManager.getColor("Menu.pressedForeground");
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.menu.setArmed(false);
        this.menu.setSelected(false);
        this.removeListeners(jComponent);
        jComponent.resetKeyboardActions();
        LookAndFeel.uninstallBorder(jComponent);
        ((JMenu)jComponent).setBorderPainted(this.oldBorderPainted);
        if (this.menuArrow instanceof UIResource) {
            this.menuArrow = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void validateKeyboardAccelerator() {
        if (this.menu.getModel().getMnemonic() != this.lastMnemonic) {
            this.menu.unregisterKeyboardAction(KeyStroke.getKeyStroke(this.lastMnemonic, 8, false));
            this.lastMnemonic = this.menu.getModel().getMnemonic();
            this.menu.registerKeyboardAction(new PostAction(this.menu, true), KeyStroke.getKeyStroke(this.lastMnemonic, 8, false), 2);
        }
    }

    protected MouseListener createMouseListener(JComponent jComponent) {
        return new MouseListener((JMenu)jComponent);
    }

    protected MouseMotionListener createMouseMotionListener(JComponent jComponent) {
        return new BasicMenuMouseMotionListener();
    }

    protected ChangeListener createMenuChangeListener(JComponent jComponent) {
        return new MenuChangeListener((JMenu)jComponent, this);
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return new MenuPropertyChangeListener();
    }

    protected void initListeners(JComponent jComponent) {
        this.mouseListener = this.createMouseListener(jComponent);
        this.dragListener = this.createMouseMotionListener(jComponent);
        this.menuChangeListener = this.createMenuChangeListener(jComponent);
        this.propertyChangeListener = this.createPropertyChangeListener(jComponent);
    }

    protected void addListeners(JComponent jComponent) {
        jComponent.addMouseListener(this.mouseListener);
        jComponent.addMouseMotionListener(this.dragListener);
        ((JMenu)jComponent).addChangeListener(this.menuChangeListener);
        ((JMenu)jComponent).addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void removeListeners(JComponent jComponent) {
        jComponent.removeMouseListener(this.mouseListener);
        jComponent.removeMouseMotionListener(this.dragListener);
        ((JMenu)jComponent).removeChangeListener(this.menuChangeListener);
        ((JMenu)jComponent).removePropertyChangeListener(this.propertyChangeListener);
    }

    protected void installDefaultIcons() {
        if (this.menu != null && this.menu.getParent() != null && !(this.menu.getParent() instanceof JMenuBar)) {
            if (this.menuArrow == null || this.menuArrow instanceof UIResource) {
                this.menuArrow = UIManager.getIcon("Menu.arrowIcon");
            }
            if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
                this.checkIcon = UIManager.getIcon("MenuItem.checkIcon");
            }
        }
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.installDefaultIcons();
        ((AbstractButton)jComponent).getModel();
        BasicGraphicsUtils.paintMenuItem(graphics, jComponent, this.checkIcon, this.menuArrow, pressedBackground, pressedForeground, 4);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Insets getDefaultMargin(AbstractButton abstractButton) {
        return new Insets(2, 2, 2, 2);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        this.installDefaultIcons();
        return BasicGraphicsUtils.getPreferredMenuItemSize(jComponent, this.checkIcon, this.menuArrow, 4);
    }

    public void processMouseEvent(JMenuItem jMenuItem, MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        Component component;
        Point point = mouseEvent.getPoint();
        if (!jMenuItem.isEnabled()) {
            return;
        }
        if (point.x >= 0 && point.x < jMenuItem.getWidth() && point.y >= 0 && point.y < jMenuItem.getHeight()) {
            JMenu jMenu = (JMenu)jMenuItem;
            MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
            if (menuElementArray2.length <= 0 || menuElementArray2[menuElementArray2.length - 1] != jMenu.getPopupMenu()) {
                if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0 || mouseEvent.getID() == 506) {
                    MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                    menuElementArray3[menuElementArray.length] = jMenu.getPopupMenu();
                    menuSelectionManager.setSelectedPath(menuElementArray3);
                    return;
                }
                menuSelectionManager.setSelectedPath(menuElementArray);
                this.setupPostTimer(jMenu);
            }
            return;
        }
        if (mouseEvent.getID() == 502 && (component = menuSelectionManager.componentForPoint(mouseEvent.getComponent(), mouseEvent.getPoint())) == null) {
            menuSelectionManager.clearSelectedPath();
        }
    }

    private int lower(int n) {
        if (n >= 65 && n <= 90) {
            return n + 97 - 65;
        }
        return n;
    }

    public void processKeyEvent(JMenuItem jMenuItem, KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        int n = jMenuItem.getMnemonic();
        if (n == 0) {
            return;
        }
        if (keyEvent.getID() == 401 && this.lower(n) == this.lower(keyEvent.getKeyChar())) {
            JPopupMenu jPopupMenu = ((JMenu)jMenuItem).getPopupMenu();
            MenuElement[] menuElementArray2 = jPopupMenu.getSubElements();
            if (menuElementArray2.length > 0) {
                MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 2];
                System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                menuElementArray3[menuElementArray.length] = jPopupMenu;
                menuElementArray3[menuElementArray.length + 1] = menuElementArray2[0];
                menuSelectionManager.setSelectedPath(menuElementArray3);
            }
            keyEvent.consume();
        }
    }

    protected void setupPostTimer(JMenu jMenu) {
        Timer timer = new Timer(jMenu.getDelay(), new PostAction(jMenu, false));
        timer.setRepeats(false);
        timer.start();
    }

    public void menuCanceled(JMenu jMenu) {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        if (menuSelectionManager.isComponentPartOfCurrentMenu(jMenu)) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }
    }

    static class PostAction
    extends AbstractAction {
        JMenu menu;
        boolean force = false;

        PostAction(JMenu jMenu, boolean bl) {
            super("postAction");
            this.menu = jMenu;
            this.force = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (this.force) {
                Container container = this.menu.getParent();
                if (container != null && container instanceof JMenuBar) {
                    MenuElement[] menuElementArray = this.menu.getPopupMenu().getSubElements();
                    if (menuElementArray.length > 0) {
                        MenuElement[] menuElementArray2 = new MenuElement[]{(MenuElement)((Object)container), this.menu, this.menu.getPopupMenu(), menuElementArray[0]};
                        menuSelectionManager.setSelectedPath(menuElementArray2);
                        return;
                    }
                    MenuElement[] menuElementArray3 = new MenuElement[]{(MenuElement)((Object)container), this.menu};
                    menuSelectionManager.setSelectedPath(menuElementArray3);
                    return;
                }
            } else {
                MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                if (menuElementArray.length > 0 && menuElementArray[menuElementArray.length - 1] == this.menu) {
                    MenuElement[] menuElementArray4 = new MenuElement[menuElementArray.length + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray4, 0, menuElementArray.length);
                    menuElementArray4[menuElementArray.length] = this.menu.getPopupMenu();
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray4);
                }
            }
        }

        public boolean isEnabled() {
            return this.menu.getModel().isEnabled();
        }
    }

    class MenuPropertyChangeListener
    implements PropertyChangeListener,
    Serializable {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("MnemonicChanged")) {
                BasicMenuUI.this.validateKeyboardAccelerator();
            }
        }

        MenuPropertyChangeListener() {
            BasicMenuUI.this = BasicMenuUI.this;
        }
    }

    static class MouseListener
    extends MouseAdapter
    implements Serializable {
        JMenu menu;

        public MouseListener(JMenu jMenu) {
            this.menu = jMenu;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.menu.isTopLevelMenu() && this.menu.isEnabled()) {
                Point point = mouseEvent.getPoint();
                if (point.x >= 0 && point.x < this.menu.getWidth() && point.y >= 0 && point.y < this.menu.getHeight()) {
                    if (this.menu.isSelected()) {
                        MenuSelectionManager.defaultManager().clearSelectedPath();
                    } else {
                        Container container = this.menu.getParent();
                        if (container != null && container instanceof JMenuBar) {
                            MenuElement[] menuElementArray = new MenuElement[]{(MenuElement)((Object)container), this.menu};
                            MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                        }
                    }
                }
            }
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }
    }

    static class MenuChangeListener
    implements ChangeListener,
    Serializable {
        JMenu menu;
        BasicMenuUI ui;
        boolean isSelected = false;
        Component wasFocused;

        public MenuChangeListener(JMenu jMenu, BasicMenuUI basicMenuUI) {
            this.menu = jMenu;
            this.ui = basicMenuUI;
            this.validateKeyboardActions(this.menu.isSelected());
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.validateKeyboardActions(this.menu.isSelected());
        }

        Component findFocusedComponent(Component component) {
            Container container = component.getParent();
            while (container != null) {
                if (container instanceof Window) {
                    return ((Window)container).getFocusOwner();
                }
                container = container.getParent();
            }
            return null;
        }

        void validateKeyboardActions(boolean bl) {
            if (bl != this.isSelected) {
                this.isSelected = bl;
                if (this.isSelected) {
                    boolean bl2 = this.menu.isRequestFocusEnabled();
                    this.wasFocused = this.findFocusedComponent(this.menu);
                    if (!bl2) {
                        this.menu.setRequestFocusEnabled(true);
                    }
                    this.menu.requestFocus();
                    if (!bl2) {
                        this.menu.setRequestFocusEnabled(false);
                    }
                    this.menu.registerKeyboardAction(new CancelAction(), KeyStroke.getKeyStroke(27, 0, false), 2);
                    this.menu.registerKeyboardAction(new SelectNextItemAction(), KeyStroke.getKeyStroke(40, 0, false), 2);
                    this.menu.registerKeyboardAction(new SelectPreviousItemAction(), KeyStroke.getKeyStroke(38, 0, false), 2);
                    this.menu.registerKeyboardAction(new SelectParentItemAction(), KeyStroke.getKeyStroke(37, 0, false), 2);
                    this.menu.registerKeyboardAction(new SelectChildItemAction(), KeyStroke.getKeyStroke(39, 0, false), 2);
                    this.menu.registerKeyboardAction(new ReturnAction(), KeyStroke.getKeyStroke(10, 0, false), 2);
                    return;
                }
                this.menu.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
                this.menu.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0, false));
                this.menu.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0, false));
                this.menu.unregisterKeyboardAction(KeyStroke.getKeyStroke(37, 0, false));
                this.menu.unregisterKeyboardAction(KeyStroke.getKeyStroke(39, 0, false));
                this.menu.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
                if (this.wasFocused != null) {
                    if (this.wasFocused instanceof JComponent) {
                        JComponent jComponent = (JComponent)this.wasFocused;
                        boolean bl3 = jComponent.isRequestFocusEnabled();
                        if (!bl3) {
                            jComponent.setRequestFocusEnabled(true);
                        }
                        this.wasFocused.requestFocus();
                        if (!bl3) {
                            jComponent.setRequestFocusEnabled(false);
                        }
                    } else {
                        this.wasFocused.requestFocus();
                    }
                    this.wasFocused = null;
                }
            }
        }

        private MenuElement nextEnabledChild(MenuElement[] menuElementArray, int n) {
            int n2 = n;
            int n3 = menuElementArray.length;
            while (n2 < n3) {
                Component component;
                if (menuElementArray[n2] != null && (component = menuElementArray[n2].getComponent()) != null && component.isEnabled()) {
                    return menuElementArray[n2];
                }
                ++n2;
            }
            return null;
        }

        private MenuElement previousEnabledChild(MenuElement[] menuElementArray, int n) {
            int n2 = n;
            while (n2 >= 0) {
                Component component;
                if (menuElementArray[n2] != null && (component = menuElementArray[n2].getComponent()) != null && component.isEnabled()) {
                    return menuElementArray[n2];
                }
                --n2;
            }
            return null;
        }

        private class CancelAction
        extends AbstractAction {
            public void actionPerformed(ActionEvent actionEvent) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                if (menuElementArray.length > 4) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 2];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length - 2);
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                    return;
                }
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }

            CancelAction() {
                MenuChangeListener.this = MenuChangeListener.this;
            }
        }

        private class ReturnAction
        extends AbstractAction {
            public void actionPerformed(ActionEvent actionEvent) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                if (menuElementArray.length > 0) {
                    MenuElement menuElement = menuElementArray[menuElementArray.length - 1];
                    if (menuElement instanceof JMenu) {
                        MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
                        System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
                        menuElementArray2[menuElementArray.length] = ((JMenu)menuElement).getPopupMenu();
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                        return;
                    }
                    if (menuElement instanceof JMenuItem) {
                        MenuSelectionManager.defaultManager().clearSelectedPath();
                        ((JMenuItem)menuElement).doClick(0);
                        ((JMenuItem)menuElement).setArmed(false);
                    }
                }
            }

            ReturnAction() {
                MenuChangeListener.this = MenuChangeListener.this;
            }
        }

        private class SelectNextItemAction
        extends AbstractAction {
            public void actionPerformed(ActionEvent actionEvent) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                if (menuElementArray.length > 1) {
                    MenuElement menuElement = menuElementArray[menuElementArray.length - 2];
                    if (menuElement.getComponent() instanceof JMenu) {
                        menuElement = menuElementArray[menuElementArray.length - 1];
                        MenuElement[] menuElementArray2 = menuElement.getSubElements();
                        if (menuElementArray2.length > 0) {
                            MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 1];
                            System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                            menuElementArray3[menuElementArray.length] = MenuChangeListener.this.nextEnabledChild(menuElementArray2, 0);
                            if (menuElementArray3[menuElementArray.length] != null) {
                                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray3);
                                return;
                            }
                        }
                    } else {
                        MenuElement[] menuElementArray4 = menuElement.getSubElements();
                        int n = 0;
                        int n2 = menuElementArray4.length;
                        while (n < n2) {
                            if (menuElementArray4[n] == menuElementArray[menuElementArray.length - 1]) {
                                MenuElement menuElement2 = MenuChangeListener.this.nextEnabledChild(menuElementArray4, n + 1);
                                if (menuElement2 == null) {
                                    menuElement2 = MenuChangeListener.this.nextEnabledChild(menuElementArray4, 0);
                                }
                                if (menuElement2 == null) break;
                                menuElementArray[menuElementArray.length - 1] = menuElement2;
                                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                                return;
                            }
                            ++n;
                        }
                    }
                }
            }

            SelectNextItemAction() {
                MenuChangeListener.this = MenuChangeListener.this;
            }
        }

        private class SelectPreviousItemAction
        extends AbstractAction {
            public void actionPerformed(ActionEvent actionEvent) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                if (menuElementArray.length > 1) {
                    MenuElement menuElement = menuElementArray[menuElementArray.length - 2];
                    if (menuElement.getComponent() instanceof JMenu) {
                        menuElement = menuElementArray[menuElementArray.length - 1];
                        MenuElement[] menuElementArray2 = menuElement.getSubElements();
                        if (menuElementArray2.length > 0) {
                            MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 1];
                            System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                            menuElementArray3[menuElementArray.length] = MenuChangeListener.this.previousEnabledChild(menuElementArray2, menuElementArray2.length - 1);
                            if (menuElementArray3[menuElementArray.length] != null) {
                                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray3);
                                return;
                            }
                        }
                    } else {
                        MenuElement[] menuElementArray4 = menuElement.getSubElements();
                        int n = 0;
                        int n2 = menuElementArray4.length;
                        while (n < n2) {
                            if (menuElementArray4[n] == menuElementArray[menuElementArray.length - 1]) {
                                MenuElement menuElement2 = MenuChangeListener.this.previousEnabledChild(menuElementArray4, n - 1);
                                if (menuElement2 == null) {
                                    menuElement2 = MenuChangeListener.this.previousEnabledChild(menuElementArray4, menuElementArray4.length - 1);
                                }
                                if (menuElement2 == null) break;
                                menuElementArray[menuElementArray.length - 1] = menuElement2;
                                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                                return;
                            }
                            ++n;
                        }
                    }
                }
            }

            SelectPreviousItemAction() {
                MenuChangeListener.this = MenuChangeListener.this;
            }
        }

        private class SelectParentItemAction
        extends AbstractAction {
            public void actionPerformed(ActionEvent actionEvent) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                if (menuElementArray.length > 3 && menuElementArray[menuElementArray.length - 3].getComponent() instanceof JMenu && !((JMenu)menuElementArray[menuElementArray.length - 3].getComponent()).isTopLevelMenu()) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 2];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length - 2);
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                    return;
                }
                if (menuElementArray.length > 0 && menuElementArray[0].getComponent() instanceof JMenuBar) {
                    MenuElement[] menuElementArray3;
                    MenuElement menuElement = null;
                    JPopupMenu jPopupMenu = null;
                    MenuElement menuElement2 = null;
                    if (menuElementArray.length > 1) {
                        menuElementArray3 = menuElementArray[0].getSubElements();
                        int n = 0;
                        int n2 = menuElementArray3.length;
                        while (n < n2) {
                            if (menuElementArray3[n] == menuElementArray[1] && (menuElement = MenuChangeListener.this.previousEnabledChild(menuElementArray3, n - 1)) == null) {
                                menuElement = MenuChangeListener.this.previousEnabledChild(menuElementArray3, menuElementArray3.length - 1);
                            }
                            ++n;
                        }
                    }
                    if (menuElement != null) {
                        jPopupMenu = ((JMenu)menuElement).getPopupMenu();
                        if (((JMenu)menuElement).isTopLevelMenu()) {
                            menuElement2 = null;
                        } else {
                            menuElementArray3 = jPopupMenu.getSubElements();
                            if (menuElementArray3.length > 0) {
                                menuElement2 = MenuChangeListener.this.nextEnabledChild(menuElementArray3, 0);
                            }
                        }
                        MenuElement[] menuElementArray4 = menuElement2 != null ? new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu, menuElement2} : new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu};
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray4);
                    }
                }
            }

            SelectParentItemAction() {
                MenuChangeListener.this = MenuChangeListener.this;
            }
        }

        private class SelectChildItemAction
        extends AbstractAction {
            public void actionPerformed(ActionEvent actionEvent) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                if (menuElementArray.length > 0 && menuElementArray[menuElementArray.length - 1].getComponent().isEnabled() && menuElementArray[menuElementArray.length - 1].getComponent() instanceof JMenu && !((JMenu)menuElementArray[menuElementArray.length - 1].getComponent()).isTopLevelMenu()) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 2];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
                    menuElementArray2[menuElementArray.length] = ((JMenu)menuElementArray[menuElementArray.length - 1].getComponent()).getPopupMenu();
                    MenuElement[] menuElementArray3 = menuElementArray2[menuElementArray.length].getSubElements();
                    if (menuElementArray3.length > 0) {
                        menuElementArray2[menuElementArray.length + 1] = MenuChangeListener.this.nextEnabledChild(menuElementArray3, 0);
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                        return;
                    }
                } else if (menuElementArray.length > 0 && menuElementArray[0].getComponent() instanceof JMenuBar) {
                    MenuElement[] menuElementArray4;
                    MenuElement menuElement = null;
                    JPopupMenu jPopupMenu = null;
                    MenuElement menuElement2 = null;
                    if (menuElementArray.length > 1) {
                        menuElementArray4 = menuElementArray[0].getSubElements();
                        int n = 0;
                        int n2 = menuElementArray4.length;
                        while (n < n2) {
                            if (menuElementArray4[n] == menuElementArray[1] && (menuElement = MenuChangeListener.this.nextEnabledChild(menuElementArray4, n + 1)) == null) {
                                menuElement = MenuChangeListener.this.nextEnabledChild(menuElementArray4, 0);
                            }
                            ++n;
                        }
                    }
                    if (menuElement != null) {
                        jPopupMenu = ((JMenu)menuElement).getPopupMenu();
                        if (((JMenu)menuElement).isTopLevelMenu()) {
                            menuElement2 = null;
                        } else {
                            menuElementArray4 = jPopupMenu.getSubElements();
                            if (menuElementArray4.length > 0) {
                                menuElement2 = MenuChangeListener.this.nextEnabledChild(menuElementArray4, 0);
                            }
                        }
                        MenuElement[] menuElementArray5 = menuElement2 != null ? new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu, menuElement2} : new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu};
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray5);
                    }
                }
            }

            SelectChildItemAction() {
                MenuChangeListener.this = MenuChangeListener.this;
            }
        }
    }
}

